/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.ResourceLoader;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.InterviewEditor;
import com.sun.javatest.exec.QSW_Listener;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.WorkDirChooser;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class QuickStartWizard
extends ToolDialog {
    private Pane currPane;
    private Pane taskPane;
    private ConfigPane configPane;
    private Pane testSuitePane;
    private Pane newWorkDirPane;
    private Pane openWorkDirPane;
    private Pane endPane;
    private int task;
    private static final int UNSET = 0;
    private static final int NEW = 1;
    private static final int RESUME = 2;
    private static final int BROWSE = 3;
    private boolean jtmTemplate = true;
    private Properties configData;
    private File configFile;
    private Properties jtmData;
    private File jtmFile;
    private QSW_Listener qswListener;
    private Icon logoIcon;
    private InterviewParameters config;
    private ContextManager contextManager;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private boolean showConfigEditorFlag;
    private boolean runTestsFlag;
    private File installDir;
    private File installParentDir;
    private boolean installDirIsTestSuite;
    private boolean installParentDirIsTestSuite;
    private File userDir;
    private boolean userDirIsTestSuite;
    private boolean userDirIsWorkDirectory;
    private JPanel body;
    private JPanel main;
    private JTextField head;
    private JTextField foot;
    private JButton backBtn;
    private JButton nextBtn;
    private JButton doneBtn;
    private Listener listener = new Listener();
    private KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    private Vector history = new Vector();
    private boolean allowConfigLoadOutsideDefault;
    private File defaultConfigSavePath;
    private boolean allowConfigSaveOutsideDefault;
    private File defaultConfigLoadPath;
    static final String QSW_OFF_PROPERTY = "com.sun.javatest.qswDisabled";
    static final String QSW_OFF_FILE = "qswDisabled";
    private static final boolean qswDisabled = QuickStartWizard.initQSWDisabled();

    QuickStartWizard(JComponent parent, Icon logoIcon, QSW_Listener finisher, UIFactory uif) {
        super(parent, uif, "qsw");
        this.logoIcon = logoIcon;
        this.qswListener = finisher;
    }

    protected void initGUI() {
        JLabel logo;
        URL tsLogoURL;
        TestSuite ts;
        this.disableDefaultDisposeHandler();
        this.initDirs();
        this.initPanes();
        this.setHelp("qsw.window.csh");
        this.setI18NTitle("qsw.title");
        this.body = this.uif.createPanel("qsw.body", new BorderLayout(), false);
        this.body.setBorder(BorderFactory.createLoweredBevelBorder());
        try {
            ts = this.installDirIsTestSuite ? TestSuite.open(this.installDir) : (this.installParentDirIsTestSuite ? TestSuite.open(this.installParentDir) : (this.userDirIsTestSuite ? TestSuite.open(this.userDir) : null));
        }
        catch (Throwable e) {
            ts = null;
        }
        URL uRL = tsLogoURL = ts == null ? null : ts.getLogo();
        if (tsLogoURL == null) {
            logo = new JLabel(this.logoIcon);
            logo.setName("qsw.jtlogo");
            logo.setBackground(this.uif.getI18NColor("qsw.jtlogo.bg"));
            this.uif.setAccessibleInfo(logo, "qsw.jtlogo");
        } else {
            logo = new JLabel(new ImageIcon(tsLogoURL));
            logo.setName("qsw.tslogo");
            logo.setBackground(Color.white);
            this.uif.setAccessibleInfo(logo, "qsw.tslogo");
        }
        logo.setOpaque(true);
        logo.setFocusable(false);
        this.body.add((Component)logo, "West");
        this.main = this.uif.createPanel("qsw.main", new BorderLayout(), false);
        this.main.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 11));
        this.head = this.uif.createOutputField("qsw.head");
        this.head.setBorder(null);
        this.head.setFont(this.head.getFont().deriveFont(1));
        this.main.add((Component)this.head, "North");
        this.foot = this.uif.createOutputField("qsw.foot");
        this.foot.setBorder(null);
        this.foot.setFont(this.foot.getFont().deriveFont(1));
        this.foot.setForeground(this.uif.getI18NColor("qsw.foot"));
        this.main.add((Component)this.foot, "South");
        this.body.add((Component)this.main, "Center");
        this.setBody(this.body);
        this.backBtn = this.uif.createButton("qsw.back", this.listener);
        this.nextBtn = this.uif.createButton("qsw.next", this.listener);
        this.doneBtn = this.uif.createButton("qsw.done", this.listener);
        JButton cancelBtn = this.uif.createCancelButton("qsw.cancel");
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickStartWizard.this.closeExecTool(e);
            }
        });
        this.setPane(this.taskPane);
        this.setButtons(new JButton[]{this.backBtn, this.nextBtn, this.doneBtn, cancelBtn}, null);
        this.setDefaultCloseOperation(0);
    }

    private void closeExecTool(AWTEvent ev) {
        Component src = (Component)ev.getSource();
        for (Container p = src.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JInternalFrame) && (!(p instanceof Window) || p.getParent() == null)) continue;
            p.setVisible(false);
            break;
        }
        this.qswListener.cancelQSW();
    }

    private void initDirs() {
        File classDir = Harness.getClassDir();
        this.installDir = classDir == null ? null : classDir.getParentFile();
        this.installDirIsTestSuite = this.installDir == null ? false : TestSuite.isTestSuite(this.installDir);
        this.installParentDir = this.installDir == null ? null : this.installDir.getParentFile();
        this.installParentDirIsTestSuite = this.installParentDir == null ? false : TestSuite.isTestSuite(this.installParentDir);
        this.userDir = new File(System.getProperty("user.dir"));
        this.userDirIsTestSuite = this.userDir == null ? false : TestSuite.isTestSuite(this.userDir);
        this.userDirIsWorkDirectory = this.userDir == null ? false : WorkDirectory.isWorkDirectory(this.userDir);
    }

    private void initPanes() {
        this.taskPane = new TaskPane();
        this.configPane = new ConfigPane();
        this.testSuitePane = new TestSuitePane();
        this.newWorkDirPane = new CreateWorkDirPane();
        this.openWorkDirPane = new OpenWorkDirPane();
        this.endPane = new EndPane();
    }

    private void setPane(Pane p) {
        if (this.currPane != null) {
            this.main.remove(this.currPane);
        }
        p.update();
        this.head.setText(p.getHead());
        this.main.add((Component)p, "Center");
        this.showError(null);
        this.backBtn.setEnabled(this.history.size() > 0);
        p.updateNextButton();
        this.doneBtn.setEnabled(p == this.endPane);
        this.currPane = p;
        this.main.validate();
        this.main.repaint();
    }

    private void showError(String key) {
        if (key == null) {
            this.foot.setText("");
            this.foot.setEnabled(false);
        } else {
            this.foot.setText(this.uif.getI18NString(key));
            this.foot.setEnabled(true);
            this.nextBtn.setEnabled(false);
        }
    }

    private void doBack() {
        int n = this.history.size();
        if (n > 0) {
            Pane p = (Pane)this.history.remove(n - 1);
            this.setPane(p);
        }
    }

    private void doNext() {
        Pane p = this.currPane.getNext();
        if (p != null) {
            this.history.add(this.currPane);
            this.setPane(p);
        }
    }

    boolean checkSingleTestManager() {
        return true;
    }

    private void doDone() {
        this.setVisible(false);
        if (this.config == null) {
            throw new IllegalStateException();
        }
        if (this.workDir != null) {
            this.config.setWorkDirectory(this.workDir);
        }
        this.qswListener.finishQSW(this.testSuite, this.workDir, this.config, this.showConfigEditorFlag, this.runTestsFlag);
    }

    static boolean isQswDisabled() {
        return qswDisabled;
    }

    private static boolean initQSWDisabled() {
        if (Boolean.parseBoolean(System.getProperty(QSW_OFF_PROPERTY))) {
            return true;
        }
        try {
            return ResourceLoader.getResourceFile(QSW_OFF_FILE, null) != null;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    private static boolean canonicalEquals(File f1, File f2) {
        try {
            File c1 = f1.getCanonicalFile();
            File c2 = f2.getCanonicalFile();
            return c1.equals(c2);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void windowClosingAction(AWTEvent e) {
        this.setVisible(false);
        this.closeExecTool(e);
    }

    private class EndPane
    extends Pane {
        private JTextArea configTextArea;
        private JCheckBox configCheck;
        private JTextArea runTestsTextArea;
        private JCheckBox runTestsCheck;

        EndPane() {
            super("qsw.end");
            this.configTextArea = this.addText(false);
            this.configCheck = this.addCheck("cfg");
            this.runTestsTextArea = this.addText(false);
            this.runTestsCheck = this.addCheck("run");
        }

        void update() {
            super.update();
            Integer haveConfig = new Integer(QuickStartWizard.this.configData == null ? 0 : 1);
            StringBuffer sb = new StringBuffer();
            if (QuickStartWizard.this.config.isFinishable()) {
                sb.append(QuickStartWizard.this.uif.getI18NString("qsw.end.cfgComplete"));
                this.configCheck.setSelected(QuickStartWizard.this.task != 3);
            } else {
                if (QuickStartWizard.this.configData != null) {
                    sb.append(QuickStartWizard.this.uif.getI18NString("qsw.end.cfgIncomplete"));
                    sb.append(" ");
                }
                sb.append(QuickStartWizard.this.uif.getI18NString("qsw.end.needEditor", haveConfig));
                this.configCheck.setSelected(QuickStartWizard.this.task != 3);
            }
            sb.append(" ");
            sb.append(QuickStartWizard.this.uif.getI18NString("qsw.end.editor"));
            this.configTextArea.setText(sb.toString());
            if (QuickStartWizard.this.task == 3) {
                this.runTestsTextArea.setVisible(false);
                this.runTestsCheck.setVisible(false);
            } else {
                this.runTestsTextArea.setVisible(true);
                this.runTestsCheck.setVisible(true);
                this.runTestsTextArea.setText(QuickStartWizard.this.uif.getI18NString("qsw.end.runTests", haveConfig));
            }
            this.stateChanged();
        }

        void updateNextButton() {
            QuickStartWizard.this.nextBtn.setEnabled(false);
        }

        void stateChanged() {
            if (this.runTestsCheck.isSelected() && (QuickStartWizard.this.config == null || !QuickStartWizard.this.config.isFinishable())) {
                this.configCheck.setSelected(true);
            }
            QuickStartWizard.this.showConfigEditorFlag = this.configCheck.isSelected();
            QuickStartWizard.this.runTestsFlag = this.runTestsCheck.isSelected();
        }
    }

    private class OpenWorkDirPane
    extends WorkDirPane {
        OpenWorkDirPane() {
            super("qsw.owd");
            this.chooser.setMode(1);
            if (QuickStartWizard.this.userDirIsWorkDirectory) {
                this.workDirPanel.setSuggestions(new String[]{QuickStartWizard.this.userDir.getPath()});
            }
        }

        void stateChanged() {
            this.updateNextButton();
        }

        void updateNextButton() {
            File file = this.workDirPanel.getFile();
            WorkDirectory chooserWorkDir = this.chooser.getSelectedWorkDirectory();
            if (file == null) {
                QuickStartWizard.this.nextBtn.setEnabled(false);
            } else if (chooserWorkDir != null && chooserWorkDir.getRoot().equals(file)) {
                QuickStartWizard.this.nextBtn.setEnabled(true);
            } else {
                QuickStartWizard.this.nextBtn.setEnabled(WorkDirectory.isWorkDirectory(file));
            }
        }

        Pane getNext() {
            File file = this.workDirPanel.getFile();
            if (file == null) {
                QuickStartWizard.this.showError("qsw.owd.noFile");
                return null;
            }
            if (QuickStartWizard.this.workDir == null || !QuickStartWizard.this.workDir.getRoot().equals(file)) {
                try {
                    WorkDirectory chooserWorkDir = this.chooser.getSelectedWorkDirectory();
                    if (chooserWorkDir != null && chooserWorkDir.getRoot().equals(file)) {
                        QuickStartWizard.this.workDir = chooserWorkDir;
                    } else {
                        QuickStartWizard.this.workDir = WorkDirectory.open(file);
                    }
                    QuickStartWizard.this.testSuite = QuickStartWizard.this.workDir.getTestSuite();
                }
                catch (FileNotFoundException e) {
                    QuickStartWizard.this.showError("qsw.owd.cantFindFile");
                    return null;
                }
                catch (WorkDirectory.Fault e) {
                    QuickStartWizard.this.uif.showError("qsw.owd.cantOpen", new Object[]{file, e.getMessage()});
                    return null;
                }
                try {
                    if (QuickStartWizard.this.config != null) {
                        QuickStartWizard.this.config.dispose();
                    }
                    QuickStartWizard.this.config = QuickStartWizard.this.testSuite.createInterview();
                }
                catch (TestSuite.Fault e) {
                    QuickStartWizard.this.uif.showError("qsw.owd.createCreateInterview", e.getMessage());
                    return null;
                }
                FileHistory h = FileHistory.getFileHistory(QuickStartWizard.this.workDir, "configHistory.jtl");
                File latestConfigFile = h.getLatestEntry();
                if (latestConfigFile != null) {
                    try {
                        QuickStartWizard.this.config.load(latestConfigFile);
                    }
                    catch (IOException e) {
                        QuickStartWizard.this.uif.showError("qsw.owd.cantLoadDefaultConfig", new Object[]{latestConfigFile, e});
                        return null;
                    }
                    catch (Interview.Fault e) {
                        QuickStartWizard.this.uif.showError("qsw.owd.cantLoadDefaultConfig", new Object[]{latestConfigFile, e.getMessage()});
                        return null;
                    }
                }
                if (QuickStartWizard.this.testSuite != null) {
                    QuickStartWizard.this.contextManager = ExecTool.createContextManager(QuickStartWizard.this.testSuite);
                    if (!QuickStartWizard.this.checkSingleTestManager()) {
                        return null;
                    }
                }
            }
            return QuickStartWizard.this.endPane;
        }
    }

    private class CreateWorkDirPane
    extends WorkDirPane {
        CreateWorkDirPane() {
            super("qsw.nwd");
            this.chooser.setMode(0);
        }

        void stateChanged() {
            this.updateNextButton();
        }

        public void update() {
            this.chooser.setTestSuite(QuickStartWizard.this.testSuite);
        }

        void updateNextButton() {
            String path = this.workDirPanel.getPath();
            QuickStartWizard.this.nextBtn.setEnabled(path != null && path.length() > 0);
        }

        Pane getNext() {
            File file = this.workDirPanel.getFile();
            if (file == null) {
                QuickStartWizard.this.showError("qsw.nwd.noFile");
                return null;
            }
            if (QuickStartWizard.this.workDir == null || !QuickStartWizard.this.workDir.getRoot().equals(file)) {
                try {
                    WorkDirectory chooserWorkDir = this.chooser.getSelectedWorkDirectory();
                    if (chooserWorkDir != null && QuickStartWizard.canonicalEquals(chooserWorkDir.getRoot(), file)) {
                        QuickStartWizard.this.workDir = chooserWorkDir;
                    } else {
                        QuickStartWizard.this.workDir = WorkDirectory.create(file, QuickStartWizard.this.testSuite);
                    }
                    if (QuickStartWizard.this.jtmFile != null && QuickStartWizard.this.workDir != null && QuickStartWizard.this.jtmTemplate) {
                        TemplateUtilities.setTemplateFile(QuickStartWizard.this.workDir, QuickStartWizard.this.jtmFile, true);
                    }
                }
                catch (WorkDirectory.Fault e) {
                    QuickStartWizard.this.uif.showError("qsw.nwd.cantCreate", new Object[]{file, e.getMessage()});
                    return null;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return QuickStartWizard.this.endPane;
        }
    }

    private abstract class WorkDirPane
    extends Pane {
        protected final JTextArea textArea;
        protected final FilePanel workDirPanel;
        protected WorkDirChooser chooser;

        WorkDirPane(String key) {
            super(key);
            this.textArea = this.addText();
            this.chooser = new WorkDirChooser(true);
            this.workDirPanel = this.addFile("file", this.chooser);
        }
    }

    private class TestSuitePane
    extends Pane {
        private FilePanel testSuitePanel;
        private TestSuiteChooser chooser;

        TestSuitePane() {
            super("qsw.ts");
            this.addText();
            this.chooser = new TestSuiteChooser();
            this.testSuitePanel = this.addFile("file", this.chooser);
        }

        void stateChanged() {
            QuickStartWizard.this.showError(null);
            this.updateNextButton();
        }

        void update() {
            String configTestSuite;
            super.update();
            TreeSet<String> s = new TreeSet<String>();
            if (QuickStartWizard.this.configData != null && (configTestSuite = (String)QuickStartWizard.this.configData.get("TESTSUITE")) != null) {
                s.add(configTestSuite);
            }
            if (QuickStartWizard.this.userDirIsTestSuite) {
                s.add(QuickStartWizard.this.userDir.getPath());
            }
            if (QuickStartWizard.this.installDirIsTestSuite) {
                s.add(QuickStartWizard.this.installDir.getPath());
            }
            if (QuickStartWizard.this.installParentDirIsTestSuite) {
                s.add(QuickStartWizard.this.installParentDir.getPath());
            }
            if (s.size() > 0) {
                this.testSuitePanel.setSuggestions(s.toArray(new String[s.size()]));
            }
        }

        void updateNextButton() {
            File file = this.testSuitePanel.getFile();
            TestSuite chooserTestSuite = this.chooser.getSelectedTestSuite();
            if (file == null) {
                QuickStartWizard.this.nextBtn.setEnabled(false);
            } else if (chooserTestSuite != null && chooserTestSuite.getRoot().equals(file)) {
                QuickStartWizard.this.nextBtn.setEnabled(true);
            } else {
                QuickStartWizard.this.nextBtn.setEnabled(TestSuite.isTestSuite(file));
            }
        }

        Pane getNext() {
            File file = this.testSuitePanel.getFile();
            if (file == null) {
                QuickStartWizard.this.showError("qsw.ts.noFile");
                return null;
            }
            if (QuickStartWizard.this.testSuite == null || !QuickStartWizard.this.testSuite.getRoot().equals(file) || QuickStartWizard.this.config == null) {
                try {
                    TestSuite chooserTestSuite = this.chooser.getSelectedTestSuite();
                    if (chooserTestSuite != null && chooserTestSuite.getRoot().equals(file)) {
                        QuickStartWizard.this.testSuite = chooserTestSuite;
                    } else {
                        QuickStartWizard.this.testSuite = TestSuite.open(file);
                    }
                }
                catch (FileNotFoundException e) {
                    QuickStartWizard.this.showError("qsw.ts.cantFindFile");
                    return null;
                }
                catch (TestSuite.Fault e) {
                    QuickStartWizard.this.uif.showError("qsw.ts.cantOpen", new Object[]{file, e.getMessage()});
                    return null;
                }
                try {
                    if (QuickStartWizard.this.config != null) {
                        QuickStartWizard.this.config.dispose();
                    }
                    QuickStartWizard.this.config = QuickStartWizard.this.testSuite.createInterview();
                }
                catch (TestSuite.Fault e) {
                    QuickStartWizard.this.uif.showError("qsw.ts.cantCreateInterview", e.getMessage());
                    return null;
                }
                catch (Throwable t) {
                    QuickStartWizard.this.uif.showError("qsw.ts.cantCreateInterview", t.toString());
                    return null;
                }
            }
            if (QuickStartWizard.this.testSuite != null) {
                QuickStartWizard.this.contextManager = ExecTool.createContextManager(QuickStartWizard.this.testSuite);
            }
            QuickStartWizard.this.configPane.tuneTemplateFilter();
            if (!QuickStartWizard.this.checkSingleTestManager()) {
                return null;
            }
            return QuickStartWizard.this.task == 1 || QuickStartWizard.this.task == 3 ? QuickStartWizard.this.configPane : (QuickStartWizard.this.task == 2 ? QuickStartWizard.this.openWorkDirPane : null);
        }
    }

    private class ConfigPane
    extends Pane {
        private ButtonGroup bg;
        private JRadioButton newConfig;
        private JRadioButton fileConfig;
        private JRadioButton jtmConfig;
        private FilePanel filePanel;
        private FilePanel jtmPanel;
        private FileChooser jtiChooser;
        private FileChooser jtmChooser;
        private long configLastModified;

        ConfigPane() {
            super("qsw.cfg");
            this.bg = new ButtonGroup();
            this.addText();
            this.jtiChooser = new FileChooser(true);
            this.jtiChooser.addChoosableExtension(".jti", QuickStartWizard.this.uif.getI18NString("qsw.cfg.jtiFiles"));
            this.jtmChooser = new FileChooser(true);
            this.jtmChooser.setDialogTitle(QuickStartWizard.this.uif.getI18NString("qsw.cfg.jtmChooser.title"));
            this.jtmChooser.addChoosableExtension(".jtm", QuickStartWizard.this.uif.getI18NString("qsw.cfg.jtmFiles"));
            this.newConfig = this.addChoice("new", this.bg);
            this.jtmConfig = this.addChoice("template", this.bg);
            this.jtmPanel = this.addFile("jtm.field", this.jtmChooser, this.jtmConfig);
        }

        void tuneTemplateFilter() {
            if (QuickStartWizard.this.contextManager != null && QuickStartWizard.this.contextManager.getFeatureManager() != null && QuickStartWizard.this.contextManager.getFeatureManager().isEnabled(5)) {
                this.jtmChooser.addChoosableExtension(".jti", QuickStartWizard.this.uif.getI18NString("qsw.cfg.jtiFiles"));
            }
        }

        private void tunePane() {
            if (QuickStartWizard.this.contextManager != null) {
                this.jtmChooser.setCurrentDirectory(QuickStartWizard.this.contextManager.getDefaultTemplateLoadPath());
                if (QuickStartWizard.this.contextManager.getFeatureManager() != null) {
                    FeatureManager fm = QuickStartWizard.this.contextManager.getFeatureManager();
                    this.jtmConfig.setEnabled(fm.isEnabled(1));
                    this.newConfig.setEnabled(fm.isEnabled(5));
                }
            }
        }

        void stateChanged() {
            QuickStartWizard.this.showError(null);
            this.updateNextButton();
        }

        void updateNextButton() {
            this.tunePane();
            if (this.newConfig.isSelected()) {
                QuickStartWizard.this.nextBtn.setEnabled(true);
            } else if (this.jtmConfig.isSelected()) {
                File f = this.jtmPanel.getFile();
                QuickStartWizard.this.nextBtn.setEnabled(f != null && f.exists() && f.isFile());
            } else {
                QuickStartWizard.this.nextBtn.setEnabled(false);
            }
        }

        Pane getNext() {
            if (this.bg.getSelection() == null) {
                return null;
            }
            if (this.newConfig.isSelected()) {
                QuickStartWizard.this.configData = null;
                QuickStartWizard.this.configFile = null;
                QuickStartWizard.this.jtmData = null;
                QuickStartWizard.this.jtmFile = null;
            } else if (this.jtmConfig.isSelected()) {
                QuickStartWizard.this.jtmData = new Properties();
                QuickStartWizard.this.jtmFile = this.chkConfigFile(this.jtmPanel, QuickStartWizard.this.jtmData);
                if (QuickStartWizard.this.jtmFile == null) {
                    return null;
                }
                if (QuickStartWizard.this.jtmData != null) {
                    String jtmDataInterview = (String)QuickStartWizard.this.jtmData.get("INTERVIEW");
                    if (jtmDataInterview != null && !QuickStartWizard.this.config.getClass().getName().equals(jtmDataInterview)) {
                        QuickStartWizard.this.uif.showError("qsw.ts.templateMismatch");
                        return null;
                    }
                    QuickStartWizard.this.jtmTemplate = Boolean.parseBoolean((String)QuickStartWizard.this.jtmData.get("IS_TEMPLATE"));
                    if (QuickStartWizard.this.config != null) {
                        try {
                            if (QuickStartWizard.this.jtmTemplate) {
                                QuickStartWizard.this.testSuite.loadInterviewFromTemplate(QuickStartWizard.this.jtmFile, QuickStartWizard.this.config);
                                QuickStartWizard.this.config.setTemplatePath(QuickStartWizard.this.jtmFile.getAbsolutePath());
                            } else {
                                QuickStartWizard.this.config.load(QuickStartWizard.this.jtmFile);
                            }
                        }
                        catch (TestSuite.Fault ex) {
                            ex.printStackTrace();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (Interview.Fault ex) {
                            QuickStartWizard.this.uif.showError("qsw.ts.cantLoadConfig", ex.getMessage());
                            return null;
                        }
                    }
                }
                return QuickStartWizard.this.task == 1 ? QuickStartWizard.this.newWorkDirPane : QuickStartWizard.this.endPane;
            }
            if (QuickStartWizard.this.configData != null) {
                String configDataInterview = (String)QuickStartWizard.this.configData.get("INTERVIEW");
                if (configDataInterview != null && !QuickStartWizard.this.config.getClass().getName().equals(configDataInterview)) {
                    QuickStartWizard.this.uif.showError("qsw.ts.configMismatch");
                    return null;
                }
                try {
                    QuickStartWizard.this.config.load((Map)QuickStartWizard.this.configData, QuickStartWizard.this.configFile);
                }
                catch (Interview.Fault e) {
                    QuickStartWizard.this.uif.showError("qsw.ts.cantLoadConfig", e.getMessage());
                    return null;
                }
            }
            return QuickStartWizard.this.config == null ? null : (QuickStartWizard.this.task == 1 ? QuickStartWizard.this.newWorkDirPane : QuickStartWizard.this.endPane);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File chkConfigFile(FilePanel panel, Properties data) {
            String path = panel.getPath();
            File file = null;
            if (path.length() == 0) {
                QuickStartWizard.this.showError("qsw.cfg.noFile");
                return null;
            }
            File f = new File(path);
            if (!f.exists()) {
                QuickStartWizard.this.showError("qsw.cfg.cantFindFile");
                return null;
            }
            if (!f.isFile()) {
                QuickStartWizard.this.showError("qsw.cfg.badFile");
                return null;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            try {
                data.clear();
                data.load(in);
                file = f;
            }
            catch (RuntimeException e) {
                File file2;
                try {
                    QuickStartWizard.this.uif.showError("qsw.cfg.cantReadFile", e);
                    file2 = null;
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)in).close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        QuickStartWizard.this.uif.showError("qsw.cfg.cantReadFile", e2);
                        return null;
                    }
                }
                ((InputStream)in).close();
                return file2;
            }
            ((InputStream)in).close();
            return file;
        }
    }

    private class TaskPane
    extends Pane {
        private ButtonGroup bg;
        private JRadioButton newRun;
        private JRadioButton resumeRun;
        private JRadioButton browse;

        TaskPane() {
            super("qsw.tsk");
            this.bg = new ButtonGroup();
            this.addText();
            this.newRun = this.addChoice("new", this.bg);
            this.resumeRun = this.addChoice("resume", this.bg);
            this.browse = this.addChoice("browse", this.bg);
        }

        void stateChanged() {
            QuickStartWizard.this.task = this.newRun.isSelected() ? 1 : (this.resumeRun.isSelected() ? 2 : (this.browse.isSelected() ? 3 : 0));
            this.updateNextButton();
        }

        void updateNextButton() {
            QuickStartWizard.this.nextBtn.setEnabled(QuickStartWizard.this.task != 0);
        }

        Pane getNext() {
            return QuickStartWizard.this.task == 1 || QuickStartWizard.this.task == 3 ? QuickStartWizard.this.testSuitePane : (QuickStartWizard.this.task == 2 ? QuickStartWizard.this.openWorkDirPane : null);
        }
    }

    private abstract class Pane
    extends JPanel {
        private ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Pane.this.stateChanged();
            }
        };
        private String paneKey;
        private String head;

        Pane(String key) {
            this.paneKey = key;
            this.setLayout(new GridBagLayout());
            int dpi = QuickStartWizard.this.uif.getDotsPerInch();
            this.setPreferredSize(new Dimension(5 * dpi, (int)(2.5 * (double)dpi)));
            this.head = QuickStartWizard.this.uif.getI18NString(this.paneKey + ".hd");
        }

        void stateChanged() {
        }

        String getHead() {
            return this.head;
        }

        void update() {
            this.updateNextButton();
        }

        abstract void updateNextButton();

        Pane getNext() {
            return null;
        }

        JCheckBox addCheck(String key) {
            JCheckBox cb = QuickStartWizard.this.uif.createCheckBox(this.paneKey + "." + key);
            cb.addChangeListener(this.changeListener);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            c.insets.left = 10;
            c.insets.bottom = 5;
            c.weightx = 1.0;
            this.add((Component)cb, c);
            return cb;
        }

        JRadioButton addChoice(String key, ButtonGroup bg) {
            JRadioButton rb = QuickStartWizard.this.uif.createRadioButton(this.paneKey + "." + key, bg);
            rb.addChangeListener(this.changeListener);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            c.insets.left = 10;
            c.insets.bottom = 5;
            c.weightx = 1.0;
            this.add((Component)rb, c);
            return rb;
        }

        FilePanel addFile(String key, JFileChooser chooser) {
            return this.addFile(key, chooser, null);
        }

        FilePanel addFile(String key, JFileChooser chooser, final JRadioButton rb) {
            final FilePanel fp = new FilePanel(this.paneKey + "." + key, chooser);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            c.insets.bottom = 10;
            c.insets.left = rb == null ? 0 : 30;
            c.weightx = 1.0;
            this.add((Component)fp, c);
            if (rb != null) {
                fp.addAncestorListener(new AncestorListener(){

                    public void ancestorAdded(AncestorEvent e) {
                        fp.setEnabled(rb.isSelected());
                    }

                    public void ancestorMoved(AncestorEvent e) {
                    }

                    public void ancestorRemoved(AncestorEvent e) {
                    }
                });
                rb.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        fp.setEnabled(rb.isSelected());
                    }
                });
            }
            fp.setDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    Pane.this.changeListener.stateChanged(new ChangeEvent(fp));
                }

                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }
            });
            return fp;
        }

        JTextArea addText() {
            return this.addText(true);
        }

        JTextArea addText(boolean initContent) {
            JTextArea textArea = QuickStartWizard.this.uif.createTextArea("qsw.text");
            textArea.setEditable(false);
            textArea.setLineWrap(true);
            textArea.setOpaque(false);
            textArea.setBackground(UIFactory.Colors.TRANSPARENT.getValue());
            textArea.setWrapStyleWord(true);
            textArea.setFocusTraversalKeys(0, null);
            textArea.setFocusTraversalKeys(1, null);
            if (initContent) {
                textArea.setText(QuickStartWizard.this.uif.getI18NString(this.paneKey + ".txt"));
            }
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 0;
            c.insets.top = 20;
            c.insets.right = 10;
            c.insets.bottom = 10;
            c.fill = 1;
            this.add((Component)textArea, c);
            return textArea;
        }
    }

    private class FilePanel
    extends JPanel {
        private JLabel label;
        private JTextField field;
        private JComboBox combo;
        private JComponent currPathComp;
        private JButton button;
        private DocumentListener listener;

        FilePanel(String key, final JFileChooser chooser) {
            QuickStartWizard.this.uif.initPanel(this, key, new BorderLayout(), false);
            this.label = QuickStartWizard.this.uif.createLabel(key, true);
            this.field = QuickStartWizard.this.uif.createInputField(key, this.label);
            this.currPathComp = this.field;
            this.button = QuickStartWizard.this.uif.createButton(key + ".browse");
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String path = FilePanel.this.getPath();
                    if (chooser instanceof FileChooser && ((FileChooser)chooser).getChosenExtension() != null && ((FileChooser)chooser).getChosenExtension().equals(".jti")) {
                        File f = InterviewEditor.loadConfigFile(QuickStartWizard.this.contextManager, QuickStartWizard.this.parent, QuickStartWizard.this.uif, (FileChooser)chooser);
                        path = f == null ? null : f.getPath();
                    } else {
                        int rc;
                        if (path != null && path.length() > 0) {
                            chooser.setSelectedFile(new File(path));
                        }
                        if ((rc = chooser.showDialog(QuickStartWizard.this.body, chooser.getApproveButtonText())) != 0) {
                            return;
                        }
                        path = chooser.getSelectedFile().getPath();
                    }
                    FilePanel.this.field.setText(path);
                    if (FilePanel.this.combo != null) {
                        FilePanel.this.combo.setSelectedItem(path);
                    }
                }
            });
            this.add((Component)this.label, "West");
            this.add((Component)this.field, "Center");
            this.add((Component)this.button, "East");
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.label.setEnabled(b);
            this.currPathComp.setEnabled(b);
            this.button.setEnabled(b);
        }

        void setSuggestions(String[] suggestions) {
            if (suggestions == null || suggestions.length == 0) {
                this.setPathComponent(this.field);
            } else {
                if (this.combo == null) {
                    Component c;
                    this.combo = QuickStartWizard.this.uif.createChoice(this.getName(), true, this.label);
                    this.combo.setFont(this.combo.getFont().deriveFont(0));
                    if (this.listener != null && (c = this.combo.getEditor().getEditorComponent()) instanceof JTextField) {
                        ((JTextField)c).getDocument().addDocumentListener(this.listener);
                    }
                }
                this.setPathComponent(this.combo);
                this.combo.removeAllItems();
                for (int i = 0; i < suggestions.length; ++i) {
                    this.combo.addItem(suggestions[i]);
                }
            }
        }

        File getFile() {
            String path = this.getPath();
            return path == null || path.length() == 0 ? null : new File(path);
        }

        String getPath() {
            if (this.currPathComp == this.field) {
                return this.field.getText();
            }
            if (this.currPathComp == this.combo) {
                Component c = this.combo.getEditor().getEditorComponent();
                if (c.isShowing() && c instanceof JTextField) {
                    return ((JTextField)c).getText();
                }
                return (String)this.combo.getSelectedItem();
            }
            throw new IllegalStateException();
        }

        void setDocumentListener(DocumentListener l) {
            this.field.getDocument().addDocumentListener(l);
            this.listener = l;
        }

        private void setPathComponent(JComponent newPathComp) {
            if (newPathComp != this.currPathComp) {
                if (this.currPathComp != null) {
                    this.remove(this.currPathComp);
                }
                this.add((Component)newPathComp, "Center");
                newPathComp.setEnabled(this.isEnabled());
                this.label.setLabelFor(newPathComp);
                this.currPathComp = newPathComp;
            }
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == QuickStartWizard.this.nextBtn) {
                QuickStartWizard.this.doNext();
            } else if (src == QuickStartWizard.this.backBtn) {
                QuickStartWizard.this.doBack();
            } else if (src == QuickStartWizard.this.doneBtn) {
                QuickStartWizard.this.doDone();
            } else {
                System.err.println("QSG.Listener " + e);
            }
        }
    }
}

