/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ET_ReportControl;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.HarnessAware;
import com.sun.javatest.exec.NewReportDialog;
import com.sun.javatest.exec.ReportBrowser;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportDirChooser;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReportHandler
implements ET_ReportControl,
HarnessAware {
    private Action newReportAction;
    private Action openReportAction;
    private static final String REPORT_PREFIX = "report";
    private JComponent parent;
    private UIFactory uif;
    private FileHistory.Listener reportHistoryListener;
    private FileHistory history;
    private File lastOpenPath;
    private Map lastState;
    private ExecModel model;
    private NewReportDialog newReportD;
    private ReportBrowser reportBrowser;
    private ReportDirChooser reportDirChooser;
    private WorkDirectory workDir;

    ReportHandler(JComponent parent, ExecModel model, UIFactory uif) {
        this.parent = parent;
        this.model = model;
        this.uif = uif;
        this.initActions();
    }

    ReportHandler(JComponent parent, ExecModel model, Harness harness, UIFactory uif) {
        this(parent, model, uif);
        this.setHarness(harness);
    }

    @Override
    public JMenu getMenu() {
        Action[] reportActions = new Action[]{this.newReportAction, this.openReportAction, null};
        JMenu menu = this.uif.createMenu("rpth", reportActions);
        menu.addMenuListener(this.reportHistoryListener);
        return menu;
    }

    void showReportDialog(int mode) {
        if (mode == 0) {
            ReportDirChooser rdc = this.getReportDirChooser();
            rdc.setMode(mode);
            int option = rdc.showDialog(this.parent);
            if (option != 0) {
                return;
            }
        } else if (mode == 1) {
            FileChooser fc = new FileChooser();
            fc.setApproveButtonToolTipText(this.uif.getI18NString("rh.open.tip"));
            fc.setApproveButtonMnemonic(this.uif.getI18NMnemonic("rh.open.mne"));
            fc.setDialogTitle(this.uif.getI18NString("rh.open.title"));
            if (this.lastOpenPath != null) {
                fc.setCurrentDirectory(this.lastOpenPath);
            }
            int res = fc.showOpenDialog(this.parent);
            File f = fc.getSelectedFile();
            if (res == 0) {
                this.showReportBrowser(f);
                this.history.add(f);
                this.lastOpenPath = f.getParentFile();
            }
        }
    }

    void showNewReportDialog() {
        if (this.newReportD == null) {
            this.newReportD = new NewReportDialog(this.parent, this.uif, this.model.getFilterConfig(), this.getReportBrowser(), this.model);
            this.newReportD.addObserver(new NewReportDialog.Observer(){

                public void update(Map l) {
                    ReportHandler.this.lastState = l;
                    String lastReportDir = (String)ReportHandler.this.lastState.get("reportDir");
                    if (lastReportDir != null) {
                        ReportHandler.this.history.add(new File(lastReportDir));
                    }
                }

                public void writingReport() {
                    ReportHandler.this.newReportAction.setEnabled(false);
                }

                public void wroteReport() {
                    ReportHandler.this.newReportAction.setEnabled(true);
                }

                public void errorWriting(String problem) {
                    ReportHandler.this.newReportAction.setEnabled(true);
                }
            });
        }
        this.newReportD.setInterviewParameters(this.model.getInterviewParameters());
        if (this.lastState != null) {
            this.newReportD.setLastState(this.lastState);
        }
        this.newReportD.setVisible(true);
    }

    void showReportBrowser(File reportDir) {
        File target = reportDir;
        if (reportDir.isDirectory()) {
            String[] names = Report.getHtmlReportFilenames();
            long newestTime = 0L;
            for (int i = 0; i < names.length; ++i) {
                File f = new File(reportDir, names[i]);
                if (!f.exists() || f.lastModified() <= newestTime) continue;
                target = f;
                newestTime = f.lastModified();
            }
        }
        this.getReportBrowser().show(target);
    }

    ReportBrowser getReportBrowser() {
        if (this.reportBrowser == null) {
            this.reportBrowser = new ReportBrowser(this.parent, this.model, this.uif, this);
        }
        return this.reportBrowser;
    }

    ReportDirChooser getReportDirChooser() {
        if (this.reportDirChooser == null) {
            this.reportDirChooser = new ReportDirChooser();
        }
        return this.reportDirChooser;
    }

    Action getNewReportAction() {
        return this.newReportAction;
    }

    Action getOpenReportAction() {
        return this.openReportAction;
    }

    @Override
    public void updateGUI() {
        this.workDir = this.model.getWorkDirectory();
        boolean workDirSet = this.workDir != null;
        this.newReportAction.setEnabled(workDirSet);
        this.openReportAction.setEnabled(workDirSet);
        if (!workDirSet) {
            return;
        }
        if (this.history == null) {
            this.history = FileHistory.getFileHistory(this.workDir, "reportDirHistory.jtl");
            this.reportHistoryListener.setFileHistory(this.history);
        }
    }

    @Override
    public void save(Map parentMap) {
        if (this.lastState != null && this.lastState.size() > 0) {
            PrefixMap pm = new PrefixMap(parentMap, REPORT_PREFIX);
            pm.putAll(this.lastState);
        }
    }

    @Override
    public void restore(Map parentMap) {
        if (parentMap == null) {
            return;
        }
        try {
            PrefixMap pm = new PrefixMap(parentMap, REPORT_PREFIX);
            if (pm == null) {
                return;
            }
            Object[] keys = pm.keySet().toArray();
            if (this.lastState == null) {
                this.lastState = new HashMap();
            }
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                String value = (String)pm.get(keys[i]);
                if (value == null) continue;
                this.lastState.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        if (this.newReportD != null) {
            this.newReportD.dispose();
        }
        if (this.reportBrowser != null) {
            this.reportBrowser.dispose();
        }
        if (this.uif != null) {
            this.uif.dispose();
        }
        this.workDir = null;
        this.model = null;
        this.lastState = null;
    }

    @Override
    public void setHarness(Harness h) {
        h.addObserver(new Harness.Observer(){

            public void startingTestRun(Parameters params) {
                ReportHandler.this.newReportAction.setEnabled(false);
            }

            public void startingTest(TestResult tr) {
            }

            public void finishedTest(TestResult tr) {
            }

            public void stoppingTestRun() {
            }

            public void finishedTesting() {
            }

            public void finishedTestRun(boolean allOK) {
                ReportHandler.this.newReportAction.setEnabled(true);
            }

            public void error(String msg) {
            }
        });
    }

    @Override
    public List<Action> getToolBarActionList() {
        return null;
    }

    private void initActions() {
        this.newReportAction = new ToolAction(this.uif, "rpth.new"){

            public void actionPerformed(ActionEvent e) {
                ReportHandler.this.showNewReportDialog();
            }
        };
        this.openReportAction = new ToolAction(this.uif, "rpth.open"){

            public void actionPerformed(ActionEvent e) {
                ReportHandler.this.showReportDialog(1);
            }
        };
        this.reportHistoryListener = new FileHistory.Listener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem mi = (JMenuItem)e.getSource();
                File f = (File)mi.getClientProperty("file");
                if (f != null) {
                    ReportHandler.this.showReportBrowser(f);
                }
            }
        });
    }
}

