/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.BasicSessionControl;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ET_TestTreeControl;
import com.sun.javatest.exec.EmptyTestTreeModel;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.HarnessAware;
import com.sun.javatest.exec.JavaTestContextMenu;
import com.sun.javatest.exec.MultiSelectPanel;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.TT_BasicNode;
import com.sun.javatest.exec.TT_Renderer;
import com.sun.javatest.exec.TT_TestNode;
import com.sun.javatest.exec.TT_TreeNode;
import com.sun.javatest.exec.TestPanel;
import com.sun.javatest.exec.TestTree;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.Deck;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestTreePanel
extends JPanel
implements ET_TestTreeControl,
HarnessAware,
Session.Observer {
    private UIFactory uif;
    private Harness harness;
    private FilterSelectionHandler filterHandler;
    private ExecModel execModel;
    private JComponent parent;
    private Thread bgThread;
    private Map stateMap;
    private volatile boolean disposed;
    private PanelModel pm;
    private TestTree tree;
    private TT_Renderer treeRend;
    private TestPanel testPanel;
    private BranchPanel brPanel;
    private MultiSelectPanel msPanel;
    private JPopupMenu popup;
    private TreePath lastPopupPath;
    private JMenuItem refreshMI;
    private JMenuItem purgeMI;
    private JMenuItem runMI;
    private String activeTest;
    private ArrayList testMenus;
    private ArrayList folderMenus;
    private ArrayList mixedMenus;
    private ArrayList customMenus;
    private TestTreeModel treeModel;
    private Deck deck;
    private JPanel deckPanel;
    private JTextField titleField;
    private Listener listener;
    private TestSuite lastTs;
    private Parameters params;
    private Parameters newParams;
    private boolean newConfigAlreadyApplied = false;
    private boolean initialized = false;
    private static final int WAIT_DIALOG_DELAY = 3000;
    private static final String OPEN_PATHS_PREF = "openpaths";
    protected static boolean debug = Boolean.getBoolean("debug." + TestTreePanel.class.getName());

    public TestTreePanel(JComponent parent, ExecModel em, UIFactory uif) {
        this.uif = uif;
        this.execModel = em;
        this.parent = parent;
        uif.setAccessibleInfo(this, "treep");
    }

    public TestTreePanel(UIFactory uif, Harness h, ExecModel em, FilterSelectionHandler fh, JComponent parent, Map map) {
        this(parent, em, uif);
        this.setHarness(h);
        this.filterHandler = fh;
        this.stateMap = map;
        this.initialize();
    }

    @Override
    public void initialize() {
        this.initGUI();
    }

    @Override
    public synchronized TestResultTable getTestResultTable() {
        return this.initialized ? this.treeModel.getTestResultTable() : null;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public synchronized TreePanelModel getTreePanelModel() {
        return this.pm;
    }

    @Override
    public synchronized void dispose() {
        this.disposed = true;
        if (this.treeModel != null) {
            this.treeModel.dispose();
            this.treeModel = null;
        }
        if (this.brPanel != null) {
            this.brPanel.dispose();
            this.brPanel = null;
        }
        if (this.bgThread != null && this.bgThread.isAlive()) {
            this.bgThread.interrupt();
        }
        this.params = null;
        this.newParams = null;
        this.popup = null;
        this.lastPopupPath = null;
        this.customMenus = null;
        this.mixedMenus = null;
        this.folderMenus = null;
        this.testMenus = null;
    }

    @Override
    public synchronized void setParameters(Parameters p) {
        this.newParams = p;
        this.newConfigAlreadyApplied = false;
    }

    synchronized void applyParameters(boolean force) {
        if (!force) {
            if (this.newParams == null) {
                return;
            }
            if (this.newConfigAlreadyApplied) {
                return;
            }
            this.newConfigAlreadyApplied = true;
        }
        String[] paths = null;
        String[] selectedPaths = null;
        if (this.params == null && this.stateMap != null) {
            String tmp = (String)this.stateMap.get(OPEN_PATHS_PREF);
            if (tmp != null) {
                paths = StringArray.split(tmp);
            }
        } else if (this.tree != null && !(this.treeModel instanceof EmptyTestTreeModel)) {
            TreePath[] ps = this.tree.snapshotOpenPaths();
            paths = this.treeModel.pathsToStrings(ps);
            ps = this.tree.snapshotSelectedPaths();
            selectedPaths = this.treeModel.pathsToStrings(ps);
        }
        this.params = this.newParams;
        if (this.treeModel instanceof EmptyTestTreeModel) {
            WorkDirectory wd = this.execModel.getWorkDirectory();
            ContextManager cm = this.execModel.getContextManager();
            EmptyTestTreeModel em = (EmptyTestTreeModel)this.treeModel;
            if (wd != null && cm != null && cm.getFeatureManager().isEnabled(7)) {
                cm.openTree(wd);
                this.treeModel = new TestTreeModel(this.params, this.filterHandler, this.uif);
                this.tree.setTreeModel(this.treeModel);
                for (TreeModelListener l : em.getTreeModelListeners()) {
                    this.treeModel.addTreeModelListener(l);
                }
                for (TestResultTable.TreeNodeObserver o : em.getRootObservers()) {
                    ((TestResultTable.TreeNode)this.treeModel.getRoot()).addObserver(o);
                }
                this.harness.removeObserver(this.pm);
                this.pm = new PanelModel();
                this.harness.addObserver(this.pm);
                this.brPanel.dispose();
                this.brPanel.setTreeModel(this.treeModel);
                em.dispose();
            }
        }
        if (this.treeModel != null) {
            this.treeModel.setParameters(this.params);
        }
        if (this.tree != null) {
            this.tree.setParameters(this.params);
            this.treeRend.setParameters(this.params);
        }
        if (this.testPanel != null) {
            this.testPanel.setTestSuite(this.params.getTestSuite());
        }
        if (this.brPanel != null) {
            this.brPanel.setParameters(this.params);
        }
        if (this.tree != null && paths != null && paths.length > 0) {
            this.tree.restorePaths(paths, true);
        }
        if (this.tree != null) {
            this.tree.restoreSelection(selectedPaths);
        }
        if (this.tree != null) {
            this.ensureTreeSelection();
        }
    }

    private TreePath[] getTreePaths(String[] paths) {
        if (paths != null) {
            ArrayList<TreePath> translatedPaths = new ArrayList<TreePath>(paths.length);
            for (int i = 0; i < paths.length; ++i) {
                TreePath tp = this.treeModel.resolveUrl(paths[i]);
                if (tp == null) continue;
                translatedPaths.add(tp);
            }
            TreePath[] result = new TreePath[translatedPaths.size()];
            translatedPaths.toArray(result);
            return result;
        }
        return null;
    }

    @Override
    public void saveTreeState(Map m) {
        String[] paths = this.getOpenPaths();
        m.put(OPEN_PATHS_PREF, StringArray.join(paths));
    }

    @Override
    public void restoreTreeState(Map m) {
        if (m != null) {
            String tmp = (String)m.get(OPEN_PATHS_PREF);
            if (this.tree != null && tmp != null && tmp.length() > 0) {
                this.tree.restorePaths(StringArray.split(tmp), true);
            }
        }
    }

    @Override
    public void save(Map m) {
        Preferences.access();
        this.saveTreeState(m);
    }

    @Override
    public void restore(Map m) {
        this.stateMap = m;
        this.restoreTreeState(this.stateMap);
    }

    private String[] getOpenPaths() {
        if (this.tree == null || this.tree.getModel() instanceof EmptyTestTreeModel) {
            return null;
        }
        TreePath[] paths = this.tree.snapshotOpenPaths();
        Vector<String> urls = new Vector<String>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                String url;
                Object last = paths[i].getLastPathComponent();
                if (last instanceof TT_TestNode) {
                    url = ((TT_TestNode)last).getTestResult().getTestName();
                } else if (last instanceof TT_BasicNode) {
                    url = ((TT_BasicNode)last).getLongPath();
                } else {
                    return null;
                }
                urls.addElement(url);
            }
        }
        if (urls == null || urls.size() == 0) {
            return null;
        }
        Object[] result = new String[urls.size()];
        urls.copyInto(result);
        return result;
    }

    private void setPopupItemsEnabled(boolean state) {
        if (state) {
            boolean haveWorkDir = this.params != null && this.params.getWorkDirectory() != null;
            this.purgeMI.setEnabled(haveWorkDir);
            this.refreshMI.setEnabled(this.params != null && this.params.getTestSuite() != null);
            this.runMI.setEnabled(!this.execModel.isConfiguring());
        } else {
            this.purgeMI.setEnabled(false);
            this.refreshMI.setEnabled(false);
            this.runMI.setEnabled(false);
        }
    }

    private void clearNodes(final TreePath[] what) {
        final WorkDirectory wd = this.execModel.getWorkDirectory();
        if (wd == null) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantPurgeNoWd.msg"), this.uif.getI18NString("treep.cantPurgeNoWd.title"), 2);
            return;
        }
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantPurgeRunning.msg"), this.uif.getI18NString("treep.cantPurgeRunning.title"), 2);
            return;
        }
        boolean ack = false;
        Object[] toPurge = new Object[what.length];
        if (what.length > 1) {
            String[] paths = TestTreePanel.createNodeList(what);
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (int i = paths.length; i > 0; --i) {
                model.add(model.getSize(), paths[model.getSize()]);
            }
            int confirm = this.showConfirmListDialog("treep.purgeItemsSure", null, model);
            if (confirm != 0) {
                return;
            }
            ack = true;
            for (int i = 0; i < what.length; ++i) {
                Object item = what[i].getLastPathComponent();
                if (item instanceof TT_TestNode) {
                    toPurge[i] = ((TT_TestNode)item).getTestResult().getWorkRelativePath();
                    continue;
                }
                if (!(item instanceof TT_BasicNode)) continue;
                TT_BasicNode tn = (TT_BasicNode)item;
                if (tn.isRoot()) {
                    toPurge = new Object[]{""};
                    break;
                }
                toPurge[i] = tn.getLongPath();
            }
        } else if (what[0].getLastPathComponent() instanceof TT_TestNode) {
            TestResult tr = ((TT_TestNode)what[0].getLastPathComponent()).getTestResult();
            int confirm = this.uif.showYesNoDialog("treep.purgeTestSure", tr.getTestName());
            if (confirm != 0) {
                return;
            }
            ack = true;
            toPurge[0] = tr.getWorkRelativePath();
        } else {
            TT_BasicNode tn = (TT_BasicNode)what[0].getLastPathComponent();
            int confirm = 0;
            confirm = tn.isRoot() ? this.uif.showYesNoDialog("treep.purgeRootSure") : this.uif.showYesNoDialog("treep.purgeNodeSure", tn.getLongPath());
            if (confirm != 0) {
                return;
            }
            ack = true;
            toPurge[0] = tn;
        }
        if (ack) {
            final JDialog d = this.uif.createWaitDialog("treep.waitPurge", this);
            final String[] finalList = TestTreePanel.createNodeList(toPurge);
            this.setPopupItemsEnabled(false);
            final Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    for (int i = 0; i < what.length; ++i) {
                        for (int j = 0; j < finalList.length; ++j) {
                            wd.purge(finalList[j]);
                        }
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                public void run() {
                                    if (d.isShowing()) {
                                        d.hide();
                                    }
                                    TestTreePanel.this.setPopupItemsEnabled(true);
                                    TreePath[] translatedPaths = TestTreePanel.this.getTreePaths(finalList);
                                    if (translatedPaths != null && TestTreePanel.this.tree != null) {
                                        TestTreePanel.this.tree.setSelectionPaths(translatedPaths);
                                    }
                                }
                            });
                        }
                        catch (InterruptedException e) {
                        }
                        catch (InvocationTargetException e) {}
                        continue;
                        catch (WorkDirectory.PurgeFault f) {
                            try {
                                I18NResourceBundle i18n = TestTreePanel.this.uif.getI18NResourceBundle();
                                wd.log(i18n, "treep.purgeFail.err", f);
                            }
                            catch (Throwable throwable) {
                                try {
                                    EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                                }
                                catch (InterruptedException e) {
                                }
                                catch (InvocationTargetException e) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (InterruptedException e) {
                            }
                            catch (InvocationTargetException invocationTargetException) {}
                            continue;
                        }
                    }
                }
            };
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (t == null) {
                        return;
                    }
                    if (t.isAlive() && !d.isVisible()) {
                        d.show();
                    } else if (!t.isAlive() && d.isVisible()) {
                        d.hide();
                    }
                }
            };
            this.bgThread = t;
            Timer timer = new Timer(3000, al);
            timer.setRepeats(false);
            timer.start();
            t.start();
        }
    }

    static String createNodeListString(String[] items) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            sb.append("      ");
            sb.append(items[i]);
            if (i + 1 >= items.length) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    static String[] createNodeList(Object[] items) {
        String[] result = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            TestResultTable.TreeNode tn;
            TestResult tr;
            Object item = items[i];
            if (item instanceof TreePath) {
                item = ((TreePath)item).getLastPathComponent();
            }
            if (item instanceof TT_TestNode) {
                tr = ((TT_TestNode)item).getTestResult();
                result[i] = tr.getTestName();
                continue;
            }
            if (item instanceof TT_BasicNode) {
                if (((TT_BasicNode)item).isRoot()) {
                    result = new String[]{TestResultTable.getRootRelativePath(((TT_BasicNode)item).getTableNode())};
                    return result;
                }
                tn = ((TT_BasicNode)item).getTableNode();
                result[i] = TestResultTable.getRootRelativePath(tn);
                continue;
            }
            if (item instanceof TestResult) {
                tr = (TestResult)item;
                result[i] = tr.getTestName();
                continue;
            }
            if (item instanceof TestResultTable.TreeNode) {
                tn = (TestResultTable.TreeNode)item;
                result[i] = TestResultTable.getRootRelativePath(tn);
                continue;
            }
            if (items[i] == null) continue;
            result[i] = items[i].toString();
        }
        return result;
    }

    private void showNodeInfoDialog(TreePath what) {
        if (what.getLastPathComponent() instanceof TT_TreeNode) {
            TT_TreeNode tn = (TT_TreeNode)what.getLastPathComponent();
            Debug.println("info for this node not implemented" + tn.getDisplayName() + " (" + tn + ")");
        }
    }

    private void runNodes(TreePath[] what) {
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantRunRunning.msg"), this.uif.getI18NString("treep.cantRunRunning.title"), 2);
            return;
        }
        this.execModel.runTests(TestTreePanel.createNodeList(what));
    }

    private static void restore(TreePath[] paths, TestTree targetTree) {
        if (paths == null || targetTree == null) {
            return;
        }
        Runnable restorer = new Runnable(){

            public void run() {
            }
        };
        EventQueue.invokeLater(restorer);
    }

    private void refreshNodes(TreePath[] what) {
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantRefreshRunning.msg"), this.uif.getI18NString("treep.cantRefreshRunning.title"), 2);
            return;
        }
        final TestResultTable trt = this.treeModel.getTestResultTable();
        boolean ack = false;
        String[] ackTargets = new String[what.length];
        Object[] ackNodes = null;
        if (what.length > 1) {
            Object[] paths = TestTreePanel.createNodeList(what);
            DefaultListModel<Object> model = new DefaultListModel<Object>();
            for (int i = paths.length; i > 0; --i) {
                model.add(model.getSize(), paths[model.getSize()]);
            }
            int confirm = this.showConfirmListDialog("treep.refreshNodeSure", paths, model);
            if (confirm != 0) {
                return;
            }
            ack = true;
            for (int i = 0; i < what.length; ++i) {
                Object item = what[i].getLastPathComponent();
                if (item instanceof TT_TestNode) {
                    ackTargets[i] = ((TT_TestNode)item).getLongPath();
                    ackNodes = (TT_TreeNode[])DynamicArray.append(ackNodes, (TT_TestNode)item, TT_TreeNode.class);
                    continue;
                }
                if (!(item instanceof TT_BasicNode)) continue;
                ackNodes = (TT_TreeNode[])DynamicArray.append(ackNodes, (TT_BasicNode)item, TT_TreeNode.class);
                TT_BasicNode tn = (TT_BasicNode)item;
                if (!tn.isRoot()) continue;
                ackTargets = new String[]{null};
                break;
            }
        } else if (what[0].getLastPathComponent() instanceof TestResult) {
            TestResult tr = (TestResult)what[0].getLastPathComponent();
            int confirm = this.uif.showYesNoDialog("treep.refreshTestSure", tr.getTestName());
            if (confirm != 0) {
                return;
            }
            ack = true;
            ackTargets[0] = tr.getTestName();
        } else {
            TT_TreeNode tn = (TT_TreeNode)what[0].getLastPathComponent();
            int confirm = 1;
            ackTargets[0] = tn.getLongPath();
            confirm = tn.isRoot() ? this.uif.showYesNoDialog("treep.refreshRootSure") : this.uif.showYesNoDialog("treep.refreshNodeSure", ackTargets[0]);
            if (confirm != 0) {
                return;
            }
            ack = true;
            if (tn instanceof TT_BasicNode) {
                ackNodes = new TT_TreeNode[]{(TT_BasicNode)tn};
            }
        }
        if (ack) {
            final JDialog d = this.uif.createWaitDialog("treep.waitRef", this);
            String[] finalTargets = ackTargets;
            Object[] finalNodes = ackNodes;
            TreePath[] tp = this.tree.snapshotOpenPaths();
            String[] openUrls = this.treeModel.pathsToStrings(tp);
            String[] selectedUrls = this.treeModel.pathsToStrings(this.tree.snapshotSelectedPaths());
            this.setPopupItemsEnabled(false);
            final Thread t = new Thread((TT_TreeNode[])finalNodes, finalTargets, d, openUrls, selectedUrls){
                final /* synthetic */ TT_TreeNode[] val$finalNodes;
                final /* synthetic */ String[] val$finalTargets;
                final /* synthetic */ JDialog val$d;
                final /* synthetic */ String[] val$openUrls;
                final /* synthetic */ String[] val$selectedUrls;
                {
                    this.val$finalNodes = tT_TreeNodeArray;
                    this.val$finalTargets = stringArray;
                    this.val$d = jDialog;
                    this.val$openUrls = stringArray2;
                    this.val$selectedUrls = stringArray3;
                    this.setName("Tree refresh");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean updateTree;
                    if (trt == null) {
                        return;
                    }
                    boolean changes = false;
                    try {
                        int i;
                        trt.waitUntilReady();
                        TestTreePanel.this.treeModel.pauseWork();
                        if (this.val$finalNodes == null) {
                            for (i = 0; i < this.val$finalTargets.length; ++i) {
                                try {
                                    if (!(this.val$finalTargets[i] instanceof String)) continue;
                                    changes = trt.refreshIfNeeded(this.val$finalTargets[i]);
                                    continue;
                                }
                                catch (TestResultTable.Fault f) {
                                    WorkDirectory wd = TestTreePanel.this.execModel.getWorkDirectory();
                                    if (wd == null) continue;
                                    I18NResourceBundle i18n = TestTreePanel.this.uif.getI18NResourceBundle();
                                    wd.log(i18n, "treep.refFail", new String[]{this.val$finalTargets[i], f.getMessage()});
                                }
                            }
                        } else {
                            for (i = 0; i < this.val$finalNodes.length; ++i) {
                                try {
                                    if (this.val$finalNodes[i] instanceof TT_TestNode) {
                                        changes = trt.refreshIfNeeded(((TT_TestNode)this.val$finalNodes[i]).getLongPath());
                                        continue;
                                    }
                                    changes = trt.refreshIfNeeded(((TT_BasicNode)this.val$finalNodes[i]).getTableNode());
                                    if (!changes) continue;
                                    trt.prune(((TT_BasicNode)this.val$finalNodes[i]).getTableNode());
                                    continue;
                                }
                                catch (TestResultTable.Fault f) {
                                    WorkDirectory wd = TestTreePanel.this.execModel.getWorkDirectory();
                                    if (wd == null) continue;
                                    I18NResourceBundle i18n = TestTreePanel.this.uif.getI18NResourceBundle();
                                    wd.log(i18n, "treep.refFail", new String[]{this.val$finalTargets[i], f.getMessage()});
                                }
                            }
                        }
                        TestTreePanel.this.treeModel.unpauseWork();
                        updateTree = changes;
                    }
                    catch (Throwable throwable) {
                        TestTreePanel.this.treeModel.unpauseWork();
                        boolean updateTree2 = changes;
                        try {
                            EventQueue.invokeAndWait(new Runnable(updateTree2){
                                final /* synthetic */ boolean val$updateTree;
                                {
                                    this.val$updateTree = bl;
                                }

                                public void run() {
                                    if (val$d.isShowing()) {
                                        val$d.hide();
                                    }
                                    TestTreePanel.this.setPopupItemsEnabled(true);
                                    if (this.val$updateTree) {
                                        TestTreePanel.this.restoreOpenTreePaths(val$openUrls);
                                        TestTreePanel.this.tree.restoreSelection(val$selectedUrls);
                                    }
                                }
                            });
                        }
                        catch (InterruptedException e) {
                        }
                        catch (InvocationTargetException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            };
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (t == null) {
                        return;
                    }
                    if (t.isAlive() && !d.isVisible()) {
                        d.show();
                    } else if (!t.isAlive() && d.isVisible()) {
                        d.hide();
                    }
                }
            };
            this.bgThread = t;
            Timer timer = new Timer(3000, al);
            timer.setRepeats(true);
            timer.start();
            t.start();
        }
    }

    private void refreshFilters() {
        if (this.execModel instanceof ExecTool) {
            ExecTool et = (ExecTool)this.execModel;
            et.filterHandler.updateFilters();
        }
    }

    private void restoreOpenTreePaths(String[] urls) {
        this.tree.restorePaths(urls, true);
    }

    @Override
    public synchronized void updateGUI() {
        MenuElement[] elems;
        if (debug) {
            Debug.println("TTP.updateGUI()");
        }
        if (!this.initialized) {
            return;
        }
        if (this.disposed) {
            return;
        }
        this.applyParameters(false);
        if (this.popup != null && this.params != null && (elems = this.popup.getSubElements()) != null) {
            boolean haveWorkDir = this.params.getWorkDirectory() != null;
            this.purgeMI.setEnabled(haveWorkDir);
            this.refreshMI.setEnabled(this.params.getTestSuite() != null);
            this.runMI.setEnabled(!this.execModel.isConfiguring());
        }
        this.tree.updateGUI();
        this.brPanel.updateGUI();
        this.startTreeUpdate();
    }

    private synchronized void startTreeUpdate() {
        final TestResultTable trt = this.getTestResultTable();
        if (trt != null && this.pm != null) {
            trt.addObserver(this.pm);
        }
        if (trt != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    new Thread("Test tree updater"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (trt != null && trt.getWorkDirectory() != null && TestTreePanel.this.treeModel != null && !TestTreePanel.this.disposed) {
                                try {
                                    TestTreePanel.this.treeModel.pauseWork();
                                    trt.getLock().lock();
                                    trt.waitUntilReady();
                                    trt.refreshIfNeeded(trt.getRoot());
                                    TT_BasicNode root = (TT_BasicNode)TestTreePanel.this.treeModel.getRoot();
                                    for (int i = 0; i >= 0 && i < root.getChildCount(); ++i) {
                                        TT_BasicNode tn;
                                        TreeNode c = root.getChildAt(i);
                                        if (!(c instanceof TT_BasicNode) || (tn = (TT_BasicNode)c).getChildCount() != 0) continue;
                                        trt.prune(tn.getTableNode());
                                        --i;
                                    }
                                    String[] openPaths = null;
                                    String[] selectedPaths = null;
                                    if (TestTreePanel.this.tree != null) {
                                        TreePath[] p = TestTreePanel.this.tree.snapshotOpenPaths();
                                        openPaths = TestTreePanel.this.treeModel.pathsToStrings(p);
                                        selectedPaths = TestTreePanel.this.treeModel.pathsToStrings(TestTreePanel.this.tree.snapshotSelectedPaths());
                                    }
                                    if (TestTreePanel.this.pm != null) {
                                        TestTreePanel.this.pm.refreshTree();
                                    }
                                    if (TestTreePanel.this.tree != null) {
                                        TestTreePanel.this.tree.invalidate();
                                        if (openPaths != null && openPaths.length > 0) {
                                            TestTreePanel.this.tree.restorePaths(openPaths, true);
                                        }
                                        TestTreePanel.this.tree.restoreSelection(selectedPaths);
                                    }
                                }
                                catch (TestResultTable.Fault fault) {
                                }
                                finally {
                                    trt.getLock().unlock();
                                    if (!TestTreePanel.this.disposed) {
                                        TestTreePanel.this.treeModel.unpauseWork();
                                    }
                                }
                            }
                        }
                    }.start();
                }
            });
        }
    }

    private synchronized void initGUI() {
        JavaTestContextMenu[] cms;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.setName("treeAndDetails");
        JSplitPane splitPane = this.uif.createSplitPane(1);
        this.listener = new Listener();
        WorkDirectory wd = this.execModel.getWorkDirectory();
        ContextManager cm = this.execModel.getContextManager();
        if (wd == null && cm != null && cm.getFeatureManager().isEnabled(7)) {
            cm.openTree(null);
            this.treeModel = new EmptyTestTreeModel(this.params, this.filterHandler, this.uif);
        } else {
            cm.openTree(wd);
            this.treeModel = new TestTreeModel(this.params, this.filterHandler, this.uif);
        }
        this.treeRend = new TT_Renderer(this.uif, this.filterHandler, this.pm);
        this.tree = new TestTree(this.uif, this.pm, this.filterHandler, this.treeModel);
        this.tree.setTreeModel(this.treeModel);
        this.tree.setCellRenderer(this.treeRend);
        this.tree.addTreeSelectionListener(this.listener);
        this.tree.addTreeExpansionListener(this.listener);
        this.tree.addMouseListener(this.listener);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.getInputMap(1).put(KeyStroke.getKeyStroke(121, 1, false), "triggerPopup");
        this.tree.getActionMap().put("triggerPopup", new TreePopupAction(this.uif.getI18NResourceBundle(), "treep.popup"));
        this.uif.setAccessibleInfo(this.tree, "treep.tree");
        JPanel left = this.uif.createPanel("tree", new BorderLayout(), false);
        left.add((Component)this.uif.createScrollPane(this.tree, 20, 30), "Center");
        splitPane.setLeftComponent(left);
        this.deck = new Deck(){

            public Dimension getPreferredSize() {
                int dpi = TestTreePanel.this.uif.getDotsPerInch();
                return new Dimension(6 * dpi, 4 * dpi);
            }
        };
        this.testPanel = new TestPanel(this.uif, this.harness, this.execModel.getContextManager());
        this.brPanel = new BranchPanel(this.uif, this.pm, this.harness, this.execModel, this.parent, this.filterHandler, this.treeModel);
        this.msPanel = new MultiSelectPanel(this.uif, this.pm, this.treeModel);
        this.deck.add(this.testPanel);
        this.deck.add(this.brPanel);
        this.deck.add(this.msPanel);
        this.deckPanel = this.uif.createPanel("main", false);
        this.deckPanel.setLayout(new BorderLayout());
        this.deckPanel.add((Component)this.deck, "Center");
        this.titleField = this.uif.createOutputField("treep.title");
        this.titleField.setBorder(null);
        this.titleField.setText(this.uif.getI18NString("treep.title.noSelection.txt"));
        this.titleField.setBackground(UIFactory.Colors.MENU_BACKGROUND.getValue());
        this.titleField.setForeground(new Color(102, 102, 102));
        Font f = UIFactory.getBaseFont();
        this.titleField.setFont(new Font("Ariel", 1, f.getSize()));
        this.titleField.setEnabled(true);
        this.titleField.setEditable(false);
        this.deckPanel.add((Component)this.titleField, "North");
        splitPane.setRightComponent(this.deckPanel);
        this.testPanel.setVisible(false);
        this.brPanel.setVisible(false);
        this.deck.setVisible(true);
        this.deckPanel.setVisible(true);
        splitPane.setDividerLocation(0.3);
        splitPane.setResizeWeight(0.3);
        this.ensureTreeSelection();
        this.popup = this.uif.createPopupMenu("treep.popup.mnu");
        this.runMI = this.uif.createMenuItem("treep.popup", "run", this.listener);
        this.popup.add(this.runMI);
        this.popup.addSeparator();
        this.refreshMI = this.uif.createMenuItem("treep.popup", "refresh", this.listener);
        this.popup.add(this.refreshMI);
        this.purgeMI = this.uif.createMenuItem("treep.popup", "clear", this.listener);
        this.popup.add(this.purgeMI);
        if (cm != null && (cms = cm.getContextMenus()) != null) {
            this.popup.addSeparator();
            for (int i = 0; i < cms.length; ++i) {
                switch (cms[i].getMenuApplication()) {
                    case 0: {
                        if (this.mixedMenus == null) {
                            this.mixedMenus = new ArrayList();
                        }
                        this.mixedMenus.add(cms[i]);
                        break;
                    }
                    case 1: {
                        if (this.testMenus == null) {
                            this.testMenus = new ArrayList();
                        }
                        this.testMenus.add(cms[i]);
                        break;
                    }
                    case 2: {
                        if (this.folderMenus == null) {
                            this.folderMenus = new ArrayList();
                        }
                        this.folderMenus.add(cms[i]);
                        break;
                    }
                    case 99: {
                        if (this.customMenus == null) {
                            this.customMenus = new ArrayList();
                        }
                        this.customMenus.add(cms[i]);
                        break;
                    }
                }
                this.popup.add(cms[i].getMenu());
            }
        }
        this.runMI.setEnabled(false);
        this.refreshMI.setEnabled(false);
        this.purgeMI.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.applyParameters(false);
        TestResultTable trt = this.treeModel.getTestResultTable();
        if (wd != null && trt != null) {
            try {
                wd.setTestResultTable(trt);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    private void ensureTreeSelection() {
        block3: {
            if (this.tree.getSelectionPath() == null) {
                TreeModel tm = this.tree.getModel();
                try {
                    TT_BasicNode root = (TT_BasicNode)tm.getRoot();
                    this.tree.setRootVisible(true);
                    EventQueue.invokeLater(new Selector(root, new TreePath(root)));
                }
                catch (ClassCastException e) {
                    if (!debug) break block3;
                    e.printStackTrace(Debug.getWriter());
                }
            }
        }
    }

    private void updatePopupMenu() {
        block42: {
            JavaTestContextMenu m;
            TreePath[] paths;
            block40: {
                int i;
                block43: {
                    int i2;
                    Object item;
                    block41: {
                        int i3;
                        paths = this.tree.getSelectionPaths();
                        if (paths == null || paths.length == 0) {
                            return;
                        }
                        if (paths.length != 1) break block40;
                        item = paths[0];
                        if (item instanceof TreePath) {
                            item = ((TreePath)item).getLastPathComponent();
                        }
                        if (!(item instanceof TT_TestNode)) break block41;
                        TestResult tr = ((TT_TestNode)item).getTestResult();
                        if (this.testMenus != null) {
                            for (i3 = 0; i3 < this.testMenus.size(); ++i3) {
                                ((JavaTestContextMenu)this.testMenus.get(i3)).getMenu().setEnabled(true);
                                ((JavaTestContextMenu)this.testMenus.get(i3)).updateState(tr);
                            }
                        }
                        if (this.customMenus != null) {
                            for (i3 = 0; i3 < this.customMenus.size(); ++i3) {
                                ((JavaTestContextMenu)this.customMenus.get(i3)).updateState(tr);
                            }
                        }
                        if (this.mixedMenus != null) {
                            for (i3 = 0; i3 < this.mixedMenus.size(); ++i3) {
                                ((JavaTestContextMenu)this.mixedMenus.get(i3)).getMenu().setEnabled(true);
                                ((JavaTestContextMenu)this.mixedMenus.get(i3)).updateState(tr);
                            }
                        }
                        if (this.folderMenus == null) break block42;
                        for (i3 = 0; i3 < this.folderMenus.size(); ++i3) {
                            ((JavaTestContextMenu)this.folderMenus.get(i3)).getMenu().setEnabled(false);
                        }
                        break block42;
                    }
                    if (!(item instanceof TT_BasicNode)) break block43;
                    String url = ((TT_BasicNode)item).getLongPath();
                    if (url == null) {
                        url = "";
                    }
                    if (this.testMenus != null) {
                        for (i2 = 0; i2 < this.testMenus.size(); ++i2) {
                            ((JavaTestContextMenu)this.testMenus.get(i2)).getMenu().setEnabled(false);
                        }
                    }
                    if (this.customMenus != null) {
                        for (i2 = 0; i2 < this.customMenus.size(); ++i2) {
                            ((JavaTestContextMenu)this.customMenus.get(i2)).updateState(url);
                        }
                    }
                    if (this.mixedMenus != null) {
                        for (i2 = 0; i2 < this.mixedMenus.size(); ++i2) {
                            ((JavaTestContextMenu)this.mixedMenus.get(i2)).getMenu().setEnabled(true);
                            ((JavaTestContextMenu)this.mixedMenus.get(i2)).updateState(url);
                        }
                    }
                    if (this.folderMenus == null) break block42;
                    for (i2 = 0; i2 < this.folderMenus.size(); ++i2) {
                        ((JavaTestContextMenu)this.folderMenus.get(i2)).getMenu().setEnabled(true);
                        ((JavaTestContextMenu)this.folderMenus.get(i2)).updateState(url);
                    }
                    break block42;
                }
                if (this.testMenus != null) {
                    for (i = 0; i < this.testMenus.size(); ++i) {
                        ((JavaTestContextMenu)this.testMenus.get(i)).getMenu().setEnabled(false);
                    }
                }
                if (this.customMenus != null) {
                    for (i = 0; i < this.customMenus.size(); ++i) {
                        ((JavaTestContextMenu)this.customMenus.get(i)).getMenu().setEnabled(false);
                    }
                }
                if (this.mixedMenus != null) {
                    for (i = 0; i < this.mixedMenus.size(); ++i) {
                        ((JavaTestContextMenu)this.mixedMenus.get(i)).getMenu().setEnabled(false);
                    }
                }
                if (this.folderMenus != null) {
                    for (i = 0; i < this.folderMenus.size(); ++i) {
                        ((JavaTestContextMenu)this.folderMenus.get(i)).getMenu().setEnabled(false);
                    }
                }
                if (!(this.tree.getModel() instanceof EmptyTestTreeModel)) {
                    throw new JavaTestError("Unknown node type from JTree!");
                }
                break block42;
            }
            ArrayList<TestResult> tests = new ArrayList<TestResult>();
            ArrayList<String> folders = new ArrayList<String>();
            for (int i = 0; i < paths.length; ++i) {
                Object item = paths[i];
                if (item instanceof TreePath) {
                    item = ((TreePath)item).getLastPathComponent();
                }
                if (item instanceof TT_TestNode) {
                    tests.add(((TT_TestNode)item).getTestResult());
                    continue;
                }
                TT_BasicNode bn = (TT_BasicNode)item;
                if (bn.isRoot()) {
                    folders.add("");
                    continue;
                }
                folders.add(bn.getLongPath());
            }
            TestResult[] t = null;
            if (tests.size() > 0) {
                t = tests.toArray(new TestResult[tests.size()]);
            }
            String[] f = null;
            if (folders.size() > 0) {
                f = folders.toArray(new String[folders.size()]);
            }
            if (this.testMenus != null) {
                for (int i = 0; i < this.testMenus.size(); ++i) {
                    m = (JavaTestContextMenu)this.testMenus.get(i);
                    m.getMenu().setEnabled(m.isMultiSelectAllowed());
                    m.updateState(f, t);
                }
            }
            if (this.customMenus != null) {
                for (int i = 0; i < this.customMenus.size(); ++i) {
                    m = (JavaTestContextMenu)this.customMenus.get(i);
                    m.getMenu().setEnabled(m.isMultiSelectAllowed());
                    m.updateState(f, t);
                }
            }
            if (this.mixedMenus != null) {
                for (int i = 0; i < this.mixedMenus.size(); ++i) {
                    m = (JavaTestContextMenu)this.mixedMenus.get(i);
                    m.getMenu().setEnabled(m.isMultiSelectAllowed());
                    m.updateState(f, t);
                }
            }
            if (this.folderMenus != null) {
                for (int i = 0; i < this.folderMenus.size(); ++i) {
                    m = (JavaTestContextMenu)this.folderMenus.get(i);
                    m.getMenu().setEnabled(m.isMultiSelectAllowed());
                    m.updateState(f, t);
                }
            }
        }
    }

    private void selectTest(TestResult tr, TreePath path) {
        if (debug) {
            Debug.println("TTP showing: " + tr);
            Debug.println("   -> path provided is " + path.getPathCount() + " components long.");
        }
        if (this.disposed) {
            if (debug) {
                Debug.println("TTP - selectTest() not running, panel is disposed.");
            }
            return;
        }
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display a leaf. No action.");
            }
            return;
        }
        this.brPanel.setVisible(false);
        this.deck.show(this.testPanel);
        TreePath jtPath = this.treeModel.resolveUrl(tr.getTestName());
        if (jtPath != null && !this.tree.isPathSelected(jtPath)) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(jtPath);
        }
        if (!this.tree.isVisible(jtPath)) {
            this.tree.scrollPathToVisible(jtPath);
        }
        if (tr != this.testPanel.getTest()) {
            this.activeTest = tr.getTestName();
            TestResult atr = this.pm.getActive(tr);
            this.testPanel.setTest(atr == null ? tr : atr);
        }
        this.titleField.setText(this.uif.getI18NString("treep.test", tr.getTestName()));
        this.testPanel.setVisible(true);
        this.tree.repaint();
        this.deckPanel.repaint();
    }

    private void selectBranch(TT_BasicNode tn, TreePath path) {
        if (debug) {
            Debug.println("TTP showing: " + tn.getShortName());
            Debug.println("   -> " + tn);
            Debug.println("   -> path provided is " + path.getPathCount() + " components long.");
        }
        if (this.disposed) {
            if (debug) {
                Debug.println("TTP - selectBranch() not running, panel is disposed.");
            }
            return;
        }
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display a branch. No action.");
            }
            return;
        }
        if (this.deck.getCurrentCard() != this.brPanel) {
            this.deck.show(this.brPanel);
            this.testPanel.setVisible(false);
            this.activeTest = null;
        }
        if (!this.tree.isPathSelected(path)) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(path);
        }
        if (!this.tree.isVisible(path)) {
            this.tree.scrollPathToVisible(path);
        }
        if (tn != this.brPanel.getNode()) {
            this.brPanel.setNode(tn);
            this.treeModel.setActiveNode(tn);
        }
        if (tn.isRoot()) {
            TestSuite ts = this.params.getTestSuite();
            String tsn = ts.getName();
            if (tsn != null) {
                this.titleField.setText(this.uif.getI18NString("treep.ts", tsn));
            } else {
                this.titleField.setText(this.uif.getI18NString("treep.ts", ts.getPath()));
            }
        } else {
            String nName = tn.getLongPath();
            this.titleField.setText(this.uif.getI18NString("treep.node", nName));
        }
        if (!this.brPanel.isVisible()) {
            this.brPanel.setVisible(true);
        }
        this.deckPanel.repaint();
        this.tree.repaint();
    }

    private void selectNodes(String[] paths) {
    }

    private void selectNodes(TreePath[] paths) {
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display selections. No action.");
            }
            return;
        }
        Object[] leaves = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            leaves[i] = paths[i].getLastPathComponent();
        }
        this.msPanel.setNodes(leaves);
        if (this.deck.getCurrentCard() != this.msPanel) {
            this.deck.show(this.msPanel);
            this.activeTest = null;
        }
        this.titleField.setText(this.uif.getI18NString("treep.ms"));
        this.msPanel.setVisible(true);
        this.deckPanel.repaint();
    }

    private int showConfirmListDialog(String prefix, Object[] args, ListModel model) {
        JPanel p = this.uif.createPanel("ttp.confirmPanel", false);
        JTextArea msg = this.uif.createMessageArea(prefix, args);
        p.setLayout(new BorderLayout());
        p.add((Component)msg, "North");
        JList list = this.uif.createList("treep.nodeList", model);
        p.add((Component)this.uif.createScrollPane(list, 20, 30), "Center");
        return this.uif.showCustomYesNoDialog(prefix, p);
    }

    private boolean isPopulated() {
        return this.params != null && this.params.getTestSuite() != null;
    }

    @Override
    public JMenu getMenu() {
        return null;
    }

    @Override
    public List<Action> getToolBarActionList() {
        return null;
    }

    @Override
    public void setHarness(Harness h) {
        this.harness = h;
        if (this.harness != null && this.pm == null) {
            this.pm = new PanelModel();
            this.harness.addObserver(this.pm);
        }
    }

    @Override
    public JComponent getViewComponent() {
        return this;
    }

    @Override
    public void setFilterSelectionHandler(FilterSelectionHandler fh) {
        this.filterHandler = fh;
    }

    @Override
    public void updated(Session.Event ev) {
        if (ev instanceof BasicSession.E_NewConfig) {
            this.setParameters(((BasicSession.E_NewConfig)ev).ip);
        } else if (ev instanceof BasicSession.E_NewWD) {
            WorkDirectory wd = ((BasicSession.E_NewWD)ev).wd;
            try {
                TestResultTable trt = this.getTestResultTable();
                if (trt != null && !wd.isTRTSet()) {
                    wd.setTestResultTable(trt);
                }
                this.applyParameters(true);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        } else if (ev instanceof BasicSessionControl.E_EditorVisibility) {
            this.runMI.setEnabled(!this.execModel.isConfiguring());
        }
    }

    private class PanelModel
    implements TreePanelModel,
    Harness.Observer,
    TestResultTable.Observer {
        private Hashtable<String, TestResult> runningTests;
        private Hashtable activeNodes;
        private Integer ONE = new Integer(1);

        PanelModel() {
            this.runningTests = new Hashtable();
            this.activeNodes = new Hashtable();
        }

        public void pauseWork() {
            if (TestTreePanel.this.treeModel != null) {
                TestTreePanel.this.treeModel.pauseWork();
            }
        }

        public void unpauseWork() {
            if (TestTreePanel.this.treeModel != null) {
                TestTreePanel.this.treeModel.unpauseWork();
            }
        }

        public void refreshTree() {
            String[] openPaths = null;
            String[] selectedPaths = null;
            if (TestTreePanel.this.tree != null) {
                TreePath[] p = TestTreePanel.this.tree.snapshotOpenPaths();
                openPaths = TestTreePanel.this.treeModel.pathsToStrings(p);
                selectedPaths = TestTreePanel.this.treeModel.pathsToStrings(TestTreePanel.this.tree.snapshotSelectedPaths());
            }
            if (TestTreePanel.this.treeModel != null) {
                TestTreePanel.this.treeModel.notifyFullStructure();
            }
            if (openPaths != null && openPaths.length > 0) {
                TestTreePanel.this.tree.restorePaths(openPaths, true);
            }
            if (TestTreePanel.this.tree != null) {
                TestTreePanel.this.tree.restoreSelection(selectedPaths);
            }
        }

        public void nodeSelected(Object node, TreePath path) {
        }

        public void testSelected(TestResult node, TreePath path) {
        }

        public void nodeUnSelected(Object node, TreePath path) {
        }

        public void testUnSelected(TestResult node, TreePath path) {
        }

        public void showNode(Object node, TreePath path) {
            TestTreePanel.this.selectBranch((TT_BasicNode)node, path);
        }

        public void showNode(String url) {
            TreePath path = TestTreePanel.this.treeModel.resolveUrl(url);
            if (path != null && path.getLastPathComponent() instanceof TT_BasicNode) {
                TestTreePanel.this.selectBranch((TT_BasicNode)path.getLastPathComponent(), path);
            }
        }

        public void showTest(TestResult node, TreePath path) {
            TestTreePanel.this.selectTest(node, path);
        }

        public void showTest(TestResult tr) {
            TreePath tp = TestTreePanel.this.treeModel.resolveUrl(tr.getTestName());
            if (tp != null && tp.getLastPathComponent() instanceof TT_TreeNode) {
                this.showTest(tr, tp);
            }
        }

        public void showTest(String url) {
            TestResultTable trt = this.getTestResultTable();
            if (trt == null) {
                return;
            }
            TestResult tr = trt.lookup(TestResult.getWorkRelativePath(url));
            if (tr != null) {
                this.showTest(tr);
            }
        }

        public void hideNode(Object node, TreePath path) {
        }

        public void hideTest(TestResult node, TreePath path) {
        }

        public TestResultTable getTestResultTable() {
            return TestTreePanel.this.treeModel.getTestResultTable();
        }

        public String getSelectedTest() {
            return TestTreePanel.this.activeTest;
        }

        public boolean isActive(TestResult tr) {
            return this.runningTests.containsKey(tr.getTestName());
        }

        public TestResult getActive(TestResult tr) {
            return this.runningTests.get(tr.getTestName());
        }

        public boolean isActive(TT_TreeNode node) {
            return this.activeNodes.containsKey(node);
        }

        public void startingTestRun(Parameters params) {
            TestTreePanel.this.runMI.setEnabled(false);
            TestTreePanel.this.purgeMI.setEnabled(false);
            TestTreePanel.this.refreshMI.setEnabled(false);
        }

        public void startingTest(TestResult tr) {
            if (TestTreePanel.this.treeModel == null) {
                return;
            }
            this.runningTests.put(tr.getTestName(), tr);
            TreePath tp = TestTreePanel.this.treeModel.urlToPath(tr.getTestName());
            if (tp != null) {
                Object[] nodes = tp.getPath();
                for (int i = 0; i < nodes.length; ++i) {
                    Object hit = this.activeNodes.get(nodes[i]);
                    if (hit == null) {
                        this.activeNodes.put(nodes[i], this.ONE);
                        continue;
                    }
                    this.activeNodes.put(nodes[i], new Integer(1 + (Integer)hit));
                }
            }
            TestTreePanel.this.tree.repaint();
        }

        public void finishedTest(TestResult tr) {
            if (TestTreePanel.this.treeModel == null) {
                return;
            }
            this.runningTests.remove(tr.getTestName());
            TestResultTable.TreeNode[] trtPath = TestResultTable.getObjectPath(tr);
            TT_BasicNode[] nodes = TestTreePanel.this.treeModel.translatePath(trtPath, false);
            if (tr.getTestName().equals(TestTreePanel.this.activeTest)) {
                Object[] p = new Object[nodes.length + 1];
                System.arraycopy(nodes, 0, p, 0, nodes.length);
                p[p.length - 1] = tr;
                EventQueue.invokeLater(new Selector(tr, new TreePath(p)));
            }
            if (nodes != null) {
                for (int i = 0; i < nodes.length; ++i) {
                    Integer n;
                    Object hit = this.activeNodes.get(nodes[i]);
                    if (hit == null) continue;
                    if (hit == this.ONE) {
                        this.activeNodes.remove(nodes[i]);
                        continue;
                    }
                    int currHits = (Integer)hit;
                    TT_BasicNode tT_BasicNode = nodes[i];
                    if (currHits == 2) {
                        n = this.ONE;
                    } else {
                        Integer n2 = new Integer(--currHits);
                        n = n2;
                    }
                    this.activeNodes.put(tT_BasicNode, n);
                }
            }
            TestTreePanel.this.tree.repaint();
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean allOK) {
            this.runningTests.clear();
            this.activeNodes.clear();
            TestTreePanel.this.runMI.setEnabled(!TestTreePanel.this.execModel.isConfiguring());
            TestTreePanel.this.purgeMI.setEnabled(true);
            TestTreePanel.this.refreshMI.setEnabled(true);
            TestTreePanel.this.tree.repaint();
        }

        public void error(String msg) {
        }

        public void update(TestResult oldValue, TestResult newValue) {
        }

        public void updated(TestResult whichTR) {
        }
    }

    private class TreePopupAction
    extends AbstractAction {
        private String name;
        private String desc;

        TreePopupAction(I18NResourceBundle bund, String key) {
            this.desc = bund.getString(key + ".desc");
            this.name = bund.getString(key + ".act");
        }

        public void actionPerformed(ActionEvent e) {
            if (TestTreePanel.this.disposed) {
                return;
            }
            TestTreePanel.this.lastPopupPath = TestTreePanel.this.tree.getSelectionPath();
            Rectangle loc = TestTreePanel.this.tree.getPathBounds(TestTreePanel.this.lastPopupPath);
            if (loc == null) {
                return;
            }
            TestTreePanel.this.updatePopupMenu();
            TestTreePanel.this.popup.show(TestTreePanel.this.tree, loc.x + (int)loc.getWidth(), loc.y + (int)loc.getHeight());
        }

        public Object getValue(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (key.equals("Name")) {
                return this.name;
            }
            if (key.equals("ShortDescription")) {
                return this.desc;
            }
            return null;
        }
    }

    class Selector
    implements Runnable {
        private TreePath tp;
        private TestResult tr;
        private TT_TreeNode tn;

        Selector(TestResult tr, TreePath path) {
            this.tr = tr;
            this.tp = path;
        }

        Selector(TT_TreeNode tn, TreePath path) {
            this.tn = tn;
            this.tp = path;
        }

        public void run() {
            if (this.tr != null) {
                TestTreePanel.this.selectTest(this.tr, this.tp);
            } else {
                TestTreePanel.this.selectBranch((TT_BasicNode)this.tn, this.tp);
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    TreeSelectionListener,
    TreeExpansionListener {
        private int lastX;
        private int lastY;

        private Listener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (e.isAddedPath() && e.getSource() == TestTreePanel.this.tree) {
                TreePath[] tp = e.getPaths();
                TestTree source = (TestTree)e.getSource();
                this.dispatchSelection(source);
            }
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            if (TestTreePanel.this.disposed) {
                return;
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
            if (TestTreePanel.this.disposed || TestTreePanel.this.treeModel instanceof EmptyTestTreeModel) {
                return;
            }
            TreePath tp = event.getPath();
            TT_BasicNode tn = (TT_BasicNode)tp.getLastPathComponent();
            for (int i = 0; i < tn.getChildCount(); ++i) {
                TestTreePanel.this.treeModel.addRelevantNode((TT_TreeNode)tn.getChildAt(i));
            }
        }

        private void dispatchSelection(TestTree source) {
            TreePath[] paths = source.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return;
            }
            if (paths.length == 1) {
                Object target = paths[0].getLastPathComponent();
                if (target instanceof TT_TestNode) {
                    TestTreePanel.this.selectTest(((TT_TestNode)target).getTestResult(), paths[0]);
                } else if (target instanceof TT_BasicNode) {
                    TestTreePanel.this.selectBranch((TT_BasicNode)target, paths[0]);
                } else if (debug) {
                    Debug.println("Unknown node click target in TestTreePanel: ");
                    Debug.println("   => " + target);
                }
            } else {
                TestTreePanel.this.selectNodes(paths);
            }
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void updateSelection(MouseEvent e) {
            TreePath pathClicked = TestTreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
            if (pathClicked != null && TestTreePanel.this.tree.getSelectionCount() <= 1 && TestTreePanel.this.tree.getSelectionPath() != pathClicked) {
                TestTreePanel.this.tree.setSelectionPath(pathClicked);
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && e.getComponent() == TestTreePanel.this.tree) {
                this.lastX = e.getX();
                this.lastY = e.getY();
                this.updateSelection(e);
                TestTreePanel.this.updatePopupMenu();
                TestTreePanel.this.popup.show(e.getComponent(), this.lastX, this.lastY);
            }
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = TestTreePanel.this.tree.getSelectionPaths();
            if (e.getActionCommand().equals("clear")) {
                if (paths != null && paths.length > 0) {
                    TestTreePanel.this.clearNodes(TestTreePanel.this.tree.getSelectionPaths());
                }
            } else if (e.getActionCommand().equals("run")) {
                if (paths != null && paths.length > 0) {
                    for (int i = 0; i < paths.length; ++i) {
                        Object target;
                        if (paths[i].getPathCount() > 1 || !((target = paths[i].getPathComponent(0)) instanceof TT_TreeNode) || !((TT_TreeNode)target).isRoot()) continue;
                        paths = new TreePath[]{new TreePath(target)};
                        break;
                    }
                    TestTreePanel.this.runNodes(paths);
                }
            } else if (e.getActionCommand().equals("refresh") && paths != null && paths.length > 0) {
                TestTreePanel.this.refreshNodes(TestTreePanel.this.tree.getSelectionPaths());
            }
        }
    }
}

