/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;

class OptionsPane
extends JPanel {
    private DefaultListModel listModel;
    private JList list;
    private CustomReport[] customReports;
    private JTextArea descriptionArea;
    private HashMap customBoxes;
    private JCheckBox cbXml;
    private JButton backBtn;
    private JButton okBtn;
    private JButton cancelBtn;
    private JCheckBox handleConfilctsBox;
    private JCheckBox resolveAsRecentBox;
    private ActionListener chTabListener;
    private ActionListener okListener;
    private JButton helpBtn;
    private Desktop desktop;
    private UIFactory uif;
    private static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();

    OptionsPane(UIFactory uif, Desktop desktop, ActionListener chTabListener, ActionListener okListener) {
        this.uif = uif;
        this.desktop = desktop;
        this.chTabListener = chTabListener;
        this.okListener = okListener;
        this.initGUI();
    }

    boolean resolveByRecent() {
        return this.resolveAsRecentBox.isSelected();
    }

    boolean isXmlReport() {
        return this.cbXml.isSelected();
    }

    CustomReport[] getCustomSelected() {
        return this.getActiveCustomReports().toArray(new CustomReport[0]);
    }

    protected void initGUI() {
        CustomReport val;
        this.setName("opts");
        this.setFocusable(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel title = this.uif.createLabel("opts.title");
        GridBagConstraints lc = new GridBagConstraints();
        lc.gridwidth = 0;
        lc.anchor = 17;
        lc.insets = new Insets(5, 5, 15, 5);
        lc.fill = 2;
        lc.weightx = 1.0;
        this.add((Component)title, lc);
        lc = new GridBagConstraints();
        lc.anchor = 12;
        lc.gridheight = 2;
        lc.insets.right = 10;
        JLabel conflictLabel = this.uif.createLabel("opts.conflict", true);
        this.add((Component)conflictLabel, lc);
        this.handleConfilctsBox = this.uif.createCheckBox("opts.handleconflict", true);
        lc = new GridBagConstraints();
        lc.anchor = 12;
        lc.fill = 2;
        lc.gridwidth = 0;
        this.handleConfilctsBox.setEnabled(false);
        this.add((Component)this.handleConfilctsBox, lc);
        this.resolveAsRecentBox = this.uif.createCheckBox("opts.resolverecent", true);
        lc = new GridBagConstraints();
        lc.anchor = 12;
        lc.fill = 2;
        this.add((Component)this.resolveAsRecentBox, lc);
        JPanel bottom = this.uif.createPanel("opts.bottom", false);
        bottom.setLayout(new BorderLayout());
        bottom.setBorder(BorderFactory.createCompoundBorder(this.uif.createTitledBorder("opts.bottom"), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        this.listModel = new DefaultListModel();
        CardLayout cards = new CardLayout();
        JPanel p = this.uif.createPanel("opts.typecards", cards, false);
        this.cbXml = this.uif.createCheckBox("opts.type.xml", false);
        this.listModel.addElement(this.cbXml);
        p.add("opts.type.xml", this.uif.createPanel("opts.blank", false));
        this.getCustomReports(p);
        this.list = this.uif.createList("opts.typel", this.listModel);
        this.list.setSelectionMode(0);
        SelectListener sl = new SelectListener(this.list, p, cards);
        this.list.addMouseListener(sl);
        this.list.addKeyListener(sl);
        this.list.addListSelectionListener(sl);
        this.list.setCellRenderer(new CheckBoxListCellRenderer());
        this.list.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        this.descriptionArea = this.uif.createMessageArea("opts.type.desc");
        this.descriptionArea.setRows(3);
        Font f = this.descriptionArea.getFont();
        f = f.deriveFont(0, f.getSize2D() - 1.0f);
        this.descriptionArea.setFont(f);
        if (this.customBoxes != null && this.list != null && (val = (CustomReport)this.customBoxes.get(this.list.getSelectedValue())) != null) {
            this.descriptionArea.setText(val.getDescription());
        }
        JPanel rightCenter = this.uif.createPanel("opts.blank", false);
        rightCenter.setLayout(new BorderLayout());
        rightCenter.add((Component)this.descriptionArea, "First");
        rightCenter.add((Component)p, "Center");
        bottom.add((Component)rightCenter, "Center");
        bottom.add((Component)this.list, "West");
        lc.insets.left = 0;
        lc.gridwidth = 1;
        lc.gridy = 3;
        lc.anchor = 18;
        lc.gridwidth = 0;
        lc.fill = 1;
        lc.weighty = 1.0;
        this.add((Component)bottom, lc);
        this.okBtn = this.uif.createButton("opts.ok", this.okListener);
        this.cancelBtn = this.uif.createCancelButton("opts.cancel");
        this.backBtn = this.uif.createButton("opts.back", this.chTabListener);
        this.helpBtn = this.uif.createHelpButton("opts.help", "mergeReports.window.csh");
        JButton[] buttons = new JButton[]{this.okBtn, this.cancelBtn, this.helpBtn};
        JPanel buttonsPanel = this.uif.createPanel("opts.but");
        GridBagConstraints co = new GridBagConstraints();
        co.anchor = 13;
        co.weightx = 1.0;
        co.gridwidth = 3;
        co.insets = new Insets(10, 0, 0, 0);
        GridBagConstraints bb = new GridBagConstraints();
        bb.anchor = 17;
        bb.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.backBtn, bb);
        this.add((Component)buttonsPanel, co);
        buttonsPanel.setLayout(new GridLayout(1, 3, 5, 5));
        GridBagConstraints b = new GridBagConstraints();
        b.anchor = 13;
        co.insets = new Insets(10, 0, 0, 0);
        for (int i = 0; i < buttons.length; ++i) {
            buttonsPanel.add(buttons[i]);
        }
        this.list.setSelectedIndex(0);
    }

    private int getCustomReports(JPanel p) {
        int i;
        int result = 0;
        Tool[] tools = this.desktop.getTools();
        ArrayList<CustomReport> customReportsList = new ArrayList<CustomReport>();
        for (i = 0; i < tools.length; ++i) {
            if (!(tools[i] instanceof ExecTool)) continue;
            ExecTool tool = (ExecTool)tools[i];
            InterviewParameters ip = tool.getInterviewParameters();
            CompositeFilter tf = new CompositeFilter(ip.getFilters());
            ReportSettings rs = new ReportSettings(ip);
            rs.setFilter(tf);
            ContextManager cm = tool.getContextManager();
            if (cm == null || cm.getCustomReports() == null) continue;
            for (CustomReport cr : cm.getCustomReports()) {
                cr.setEnviroment(rs);
                customReportsList.add(cr);
            }
        }
        this.customReports = customReportsList.toArray(new CustomReport[0]);
        if (this.customReports == null || this.customReports.length == 0) {
            this.customReports = null;
            return 0;
        }
        this.customBoxes = new HashMap();
        for (i = 0; i < this.customReports.length; ++i) {
            JCheckBox cb = new JCheckBox(this.customReports[i].getName());
            cb.setName(this.customReports[i].getReportId());
            this.listModel.addElement(cb);
            this.customBoxes.put(cb, this.customReports[i]);
            CustomReport.ReportConfigPanel[] ops = this.customReports[i].getOptionPanes();
            if (ops == null || ops.length == 0) {
                p.add(this.customReports[i].getReportId(), this.uif.createPanel("opts.blank", false));
            } else {
                JTabbedPane tp = this.uif.createTabbedPane("opts.custom.tabs");
                for (int j = 0; j < ops.length; ++j) {
                    tp.addTab(ops[j].getPanelName(), ops[j]);
                }
                p.add(this.customReports[i].getReportId(), tp);
            }
            ++result;
        }
        return result;
    }

    private ArrayList getActiveCustomReports() {
        ArrayList customReps = new ArrayList();
        if (this.customBoxes != null && this.customBoxes.size() > 0) {
            for (JCheckBox box : this.customBoxes.keySet()) {
                if (!box.isSelected()) continue;
                customReps.add(this.customBoxes.get(box));
            }
        }
        return customReps;
    }

    JButton[] getButtons() {
        return new JButton[]{this.backBtn, this.okBtn, this.cancelBtn, this.helpBtn};
    }

    private class CheckBoxListCellRenderer
    implements ListCellRenderer {
        private CheckBoxListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)value;
            if (isSelected) {
                comp.setOpaque(true);
                comp.setBackground(UIFactory.Colors.TEXT_HIGHLIGHT_COLOR.getValue());
            } else {
                comp.setOpaque(false);
                comp.setForeground(Color.black);
            }
            return comp;
        }
    }

    private class PanelEnableListener
    implements PropertyChangeListener {
        private Container theContainer;
        private HashSet enabledComp;

        PanelEnableListener(Container container) {
            this.theContainer = container;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            block2: {
                boolean newV;
                boolean oldV;
                block3: {
                    if (!"enabled".equals(evt.getPropertyName())) break block2;
                    oldV = (Boolean)evt.getOldValue();
                    newV = (Boolean)evt.getNewValue();
                    if (!oldV || newV) break block3;
                    Iterator chIt = this.collectChildren(this.theContainer, new ArrayList()).iterator();
                    this.enabledComp = new HashSet();
                    while (chIt.hasNext()) {
                        Component c = (Component)chIt.next();
                        if (!c.isEnabled()) continue;
                        this.enabledComp.add(c);
                        c.setEnabled(false);
                    }
                    break block2;
                }
                if (oldV || !newV || this.enabledComp == null) break block2;
                for (Component c : this.collectChildren(this.theContainer, new ArrayList())) {
                    if (!this.enabledComp.contains(c)) continue;
                    c.setEnabled(true);
                }
            }
        }

        private Collection collectChildren(Container comp, Collection c) {
            Component[] ch = comp.getComponents();
            for (int i = 0; i < ch.length; ++i) {
                c.add(ch[i]);
                if (!(ch[i] instanceof Container)) continue;
                this.collectChildren((Container)ch[i], c);
            }
            return c;
        }
    }

    private class SelectListener
    extends MouseInputAdapter
    implements KeyListener,
    ListSelectionListener {
        Object lastSelected;
        JList list;
        ListModel listModel;
        JPanel panel;
        CardLayout cards;
        double emptyCBW = new JCheckBox("").getPreferredSize().getWidth() + 2.0;

        SelectListener(JList lst, JPanel p, CardLayout cardLayout) {
            this.list = lst;
            this.listModel = this.list.getModel();
            this.lastSelected = this.listModel.getElementAt(0);
            this.panel = p;
            this.cards = cardLayout;
        }

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this.process(this.list.getSelectedIndex());
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getPoint().getX() <= this.emptyCBW) {
                this.process(this.list.locationToIndex(e.getPoint()));
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = this.list.getSelectedIndex();
            JCheckBox box = (JCheckBox)this.listModel.getElementAt(index);
            if (this.lastSelected != box) {
                this.cards.show(this.panel, box.getName());
                this.lastSelected = box;
            }
            this.enablePanel(box);
        }

        private void enablePanel(JCheckBox box) {
            CustomReport rep;
            for (int i = 0; i < this.panel.getComponentCount(); ++i) {
                JComponent tab = (JComponent)this.panel.getComponent(i);
                tab.setEnabled(box.isSelected());
            }
            if (box == OptionsPane.this.cbXml) {
                OptionsPane.this.descriptionArea.setText(OptionsPane.this.uif.getI18NString("opts.xmlDesc.txt"));
                return;
            }
            if (OptionsPane.this.customBoxes != null && (rep = (CustomReport)OptionsPane.this.customBoxes.get(box)) != null) {
                if (rep.getOptionPanes() != null) {
                    for (int i = 0; i < rep.getOptionPanes().length; ++i) {
                        rep.getOptionPanes()[i].setEnabled(box.isSelected());
                    }
                }
                OptionsPane.this.descriptionArea.setText(rep.getDescription());
            }
        }

        private void process(int index) {
            JCheckBox box = (JCheckBox)this.listModel.getElementAt(index);
            if (this.lastSelected == box) {
                box.doClick();
                this.list.repaint();
                this.enablePanel(box);
            }
            this.lastSelected = box;
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }
    }
}

