/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.servlets;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResultBrowser
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        TestResult.Section s;
        TestResult tr;
        String uri = req.getRequestURI();
        File file = new File(req.getRealPath(uri));
        if (!file.exists()) {
            res.sendError(404);
            return;
        }
        try {
            tr = new TestResult(file);
        }
        catch (TestResult.Fault e) {
            String msg = "File does not appear to be a valid test result file. The following exception was received while trying to open it: " + e.getLocalizedMessage();
            res.sendError(404, msg);
            return;
        }
        res.setContentType("text/html");
        PrintWriter out = new PrintWriter((OutputStream)res.getOutputStream());
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + file + "</title>");
        out.println("</head>");
        out.println("<body>");
        try {
            TestDescription td = tr.getDescription();
            out.println("<h1>Test Results: " + td.getRootRelativeURL() + "</h1>");
        }
        catch (TestResult.Fault e) {
            out.println("<h1>(Unknown test)</h1>");
        }
        String[] colors = new String[]{"lime", "red", "yellow", "aqua", null};
        String[] outcomes = new String[]{"Passed", "Failed", "Check output", "Error", "Not run"};
        Status status = tr.getStatus();
        String color = colors[status.getType()];
        String outcome = outcomes[status.getType()];
        out.println("<table cellpadding=5><tr><td" + (color != null ? " bgcolor=" + color : "") + ">" + "<b>" + outcome + "</b><td><b>" + status.getReason() + "</b></table>");
        out.println("<ul>");
        out.println("<li><a href=\"#td\">Test Description properties</a>");
        out.println("<li><a href=\"#tr\">Test Result properties</a>");
        out.println("<li><a href=\"#tr\">Test Environment</a>");
        out.println("<li><a href=\"#output\">Test Output</a>");
        out.println("<ul>");
        for (int i = 0; i < tr.getSectionCount(); ++i) {
            try {
                s = tr.getSection(i);
                out.println("<li><a href=\"#output-" + s.getTitle() + "\">" + s.getTitle() + "</a>");
                continue;
            }
            catch (TestResult.Fault f) {
                out.println("The following exception occurred while trying to determine the test description: " + f.getLocalizedMessage());
            }
        }
        out.println("</ul>");
        out.println("</ul>");
        out.println("<p><hr>");
        out.println("<h2><a name=td>Test Description properties</a></h2>");
        try {
            TestDescription td = tr.getDescription();
            out.println("<table>");
            Iterator iter = td.getParameterKeys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = td.getParameter(key);
                if (key.equals("$root") || key.equals("$file") || key.equals("testsuite") || key.equals("file")) {
                    out.println("<tr><td align=top>" + key + "<td><a href=\"" + value + "\">" + this.filter(value, false) + "</a>");
                    continue;
                }
                if (key.equals("source")) {
                    out.println("<tr><td align=top>" + key + "<td>");
                    String[] srcs = StringArray.split(value);
                    if (srcs == null) continue;
                    File tdFile = td.getFile();
                    String tdFilePath = tdFile == null ? null : tdFile.getPath();
                    String tdDir = tdFilePath == null ? null : tdFilePath.substring(0, tdFilePath.lastIndexOf(47) + 1);
                    for (int i = 0; i < srcs.length; ++i) {
                        if (tdDir == null) {
                            out.println(srcs[i]);
                            continue;
                        }
                        out.println("<a href=\"" + tdDir + srcs[i] + "\">" + srcs[i] + "</a>");
                    }
                    continue;
                }
                out.println("<tr><td align=top>" + key + "<td>" + this.filter(value, true));
            }
            out.println("</table>");
        }
        catch (TestResult.Fault e) {
            out.println("The following exception occurred while trying to determine the test description: " + e.getLocalizedMessage());
        }
        out.println("<p><hr>");
        out.println("<h2><a name=tr>Test Result properties</a></h2>");
        try {
            out.println("<table>");
            Enumeration e = tr.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                out.println("<tr><td>" + key + "<td>" + this.filter(tr.getProperty(key), true));
            }
        }
        catch (TestResult.Fault e) {
            out.println("The following exception occurred while trying to determine the test result properties: " + e.getLocalizedMessage());
        }
        finally {
            out.println("</table>");
        }
        out.println("<p><hr>");
        out.println("<h2><a name=env>Test Environment</a></h2>");
        try {
            Map env = tr.getEnvironment();
            if (env.size() == 0) {
                out.println("<tr><td>No environment details found");
            } else {
                out.println("<table>");
                for (Map.Entry e : env.entrySet()) {
                    String key = (String)e.getKey();
                    String value = (String)e.getValue();
                    out.println("<tr><td>" + key + "<td>" + this.filter(value, true));
                }
                out.println("</table>");
            }
        }
        catch (TestResult.Fault e) {
            out.println("The following exception occurred while trying to determine the test environment: " + e.getLocalizedMessage());
        }
        out.println("<p><hr>");
        out.println("<h2><a name=output>Test Output</a></h2>");
        if (tr.getSectionCount() == 0) {
            out.println("No output recorded.");
        } else {
            try {
                for (int i = 0; i < tr.getSectionCount(); ++i) {
                    s = tr.getSection(i);
                    if (i > 0) {
                        out.println("<p><hr align=left width=\"25%\">");
                    }
                    out.println("<h3><a name=\"output-" + s.getTitle() + "\">" + s.getTitle() + "</a></h3>");
                    String[] sects = s.getOutputNames();
                    for (int j = 0; j < sects.length; ++j) {
                        String output;
                        if (!sects[j].equals("messages")) {
                            out.println("<h4>Output: " + sects[j] + "</h4>");
                        }
                        if ((output = s.getOutput(sects[j])).equals("")) {
                            out.println("<em>(No output.)</em>");
                        }
                        out.println("<pre>" + output + "</pre>");
                    }
                    if (s.getStatus() == null) continue;
                    out.println("<h4>Status</h4>");
                    out.println(s.getStatus());
                }
            }
            catch (TestResult.ReloadFault f) {
                out.println("<b>Internal error while reading test results.</b>");
            }
        }
        out.println("<p><hr>");
        out.println("File: <em>" + file + "</em>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    private String filter(String s, boolean newlines) {
        if (!(s.indexOf(60) != -1 || s.indexOf(62) != -1 || newlines && s.indexOf(10) != -1)) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() * 2);
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '\n': {
                    if (newlines) {
                        sb.append("<br>");
                    }
                    sb.append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

