/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.help.HelpBroker;
import javax.help.JHelpContentViewer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class HelpLink
extends JComponent
implements Accessible {
    private String target;
    private String text = "link";
    private Font font;
    private Color color = Color.blue;
    public static final String HELPBROKER_FOR_HELPLINK = "helpBrokerForHelpLink";

    public HelpLink() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JHelpContentViewer cv = (JHelpContentViewer)SwingUtilities.getAncestorOfClass(JHelpContentViewer.class, e.getComponent());
                HelpBroker hb = (HelpBroker)cv.getClientProperty(HelpLink.HELPBROKER_FOR_HELPLINK);
                hb.setCurrentID(HelpLink.this.target);
                hb.setDisplayed(true);
            }
        });
        this.setCursor(new Cursor(12));
    }

    protected HelpLink(Object o) {
        this.setCursor(new Cursor(12));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return new Dimension(100, 10);
        }
        FontMetrics fm = this.font == null ? g.getFontMetrics() : g.getFontMetrics(this.font);
        int w = fm.stringWidth(this.text);
        int h = fm.getHeight();
        return new Dimension(w, h);
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.color);
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics();
        int baseLine = fm.getLeading() + fm.getMaxAscent();
        g.drawString(this.text, 0, baseLine);
        g.drawLine(0, baseLine + 1, fm.stringWidth(this.text) - 1, baseLine + 1);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTextFont() {
        return this.font == null ? null : this.font.toString();
    }

    public void setTextFont(String font) {
        this.font = Font.decode(font);
    }

    public String getTextColor() {
        return this.color.toString();
    }

    public void setTextColor(String color) {
        this.color = Color.decode(color);
    }
}

