/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.junit;

import com.sun.javatest.TestFinder;
import com.sun.javatest.junit.JUnitTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class JUnitSuperTestFinder
extends JUnitTestFinder
implements ClassVisitor {
    protected ArrayList<String> requiredSuperclass = new ArrayList();
    protected String initialTag = "test";
    protected final MethodFinderVisitor mfv = new MethodFinderVisitor();
    protected static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JUnitSuperTestFinder.class);

    public JUnitSuperTestFinder() {
        this.exclude(excludeNames);
    }

    protected void decodeAllArgs(String[] args) throws TestFinder.Fault {
        super.decodeAllArgs(args);
        for (int i = 0; i < args.length; ++i) {
            if (!"-superclass".equalsIgnoreCase(args[i])) continue;
            if (args.length <= i + 1) {
                this.error(i18n, "finder.missingsuper");
                return;
            }
            this.requiredSuperclass.add(args[++i]);
        }
        if (this.requiredSuperclass.size() == 0) {
            this.requiredSuperclass.add("junit.framework.TestCase");
        }
    }

    public void scan(File file) {
        this.currFile = file;
        if (file.isDirectory()) {
            this.scanDirectory(file);
        } else {
            this.scanFile(file);
        }
    }

    private void scanDirectory(File dir) {
        String[] names = dir.list();
        for (int i = 0; i < names.length; ++i) {
            String extn;
            String name = names[i];
            if (this.excludeList.containsKey(name)) continue;
            File file = new File(dir, name);
            if (file.isDirectory()) {
                if (this.verbose) {
                    System.out.println("dir: " + dir.getAbsolutePath());
                }
                this.scanDirectory(file);
                continue;
            }
            int dot = name.indexOf(46);
            if (dot == -1 || !this.extensionTable.containsKey(extn = name.substring(dot))) continue;
            this.foundFile(file);
        }
    }

    protected void scanFile(File file) {
        int dot;
        this.testMethods = new ArrayList();
        this.tdValues = new HashMap();
        String name = file.getName();
        if (this.verbose) {
            System.out.println(i18n.getString("finder.whichfile", (Object)name));
        }
        if ((dot = name.indexOf(46)) == -1) {
            return;
        }
        String classFile = "";
        if (this.scanClasses) {
            classFile = file.getPath();
        } else {
            String currentDir = new File("").getAbsolutePath();
            String sources = name;
            String filePath = file.getAbsolutePath().substring(currentDir.length() + 1, file.getAbsolutePath().length());
            if (filePath.startsWith("tests")) {
                classFile = currentDir + File.separator + "classes" + File.separator + filePath.substring(6, filePath.length());
            } else if (filePath.startsWith("test")) {
                classFile = currentDir + File.separator + "classes" + File.separator + filePath.substring(5, filePath.length());
            } else {
                return;
            }
            classFile = file.getAbsolutePath().replaceFirst("tests", "classes");
        }
        dot = classFile.lastIndexOf(46);
        classFile = classFile.substring(0, dot) + ".class";
        try {
            if (!new File(classFile).exists()) {
                System.out.println("classFile does not exist: " + classFile);
                return;
            }
            try {
                FileInputStream fis = new FileInputStream(classFile);
                ClassReader cr = new ClassReader((InputStream)fis);
                cr.accept((ClassVisitor)this, 0);
                if (this.tdValues.get("executeClass") == null) {
                    return;
                }
                if (this.testMethods.size() != 0) {
                    StringBuilder tms = new StringBuilder();
                    for (String n : this.testMethods) {
                        tms.append(n);
                        tms.append(" ");
                    }
                    tms.deleteCharAt(tms.length() - 1);
                    this.tdValues.put("junit.testmethods", tms.toString());
                }
                this.tdValues.put("keywords", "junit junit3");
                this.tdValues.put("junit.finderscantype", "superclass");
                this.tdValues.put("source", file.getPath());
                StringBuilder cls = new StringBuilder();
                for (String n : this.requiredSuperclass) {
                    cls.append(n);
                    cls.append(" ");
                }
                cls.deleteCharAt(cls.length() - 1);
                this.tdValues.put("junit.findersuperclasses", cls.toString());
                this.foundTestDescription(this.tdValues, this.currFile, 0);
            }
            catch (IOException e) {
                this.error(i18n, "finder.classioe", classFile);
            }
        }
        catch (Exception e) {
            System.out.println("!!! Exception: " + e);
        }
    }

    private boolean isMatchSuper(String cname) {
        if (cname == null || cname.equals("java.lang.Object")) {
            return false;
        }
        for (String n : this.requiredSuperclass) {
            if (!cname.equals(n)) continue;
            return true;
        }
        try {
            return this.isMatchSuper(this.mfv.getSuperClass(cname));
        }
        catch (IOException e) {
            this.error(i18n, "finder.cantsuper", cname);
            return false;
        }
    }

    public boolean isTestMethodSignature(String sig) {
        return sig.startsWith(this.initialTag);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.verbose) {
            System.out.println("found class " + name + " with super " + superName);
        }
        if (this.isMatchSuper(superName.replaceAll("/", "."))) {
            this.tdValues.put("executeClass", name.replaceAll("/", "."));
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (access == 1 && this.isTestMethodSignature(name)) {
            this.foundTestMethod(name);
        }
        return null;
    }

    public void visitSource(String string, String string0) {
    }

    public void visitOuterClass(String string, String string0, String string1) {
    }

    public AnnotationVisitor visitAnnotation(String string, boolean b) {
        return null;
    }

    public void visitAttribute(Attribute attribute) {
    }

    public void visitInnerClass(String string, String string0, String string1, int i) {
    }

    public FieldVisitor visitField(int i, String string, String string0, String string1, Object object) {
        return null;
    }

    public void visitEnd() {
    }

    private static class MethodFinderVisitor
    extends EmptyVisitor {
        String thisSupername;

        private MethodFinderVisitor() {
        }

        public String getSuperClass(String cname) throws IOException {
            ClassReader cr = new ClassReader(cname);
            cr.accept((ClassVisitor)this, 0);
            return this.thisSupername.replaceAll("/", ".");
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.thisSupername = superName;
        }
    }
}

