/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.junit;

import com.sun.javatest.TestFinder;
import com.sun.javatest.junit.JUnitTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class JUnitAnnotationTestFinder
extends JUnitTestFinder
implements ClassVisitor,
MethodVisitor {
    protected String currMethod;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JUnitAnnotationTestFinder.class);
    protected String methodAnnotation = "Lorg/junit/Test;";

    public JUnitAnnotationTestFinder() {
        this.exclude(excludeNames);
    }

    protected void decodeAllArgs(String[] args) throws TestFinder.Fault {
        super.decodeAllArgs(args);
    }

    public void scan(File file) {
        this.currFile = file;
        if (file.isDirectory()) {
            this.scanDirectory(file);
        } else {
            this.scanFile(file);
        }
    }

    public void foundTestMethod(String name) {
        this.testMethods.add(name);
    }

    private void scanDirectory(File dir) {
        String[] names = dir.list();
        for (int i = 0; i < names.length; ++i) {
            String extn;
            String name = names[i];
            if (this.excludeList.containsKey(name)) continue;
            File file = new File(dir, name);
            if (file.isDirectory()) {
                this.scanDirectory(file);
                continue;
            }
            int dot = name.indexOf(46);
            if (dot == -1 || !this.extensionTable.containsKey(extn = name.substring(dot))) continue;
            this.foundFile(file);
        }
    }

    protected void scanFile(File file) {
        this.testMethods = new ArrayList();
        this.tdValues = new HashMap();
        String name = file.getName();
        int dot = name.indexOf(46);
        if (dot == -1) {
            return;
        }
        String classFile = "";
        if (this.scanClasses) {
            classFile = file.getPath();
        } else {
            String currentDir = new File("").getAbsolutePath();
            String sources = name;
            String filePath = file.getAbsolutePath().substring(currentDir.length() + 1, file.getAbsolutePath().length());
            if (filePath.startsWith("tests")) {
                classFile = currentDir + File.separator + "classes" + File.separator + filePath.substring(6, filePath.length());
            } else if (filePath.startsWith("test")) {
                classFile = currentDir + File.separator + "classes" + File.separator + filePath.substring(5, filePath.length());
            } else {
                return;
            }
            classFile = file.getAbsolutePath().replaceFirst("tests", "classes");
        }
        dot = classFile.lastIndexOf(46);
        classFile = classFile.substring(0, dot) + ".class";
        try {
            if (!new File(classFile).exists()) {
                System.out.println("classFile does not exist: " + classFile);
                return;
            }
            try {
                FileInputStream fis = new FileInputStream(classFile);
                ClassReader cr = new ClassReader((InputStream)fis);
                cr.accept((ClassVisitor)this, 0);
                if (this.testMethods.size() != 0) {
                    StringBuilder tms = new StringBuilder();
                    for (String n : this.testMethods) {
                        tms.append(n);
                        tms.append(" ");
                    }
                    tms.deleteCharAt(tms.length() - 1);
                    this.tdValues.put("source", file.getPath());
                    this.tdValues.put("junit.testmethods", tms.toString());
                    this.tdValues.put("junit.finderscantype", "annotation");
                    this.tdValues.put("keywords", "junit junit4");
                    this.tdValues.put("executeClass", cr.getClassName().replaceAll("/", "."));
                    this.foundTestDescription(this.tdValues, this.currFile, 0);
                }
            }
            catch (IOException e) {
                this.error(i18n, "finder.classioe", classFile);
            }
        }
        catch (Exception e) {
            System.out.println("!!! Exception: " + e);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.verbose) {
            System.out.println("found class " + name + " with super " + superName);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (access == 1) {
            this.currMethod = name;
            return this;
        }
        return null;
    }

    public void visitSource(String string, String string0) {
    }

    public void visitOuterClass(String string, String string0, String string1) {
    }

    public AnnotationVisitor visitAnnotation(String string, boolean b) {
        if (this.methodAnnotation.equals(string)) {
            this.foundTestMethod(this.currMethod);
        }
        return null;
    }

    public void visitAttribute(Attribute attribute) {
    }

    public void visitInnerClass(String string, String string0, String string1, int i) {
    }

    public FieldVisitor visitField(int i, String string, String string0, String string1, Object object) {
        return null;
    }

    public void visitEnd() {
    }

    public void visitJumpInsn(int i, Label label) {
    }

    public void visitLineNumber(int i, Label label) {
    }

    public void visitLabel(Label label) {
    }

    public void visitTableSwitchInsn(int i, int i0, Label label, Label[] label0) {
    }

    public void visitLdcInsn(Object object) {
    }

    public void visitFrame(int i, int i0, Object[] object, int i1, Object[] object0) {
    }

    public void visitInsn(int i) {
    }

    public void visitLookupSwitchInsn(Label label, int[] i, Label[] label0) {
    }

    public void visitTryCatchBlock(Label label, Label label0, Label label1, String string) {
    }

    public void visitTypeInsn(int i, String string) {
    }

    public void visitMultiANewArrayInsn(String string, int i) {
    }

    public void visitMethodInsn(int i, String string, String string0, String string1) {
    }

    public void visitFieldInsn(int i, String string, String string0, String string1) {
    }

    public void visitLocalVariable(String string, String string0, String string1, Label label, Label label0, int i) {
    }

    public AnnotationVisitor visitParameterAnnotation(int i, String string, boolean b) {
        return null;
    }

    public void visitVarInsn(int i, int i0) {
    }

    public void visitMaxs(int i, int i0) {
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    public void visitCode() {
    }

    public void visitIincInsn(int i, int i0) {
    }

    public void visitIntInsn(int i, int i0) {
    }
}

