/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.junit;

import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.CommentStream;
import com.sun.javatest.finder.JavaCommentStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class JUnitTestFinder
extends TestFinder {
    protected boolean verbose = false;
    protected Map tdValues = new HashMap();
    protected boolean scanClasses = false;
    protected File currFile;
    protected HashMap excludeList = new HashMap();
    protected HashMap extensionTable = new HashMap();
    protected ArrayList<String> testMethods;
    protected static final String[] excludeNames = new String[]{"SCCS", "deleted_files", ".svn"};

    protected void decodeAllArgs(String[] args) throws TestFinder.Fault {
        for (int i = 0; i < args.length; ++i) {
            if ("-scanClasses".equalsIgnoreCase(args[i])) {
                this.scanClasses = true;
                this.addExtension(".class", null);
                continue;
            }
            if ("-verbose".equalsIgnoreCase(args[i])) {
                this.verbose = true;
                continue;
            }
            super.decodeArg(args, i);
        }
        if (!this.scanClasses) {
            this.addExtension(".java", JavaCommentStream.class);
        }
    }

    protected File getCurrentFile() {
        return this.currFile;
    }

    public void exclude(String name) {
        this.excludeList.put(name, name);
    }

    public void exclude(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            this.excludeList.put(name, name);
        }
    }

    public void addExtension(String extn, Class commentStreamClass) {
        if (!extn.startsWith(".")) {
            throw new IllegalArgumentException("extension must begin with `.'");
        }
        if (commentStreamClass != null && !CommentStream.class.isAssignableFrom(commentStreamClass)) {
            throw new IllegalArgumentException("class must be a subtype of " + CommentStream.class.getName());
        }
        this.extensionTable.put(extn, commentStreamClass);
    }

    public Class getClassForExtension(String extn) {
        return (Class)this.extensionTable.get(extn);
    }

    public void foundTestMethod(String name) {
        this.testMethods.add(name);
    }
}

