/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.exec.BP_BranchSubpanel;
import com.sun.javatest.exec.BP_Model;
import com.sun.javatest.exec.TT_BasicNode;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class BP_FilteredOutSubpanel
extends BP_BranchSubpanel {
    private JTable table;
    private TestTableModel mod;
    private TT_NodeCache cache;
    private TT_BasicNode lastNode;
    private CacheObserver cacheWatcher;
    private volatile TableSynchronizer resyncThread;
    private TableCellRenderer renderer;
    private InputListener listener;
    private JTextArea infoTa;
    private boolean rowHeightSet;
    private static final int ROW_HEIGHT_PADDING = 3;
    private JPopupMenu popupTable;
    private boolean debug = Debug.getBoolean(BP_FilteredOutSubpanel.class);

    BP_FilteredOutSubpanel(UIFactory uif, BP_Model bpm, TestTreeModel ttm) {
        super("fo", uif, bpm, ttm, "br.fo");
        this.init();
        CSH.setHelpIDString(this, "browse.filteredOutTab.csh");
        this.cacheWatcher = new CacheObserver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(TT_NodeCache cache) {
        BP_FilteredOutSubpanel bP_FilteredOutSubpanel = this;
        synchronized (bP_FilteredOutSubpanel) {
            if (this.cache != null) {
                this.cache.removeObserver(this.cacheWatcher);
            }
            this.cache = cache;
            if (this.resyncThread != null) {
                this.resyncThread.halt();
            }
            if (this.mod != null) {
                this.mod.reset();
            }
        }
        this.validateEnableState();
    }

    protected void invalidateFilters() {
        super.invalidateFilters();
        if (this.cache != null) {
            this.cache.removeObserver(this.cacheWatcher);
        }
        if (this.subpanelNode != null) {
            this.cache = this.ttm.getNodeInfo(this.subpanelNode.getTableNode(), false);
            this.validateEnableState();
        }
        this.updateInfoText();
    }

    protected synchronized void updateSubpanel(TT_BasicNode currNode) {
        super.updateSubpanel(currNode);
        if (this.lastNode != currNode || this.filtersInvalidated) {
            if (this.debug) {
                Debug.println("updating FO table");
            }
            if (this.resyncThread != null) {
                this.resyncThread.halt();
            }
            this.resyncThread = new TableSynchronizer();
            this.resyncThread.start();
            this.lastNode = currNode;
            this.filtersInvalidated = false;
            this.validateEnableState();
        }
    }

    private void updateInfoText() {
        if (this.infoTa == null) {
            return;
        }
        TestFilter f = this.model.getFilter();
        if (f != null) {
            this.infoTa.setText(this.uif.getI18NString("br.fo.info.txt", f.getName()));
        } else {
            this.infoTa.setText(this.uif.getI18NString("br.fo.noFn.txt"));
        }
    }

    private void validateEnableState() {
        if (this.cache.getRejectCount() > 0) {
            this.model.setEnabled(this, true);
        } else if (this.cache.getRejectCount() == 0) {
            this.model.setEnabled(this, false);
        }
    }

    private void init() {
        this.mod = new TestTableModel(this.uif);
        this.renderer = new TestCellRenderer(this.uif);
        this.listener = new InputListener();
        this.table = this.uif.createTable("br.fo.tbl", this.mod);
        this.table.setOpaque(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this.listener);
        TableColumn tc = this.table.getColumnModel().getColumn(0);
        tc.setCellRenderer(this.renderer);
        tc.setResizable(true);
        tc = this.table.getColumnModel().getColumn(1);
        tc.setCellRenderer(this.renderer);
        tc.setResizable(true);
        this.uif.setAccessibleInfo(this, "br.fo");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridy = 0;
        gbc.ipady = 12;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.infoTa = this.uif.createMessageArea("br.fo.info");
        this.infoTa.setOpaque(false);
        this.add((Component)this.infoTa, gbc);
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.uif.createScrollPane(this.table, 20, 30), gbc);
        this.updateInfoText();
        InputListener tableListener = new InputListener();
        this.table.addMouseListener(tableListener);
        this.table.getSelectionModel().addListSelectionListener(tableListener);
        this.table.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "gotoTest");
        this.table.getActionMap().put("gotoTest", new KbTableAction(this.uif.getI18NResourceBundle(), "br.list.enter"));
        String[] actions = new String[]{};
        this.popupTable = this.uif.createPopupMenu("br", actions, tableListener);
        actions = new String[]{"action.cpnamelist", "action.cpnamestr"};
        this.popupTable.add(this.uif.createMenu("br.cp", actions, tableListener));
        this.setMinimumSize(new Dimension(150, 100));
    }

    class TestCellRenderer
    extends DefaultTableCellRenderer {
        private Border spacerBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);

        public TestCellRenderer(UIFactory uif) {
            this.setOpaque(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            if (value instanceof TestResult) {
                TestResult tr = (TestResult)value;
                this.setText(tr.getTestName());
                this.setToolTipText(I18NUtils.getStatusMessage(tr.getStatus()));
            } else if (value instanceof TestFilter) {
                TestFilter tf = (TestFilter)value;
                this.setText(tf.getReason());
                this.setToolTipText(tf.getDescription());
            } else {
                this.setText(value.toString());
            }
            this.setBorder(this.spacerBorder);
            this.setFont(this.getFont().deriveFont(0));
            if (isSelected) {
                this.setOpaque(true);
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                this.setOpaque(false);
            }
            if (!BP_FilteredOutSubpanel.this.rowHeightSet) {
                table.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 3);
                BP_FilteredOutSubpanel.this.rowHeightSet = true;
            }
            return this;
        }
    }

    private class KbTableAction
    extends AbstractAction {
        private String name;
        private String desc;

        KbTableAction(I18NResourceBundle bund, String key) {
            this.desc = bund.getString(key + ".desc");
            this.name = bund.getString(key + ".act");
        }

        public void actionPerformed(ActionEvent e) {
            int row = BP_FilteredOutSubpanel.this.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            Object target = BP_FilteredOutSubpanel.this.table.getModel().getValueAt(row, 0);
            if (!(target instanceof TestResult)) {
                return;
            }
            TestResult tr = (TestResult)target;
            TestResultTable.TreeNode[] path = TestResultTable.getObjectPath(tr);
            if (path == null || path.length == 0) {
                return;
            }
            Object[] fp = new Object[path.length + 1];
            System.arraycopy(path, 0, fp, 0, path.length);
            fp[fp.length - 1] = tr;
            BP_FilteredOutSubpanel.this.model.showTest(tr, fp);
        }

        public Object getValue(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (key.equals("Name")) {
                return this.name;
            }
            if (key.equals("ShortDescription")) {
                return this.desc;
            }
            return null;
        }
    }

    class InputListener
    extends MouseAdapter
    implements ListSelectionListener,
    ActionListener {
        private int lastIndex = -2;

        InputListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows;
            if ((e.getActionCommand().equals("action.cpnamelist") || e.getActionCommand().equals("action.cpnamestr")) && (rows = BP_FilteredOutSubpanel.this.table.getSelectedRows()).length > 0) {
                String[] result = new String[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    if (BP_FilteredOutSubpanel.this.table.getValueAt(rows[i], 0) instanceof TestResult) {
                        TestResult r = (TestResult)BP_FilteredOutSubpanel.this.table.getValueAt(rows[i], 0);
                        result[i] = r.getTestName();
                        continue;
                    }
                    result[i] = BP_FilteredOutSubpanel.this.table.getValueAt(rows[i], 0).toString();
                }
                StringSelection payload = null;
                payload = e.getActionCommand().equals("action.cpnamestr") ? new StringSelection(StringArray.join(result)) : new StringSelection(StringArray.join(result, "\n"));
                if (payload != null) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(payload, null);
                    Clipboard selection = Toolkit.getDefaultToolkit().getSystemSelection();
                    if (selection != null) {
                        selection.setContents(payload, null);
                    }
                }
            }
            BP_FilteredOutSubpanel.this.table.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getComponent() == BP_FilteredOutSubpanel.this.table) {
                if (e.getButton() == 3) {
                    BP_FilteredOutSubpanel.this.popupTable.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    JTable tbl = (JTable)e.getComponent();
                    int col = BP_FilteredOutSubpanel.this.table.columnAtPoint(e.getPoint());
                    int row = BP_FilteredOutSubpanel.this.table.rowAtPoint(e.getPoint());
                    TableModel tm = BP_FilteredOutSubpanel.this.table.getModel();
                    if (tm.getRowCount() < 1) {
                        BP_FilteredOutSubpanel.this.showMessage("");
                        return;
                    }
                    TestResult tr = (TestResult)tm.getValueAt(row, 0);
                    if (e.getClickCount() == 1) {
                        BP_FilteredOutSubpanel.this.showMessage(I18NUtils.getStatusMessage(tr.getStatus()));
                    } else if (e.getClickCount() == 2) {
                        TestResultTable.TreeNode[] path = TestResultTable.getObjectPath(tr);
                        if (path == null || path.length == 0) {
                            return;
                        }
                        Object[] fp = new Object[path.length + 1];
                        System.arraycopy(path, 0, fp, 0, path.length);
                        fp[fp.length - 1] = tr;
                        BP_FilteredOutSubpanel.this.model.showTest(tr, fp);
                    }
                }
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = e.getLastIndex();
            if (BP_FilteredOutSubpanel.this.mod.getRowCount() == 0 || index >= BP_FilteredOutSubpanel.this.mod.getRowCount()) {
                return;
            }
            if (index != this.lastIndex) {
                TestResult tr = (TestResult)BP_FilteredOutSubpanel.this.mod.getValueAt(index, 0);
                BP_FilteredOutSubpanel.this.showMessage(I18NUtils.getStatusMessage(tr.getStatus()));
                this.lastIndex = index;
            }
        }
    }

    class TableNotifier
    implements Runnable {
        TT_BasicNode node;
        TestTableModel tm;
        private TableModelEvent tme;
        private boolean isValid = true;

        TableNotifier(TT_BasicNode n, TestTableModel m) {
            this.node = n;
            this.tm = m;
            this.tm.isUpdateScheduled = true;
        }

        TableNotifier(TableModelEvent e, TestTableModel m) {
            this.tm = m;
            this.tme = e;
        }

        public void run() {
            this.tm.pendingEvents.remove(this);
            if (!this.isValid) {
                return;
            }
            if (this.tme == null) {
                this.tm.isUpdateScheduled = false;
                this.tm.goLive();
            } else {
                this.tm.fireTableChanged(this.tme);
            }
        }

        public void cancel() {
            this.isValid = false;
        }
    }

    private class CacheObserver
    extends TT_NodeCache.TT_NodeCacheObserver {
        CacheObserver() {
            this.interestList[6] = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testAdded(int msgType, TestResultTable.TreeNode[] path, TestResult what, int index) {
            BP_FilteredOutSubpanel bP_FilteredOutSubpanel = BP_FilteredOutSubpanel.this;
            synchronized (bP_FilteredOutSubpanel) {
                BP_FilteredOutSubpanel.this.mod.addTest(what, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testRemoved(int msgType, TestResultTable.TreeNode[] path, TestResult what, int index) {
            BP_FilteredOutSubpanel bP_FilteredOutSubpanel = BP_FilteredOutSubpanel.this;
            synchronized (bP_FilteredOutSubpanel) {
                BP_FilteredOutSubpanel.this.mod.removeTest(what);
            }
        }

        public void statsUpdated(int[] stats) {
        }
    }

    private class TestTableModel
    extends AbstractTableModel {
        private String[] colNames;
        private final Object vLock = new Object();
        private Vector inQueue;
        private Vector rmQueue;
        private LinkedList liveData;
        Vector pendingEvents = new Vector();
        volatile boolean isUpdateScheduled;
        private static final int BATCH_SIZE = 100;
        private static final int COLUMN_COUNT = 2;

        TestTableModel(UIFactory uif) {
            this.colNames = new String[]{uif.getI18NString("br.fo.col0.txt"), uif.getI18NString("br.fo.col1.txt")};
            if (BP_FilteredOutSubpanel.this.debug) {
                Debug.println("TableModel constructed: ");
                Debug.println("   -> " + this);
            }
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            LinkedList linkedList = this.liveData;
            synchronized (linkedList) {
                return this.liveData.size();
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex >= this.colNames.length) {
                throw new IndexOutOfBoundsException();
            }
            return this.colNames[columnIndex];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                LinkedList linkedList = this.liveData;
                synchronized (linkedList) {
                    return this.liveData.get(row);
                }
            }
            if (column == 1) {
                LinkedList linkedList = this.liveData;
                synchronized (linkedList) {
                    Object tst = this.liveData.get(row);
                    Object r = null;
                    if (BP_FilteredOutSubpanel.this.cache != null && r == null) {
                        r = BP_FilteredOutSubpanel.this.cache.getRejectReason((TestResult)tst);
                    }
                    if (r == null) {
                        r = BP_FilteredOutSubpanel.this.uif.getI18NString("br.fo.noFi.txt");
                    }
                    return r;
                }
            }
            throw new IndexOutOfBoundsException("Index into filtered out table is out of range: " + row + ", " + column);
        }

        public boolean isCellEditable(int rowIndex, int colIndex) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTest(Object tr, boolean suppressNotify) {
            Object object = this.vLock;
            synchronized (object) {
                if (!this.inQueue.contains(tr)) {
                    this.inQueue.addElement(tr);
                }
            }
            if (!suppressNotify && !this.isUpdateScheduled) {
                TableNotifier tn = new TableNotifier(BP_FilteredOutSubpanel.this.subpanelNode, this);
                this.pendingEvents.addElement(tn);
                EventQueue.invokeLater(tn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeTest(Object tr) {
            Object object = this.vLock;
            synchronized (object) {
                this.rmQueue.addElement(tr);
                if (!this.isUpdateScheduled) {
                    TableNotifier tn = new TableNotifier(BP_FilteredOutSubpanel.this.subpanelNode, this);
                    this.pendingEvents.addElement(tn);
                    EventQueue.invokeLater(tn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            Object object = this.vLock;
            synchronized (object) {
                this.init();
            }
            this.notifyDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Vector vector = this.pendingEvents;
            synchronized (vector) {
                for (int i = 0; i < this.pendingEvents.size(); ++i) {
                    TableNotifier tn = (TableNotifier)this.pendingEvents.get(i);
                    tn.cancel();
                }
            }
            this.inQueue = new Vector();
            this.rmQueue = new Vector();
            this.liveData = new LinkedList();
            this.isUpdateScheduled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void goLive() {
            int lastNew = 0;
            if (BP_FilteredOutSubpanel.this.debug) {
                Debug.println("BP_TL.TLM - goLive() starting.");
            }
            BP_FilteredOutSubpanel bP_FilteredOutSubpanel = BP_FilteredOutSubpanel.this;
            synchronized (bP_FilteredOutSubpanel) {
                Object object = this.vLock;
                synchronized (object) {
                    if (this.inQueue.size() == 0 && this.rmQueue.size() == 0) {
                        if (BP_FilteredOutSubpanel.this.debug) {
                            Debug.println("BP_TT.TTM - goLive() nothing to do, returning");
                        }
                        return;
                    }
                    this.processRemoveQueue();
                    if (this.inQueue.size() != 0) {
                        int firstNew;
                        LinkedList linkedList = this.liveData;
                        synchronized (linkedList) {
                            firstNew = this.liveData.size();
                            if (this.inQueue.size() < 100) {
                                this.liveData.addAll(this.inQueue);
                                lastNew = this.liveData.size() - 1;
                                this.inQueue.setSize(0);
                            } else {
                                for (int i = 0; i < 100; ++i) {
                                    this.liveData.add(this.inQueue.remove(0));
                                }
                                if (!this.isUpdateScheduled) {
                                    TableNotifier tn = new TableNotifier(BP_FilteredOutSubpanel.this.subpanelNode, this);
                                    this.pendingEvents.addElement(tn);
                                    EventQueue.invokeLater(tn);
                                }
                                lastNew = this.liveData.size() - 1;
                            }
                        }
                        if (this.listenerList.getListenerCount() > 0) {
                            TableModelEvent e = new TableModelEvent(this, firstNew, lastNew, -1, 1);
                            TableNotifier tn = new TableNotifier(e, BP_FilteredOutSubpanel.this.mod);
                            this.pendingEvents.addElement(tn);
                            EventQueue.invokeLater(tn);
                        }
                    }
                    if (BP_FilteredOutSubpanel.this.table.getSelectedRow() == -1 && this.inQueue.size() == 0) {
                        BP_FilteredOutSubpanel.this.showMessage("");
                    }
                }
            }
            if (BP_FilteredOutSubpanel.this.debug) {
                Debug.println("BP_TL.LT - goLive() finished");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRemoveQueue() {
            if (this.rmQueue.size() == 0) {
                return;
            }
            while (this.rmQueue.size() > 0) {
                TestResult target = (TestResult)this.rmQueue.remove(0);
                int targetIndex = this.liveData.indexOf(target);
                if (targetIndex == -1) continue;
                LinkedList linkedList = this.liveData;
                synchronized (linkedList) {
                    targetIndex = this.liveData.indexOf(target);
                    if (targetIndex == -1) {
                        continue;
                    }
                    this.liveData.remove(targetIndex);
                    this.notifyRemoved(target, targetIndex);
                }
            }
        }

        private void preprocessAddQueue() {
            for (int i = 0; i < this.inQueue.size(); ++i) {
                if (!this.liveData.contains(this.inQueue.elementAt(i))) continue;
                this.inQueue.remove(i);
                --i;
            }
        }

        private void notifyAdded(TestResult what, int index) {
            if (this.listenerList.getListenerCount() > 0) {
                TableModelEvent e = new TableModelEvent(this, index, index, -1, 1);
                if (EventQueue.isDispatchThread()) {
                    BP_FilteredOutSubpanel.this.mod.fireTableChanged(e);
                } else {
                    TableNotifier tn = new TableNotifier(e, BP_FilteredOutSubpanel.this.mod);
                    this.pendingEvents.addElement(tn);
                    EventQueue.invokeLater(tn);
                }
            }
        }

        private void notifyRemoved(TestResult what, int index) {
            if (this.listenerList.getListenerCount() > 0) {
                TableModelEvent e = new TableModelEvent(this, index, index, -1, -1);
                if (EventQueue.isDispatchThread()) {
                    BP_FilteredOutSubpanel.this.mod.fireTableChanged(e);
                } else {
                    TableNotifier tn = new TableNotifier(e, BP_FilteredOutSubpanel.this.mod);
                    this.pendingEvents.addElement(tn);
                    EventQueue.invokeLater(tn);
                }
            }
        }

        private void notifyDone() {
            if (this.listenerList.getListenerCount() > 0) {
                TableModelEvent e = new TableModelEvent(this);
                TableNotifier tn = new TableNotifier(e, BP_FilteredOutSubpanel.this.mod);
                this.pendingEvents.addElement(tn);
                EventQueue.invokeLater(tn);
            }
        }
    }

    private class TableSynchronizer
    extends Thread {
        private volatile boolean stopping;

        TableSynchronizer() {
            super("filtered-out list synchronizer");
            this.setPriority(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TT_NodeCache tT_NodeCache = BP_FilteredOutSubpanel.this.cache;
            synchronized (tT_NodeCache) {
                BP_FilteredOutSubpanel bP_FilteredOutSubpanel = BP_FilteredOutSubpanel.this;
                synchronized (bP_FilteredOutSubpanel) {
                    Vector[] newData = BP_FilteredOutSubpanel.this.cache.addObserver(BP_FilteredOutSubpanel.this.cacheWatcher, true);
                    for (int j = 0; j < newData[newData.length - 1].size() - 1 && !this.stopping; ++j) {
                        BP_FilteredOutSubpanel.this.mod.addTest(newData[newData.length - 1].elementAt(j), true);
                    }
                    if (newData[newData.length - 1].size() > 0 && !this.stopping) {
                        BP_FilteredOutSubpanel.this.mod.addTest(newData[newData.length - 1].lastElement(), false);
                    }
                    BP_FilteredOutSubpanel.this.resyncThread = null;
                }
            }
            BP_FilteredOutSubpanel.this.validateEnableState();
        }

        public void halt() {
            this.stopping = true;
        }
    }
}

