/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TRT_TreeNode;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.BP_BranchSubpanel;
import com.sun.javatest.exec.BP_Model;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.ProgressMeter;
import com.sun.javatest.exec.TT_BasicNode;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.PieChart;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class BP_SummarySubpanel
extends BP_BranchSubpanel {
    private CounterThread ct;
    private int[] stats;
    private int filtered;
    private JLabel progLabel;
    private ProgressMeter pMeter;
    private JLabel[] sTypes;
    private JTextField[] sValues;
    private JTextField subtotalTf;
    private JTextField totalTf;
    private JTextField folderNameTf;
    private JTextField filterNameTf;
    private JTextField filterDescTf;
    private PieChart pie;
    private static Color[] pieColors;
    private static final int NUM_FIELDS = 7;
    private static final int SUBTOTAL_INDEX = 4;
    private static final int FILTERED_INDEX = 5;
    private static final int TOTAL_INDEX = 6;
    private static final int NONTOTAL_FIELD_RMARGIN = 10;
    private static final int TOTAL_FIELD_RMARGIN = 2;
    private static final int ACTIVE_FREQUENCY = 1000;
    private static final int INACTIVE_FREQUENCY = 2500;
    private final int NTFIELD_WIDTH = 5;
    private final int TFIELD_WIDTH = 7;
    protected final int[] stateOrdering = new int[]{2, 1, 3, 0};
    private static int debug;

    BP_SummarySubpanel(UIFactory uif, BP_Model bpm, TestTreeModel ttm) {
        super("stats", uif, bpm, ttm, "br.summ");
        this.init();
    }

    private synchronized void init() {
        int i;
        if (pieColors == null) {
            pieColors = new Color[5];
            BP_SummarySubpanel.pieColors[0] = I18NUtils.getStatusColor(0);
            BP_SummarySubpanel.pieColors[1] = I18NUtils.getStatusColor(1);
            BP_SummarySubpanel.pieColors[2] = I18NUtils.getStatusColor(2);
            BP_SummarySubpanel.pieColors[3] = I18NUtils.getStatusColor(3);
            BP_SummarySubpanel.pieColors[BP_SummarySubpanel.pieColors.length - 1] = I18NUtils.getStatusColor(4);
        }
        CSH.setHelpIDString(this, "browse.summaryTab.csh");
        JPanel bodyPanel = this.uif.createPanel("br.summ.body", false);
        bodyPanel.setLayout(new GridBagLayout());
        JPanel statsPanel = this.uif.createPanel("br.summStats", false);
        statsPanel.setLayout(new GridBagLayout());
        statsPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        int pbarOffset = 3;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.ipady = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        this.sTypes = new JLabel[7];
        for (i = 0; i < 4; ++i) {
            this.sTypes[i] = this.uif.createLabel("br.summ.status" + i);
            this.sTypes[i].setHorizontalAlignment(2);
            this.sTypes[i].setDisplayedMnemonic(this.uif.getI18NString("br.summ.status" + i + ".mne").charAt(0));
            this.sTypes[i].setIcon(new LegendIcon(I18NUtils.getStatusBarColor(i), true));
            this.uif.setAccessibleDescription(this.sTypes[i], "br.summ.status" + i);
        }
        this.sTypes[4] = this.uif.createLabel("br.summ.subtotal");
        this.sTypes[5] = this.uif.createLabel("br.summ.filtered");
        this.sTypes[6] = this.uif.createLabel("br.summ.total");
        this.sTypes[5].setIcon(new LegendIcon(I18NUtils.getStatusColor(4), true));
        this.sTypes[4].setDisplayedMnemonic(this.uif.getI18NString("br.summ.subtotal.mne").charAt(0));
        this.sTypes[5].setDisplayedMnemonic(this.uif.getI18NString("br.summ.filtered.mne").charAt(0));
        this.sTypes[6].setDisplayedMnemonic(this.uif.getI18NString("br.summ.total.mne").charAt(0));
        this.uif.setAccessibleDescription(this.sTypes[4], "br.summ.subtotal");
        this.uif.setAccessibleDescription(this.sTypes[5], "br.summ.filtered");
        this.uif.setAccessibleDescription(this.sTypes[6], "br.summ.total");
        this.sTypes[4].setBackground(UIFactory.Colors.PRIMARY_CONTROL_DARK_SHADOW.getValue());
        this.sTypes[4].setForeground(UIFactory.Colors.WINDOW_BACKGROUND.getValue());
        this.sTypes[4].setOpaque(true);
        this.sTypes[6].setBackground(UIFactory.Colors.PRIMARY_CONTROL_DARK_SHADOW.getValue());
        this.sTypes[6].setForeground(UIFactory.Colors.WINDOW_BACKGROUND.getValue());
        this.sTypes[6].setOpaque(true);
        this.sValues = new JTextField[7];
        for (i = 0; i < 4; ++i) {
            this.sValues[i] = this.createPlainField(i);
        }
        this.sValues[5] = this.createPlainField(5);
        this.sValues[4] = this.createTotalField(4);
        this.sValues[6] = this.createTotalField(6);
        this.sTypes[4].setIcon(new LegendIcon(this.sTypes[4].getBackground(), false));
        this.sTypes[6].setIcon(new LegendIcon(this.sTypes[6].getBackground(), false));
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.ipadx = 10;
        gbc.weightx = 0.0;
        for (i = 0; i < 7; ++i) {
            gbc.gridy = i + pbarOffset;
            gbc.gridx = 1;
            gbc.insets.right = 10;
            gbc.fill = i == 4 || i == 6 ? 0 : 2;
            statsPanel.add((Component)this.sTypes[i], gbc);
            gbc.gridx = 2;
            gbc.insets.right = this.sValues[i] != this.subtotalTf && this.sValues[i] != this.totalTf ? 10 : 2;
            statsPanel.add((Component)this.sValues[i], gbc);
            this.sTypes[i].setLabelFor(this.sValues[i]);
        }
        gbc = new GridBagConstraints();
        gbc.anchor = 15;
        gbc.weighty = 10.0;
        gbc.fill = 3;
        gbc.ipadx = 10;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weighty = 10.0;
        gbc.gridwidth = 3;
        Component strut = Box.createVerticalStrut(1);
        bodyPanel.add(strut, gbc);
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.weightx = 3.0;
        gbc.fill = 2;
        strut = Box.createHorizontalStrut(1);
        bodyPanel.add(strut, gbc);
        gbc.gridx = 4;
        strut = Box.createHorizontalStrut(1);
        bodyPanel.add(strut, gbc);
        gbc.weighty = 0.0;
        JLabel lab = this.uif.createLabel("br.summ.fldlbl", true);
        lab.setOpaque(false);
        this.folderNameTf = this.uif.createOutputField("br.summ.fldtf", 35, lab);
        this.folderNameTf.setOpaque(false);
        this.folderNameTf.setBorder(BorderFactory.createEmptyBorder());
        gbc.fill = 0;
        gbc.anchor = 14;
        gbc.weightx = 1.0;
        gbc.gridy = 1;
        gbc.gridx = 1;
        bodyPanel.add((Component)lab, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 5.0;
        gbc.fill = 2;
        gbc.anchor = 16;
        bodyPanel.add((Component)this.folderNameTf, gbc);
        lab = this.uif.createLabel("br.summ.ftrlbl", true);
        lab.setOpaque(false);
        this.filterNameTf = this.uif.createOutputField("br.summ.ftrtf", 35, lab);
        this.filterNameTf.setOpaque(false);
        this.filterNameTf.setBorder(BorderFactory.createEmptyBorder());
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 14;
        gbc.fill = 0;
        bodyPanel.add((Component)lab, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 5.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        bodyPanel.add((Component)this.filterNameTf, gbc);
        this.filterDescTf = this.uif.createOutputField("br.summ.fdesc", 35);
        this.filterDescTf.setOpaque(false);
        this.filterDescTf.setBorder(BorderFactory.createEmptyBorder());
        gbc.gridy = 3;
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.anchor = 16;
        gbc.fill = 0;
        bodyPanel.add((Component)this.filterDescTf, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.anchor = 10;
        Divider div = new Divider(1, 5);
        div.getInsets().top = 5;
        div.getInsets().bottom = 5;
        bodyPanel.add((Component)div, gbc);
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.weightx = 3.0;
        gbc.fill = 2;
        strut = Box.createHorizontalStrut(1);
        bodyPanel.add(strut, gbc);
        JPanel pan = this.uif.createPanel("br.statpie", new GridBagLayout(), false);
        pan.setOpaque(false);
        GridBagConstraints gl = new GridBagConstraints();
        gl.fill = 0;
        gl.anchor = 10;
        gl.gridy = 0;
        gl.gridx = 0;
        gl.weightx = 1.0;
        statsPanel.setMinimumSize(new Dimension(80, 80));
        pan.add((Component)statsPanel, gl);
        statsPanel.setMinimumSize(new Dimension(150, 100));
        this.pie = new PieChart(new int[]{100}, new Color[]{I18NUtils.getStatusColor(4)});
        gl.fill = 1;
        gl.weightx = 2.0;
        gl.gridx = 1;
        pan.add((Component)this.pie, gl);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        bodyPanel.add((Component)pan, gbc);
        gbc.gridwidth = 5;
        gbc.gridy = 6;
        gbc.gridx = 0;
        gbc.weightx = 10.0;
        gbc.weighty = 10.0;
        strut = Box.createVerticalStrut(5);
        bodyPanel.add(strut, gbc);
        bodyPanel.setMinimumSize(new Dimension(150, 100));
        bodyPanel.setBackground(Color.WHITE);
        bodyPanel.setOpaque(true);
        JScrollPane sp = this.uif.createScrollPane(bodyPanel, 20, 30);
        sp.setMinimumSize(new Dimension(150, 100));
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
        this.setMinimumSize(new Dimension(150, 100));
    }

    void dispose() {
        if (this.ct != null) {
            this.ct.interrupt();
            this.ct = null;
        }
    }

    protected JTextField createPlainField(int id) {
        JTextField f = this.uif.createOutputField("br.summ." + id, 5);
        f.setHorizontalAlignment(4);
        f.setBorder(BorderFactory.createEmptyBorder());
        f.setOpaque(false);
        return f;
    }

    protected JTextField createTotalField(int id) {
        JTextField f = this.uif.createOutputField("br.summ." + id, 7);
        f.setHorizontalAlignment(4);
        f.setBorder(null);
        f.setBackground(UIFactory.Colors.PRIMARY_CONTROL_DARK_SHADOW.getValue());
        f.setForeground(UIFactory.Colors.WINDOW_BACKGROUND.getValue());
        f.setOpaque(true);
        f.setEnabled(true);
        return f;
    }

    protected void updateSubpanel(TT_BasicNode currNode) {
        super.updateSubpanel(currNode);
        if (debug > 1) {
            Debug.println("BP_SP - updateSubpanel() called");
        }
        if (this.filterNameTf != null && this.filterDescTf != null && !this.ttm.getTestFilter().getName().equals(this.filterNameTf.getText())) {
            this.filterNameTf.setText(this.ttm.getTestFilter().getName());
            this.filterDescTf.setText(this.ttm.getTestFilter().getDescription());
        }
        if (this.ct != null && this.ct.getNode() == this.subpanelNode.getTableNode()) {
            return;
        }
        if (debug > 0) {
            Debug.println("BP_SP - updating panel");
        }
        if (this.ct == null) {
            this.ct = new CounterThread(this.subpanelNode.getTableNode(), this.sValues);
            this.ct.setPriority(4);
            this.ct.start();
        }
        this.ct.setNode(this.subpanelNode.getTableNode());
        String spn = this.subpanelNode.getDisplayName();
        if (spn != null) {
            this.folderNameTf.setText(spn);
        } else {
            Parameters p = this.ttm.getParameters();
            if (p != null) {
                TestSuite ts = p.getTestSuite();
                this.folderNameTf.setText(ts == null ? "" : this.uif.getI18NString("br.summ.fldtf.root", ts.getName()));
            }
        }
    }

    static {
        debug = Debug.getInt(BP_SummarySubpanel.class);
    }

    private class LegendIcon
    implements Icon {
        private Color color;
        private Color shadowColor;
        private Image image;
        private boolean paintShadow;

        LegendIcon(Color c, boolean shadow) {
            this.color = c;
            this.shadowColor = new Color(0x555555);
            this.paintShadow = shadow;
        }

        LegendIcon() {
            this.shadowColor = null;
            this.color = null;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics imageG = this.image.getGraphics();
                this.paintIt(imageG, this.paintShadow, this.color);
                imageG.dispose();
            }
            g.drawImage(this.image, x, y, null);
        }

        private void paintIt(Graphics g, boolean shadow, Color c) {
            int width;
            int height;
            if (c == null) {
                return;
            }
            int x = 2;
            int y = 2;
            if (shadow) {
                height = 10;
                width = 10;
            } else {
                height = 12;
                width = 12;
            }
            if (shadow) {
                g.setColor(this.shadowColor);
                g.fillRect(x + 2, y + 2, width, height);
            }
            g.setColor(c);
            g.fillRect(x, y, width, height);
        }
    }

    class Divider2
    extends JComponent {
        int thick = 2;
        int arcWidth = 15;

        public Divider2() {
        }

        public Divider2(int thickness) {
            this.thick = thickness;
        }

        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Insets inset = this.getInsets();
            int width = this.getWidth() - inset.left - inset.right;
            int height = this.getHeight() - inset.left - inset.right;
            g.setColor(UIFactory.Colors.SEPARATOR_FOREGROUND.getValue());
            if (height < 2) {
                return;
            }
            if (height < this.thick * 2) {
                int mid = height / 2;
                g.fillRect(inset.left, mid - this.thick / 2, width, this.thick);
            } else {
                int mid = height / 2;
                g.fillRect(inset.left + this.arcWidth, mid - this.thick * 2, width - this.arcWidth, this.thick);
                g.fillArc(inset.left, mid - this.thick * 2, width, this.thick * 2, -90, 0);
            }
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Insets inset = this.getInsets();
            return new Dimension(this.arcWidth * 2 + inset.left + inset.right, this.thick * 2 + inset.top + inset.bottom);
        }
    }

    class Divider
    extends JComponent {
        int thick = 2;
        int space = 4;

        public Divider() {
        }

        public Divider(int thickness, int spacing) {
            this.thick = thickness;
            this.space = spacing;
        }

        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Insets inset = this.getInsets();
            int width = this.getWidth() - inset.left - inset.right;
            int height = this.getHeight() - inset.left - inset.right;
            g.setColor(Color.BLACK);
            int mid = height / 2;
            g.fillRect(inset.left, mid - this.thick / 2, width, this.thick);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Insets inset = this.getInsets();
            return new Dimension(10 + inset.left + inset.right, this.thick * 2 + this.space + inset.top + inset.bottom);
        }
    }

    private class CounterThread
    extends Thread {
        private volatile boolean stopping;
        private TestResultTable.TreeNode node;
        private TT_NodeCache cache;
        private JTextField[] tfs;
        private int[] lastStats;
        private boolean debug;

        CounterThread(TestResultTable.TreeNode tn, JTextField[] fields) {
            super("BP_SP.CounterThread");
            this.debug = Debug.getBoolean(BP_SummarySubpanel.class, "CounterThread");
            this.node = tn;
            this.tfs = fields;
        }

        TestResultTable.TreeNode getNode() {
            return this.node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int[] stats;
            if (this.debug) {
                Debug.println("BP_SP.CT - thread running");
                Debug.println("   -> " + this);
            }
            if (this.stopping) {
                this.halt();
                return;
            }
            CounterThread counterThread = this;
            synchronized (counterThread) {
                this.cache = BP_SummarySubpanel.this.ttm.getNodeInfo(this.node, true);
            }
            if (!BP_SummarySubpanel.this.model.isRunning()) {
                EventQueue.invokeLater(new BranchPanel.TextUpdater(2, this.tfs, null, BP_SummarySubpanel.this.uif));
                BP_SummarySubpanel.this.showMessage(BP_SummarySubpanel.this.uif.getI18NString("br.summ.working"));
            }
            while (true) {
                int[] combinedStats;
                if (this.stopping) {
                    if (!this.debug) break;
                    Debug.println("BP_SP.CT - thread terminating in run() due to halt()");
                    Debug.println("   -> " + this);
                    break;
                }
                boolean isComplete = false;
                CounterThread counterThread2 = this;
                synchronized (counterThread2) {
                    this.cache = BP_SummarySubpanel.this.ttm.getNodeInfo(this.node, true);
                    if (this.cache == null) {
                        continue;
                    }
                    stats = this.cache.getStats();
                    combinedStats = this.fillStats(stats, this.cache.getRejectCount(), true, true);
                    isComplete = this.cache.isComplete() || this.cache.isAborted();
                }
                if (!Arrays.equals(this.lastStats, combinedStats)) {
                    this.notifyUpdate(stats, combinedStats);
                    this.lastStats = combinedStats;
                    this.updateMessage(stats, !isComplete);
                } else if (BP_SummarySubpanel.this.ttm.isWorkPaused()) {
                    int[] tmpStats = new int[4];
                    tmpStats[3] = ((TRT_TreeNode)this.node).getEstimatedSize();
                    this.updateMessage(tmpStats, true);
                }
                counterThread2 = this;
                synchronized (counterThread2) {
                    try {
                        if (this.cache == null || this.cache.isComplete() || this.cache.isAborted()) {
                            this.wait(2500L);
                        } else {
                            this.wait(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            if (this.stopping) {
                this.halt();
                return;
            }
            CounterThread counterThread3 = this;
            synchronized (counterThread3) {
                if (this.cache == null) {
                    this.cache = BP_SummarySubpanel.this.ttm.getNodeInfo(this.node, true);
                }
                stats = this.cache.getStats();
                this.notifyUpdate(stats, this.fillStats(stats, this.cache.getRejectCount(), true, true));
            }
            this.updateMessage(stats, false);
            if (this.debug) {
                Debug.println("counter thread done...");
            }
        }

        public void halt() {
            if (this.debug) {
                Debug.println("BP_SP.CT - thread stopping");
                Debug.println("   -> " + this);
            }
            this.stopping = true;
        }

        synchronized void setNode(TestResultTable.TreeNode tn) {
            if (tn != this.node) {
                this.cache = null;
                this.node = tn;
            }
        }

        private int[] fillStats(int[] basic, int filtered, boolean validSub, boolean validTot) {
            int[] result = new int[this.tfs.length];
            System.arraycopy(basic, 0, result, 0, basic.length);
            if (validSub) {
                int sub = 0;
                for (int i = 0; i < basic.length; ++i) {
                    sub += basic[i];
                }
                result[4] = sub;
            } else {
                result[4] = -1;
            }
            result[5] = filtered;
            result[6] = validTot ? result[5] + result[4] : -1;
            return result;
        }

        private void updateMessage(int[] stats, boolean stillRunning) {
            int worstIndex = -1;
            for (int i = 0; i < BP_SummarySubpanel.this.stateOrdering.length; ++i) {
                if (stats[BP_SummarySubpanel.this.stateOrdering[i]] <= 0) continue;
                worstIndex = BP_SummarySubpanel.this.stateOrdering[i];
                break;
            }
            if (this.stopping) {
                this.halt();
                return;
            }
            if (worstIndex != -1) {
                String msg = null;
                switch (worstIndex) {
                    case 0: {
                        msg = BP_SummarySubpanel.this.uif.getI18NString("br.worst.0");
                        break;
                    }
                    case 1: {
                        msg = BP_SummarySubpanel.this.uif.getI18NString("br.worst.1");
                        break;
                    }
                    case 2: {
                        msg = BP_SummarySubpanel.this.uif.getI18NString("br.worst.2");
                        break;
                    }
                    case 3: {
                        msg = BP_SummarySubpanel.this.uif.getI18NString("br.worst.3");
                        break;
                    }
                    default: {
                        throw new JavaTestError(BP_SummarySubpanel.this.uif.getI18NString("br.worstNum"));
                    }
                }
                if (stillRunning) {
                    msg = BP_SummarySubpanel.this.uif.getI18NString("br.stillWork") + msg;
                }
                BP_SummarySubpanel.this.showMessage(msg);
            } else {
                BP_SummarySubpanel.this.showMessage(BP_SummarySubpanel.this.uif.getI18NString("br.none"));
            }
        }

        private void notifyUpdate(int[] basic, int[] values) {
            EventQueue.invokeLater(new BranchPanel.TextUpdater(1, this.tfs, values, BP_SummarySubpanel.this.uif));
            final int[] pieStats = new int[5];
            System.arraycopy(basic, 0, pieStats, 0, basic.length);
            pieStats[4] = values[5];
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BP_SummarySubpanel.this.pie.setValue(pieStats, pieColors);
                }
            });
        }
    }
}

