/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.exec.BP_BranchSubpanel;
import com.sun.javatest.exec.BP_DocumentationSubpanel;
import com.sun.javatest.exec.BP_FilteredOutSubpanel;
import com.sun.javatest.exec.BP_Model;
import com.sun.javatest.exec.BP_SummarySubpanel;
import com.sun.javatest.exec.BP_TestListSubpanel;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.TT_BasicNode;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.exec.TT_TreeNode;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

class BranchPanel
extends JPanel
implements FilterSelectionHandler.Observer {
    private TestTreeModel ttm;
    private JTabbedPane bPane;
    private JTextField statusTf;
    private TT_BasicNode currNode;
    private TreePanelModel tpm;
    private Harness harness;
    private ExecModel execModel;
    private JComponent parent;
    private FilterSelectionHandler filterHandler;
    private TT_NodeCache cache;
    private CacheObserver cacheWatcher = new CacheObserver();
    private UIFactory uif;
    private BP_BranchSubpanel currPanel;
    private BranchModel bModel = new BranchModel();
    private volatile boolean needToUpdateGUIWhenShown;
    private volatile boolean needToUpdateData;
    protected Parameters params;
    protected static final int NUM_TABS = 7;
    static final int STATUS_FILTERED = 4;
    private BP_SummarySubpanel summPanel;
    private BP_DocumentationSubpanel docPanel;
    private BP_FilteredOutSubpanel foPanel;
    private BP_TestListSubpanel[] lists;
    private boolean[] listDisplayStatus;
    private BP_BranchSubpanel[] allPanels;
    private static boolean debug = Debug.getBoolean(BranchPanel.class);

    BranchPanel(UIFactory uif, TreePanelModel model, Harness h, ExecModel em, JComponent parent, FilterSelectionHandler filterHandler, TestTreeModel ttm) {
        this.uif = uif;
        this.tpm = model;
        this.harness = h;
        this.execModel = em;
        this.parent = parent;
        this.filterHandler = filterHandler;
        this.ttm = ttm;
        this.initGUI();
        filterHandler.addObserver(this);
    }

    void setNode(TT_BasicNode tn) {
        if (tn == this.currNode) {
            return;
        }
        this.updatePanel(tn, this.currPanel);
    }

    void setParameters(Parameters p) {
        this.params = p;
        TestResultTable newTrt = null;
        if (p.getWorkDirectory() != null) {
            newTrt = p.getWorkDirectory().getTestResultTable();
        }
    }

    void dispose() {
        this.summPanel.dispose();
    }

    protected boolean isUpdateRequired() {
        return this.needToUpdateGUIWhenShown;
    }

    protected void initGUI() {
        this.setName("branch");
        this.allPanels = new BP_BranchSubpanel[7];
        this.summPanel = new BP_SummarySubpanel(this.uif, this.bModel, this.ttm);
        this.allPanels[0] = this.summPanel;
        this.docPanel = new BP_DocumentationSubpanel(this.uif, this.bModel, this.ttm, this.execModel);
        this.allPanels[1] = this.docPanel;
        this.lists = new BP_TestListSubpanel[4];
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i] = new BP_TestListSubpanel(this.uif, this.harness, this.execModel, this.bModel, this.ttm, i);
            this.allPanels[i + 2] = this.lists[i];
        }
        this.foPanel = new BP_FilteredOutSubpanel(this.uif, this.bModel, this.ttm);
        this.allPanels[this.allPanels.length - 1] = this.foPanel;
        this.listDisplayStatus = new boolean[this.allPanels.length];
        JComponent[] panes = new JComponent[3 + this.lists.length];
        panes[0] = this.summPanel;
        panes[1] = this.docPanel;
        panes[panes.length - 1] = this.foPanel;
        System.arraycopy(this.lists, 0, panes, 2, this.lists.length);
        this.bPane = this.uif.createTabbedPane("br.tabs", panes);
        this.bPane.setTabPlacement(1);
        this.bPane.setBorder(BorderFactory.createEmptyBorder());
        this.bPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component c = BranchPanel.this.bPane.getSelectedComponent();
                if (c instanceof BP_BranchSubpanel) {
                    BP_BranchSubpanel bsp = (BP_BranchSubpanel)c;
                    bsp.updateSubpanel(BranchPanel.this.currNode);
                    if (BranchPanel.this.bPane.isEnabledAt(BranchPanel.this.bPane.indexOfComponent(c))) {
                        BranchPanel.this.updatePanel(BranchPanel.this.currNode, bsp);
                        BranchPanel.this.statusTf.setText(bsp.getLastMessage());
                    }
                }
            }
        });
        for (int i = 2; i < 7; ++i) {
            this.bPane.setIconAt(i, IconFactory.getTestIcon(i - 2, false, true));
        }
        this.currPanel = this.summPanel;
        CSH.setHelpIDString(this.bPane, CSH.getHelpIDString(this.currPanel));
        this.setLayout(new BorderLayout());
        this.add((Component)this.bPane, "Center");
        ComponentListener cl = new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                BranchPanel.this.currPanel.invalidate();
                BranchPanel.this.bPane.invalidate();
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
                if (BranchPanel.this.needToUpdateGUIWhenShown) {
                    BranchPanel.this.updateGUI();
                    BranchPanel.this.needToUpdateGUIWhenShown = false;
                }
            }

            public void componentHidden(ComponentEvent e) {
            }
        };
        this.addComponentListener(cl);
        this.statusTf = this.uif.createOutputField("br.status");
        this.statusTf.setEnabled(true);
        this.statusTf.setEditable(false);
        this.add((Component)this.statusTf, "South");
    }

    void setTreeModel(TestTreeModel ttm) {
        this.ttm = ttm;
        for (BP_BranchSubpanel bps : this.allPanels) {
            bps.setTreeModel(ttm);
        }
    }

    protected void updatePanel(TT_BasicNode newNode, BP_BranchSubpanel newPanel) {
        if (newPanel != this.currPanel) {
            CSH.setHelpIDString(this.bPane, CSH.getHelpIDString(newPanel));
            this.currPanel = newPanel;
        }
        if (newNode != this.currNode) {
            if (debug) {
                Debug.println("BP - setting node to " + newNode.getShortName() + "  " + newNode);
                Debug.println("   -> old node " + (this.currNode == null ? "[null]" : this.currNode.getShortName()) + "  " + this.currNode);
            }
            for (int i = 0; i < this.lists.length; ++i) {
                this.lists[i].setUpdateRequired(true);
            }
            this.currNode = newNode;
            if (this.isVisible()) {
                this.updateGUI();
            } else {
                this.needToUpdateGUIWhenShown = true;
            }
        }
    }

    TT_TreeNode getNode() {
        return this.currNode;
    }

    protected void updateGUI() {
        if (this.currNode == null) {
            for (int i = 1; i < this.bPane.getComponentCount(); ++i) {
                this.bPane.setEnabledAt(i, false);
            }
        } else {
            if (this.cache != null) {
                this.cache.removeObserver(this.cacheWatcher);
            }
            this.cache = this.ttm.getNodeInfo(this.currNode.getTableNode(), false);
            this.cache.addObserver(this.cacheWatcher, false);
            this.summPanel.updateSubpanel(this.currNode);
            this.docPanel.updateSubpanel(this.currNode);
            this.foPanel.reset(this.cache);
            for (int i = 0; i < this.lists.length; ++i) {
                this.lists[i].reset(this.cache);
            }
            if (this.currPanel != this.summPanel) {
                this.currPanel.updateSubpanel(this.currNode);
            }
        }
    }

    private static boolean isAlongPath(TestResultTable.TreeNode[] path, TestResultTable.TreeNode node) {
        for (int i = 0; i < path.length; ++i) {
            if (path[i] != node) continue;
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void filterUpdated(TestFilter f) {
        for (int i = 0; i < this.allPanels.length; ++i) {
            this.allPanels[i].invalidateFilters();
        }
        this.updateGUI();
    }

    public void filterSelected(TestFilter f) {
        for (int i = 0; i < this.allPanels.length; ++i) {
            this.allPanels[i].invalidateFilters();
        }
        this.updateGUI();
    }

    public void filterAdded(TestFilter f) {
    }

    public void filterRemoved(TestFilter f) {
    }

    private class CacheObserver
    extends TT_NodeCache.TT_NodeCacheObserver {
        CacheObserver() {
            this.interestList[0] = false;
            this.interestList[1] = true;
            this.interestList[2] = false;
            this.interestList[3] = false;
            this.interestList[4] = false;
            this.interestList[5] = false;
            this.interestList[6] = false;
        }

        public void testAdded(int msgType, TestResultTable.TreeNode[] path, TestResult what, int index) {
        }

        public void testRemoved(int msgType, TestResultTable.TreeNode[] path, TestResult what, int index) {
        }

        public void statsUpdated(final int[] stats) {
            if (!EventQueue.isDispatchThread()) {
                Runnable cmd = new Runnable(){

                    public void run() {
                        CacheObserver.this.statsUpdated(stats);
                    }
                };
                EventQueue.invokeLater(cmd);
            } else {
                for (int i = 0; i < stats.length; ++i) {
                    if (stats[i] > 0 && !BranchPanel.this.listDisplayStatus[i + 2]) {
                        BranchPanel.this.bModel.setEnabled(i + 2, true);
                    }
                    if (stats[i] != 0 || !BranchPanel.this.listDisplayStatus[i + 2]) continue;
                    BranchPanel.this.bModel.setEnabled(i + 2, false);
                }
                int rej = BranchPanel.this.cache.getRejectCount();
                if (rej == 0) {
                    if (BranchPanel.this.listDisplayStatus[BranchPanel.this.listDisplayStatus.length - 1]) {
                        BranchPanel.this.bModel.setEnabled(BranchPanel.this.listDisplayStatus.length - 1, false);
                    }
                } else if (rej > 0 && !BranchPanel.this.listDisplayStatus[BranchPanel.this.listDisplayStatus.length - 1]) {
                    BranchPanel.this.bModel.setEnabled(BranchPanel.this.listDisplayStatus.length - 1, true);
                }
            }
        }
    }

    static class TextUpdater
    implements Runnable {
        static final int UPDATE = 1;
        static final int CLEAR = 2;
        static final int WAIT = 3;
        static final int MSG = 4;
        private int type;
        private int[] values;
        private JTextComponent[] tfs;
        private JTextComponent stf;
        private String msg;
        private UIFactory uif;

        TextUpdater(int eType, JTextComponent[] tfs, int[] values, UIFactory uif) {
            this.type = eType;
            this.values = values;
            this.tfs = tfs;
            this.uif = uif;
        }

        TextUpdater(JTextComponent tf, String val, UIFactory uif) {
            this.type = 4;
            this.stf = tf;
            this.msg = val;
            this.uif = uif;
        }

        public void run() {
            switch (this.type) {
                case 1: {
                    for (int i = 0; i < this.tfs.length; ++i) {
                        if (this.values[i] >= 0) {
                            this.tfs[i].setText(Integer.toString(this.values[i]));
                            continue;
                        }
                        this.tfs[i].setText("");
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.tfs.length; ++i) {
                        this.tfs[i].setText("");
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.tfs.length; ++i) {
                        this.tfs[i].setText("wait...");
                    }
                    break;
                }
                case 4: {
                    this.stf.setText(this.msg);
                    break;
                }
                default: {
                    throw new JavaTestError(this.uif.getI18NString("br.noEType2"));
                }
            }
        }
    }

    class BranchModel
    implements BP_Model {
        BranchModel() {
        }

        public boolean isRunning() {
            return BranchPanel.this.harness.isRunning();
        }

        public void showMessage(String msg) {
            EventQueue.invokeLater(new TextUpdater(BranchPanel.this.statusTf, msg, BranchPanel.this.uif));
        }

        public void showTest(TestResult tr, Object[] path) {
            BranchPanel.this.tpm.showTest(tr, new TreePath(path));
        }

        public void setEnabled(final Component c, final boolean state) {
            if (!EventQueue.isDispatchThread()) {
                Runnable cmd = new Runnable(){

                    public void run() {
                        BranchModel.this.setEnabled(c, state);
                    }
                };
                EventQueue.invokeLater(cmd);
            } else {
                if (BranchPanel.this.bPane == null) {
                    return;
                }
                this.setEnabled(BranchPanel.this.bPane.indexOfComponent(c), state);
            }
        }

        public boolean isEnabled(Component c) {
            int index = BranchPanel.this.bPane.indexOfComponent(c);
            if (index == -1) {
                return false;
            }
            return BranchPanel.this.listDisplayStatus[index];
        }

        public TestFilter getFilter() {
            return BranchPanel.this.filterHandler.getActiveFilter();
        }

        void setEnabled(final int index, final boolean newState) {
            if (BranchPanel.this.listDisplayStatus[index] == newState) {
                return;
            }
            if (!EventQueue.isDispatchThread()) {
                Runnable cmd = new Runnable(){

                    public void run() {
                        BranchModel.this.setEnabled(index, newState);
                    }
                };
                EventQueue.invokeLater(cmd);
            } else {
                if (index == -1) {
                    return;
                }
                ((BranchPanel)BranchPanel.this).listDisplayStatus[index] = newState;
                BranchPanel.this.bPane.setEnabledAt(index, newState);
            }
        }
    }
}

