/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TRT_TreeNode;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.exec.TT_TestNode;
import com.sun.javatest.exec.TT_TreeNode;
import com.sun.javatest.util.Debug;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeNode;

public class TT_BasicNode
extends TT_TreeNode {
    private final ArrayList<TT_TreeNode> children = new ArrayList();
    private TRT_TreeNode tn;
    private Comparator comp;
    private final AtomicBoolean isUpdated = new AtomicBoolean(false);
    private boolean debug = Debug.getBoolean(TT_BasicNode.class);

    TT_BasicNode(TT_BasicNode parent, TRT_TreeNode tn, Comparator comp) {
        this.comp = comp;
        this.parent = parent;
        this.tn = tn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration children() {
        this.updateNode();
        ArrayList copy = null;
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            copy = (ArrayList)this.children.clone();
        }
        final Iterator it = copy.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode getChildAt(int arg0) {
        if (this.children == null) {
            return null;
        }
        this.updateNode();
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            return this.children.get(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount() {
        this.updateNode();
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            return this.children.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex(TreeNode arg0) {
        if (this.children == null) {
            return -1;
        }
        this.updateNode();
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            return this.children.indexOf(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex(TT_TestNode arg) {
        this.updateNode();
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            return this.children.indexOf(arg);
        }
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    boolean isRoot() {
        return this.parent == null;
    }

    String getDisplayName() {
        return this.getShortName();
    }

    String getLongDescription() {
        return null;
    }

    String getShortName() {
        return this.tn.getName();
    }

    String getLongPath() {
        if (this.parent == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(this.getShortName());
        TT_BasicNode spot = this.parent;
        while (spot.parent != null) {
            sb.insert(0, "/");
            sb.insert(0, spot.getShortName());
            spot = spot.parent;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TT_TreeNode findByName(String name) {
        this.updateNode();
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            if (this.children.size() == 0) {
                return null;
            }
            for (TT_TreeNode node : this.children) {
                if (!name.equals(node.getShortName())) continue;
                return node;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TT_TestNode findByName(TestResult tr) {
        this.updateNode();
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            if (this.children.size() == 0) {
                return null;
            }
        }
        String name = tr.getTestName();
        ArrayList<TT_TreeNode> arrayList2 = this.children;
        synchronized (arrayList2) {
            for (TT_TreeNode node : this.children) {
                if (!name.equals(node.getLongPath())) continue;
                return (TT_TestNode)node;
            }
        }
        return null;
    }

    TRT_TreeNode getTableNode() {
        return this.tn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeModelEvent removeTest(TestResult tr) {
        if (this.updateNode()) {
            return null;
        }
        TT_TestNode tn = this.findByName(tr);
        if (tn == null) {
            return null;
        }
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            int index = this.children.indexOf(tn);
            this.children.remove(tn);
            return new TreeModelEvent((Object)this, this.getNodePath(), new int[]{index}, new Object[]{tn});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeNode(TT_TreeNode node) {
        this.updateNode();
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            int index = this.children.indexOf(node);
            if (index >= 0) {
                this.children.remove(index);
                return index;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeModelEvent replaceTest(TestResult tr, boolean insert) {
        if (this.updateNode()) {
            return null;
        }
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            TT_TestNode tn = this.findByName(tr);
            if (tn != null) {
                int pos = this.getIndex(tn);
                this.children.remove(pos);
                this.children.add(pos, new TT_TestNode(this, tr));
                return new TreeModelEvent((Object)this, this.getNodePath());
            }
            if (insert) {
                return this.addTest(new TT_TestNode(this, tr), this.comp);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeModelEvent addTest(TT_TestNode tn, Comparator sortComparator) {
        if (this.updateNode()) {
            return null;
        }
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            int result = -1;
            if (this.children.size() == 0) {
                this.children.add(tn);
                result = 0;
            } else if (sortComparator == null) {
                this.children.add(0, tn);
                result = 0;
            } else {
                result = this.recursiveIns(0, this.children.size() - 1, tn, tn.getDisplayName(), sortComparator);
            }
            return new TreeModelEvent((Object)this, this.getNodePath(), new int[]{result}, new Object[]{tn});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recursiveIns(int lPos, int rPos, TT_TreeNode tn, String dispName, Comparator sortComparator) {
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            int diff = rPos - lPos;
            int pos = diff / 2 + lPos;
            String posStr = this.children.get(pos).getDisplayName();
            int res = sortComparator.compare(dispName, posStr);
            if (res == 0) {
                this.children.set(pos, tn);
                if (this.debug) {
                    Debug.println("Duplicate test, replaced - " + tn.getDisplayName());
                }
                return pos;
            }
            if (diff <= 0) {
                if (res < 0) {
                    this.children.add(lPos, tn);
                    return lPos;
                }
                if (res > 0) {
                    this.children.add(lPos + 1, tn);
                    return lPos + 1;
                }
            }
            if (res < 0) {
                return this.recursiveIns(lPos, pos - 1, tn, dispName, sortComparator);
            }
            return this.recursiveIns(pos + 1, rPos, tn, dispName, sortComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateNode() {
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            if (this.isUpdated.compareAndSet(false, true)) {
                this.updateNode0();
                return true;
            }
            return false;
        }
    }

    private void updateNode0() {
        TestResultTable.TreeNode[] nodes = this.tn.getTreeNodes();
        this.addNodes(nodes);
        TestResult[] tests = this.tn.getTestResults();
        this.addTests(tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] addNodes(TestResultTable.TreeNode[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        this.updateNode();
        int[] newPositions = new int[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            TRT_TreeNode tnode = (TRT_TreeNode)nodes[i];
            ArrayList<TT_TreeNode> arrayList = this.children;
            synchronized (arrayList) {
                newPositions[i] = this.findDuplicateNode(tnode);
                if (newPositions[i] >= 0) {
                    continue;
                }
                TT_BasicNode newNode = new TT_BasicNode(this, tnode, this.comp);
                if (this.children.size() == 0) {
                    this.children.add(newNode);
                    newPositions[i] = 0;
                } else if (this.comp == null) {
                    this.children.add(newNode);
                    newPositions[i] = this.children.size() - 1;
                } else {
                    newPositions[i] = this.recursiveIns(0, this.children.size() - 1, newNode, newNode.getDisplayName(), this.comp);
                }
                continue;
            }
        }
        return newPositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTests(TestResult[] tests) {
        if (tests == null || tests.length == 0) {
            return;
        }
        for (int i = 0; i < tests.length; ++i) {
            TT_TestNode tn = new TT_TestNode(this, tests[i]);
            ArrayList<TT_TreeNode> arrayList = this.children;
            synchronized (arrayList) {
                if (this.children.size() == 0 || this.comp == null) {
                    this.children.add(tn);
                } else {
                    int result = this.recursiveIns(0, this.children.size() - 1, tn, tn.getDisplayName(), this.comp);
                }
                continue;
            }
        }
    }

    private int findDuplicateNode(TRT_TreeNode node) {
        for (TreeNode treeNode : this.children) {
            if (!(treeNode instanceof TT_BasicNode) || ((TT_BasicNode)treeNode).tn != node) continue;
            return this.children.indexOf(treeNode);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertNewBranch(TT_BasicNode tn) {
        ArrayList<TT_TreeNode> arrayList = this.children;
        synchronized (arrayList) {
            if (this.children.size() == 0) {
                this.children.add(tn);
                return 0;
            }
            if (this.comp == null) {
                this.children.add(tn);
                return this.children.size() - 1;
            }
            int result = this.recursiveIns(0, this.children.size() - 1, tn, tn.getDisplayName(), this.comp);
            return result;
        }
    }
}

