/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class TT_NodeCache
implements Runnable {
    private final TestResultTable.TreeNode node;
    private final Logger log;
    private TestResultTable.TreeIterator it;
    private TestFilter filter;
    private int[] stats = new int[4];
    private int localRejectCount;
    private Hashtable rejectReasons = new Hashtable();
    private final FilterObserver fObs = new FilterObserver();
    private TT_NodeCacheObserver[] observers = new TT_NodeCacheObserver[0];
    private Vector[] testLists;
    private volatile int state;
    private volatile boolean valid = true;
    private static final int NOT_COMPUTED = 0;
    private static final int COMPUTING = 1;
    private static final int COMPLETED = 2;
    private static final int PAUSED = 3;
    private static final int ABORTED = 4;
    private static final boolean debug = Debug.getBoolean(TT_NodeCache.class);

    TT_NodeCache(TestResultTable.TreeNode n, TestFilter f, Logger l) {
        this.filter = f;
        this.node = n;
        this.log = l;
        this.testLists = new Vector[5];
        for (int i = 0; i < 5; ++i) {
            this.testLists[i] = new Vector();
        }
    }

    public void run() {
        if (debug) {
            Debug.println("TT_NodeCache starting");
            Debug.println("   -> " + this);
            Debug.println("   -> node " + this.node + "(" + this.node.getName() + ")");
            Debug.println("   -> filter=" + this.filter);
            Debug.println("   -> old state=" + this.state);
        }
        if (this.it == null) {
            this.it = this.init();
        }
        if (debug) {
            Debug.println("   -> iterator= " + this.it);
        }
        this.state = 1;
        this.process();
    }

    void pause() {
        if (this.state < 2) {
            this.state = 3;
            if (debug) {
                Debug.println("TT_NodeCache for " + this.node.getName() + " pausing...");
            }
        }
    }

    void resume() {
        if (this.state != 3) {
            throw new IllegalStateException("Cache node not previously paused.");
        }
        if (debug) {
            Debug.println("TT_NodeCache for " + this.node.getName() + " resuming...");
        }
        this.state = 1;
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean add(TestResultTable.TreeNode[] path, TestResult what, int index) {
        boolean result = false;
        boolean wouldAccept = false;
        boolean needsProcessing = false;
        if (this.it == null) {
            return false;
        }
        try {
            Object peek;
            TestDescription td = what.getDescription();
            TestFilter rejector = null;
            FilterObserver filterObserver = this.fObs;
            synchronized (filterObserver) {
                wouldAccept = this.filter.accepts(what, (TestFilter.Observer)this.fObs);
                if (!wouldAccept && this.fObs.lastTd == td) {
                    rejector = this.fObs.lastRejector;
                    this.fObs.clear();
                }
            }
            boolean bl = needsProcessing = !this.it.isPending(what);
            if (!needsProcessing && (peek = this.it.peek()) instanceof TestResult && ((TestResult)peek).getTestName().equals(what.getTestName())) {
                this.it.next();
                needsProcessing = true;
            }
            if (needsProcessing) {
                if (!wouldAccept) {
                    ++this.localRejectCount;
                    this.testLists[this.testLists.length - 1].add(what);
                    this.rejectReasons.put(what, rejector);
                } else {
                    int type = what.getStatus().getType();
                    if (!this.testLists[type].contains(what)) {
                        int n = type;
                        this.stats[n] = this.stats[n] + 1;
                        this.testLists[type].add(what);
                    }
                }
                result = true;
            } else {
                result = false;
            }
            this.notify(wouldAccept ? what.getStatus().getType() + 2 : 6, true, path, what, index);
            if (result) {
                this.notifyStats();
            }
        }
        catch (TestResult.Fault f) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                String msg = "TT_NodeCache - TR fault, purging old info. " + what.getTestName();
                this.log.log(Level.SEVERE, msg, f);
            }
            this.node.getEnclosingTable().resetTest(what.getTestName());
            result = false;
        }
        catch (TestFilter.Fault f) {
            f.printStackTrace(Debug.getWriter());
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, "TT_NodeCache - filter is broken", f);
            }
            if (needsProcessing) {
                ++this.localRejectCount;
                this.testLists[this.testLists.length - 1].add(what);
            }
            result = false;
        }
        return result;
    }

    synchronized boolean remove(TestResultTable.TreeNode[] path, TestResult what, int index) {
        boolean result = false;
        if (this.it == null) {
            return false;
        }
        int type = what.getStatus().getType();
        if (!this.it.isPending(what)) {
            int[] rmList = this.locateTestInLists(what, type, -1);
            if (rmList[0] != -1) {
                this.testLists[rmList[0]].remove(rmList[1]);
                if (rmList[0] < this.stats.length) {
                    int n = rmList[0];
                    this.stats[n] = this.stats[n] - 1;
                } else {
                    --this.localRejectCount;
                }
                this.notify(rmList[0] + 2, false, path, what, index);
                result = true;
            }
        } else {
            Object peek = this.it.peek();
            if (peek instanceof TestResult && ((TestResult)peek).getTestName().equals(what.getTestName())) {
                this.it.next();
                result = this.remove(path, what, index);
            }
        }
        if (result) {
            this.notifyStats();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean replace(TestResultTable.TreeNode[] path, TestResult what, int index, TestResult old) {
        boolean result = false;
        if (this.it == null) {
            return false;
        }
        if (!this.it.isPending(what)) {
            int typeNew = what.getStatus().getType();
            int typeOld = old.getStatus().getType();
            boolean wouldAcceptNew = false;
            TestFilter rejector = null;
            try {
                TestDescription td = what.getDescription();
                FilterObserver filterObserver = this.fObs;
                synchronized (filterObserver) {
                    wouldAcceptNew = this.filter.accepts(what, (TestFilter.Observer)this.fObs);
                    if (!wouldAcceptNew && this.fObs.lastTd == td) {
                        rejector = this.fObs.lastRejector;
                        this.fObs.clear();
                    }
                }
            }
            catch (TestResult.Fault f) {
                f.printStackTrace(Debug.getWriter());
                if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                    this.log.log(Level.SEVERE, "TT_NodeCache - problem with test result", f);
                }
                return false;
            }
            catch (TestFilter.Fault f) {
                f.printStackTrace(Debug.getWriter());
                if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                    this.log.log(Level.SEVERE, "TT_NodeCache - filter is broken", f);
                }
                return false;
            }
            int targetList = wouldAcceptNew ? typeNew : this.testLists.length - 1;
            int[] rmList = null;
            if (what == old) {
                if (typeOld != typeNew) {
                    rmList = new int[]{-1, -1};
                } else {
                    rmList = this.locateTestInLists(old, 3, targetList);
                    if (rmList[0] == targetList) {
                        rmList[0] = -1;
                        rmList[1] = -1;
                    }
                }
            } else {
                rmList = this.locateTestInLists(old, typeOld, targetList);
            }
            if (rmList[0] != -1) {
                this.testLists[rmList[0]].remove(rmList[1]);
                this.testLists[targetList].add(what);
                if (rmList[0] < this.stats.length) {
                    int n = rmList[0];
                    this.stats[n] = this.stats[n] - 1;
                } else {
                    --this.localRejectCount;
                    this.rejectReasons.remove(what);
                }
                if (targetList < this.stats.length) {
                    int n = targetList;
                    this.stats[n] = this.stats[n] + 1;
                } else {
                    ++this.localRejectCount;
                    this.rejectReasons.put(what, rejector);
                }
                this.notify(rmList[0] + 2, false, path, old, index);
                this.notify(targetList + 2, true, path, what, index);
                result = true;
            }
        } else {
            result = false;
        }
        if (result) {
            this.notifyStats();
        }
        return result;
    }

    boolean isPaused() {
        return this.state == 3;
    }

    boolean canRun() {
        return (this.state == 3 || this.state == 0) && this.valid;
    }

    void halt() {
        if (debug) {
            Debug.println("TT_NodeCache thread stopping");
            Debug.println("   -> " + this);
        }
        this.state = 4;
        this.valid = false;
    }

    boolean isActive() {
        return this.state == 1;
    }

    boolean isComplete() {
        return this.state == 2;
    }

    boolean isAborted() {
        return this.state == 4;
    }

    void invalidate() {
        this.valid = false;
    }

    boolean isValid() {
        return this.valid;
    }

    TestResultTable.TreeNode getNode() {
        return this.node;
    }

    TestFilter getFilter() {
        return this.filter;
    }

    int[] getStats() {
        return this.stats;
    }

    int getRejectCount() {
        if (this.it != null) {
            return this.it.getRejectCount() + this.localRejectCount;
        }
        return this.localRejectCount;
    }

    TestFilter getRejectReason(TestResult tr) {
        return (TestFilter)this.rejectReasons.get(tr);
    }

    synchronized Vector[] addObserver(TT_NodeCacheObserver obs, boolean needSnapshot) {
        Vector[] cp = null;
        if (needSnapshot) {
            cp = new Vector[this.testLists.length];
            for (int i = 0; i < this.testLists.length; ++i) {
                cp[i] = (Vector)this.testLists[i].clone();
            }
        }
        if (obs != null) {
            this.observers = (TT_NodeCacheObserver[])DynamicArray.append(this.observers, obs);
        }
        return cp;
    }

    synchronized void removeObserver(TT_NodeCacheObserver obs) {
        this.observers = (TT_NodeCacheObserver[])DynamicArray.remove((Object[])this.observers, obs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        TestResultTable trt = this.node.getEnclosingTable();
        if (trt == null) {
            return;
        }
        try {
            trt.getLock().lock();
            while (this.state != 4 && this.state != 3 && this.it.hasNext()) {
                block25: {
                    try {
                        TestResultTable.TreeNode treeNode = this.node;
                        synchronized (treeNode) {
                            TT_NodeCache tT_NodeCache = this;
                            synchronized (tT_NodeCache) {
                                if (!this.it.hasNext()) {
                                    continue;
                                }
                                TestResult tr = (TestResult)this.it.next();
                                TestDescription td = tr.getDescription();
                                TestFilter rejector = null;
                                boolean wouldAccept = false;
                                FilterObserver filterObserver = this.fObs;
                                synchronized (filterObserver) {
                                    try {
                                        wouldAccept = this.filter.accepts(tr, (TestFilter.Observer)this.fObs);
                                    }
                                    catch (TestFilter.Fault f) {
                                        f.printStackTrace(Debug.getWriter());
                                        if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                                            this.log.log(Level.SEVERE, "TT_NodeCache - filter is broken", f);
                                        }
                                        wouldAccept = true;
                                    }
                                    if (!wouldAccept && this.fObs.lastTd == td) {
                                        rejector = this.fObs.lastRejector;
                                        this.fObs.clear();
                                    }
                                }
                                if (wouldAccept) {
                                    int type = tr.getStatus().getType();
                                    if (!this.testLists[type].contains(tr)) {
                                        int n = type;
                                        this.stats[n] = this.stats[n] + 1;
                                        this.testLists[type].add(tr);
                                        this.notify(type + 2, true, null, tr, -1);
                                    }
                                } else {
                                    this.testLists[this.testLists.length - 1].add(tr);
                                    this.rejectReasons.put(tr, rejector);
                                    ++this.localRejectCount;
                                    this.notify(6, true, null, tr, -1);
                                }
                            }
                        }
                    }
                    catch (TestResult.Fault f) {
                        f.printStackTrace(Debug.getWriter());
                        if (this.log == null || !this.log.isLoggable(Level.SEVERE)) break block25;
                        this.log.log(Level.SEVERE, "TT_NodeCache - problem with test result", f);
                    }
                }
                this.notifyStats();
            }
            if (this.state != 3) {
                this.cleanup();
            }
        }
        finally {
            trt.getLock().unlock();
        }
    }

    private int[] locateTestInLists(TestResult tr, int firstListToCheck, int lastListToCheck) {
        int possible;
        int[] result = new int[]{-1, -1};
        if (firstListToCheck >= 0 && (possible = this.testLists[firstListToCheck].indexOf(tr)) != -1) {
            result[0] = firstListToCheck;
            result[1] = possible;
        }
        if (result[0] == -1) {
            for (int i = 0; i < this.testLists.length; ++i) {
                int possible2;
                if (i == firstListToCheck || i == lastListToCheck || (possible2 = this.testLists[i].indexOf(tr)) == -1) continue;
                result[0] = i;
                result[1] = possible2;
                break;
            }
        }
        if (result[0] == -1 && lastListToCheck >= 0 && (possible = this.testLists[lastListToCheck].indexOf(tr)) != -1) {
            result[0] = lastListToCheck;
            result[1] = possible;
        }
        return result;
    }

    private int searchList(TestResult target, Vector list) {
        int possible = list.indexOf(target);
        return possible;
    }

    private void cleanup() {
        if (this.state == 4) {
            return;
        }
        this.state = 2;
    }

    private TestResultTable.TreeIterator init() {
        if (this.node == null) {
            this.valid = false;
            this.state = 4;
            return null;
        }
        return TestResultTable.getIterator(this.node);
    }

    private synchronized void notify(int type, boolean isAdd, TestResultTable.TreeNode[] path, TestResult what, int index) {
        if (this.observers.length == 0) {
            return;
        }
        for (int i = 0; i < this.observers.length; ++i) {
            boolean[] mask = this.observers[i].getEventMasks();
            if (!mask[0] && !mask[type]) continue;
            if (isAdd) {
                this.observers[i].testAdded(type, path, what, index);
                continue;
            }
            this.observers[i].testRemoved(type, path, what, index);
        }
    }

    private synchronized void notifyStats() {
        if (this.observers.length == 0) {
            return;
        }
        for (int i = 0; i < this.observers.length; ++i) {
            boolean[] mask = this.observers[i].getEventMasks();
            if (!mask[0] && !mask[1]) continue;
            this.observers[i].statsUpdated(this.stats);
        }
    }

    static class FilterObserver
    implements TestFilter.Observer {
        TestDescription lastTd;
        TestFilter lastRejector;

        FilterObserver() {
        }

        public void rejected(TestDescription d, TestFilter rejector) {
            this.lastTd = d;
            this.lastRejector = rejector;
        }

        public void clear() {
            this.lastTd = null;
            this.lastRejector = null;
        }
    }

    static abstract class TT_NodeCacheObserver {
        protected boolean[] interestList = new boolean[7];
        public static final int EVENT_LIST_SIZE = 7;
        public static final int MSGS_ALL = 0;
        public static final int MSGS_STATS = 1;
        public static final int MSGS_PASSED = 2;
        public static final int MSGS_FAILED = 3;
        public static final int MSGS_ERRORS = 4;
        public static final int MSGS_NOT_RUNS = 5;
        public static final int MSGS_FILTERED = 6;
        public static final int OFFSET_FROM_STATUS = 2;

        public boolean[] getEventMasks() {
            return this.interestList;
        }

        public abstract void testAdded(int var1, TestResultTable.TreeNode[] var2, TestResult var3, int var4);

        public abstract void testRemoved(int var1, TestResultTable.TreeNode[] var2, TestResult var3, int var4);

        public abstract void statsUpdated(int[] var1);
    }
}

