/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.agent.SocketConnection;
import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.httpd.RequestHandler;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class HttpdServer
implements Runnable {
    private static ServerSocket socket;
    private static String baseURL;
    private static final int MAX_PORT_SEARCH = 10;
    private static boolean active;
    protected static boolean debug;
    private static I18NResourceBundle i18n;

    public HttpdServer() {
        try {
            this.init();
            HttpdServer.setActive();
        }
        catch (IOException e) {
            throw new IllegalStateException(i18n.getString("server.cantInit"));
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket ns = socket.accept();
                    if (debug) {
                        System.out.println("httpd-New connection " + ns);
                    }
                    RequestHandler handler = new RequestHandler(ns);
                    Thread thr = new Thread(handler);
                    if (debug) {
                        System.out.println("httpd-Starting thread for connection ");
                    }
                    thr.start();
                }
            }
            catch (IOException e) {
                System.out.println(i18n.getString("server.errorInAccept"));
                e.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    public static int getLocalPort() {
        if (socket == null) {
            throw new IllegalStateException();
        }
        return socket.getLocalPort();
    }

    public static boolean isActive() {
        return active;
    }

    private static void setActive() {
        active = true;
    }

    private static String getBaseUrl() {
        return baseURL;
    }

    private void init() throws IOException {
        int soc_num;
        if (debug) {
            System.out.println("Initializing JT Harness HTTP Server");
        }
        for (int i = soc_num = Integer.getInteger("jt.httpd.port", 1903).intValue(); i < soc_num + 10; ++i) {
            try {
                socket = SocketConnection.createServerSocket(i, 25);
                System.out.println(i18n.getString("server.port", String.valueOf(socket.getLocalPort())));
                StringBuffer buf = new StringBuffer("http://");
                buf.append(InetAddress.getLocalHost().getHostAddress());
                buf.append(":");
                buf.append(socket.getLocalPort());
                buf.append("/");
                baseURL = buf.toString();
                buf = null;
                System.out.println(i18n.getString("server.url", baseURL));
                break;
            }
            catch (BindException e) {
                if (i + 1 >= soc_num + 10) {
                    throw e;
                }
                System.out.println(i18n.getString("server.portBusy", new Integer(i)));
                continue;
            }
            catch (IOException e) {
                System.out.println(i18n.getString("server.errorInInit"));
                throw e;
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("Starting JT Harness httpd in debug mode.");
        JThttpProvider prov = new JThttpProvider(){

            public void serviceRequest(httpURL url, PrintWriter out) {
                PageGenerator.generateDocType(out, 0);
                out.println("<html>");
                out.println("<Body>");
                out.println("<h2>Hello, this is the JT Harness web server.</h2>");
                out.println("Running in test mode, no harness.");
                out.println("</Body>");
                out.println("</html>");
                out.close();
            }
        };
        RootRegistry.getInstance().addHandler("/", "Root JT Harness URL", prov);
        HttpdServer server = new HttpdServer();
        debug = true;
        Thread thr = new Thread(server);
        thr.start();
    }

    static {
        debug = Boolean.getBoolean("debug." + HttpdServer.class.getName());
        i18n = I18NResourceBundle.getBundleForClass(HttpdServer.class);
    }
}

