/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.Main;
import com.sun.javatest.cof.Report;
import com.sun.javatest.report.ReportFormat;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COFReport
implements ReportFormat {
    private final String FNAME = "cof.xml";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(COFReport.class);
    private static final String ID = "cof";

    @Override
    public ReportFormat.ReportLink write(ReportSettings s, File dir) throws IOException {
        COFData data = new COFData();
        data.setInterviewParameters(s.getInterview());
        File outputFile = new File(dir.getAbsolutePath() + File.separator + "cof.xml");
        if (!s.isCOFTestCasesEnabled()) {
            Main.setGenerateTestCases(s.isCOFTestCasesEnabled());
        }
        Main cofMain = new Main();
        cofMain.setInterviewParameters(s.getInterview());
        try {
            Report report = cofMain.fillReport(data);
            cofMain.writeReport(report, outputFile);
        }
        catch (Main.Fault ex) {
            Logger.getLogger(COFReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        String warning = data.get("warning");
        if (warning != null) {
            // empty if block
        }
        return new ReportFormat.ReportLink(i18n.getString("index.coftype.txt"), this.getBaseDirName(), i18n.getString("index.desc.cof"), outputFile);
    }

    @Override
    public String getReportID() {
        return ID;
    }

    @Override
    public String getBaseDirName() {
        return ID;
    }

    @Override
    public boolean acceptSettings(ReportSettings s) {
        return s.isCOFEnabled();
    }

    @Override
    public List<ReportFormat> getSubReports() {
        return Collections.emptyList();
    }

    @Override
    public String getTypeName() {
        return ID;
    }
}

