/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.Harness;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.Main;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelpSearchNavigator;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class HelpManager
extends CommandManager {
    private CommandManager[] commandManagers;
    private boolean commandLineHelpFlag;
    private String[] commandLineHelpQuery;
    private boolean onlineHelpFlag;
    private String onlineHelpQuery;
    private boolean versionFlag;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(HelpManager.class);

    public HelpManager() {
    }

    public HelpManager(CommandManager[] commandManagers) {
        this.setCommandManagers(commandManagers);
    }

    public HelpTree.Node getHelp() {
        String[] helpOptions = new String[]{"help", "onlineHelp", "query1", "query2", "usage", "version"};
        return new HelpTree.Node(i18n, "help.cmd.opts", helpOptions);
    }

    public boolean parseCommand(String cmd, ListIterator argIter, CommandContext ctx) {
        if (cmd.equalsIgnoreCase("help") || cmd.equalsIgnoreCase("usage") || cmd.equalsIgnoreCase("?")) {
            ArrayList<String> v = new ArrayList<String>();
            while (argIter.hasNext()) {
                v.add(((String)argIter.next()).toLowerCase());
            }
            this.commandLineHelpFlag = true;
            this.commandLineHelpQuery = v.toArray(new String[v.size()]);
            return true;
        }
        if (cmd.equalsIgnoreCase("onlineHelp") || cmd.equalsIgnoreCase("userGuide")) {
            StringBuilder sb = new StringBuilder();
            while (argIter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(argIter.next());
            }
            this.onlineHelpFlag = true;
            this.onlineHelpQuery = sb.toString();
            return true;
        }
        if (cmd.equalsIgnoreCase("version")) {
            this.versionFlag = true;
            return true;
        }
        return false;
    }

    public void setCommandManagers(CommandManager[] commandManagers) {
        this.commandManagers = commandManagers;
    }

    boolean isInfoRequired() {
        return this.versionFlag || this.commandLineHelpFlag || this.onlineHelpFlag;
    }

    void showRequiredInfo(PrintWriter out, CommandContext ctx) {
        if (this.versionFlag) {
            this.showVersion(out);
        }
        if (this.commandLineHelpFlag) {
            this.showCommandLineHelp(out);
        }
        if (this.onlineHelpFlag) {
            this.showOnlineHelp(out, ctx);
        }
    }

    void showCommandLineHelp(PrintWriter out) {
        Integer descIndent;
        HelpTree commandHelpTree = new HelpTree();
        Integer nodeIndent = Integer.getInteger("javatest.help.nodeIndent");
        if (nodeIndent != null) {
            commandHelpTree.setNodeIndent(nodeIndent);
        }
        if ((descIndent = Integer.getInteger("javatest.help.descIndent")) != null) {
            commandHelpTree.setDescriptionIndent(descIndent);
        }
        TreeMap<String, HelpTree.Node> tm = new TreeMap<String, HelpTree.Node>();
        for (int i = 0; i < this.commandManagers.length; ++i) {
            HelpTree.Node n = this.commandManagers[i].getHelp();
            tm.put(n.getName(), n);
        }
        Iterator iter = tm.values().iterator();
        while (iter.hasNext()) {
            commandHelpTree.addNode((HelpTree.Node)iter.next());
        }
        String[] fileTypes = new String[]{"ts", "wd", "jti"};
        HelpTree.Node filesNode = new HelpTree.Node(i18n, "help.cmd.files", fileTypes);
        commandHelpTree.addNode(filesNode);
        String[] syntaxTypes = new String[]{"opts", "string", "atfile", "readfile", "encode"};
        HelpTree.Node syntaxNode = new HelpTree.Node(i18n, "help.cmd.syntax", syntaxTypes);
        commandHelpTree.addNode(syntaxNode);
        String progName = System.getProperty("program", "java " + Main.class.getName());
        try {
            WrapWriter ww = new WrapWriter(out);
            if (this.commandLineHelpQuery == null || this.commandLineHelpQuery.length == 0) {
                ww.write(i18n.getString("help.cmd.proto", progName));
                ww.write("\n\n");
                ww.write(i18n.getString("help.cmd.introHead"));
                ww.write('\n');
                commandHelpTree.writeSummary(ww);
            } else if (Arrays.asList(this.commandLineHelpQuery).contains("all")) {
                ww.write(i18n.getString("help.cmd.proto", progName));
                ww.write("\n\n");
                ww.write(i18n.getString("help.cmd.fullHead"));
                ww.write('\n');
                commandHelpTree.write(ww);
            } else {
                HelpTree.Selection s = commandHelpTree.find(this.commandLineHelpQuery);
                if (s != null) {
                    commandHelpTree.write((Writer)ww, s);
                } else {
                    ww.write(i18n.getString("help.cmd.noEntriesFound"));
                    ww.write("\n\n");
                    ww.write(i18n.getString("help.cmd.summaryHead"));
                    ww.write('\n');
                    commandHelpTree.writeSummary(ww);
                }
            }
            ww.write('\n');
            ww.write(i18n.getString("help.cmd.tail"));
            ww.write("\n\n");
            ww.write(i18n.getString("help.copyright.txt"));
            ww.write("\n\n");
            ww.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    void showOnlineHelp(PrintWriter out, CommandContext ctx) {
        out.println(i18n.getString("help.onlineHelp.pleaseWait"));
        out.flush();
        Command[] cmds = ctx.getCommands();
        ClassLoader theLoader = null;
        URL u = null;
        for (int i = 0; i < cmds.length && (u = HelpSet.findHelpSet(theLoader = cmds[i].getCustomHelpLoader(), "jthelp.hs")) == null; ++i) {
        }
        if (u == null) {
            theLoader = this.getClass().getClassLoader();
            u = HelpSet.findHelpSet(theLoader, "com/sun/javatest/help/jthelp.hs");
        }
        if (u != null) {
            try {
                HelpSet helpSet = new HelpSet(theLoader, u);
                CustomHelpBroker b = new CustomHelpBroker(helpSet);
                if (this.onlineHelpQuery != null && this.onlineHelpQuery.length() > 0) {
                    b.search(this.onlineHelpQuery);
                } else {
                    b.setCurrentID("command.intro.csh");
                }
                b.setDisplayed(true);
            }
            catch (HelpSetException e) {
                // empty catch block
            }
        }
    }

    void showVersion(PrintWriter out) {
        File classDir = Harness.getClassDir();
        String classDirPath = classDir == null ? i18n.getString("help.version.unknown") : classDir.getPath();
        DateFormat df = DateFormat.getDateInstance(1);
        Object[] versionArgs = new Object[]{ProductInfo.getName(), ProductInfo.getVersion(), ProductInfo.getMilestone(), ProductInfo.getBuildNumber(), ProductInfo.getHarnessVariety(), ProductInfo.getPackagingType(), classDirPath, System.getProperty("java.version"), System.getProperty("java.home"), ProductInfo.getBuildJavaVersion(), df.format(ProductInfo.getBuildDate())};
        out.println(i18n.getString("help.version.txt", versionArgs));
        out.println(i18n.getString("help.copyright.txt"));
    }

    String getHarnessType() {
        return i18n.getString("help.harnessType.full.txt");
    }

    private static class CustomHelpBroker
    extends DefaultHelpBroker {
        CustomHelpBroker(HelpSet hs) {
            super(hs);
            ExitCount.inc();
        }

        void search(String s) {
            this.initPresentation();
            JFrame frame = (JFrame)this.getHelpWindow();
            Container root = frame.getContentPane();
            JHelpSearchNavigator searchNav = (JHelpSearchNavigator)this.findComponent(root, JHelpSearchNavigator.class);
            if (searchNav == null) {
                return;
            }
            JTextField searchField = (JTextField)this.findComponent(searchNav, JTextField.class);
            if (searchField == null) {
                return;
            }
            searchField.setText(s);
            searchField.postActionEvent();
            this.setCurrentView("Search");
        }

        public void setDisplayed(boolean b) {
            super.setDisplayed(b);
            JFrame frame = (JFrame)this.getHelpWindow();
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    ExitCount.dec();
                }
            });
        }

        private Component findComponent(Container cont, Class targetClass) {
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child;
                Component c = cont.getComponent(i);
                if (targetClass.isInstance(c)) {
                    return c;
                }
                if (!(c instanceof Container) || (child = this.findComponent((Container)c, targetClass)) == null) continue;
                return child;
            }
            return null;
        }

        private Window getHelpWindow() {
            return this.getWindowPresentation().getHelpWindow();
        }
    }
}

