/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class ToolAction
implements Action {
    private String name;
    private String desc;
    private Integer mnemonic;
    private Icon icon;
    private Map misc;
    private boolean enabled = true;
    private WeakReference[] listeners = new WeakReference[0];

    public ToolAction(String name, String desc, int mnemonic) {
        this.name = name;
        this.desc = desc;
        this.mnemonic = new Integer(mnemonic);
        this.enabled = true;
    }

    public ToolAction(UIFactory uif, String key) {
        this(uif.getI18NResourceBundle(), key);
    }

    public ToolAction(UIFactory uif, String key, boolean needIcon) {
        this(uif, key);
        if (needIcon) {
            this.putValue("SmallIcon", uif.createIcon(key));
        }
    }

    public ToolAction(I18NResourceBundle i18n, String key) {
        this(i18n.getString(key + ".act"), i18n.getString(key + ".tip"), ToolAction.getMnemonic(i18n, key + ".mne"));
    }

    public Object getValue(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.equals("Name")) {
            return this.name;
        }
        if (key.equals("ShortDescription")) {
            return this.desc;
        }
        if (key.equals("MnemonicKey")) {
            return this.mnemonic;
        }
        if (key.equals("SmallIcon")) {
            return this.icon;
        }
        return this.misc == null ? null : this.misc.get(key);
    }

    public void putValue(String key, Object newVal) {
        Object oldVal;
        if (key.equals("Name")) {
            if (ToolAction.equal(newVal, this.name)) {
                return;
            }
            oldVal = this.name;
            this.name = (String)newVal;
        } else if (key.equals("ShortDescription")) {
            if (ToolAction.equal(newVal, this.desc)) {
                return;
            }
            oldVal = this.desc;
            this.desc = (String)newVal;
        } else if (key.equals("MnemonicKey")) {
            if (ToolAction.equal(newVal, this.mnemonic)) {
                return;
            }
            oldVal = this.mnemonic;
            this.mnemonic = (Integer)newVal;
        } else if (key.equals("SmallIcon")) {
            if (ToolAction.equal(newVal, this.icon)) {
                return;
            }
            oldVal = this.icon;
            this.icon = (Icon)newVal;
        } else {
            if (this.misc == null) {
                this.misc = new HashMap();
            }
            if (ToolAction.equal(newVal, oldVal = this.misc.get(key))) {
                return;
            }
            this.misc.put(key, newVal);
        }
        this.firePropertyChangeEvent(key, oldVal, newVal);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean newVal) {
        if (this.enabled == newVal) {
            return;
        }
        boolean oldVal = this.enabled;
        this.enabled = newVal;
        if (this.listeners.length > 0) {
            this.firePropertyChangeEvent("enabled", new Boolean(oldVal), new Boolean(newVal));
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners = (WeakReference[])DynamicArray.append(this.listeners, new WeakReference<PropertyChangeListener>(listener));
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        WeakReference[] l = this.listeners;
        int size = l.length;
        for (int i = size - 1; i >= 0; --i) {
            if (l[i].get() != listener) continue;
            System.arraycopy(l, i + 1, l, i, --size - i);
        }
        if (size < l.length) {
            this.listeners = new WeakReference[size];
            System.arraycopy(l, 0, this.listeners, 0, size);
        }
    }

    private void firePropertyChangeEvent(String name, Object oldVal, Object newVal) {
        PropertyChangeEvent ev = null;
        WeakReference[] l = this.listeners;
        if (l.length > 0) {
            for (int i = l.length - 1; i >= 0; --i) {
                PropertyChangeListener pcl = (PropertyChangeListener)l[i].get();
                if (pcl == null) continue;
                if (ev == null) {
                    ev = new PropertyChangeEvent(this, name, oldVal, newVal);
                }
                pcl.propertyChange(ev);
            }
        }
    }

    private static int getMnemonic(I18NResourceBundle i18n, String key) {
        String keyString = i18n.getString(key);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyString);
        return keyStroke == null ? 0 : keyStroke.getKeyCode();
    }

    private static boolean equal(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }
}

