/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TRT_HttpHandler;
import com.sun.javatest.TRT_Iterator;
import com.sun.javatest.TRT_TreeNode;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultCache;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

public class TestResultTable {
    private Map<String, TestResult> cachedResults;
    private RequestsToCache rtc;
    private Hashtable[] statusTables;
    private WorkDirectory workDir;
    private TestFinder finder;
    private String[] finderErrors = new String[0];
    private Observer[] observers = new Observer[0];
    private TRT_HttpHandler httpHandle;
    private TreeObserver[] treeObservers = new TreeObserver[0];
    private TestResultCache trCache;
    private boolean suppressFinderScan = false;
    private Updater updater = new Updater();
    private volatile boolean updateInProgress;
    private volatile boolean cacheInitialized = false;
    private Vector testsInUpdate = new Vector();
    private static int instanceId;
    private TRT_TreeNode root;
    private File suiteRoot;
    private static I18NResourceBundle i18n;
    private ReentrantLock processLock = new ReentrantLock();
    static final Status notYetRun;
    private static int debug;

    public void dispose() {
        if (this.trCache != null) {
            this.trCache.shutdown();
        }
    }

    public TestResultTable() {
        this.statusTables = new Hashtable[4];
        for (int i = 0; i < this.statusTables.length; ++i) {
            this.statusTables[i] = new Hashtable();
        }
        this.root = new TRT_TreeNode(this, null);
        ++instanceId;
        if (HttpdServer.isActive()) {
            String url = "/trt/" + instanceId;
            this.httpHandle = new TRT_HttpHandler(this, url, instanceId);
            RootRegistry.getInstance().addHandler(url, "Test Result Table", this.httpHandle);
            RootRegistry.associateObject(this, this.httpHandle);
        }
        this.rtc = new RequestsToCache();
    }

    public TestResultTable(WorkDirectory wd) {
        this();
        this.setWorkDirectory(wd);
    }

    public TestResultTable(WorkDirectory wd, TestFinder tf) {
        this();
        this.setWorkDirectory(wd, tf);
    }

    public void setTestFinder(TestFinder tf) {
        if (this.finder != null) {
            throw new IllegalStateException(i18n.getString("trt.alreadyFinder"));
        }
        this.finder = tf;
        if (this.trCache == null) {
            this.initFinder();
        }
    }

    public WorkDirectory getWorkDir() {
        return this.getWorkDirectory();
    }

    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    public void setWorkDirectory(WorkDirectory wd) {
        this.setWorkDirectory(wd, wd.getTestSuite().getTestFinder());
    }

    private void setWorkDirectory(WorkDirectory wd, TestFinder tf) {
        if (wd == null) {
            throw new NullPointerException();
        }
        if (this.workDir == wd) {
            return;
        }
        if (this.workDir != null && this.workDir != wd) {
            throw new IllegalStateException();
        }
        if (this.finder != null && this.finder != tf) {
            throw new IllegalStateException();
        }
        this.workDir = wd;
        this.finder = tf;
        this.initFinder();
        try {
            this.trCache = new TestResultCache(this.workDir, this.updater);
        }
        catch (IOException e) {
            this.updater.error(e);
        }
    }

    public int getCurrentTestCount() {
        return this.root.getCurrentSize();
    }

    void starting() {
    }

    void finished() {
        if (this.trCache != null) {
            if (this.needsCacheCompress()) {
                if (debug > 0) {
                    Debug.print("TRT.finished(), attempting cache compress...");
                }
                this.trCache.compress();
            }
            if (debug > 0) {
                Debug.print("TRT.finished(), requesting cache flush...");
            }
        }
    }

    public void update(TestResult tr) {
        this.update(tr, false);
    }

    public void update(TestResult tr, boolean suppressScan) {
        TestResult prev = this.insert(tr, suppressScan);
        this.updateNotify(tr, prev);
    }

    void updateNotify(TestResult tr, TestResult prev) {
        if (tr != prev) {
            tr.shareStatus(this.statusTables);
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].update(prev, tr);
            }
        } else {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].updated(tr);
            }
        }
        this.testsInUpdate.add(tr);
        if (this.trCache != null && !this.updateInProgress && tr.getStatus().getType() != 3) {
            this.trCache.insert(tr);
        }
        this.testsInUpdate.remove(tr);
    }

    public synchronized boolean waitUntilReady() {
        while (this.workDir != null && !this.cacheInitialized || this.updateInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (debug <= 0) continue;
                e.printStackTrace(Debug.getWriter());
            }
        }
        return true;
    }

    public synchronized boolean isReady() {
        return this.cacheInitialized && !this.updateInProgress;
    }

    public TestResult lookup(TestDescription td) {
        return this.lookup(TestResult.getWorkRelativePath(td.getRootRelativeURL()));
    }

    public TestResult lookup(String jtrPath) {
        if (this.root == null) {
            return null;
        }
        return TestResultTable.findTest(this.root, jtrPath, jtrPath);
    }

    public Object resolveUrl(String url) {
        return TestResultTable.lookupNode(this.root, url);
    }

    public boolean validatePath(String path) {
        if (path == null) {
            return false;
        }
        Object[] result = TestResultTable.lookupInitURL(this.root, path);
        return result != null && result.length > 0;
    }

    public static TreeNode[] getObjectPath(TestResult target) {
        if (target == null) {
            return null;
        }
        Vector<TreeNode> path = new Vector<TreeNode>();
        for (TreeNode loc = target.getParent(); loc != null; loc = loc.getParent()) {
            path.insertElementAt(loc, 0);
        }
        Object[] result = new TreeNode[path.size()];
        path.copyInto(result);
        if (debug == 2 || debug == 99) {
            Debug.println("TRT - getObjectPath() results:");
            Debug.println("   -> target: " + target.getTestName());
            Debug.println("   -> resulting path length: " + result.length);
        }
        if (result == null || result.length == 0) {
            return null;
        }
        return result;
    }

    public static TreeNode[] getObjectPath(TreeNode target) {
        if (target == null) {
            return null;
        }
        Vector<TreeNode> path = new Vector<TreeNode>();
        for (TreeNode loc = target; loc != null; loc = loc.getParent()) {
            path.insertElementAt(loc, 0);
        }
        Object[] result = new TreeNode[path.size()];
        path.copyInto(result);
        if (debug == 2 || debug == 99) {
            Debug.println("TRT - getObjectPath() results:");
            Debug.println("   -> target RRP: " + TestResultTable.getRootRelativePath(target));
            Debug.println("   -> resulting path length: " + result.length);
        }
        return result;
    }

    public TreeIterator getIterator() {
        if (this.root == null) {
            return NullEnum.getInstance();
        }
        return TestResultTable.getIterator(this.root);
    }

    public Enumeration elements() {
        return this.getIterator();
    }

    public TreeIterator getIterator(TestFilter[] filters) {
        if (this.root == null) {
            return NullEnum.getInstance();
        }
        return TestResultTable.getIterator((TreeNode)this.root, filters);
    }

    public Enumeration elements(TestFilter[] filters) {
        return this.getIterator(filters);
    }

    public static TreeIterator getIterator(TreeNode node) {
        if (node == null) {
            return NullEnum.getInstance();
        }
        return new TRT_Iterator(node);
    }

    public static Enumeration elements(TreeNode node) {
        return TestResultTable.getIterator(node);
    }

    public static TreeIterator getIterator(TreeNode node, TestFilter filter) {
        if (node == null) {
            return NullEnum.getInstance();
        }
        TestFilter[] filters = new TestFilter[]{filter};
        return new TRT_Iterator(node, filters);
    }

    public static Enumeration elements(TreeNode node, TestFilter filter) {
        return TestResultTable.getIterator(node, filter);
    }

    public static TreeIterator getIterator(TreeNode node, TestFilter[] filters) {
        if (node == null) {
            return NullEnum.getInstance();
        }
        return new TRT_Iterator(node, filters);
    }

    public static Enumeration elements(TreeNode node, TestFilter[] filters) {
        return TestResultTable.getIterator(node, filters);
    }

    public Enumeration elements(String url, TestFilter[] filters) {
        if (url == null) {
            return NullEnum.getInstance();
        }
        String[] urls = new String[]{url};
        return this.elements(urls, filters);
    }

    public TreeIterator getIterator(File[] tests, TestFilter[] filters) throws Fault {
        String[] urls = this.preProcessInitFiles(tests);
        if (urls != null && urls.length > 0) {
            return this.getIterator(urls, filters);
        }
        return this.getIterator(filters);
    }

    public Enumeration elements(File[] tests, TestFilter[] filters) throws Fault {
        return this.getIterator(tests, filters);
    }

    public TreeIterator getIterator(String[] paths, TestFilter[] filters) {
        LinkedList<TreeNode> initNodes = new LinkedList<TreeNode>();
        LinkedList<TestResult> initTests = new LinkedList<TestResult>();
        String[] urls = this.sortByName(paths);
        urls = TestResultTable.distillUrls(urls);
        if (!Boolean.parseBoolean(Preferences.access().getPreference("javatest.sortExecution", "true"))) {
            urls = urls.length != paths.length ? this.removeMissing(paths, urls) : paths;
        }
        for (int i = 0; i < urls.length; ++i) {
            Object[] objs = TestResultTable.lookupInitURL(this.root, urls[i]);
            if (debug == 1 || debug == 99) {
                Debug.println("TRT.lookupInitURL gave back " + Arrays.toString(objs));
            }
            if (objs == null) continue;
            if (objs instanceof TreeNode[]) {
                if (initNodes.contains((TreeNode)objs[0])) continue;
                initNodes.add((TreeNode)objs[0]);
                continue;
            }
            if (objs instanceof TestResult[]) {
                initTests.addAll(Arrays.asList((TestResult[])objs));
                continue;
            }
            throw new IllegalArgumentException(i18n.getString("trt.invalidIURL", urls[i]));
        }
        if (!(initNodes != null && initNodes.size() != 0 || initTests != null && initTests.size() != 0)) {
            if (debug == 1 || debug == 99) {
                Debug.println("None of the initial URLs could be looked up.");
            }
            return NullEnum.getInstance();
        }
        if (initTests.size() > 0) {
            if (debug == 1 || debug == 99) {
                Debug.println("Using combo TreeIterator, " + initTests.size() + " tests, " + initNodes.size() + " nodes.");
            }
            return new TRT_Iterator(initNodes.toArray(new TreeNode[0]), initTests.toArray(new TestResult[0]), filters);
        }
        return new TRT_Iterator(initNodes.toArray(new TreeNode[0]), filters);
    }

    public Enumeration elements(String[] urls, TestFilter[] filters) {
        return this.getIterator(urls, filters);
    }

    public int size() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getSize();
    }

    TestResult insert(TestResult tr) {
        return this.insert(tr, false);
    }

    TestResult insert(TestResult tr, boolean suppressScan) {
        if (tr == null) {
            return null;
        }
        String key = tr.getWorkRelativePath();
        TRT_TreeNode[] path = new TRT_TreeNode[]{};
        return this.insert(this.root, key, tr, path, suppressScan);
    }

    TestResult insert(TestResult tr, Status oldStatus) {
        if (tr == null) {
            return null;
        }
        String key = tr.getWorkRelativePath();
        TRT_TreeNode[] path = new TRT_TreeNode[]{};
        return this.insert(this.root, key, tr, path, false);
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public File getTestSuiteRoot() {
        return this.suiteRoot;
    }

    public TestFinder getTestFinder() {
        return this.finder;
    }

    public static String getRootRelativePath(TreeNode node) {
        if (node.isRoot()) {
            return "";
        }
        StringBuffer name = new StringBuffer(node.getName());
        for (node = node.getParent(); node != null && !node.isRoot(); node = node.getParent()) {
            name.insert(0, '/');
            name.insert(0, node.getName());
        }
        return name.toString();
    }

    public static TreeNode findNode(TreeNode node, String path) {
        if (node == null) {
            throw new IllegalArgumentException(i18n.getString("trt.nodeNull"));
        }
        if (path == null) {
            throw new IllegalArgumentException(i18n.getString("trt.pathNull"));
        }
        if (path.length() == 0) {
            return node;
        }
        String dir = TestResultTable.getDirName(path);
        TreeNode tn = null;
        if (debug > 9) {
            Debug.println("TRT.findNode() looking for " + path + " in " + node.getName());
        }
        if (dir.equals(path)) {
            tn = ((TRT_TreeNode)node).getTreeNode(path, false);
        } else {
            TRT_TreeNode next = ((TRT_TreeNode)node).getTreeNode(dir, false);
            if (next != null) {
                tn = TestResultTable.findNode(next, TestResultTable.behead(path));
            }
        }
        return tn;
    }

    public synchronized void addObserver(Observer o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.observers = (Observer[])DynamicArray.append(this.observers, o);
    }

    public synchronized void removeObserver(Observer o) {
        this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, o);
    }

    public void addObserver(TreeObserver obs) {
        this.treeObservers = (TreeObserver[])DynamicArray.append(this.treeObservers, obs);
    }

    public void removeObserver(TreeObserver obs) {
        if (this.treeObservers != null) {
            this.treeObservers = (TreeObserver[])DynamicArray.remove((Object[])this.treeObservers, obs);
        }
    }

    public synchronized TestResult resetTest(TestResult tr) {
        TestResult newTest = null;
        this.workDir.log(i18n, "trt.rstTest", tr.getTestName());
        TreeNode[] location = TestResultTable.getObjectPath(tr);
        if (location == null) {
            newTest = this.lookup(tr.getWorkRelativePath());
            if (debug > 0) {
                Debug.println("Recovered test by replacement (1). " + newTest);
            }
        } else {
            TRT_TreeNode targetNode = (TRT_TreeNode)location[location.length - 1];
            int index = targetNode.getIndex(tr, false);
            if (index >= 0) {
                newTest = targetNode.resetTest(index, tr);
                if (newTest == null && debug > 0) {
                    Debug.println("reset of test " + tr.getTestName() + " failed.");
                } else {
                    if (this.trCache != null) {
                        this.testsInUpdate.add(newTest);
                        this.trCache.insert(newTest);
                        this.testsInUpdate.remove(newTest);
                    }
                    this.notifyRemoveLeaf(location, tr, index);
                    this.notifyNewLeaf(location, newTest, index);
                }
            } else {
                newTest = this.lookup(tr.getWorkRelativePath());
                if (debug > 0) {
                    Debug.println("Recovered test by replacement (2). " + newTest);
                }
            }
        }
        return newTest;
    }

    public synchronized TestResult resetTest(String testName) {
        TestResult tr = TestResultTable.findTest(this.root, TestResult.getWorkRelativePath(testName), testName);
        if (tr == null) {
            return null;
        }
        return this.resetTest(tr);
    }

    public synchronized boolean refreshIfNeeded(String test) throws Fault {
        TestResult tr = this.lookup(TestResult.getWorkRelativePath(test));
        if (tr == null) {
            throw new Fault(i18n, "trt.refreshNoTest", test);
        }
        TreeNode[] path = TestResultTable.getObjectPath(tr);
        if (path == null) {
            return false;
        }
        TRT_TreeNode tn = (TRT_TreeNode)path[path.length - 1];
        TestResult newTr = tn.refreshIfNeeded(tr);
        if (newTr != tr) {
            this.notifyChangeLeaf(TestResultTable.getObjectPath(tn), newTr, tn.getTestIndex(newTr, false), tr);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean refreshIfNeeded(TreeNode node) throws Fault {
        if (node.getEnclosingTable() != this) {
            throw new IllegalStateException("refresh requested for node not owned by this table");
        }
        this.notifyStartRefresh(node);
        try {
            boolean bl = this.recursiveRefresh((TRT_TreeNode)node);
            return bl;
        }
        finally {
            this.notifyFinishRefresh(node);
        }
    }

    public synchronized boolean prune() throws Fault {
        if (this.root == null) {
            return false;
        }
        boolean changes = false;
        this.root.scanIfNeeded();
        TreeNode[] nodes = this.root.getTreeNodes();
        if (nodes == null) {
            return changes;
        }
        for (int i = 0; i < nodes.length; ++i) {
            changes = changes || this.prune(nodes[i]);
        }
        return changes;
    }

    public synchronized boolean prune(TreeNode node) throws Fault {
        TRT_TreeNode parent = (TRT_TreeNode)node.getParent();
        if (node.getChildCount() == 0) {
            int index = parent.rmChild((TRT_TreeNode)node);
            if (index != -1) {
                this.notifyRemoveLeaf(TestResultTable.getObjectPath(parent), node, index);
            }
            return index != -1;
        }
        TreeNode[] nodes = node.getTreeNodes();
        if (nodes == null) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            this.prune(nodes[i]);
        }
        if (node.getChildCount() == 0) {
            int index = parent.rmChild((TRT_TreeNode)node);
            if (index != -1) {
                this.notifyRemoveLeaf(TestResultTable.getObjectPath(parent), node, index);
            }
            return index != -1;
        }
        return false;
    }

    void suppressFinderScan(boolean state) {
        TestSuite ts;
        this.suppressFinderScan = !state ? false : (this.workDir != null ? ((ts = this.workDir.getTestSuite()) != null && (ts.getTestRefreshBehavior(0) || ts.getTestRefreshBehavior(1) || ts.getTestRefreshBehavior(2)) ? false : state) : state);
    }

    boolean isFinderScanSuppressed() {
        return this.suppressFinderScan;
    }

    boolean isBranchFile(File f) {
        return this.finder.isFolder(f);
    }

    long getLastModifiedTime(File f) {
        return this.finder.lastModified(f);
    }

    private String[] sortByName(String[] in) {
        if (in == null || in.length <= 1) {
            return in;
        }
        Comparator c = this.finder.getComparator();
        if (c == null) {
            c = Collator.getInstance(Locale.US);
            ((Collator)c).setStrength(0);
        }
        DisassembledUrl[] elements = new DisassembledUrl[in.length];
        for (int i = 0; i < in.length; ++i) {
            elements[i] = new DisassembledUrl(in[i]);
        }
        Arrays.sort(elements, new SortingComparator(c));
        String[] result = new String[elements.length];
        int i = 0;
        for (DisassembledUrl s : elements) {
            result[i++] = s.initStr;
        }
        return result;
    }

    private int compareStringArrays(Comparator c, String[] s1, String[] s2) {
        for (int i = 0; i < s1.length; ++i) {
            if (i >= s2.length) {
                return 1;
            }
            int comp = c.compare(s1[i], s2[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public static String[] distillUrls(String[] urls) {
        if (urls == null || urls.length <= 1) {
            return urls;
        }
        LinkedList<String> result = new LinkedList<String>();
        result.add(urls[0]);
        String prev = urls[0];
        if (prev.contains("#")) {
            prev = "//##//";
        }
        for (int i = 1; i < urls.length; ++i) {
            if (TestResultTable.isPartOf(urls[i], prev)) continue;
            if (!urls[i].contains("#")) {
                prev = urls[i];
            }
            result.add(urls[i]);
        }
        if (result.size() == urls.length) {
            return urls;
        }
        String[] s = new String[result.size()];
        return result.toArray(s);
    }

    private static boolean isPartOf(String part, String of) {
        if (part.length() <= of.length()) {
            return false;
        }
        return part.startsWith(of) && (part.charAt(of.length()) == '#' || part.charAt(of.length()) == '/');
    }

    private String[] removeMissing(String[] removeFrom, String[] missingIn) {
        String[] result = new String[missingIn.length];
        int i = 0;
        block0: for (String path : removeFrom) {
            for (String url : missingIn) {
                if (path != url) continue;
                result[i++] = path;
                continue block0;
            }
        }
        return result;
    }

    private synchronized void updateFromCache(Map m) {
        this.updateInProgress = true;
        this.cachedResults = m;
        if (this.rtc.getRequests() != null) {
            for (TestDescription td : this.rtc.getRequests()) {
                String testRes = TestResult.getWorkRelativePath(td.getRootRelativeURL());
                TestResult tr = (TestResult)m.get(testRes);
                if (tr == null) continue;
                tr.setTestDescription(td);
                this.update(tr, this.suppressFinderScan);
            }
        }
        this.rtc.clear();
        if (!this.cacheInitialized) {
            this.cacheInitialized = true;
        }
        this.updateInProgress = false;
        this.notifyAll();
    }

    synchronized TestResult insert(TRT_TreeNode node, String path, TestResult tr, TRT_TreeNode[] rec) {
        return this.insert(node, path, tr, rec, false);
    }

    synchronized TestResult insert(TRT_TreeNode node, String path, TestResult tr, TRT_TreeNode[] rec, boolean suppressScan) {
        String newPath;
        if (debug > 9) {
            Debug.println("TRT Beginning insert " + path);
        }
        if (path == (newPath = TestResultTable.behead(path))) {
            TestResult oldTR = node.addChild(tr, suppressScan, !this.cacheInitialized);
            rec = (TRT_TreeNode[])DynamicArray.append(rec, node);
            int index = node.getIndex(tr, suppressScan);
            if (oldTR == null) {
                if (debug > 10) {
                    Debug.println("   => Inserted TR: " + tr.getTestName());
                    Debug.println("   => Test Ref: " + tr);
                    Debug.println("   => Status is: " + Status.typeToString(tr.getStatus().getType()));
                    Debug.println("   => TRT: " + this);
                    Debug.println("   => Node Ref: " + node);
                    Debug.println("   => Node path: " + TestResultTable.getRootRelativePath(node));
                    Debug.println("   => Index in node: " + node.getIndex(tr, suppressScan));
                }
                if (index != -1) {
                    this.notifyNewLeaf(rec, tr, node.getIndex(tr, suppressScan));
                }
            } else if (oldTR == tr) {
                if (debug > 10) {
                    Debug.println("   => Ignored new TR: " + tr.getTestName());
                    Debug.println("   => Test Ref: " + tr);
                    Debug.println("   => Status is: " + Status.typeToString(tr.getStatus().getType()));
                    Debug.println("   => RESETTING IT! " + this.updateInProgress);
                }
                if (this.updateInProgress) {
                    this.resetTest(tr.getTestName());
                }
            } else {
                if (debug > 10) {
                    Debug.println("   => Updated TR: " + tr.getTestName());
                    Debug.println("   => Test Ref: " + tr);
                    Debug.println("   => Status is: " + Status.typeToString(tr.getStatus().getType()));
                    Debug.println("   => TRT: " + this);
                    Debug.println("   => Node Ref: " + node);
                    Debug.println("   => Node path: " + TestResultTable.getRootRelativePath(node));
                    Debug.println("   => Index in node: " + index);
                }
                if (index != -1) {
                    if (oldTR != null && oldTR != tr) {
                        if (tr.isShrunk()) {
                            try {
                                TestDescription desc = oldTR.getDescription();
                                if (desc != null) {
                                    tr.setTestDescription(desc);
                                }
                            }
                            catch (TestResult.Fault f) {
                                // empty catch block
                            }
                        }
                        this.notifyRemoveLeaf((TreeNode[])rec, oldTR, index);
                        this.notifyNewLeaf(rec, tr, index);
                    } else {
                        this.notifyChangeLeaf(rec, tr, index, oldTR);
                    }
                }
            }
            return oldTR;
        }
        String nextDir = TestResultTable.getDirName(path);
        TRT_TreeNode next = node.getTreeNode(nextDir, suppressScan);
        if (next == null) {
            TRT_TreeNode tn = new TRT_TreeNode(this, node);
            tn.setName(TestResultTable.getDirName(nextDir));
            node.addChild(tn, suppressScan);
            rec = (TRT_TreeNode[])DynamicArray.append(rec, tn);
            this.notifyNewBranch(rec, tn, node.getIndex(tn, suppressScan));
            return this.insert(tn, newPath, tr, rec, suppressScan);
        }
        rec = (TRT_TreeNode[])DynamicArray.append(rec, node);
        return this.insert(next, newPath, tr, rec, suppressScan);
    }

    private boolean recursiveRefresh(TRT_TreeNode node) {
        boolean result = node.refreshIfNeeded();
        TreeNode[] children = node.getTreeNodes();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                result |= this.recursiveRefresh((TRT_TreeNode)children[i]);
            }
        }
        return result;
    }

    void notifyNewBranch(TreeNode[] where, TreeNode what, int index) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            this.treeObservers[i].nodeInserted(where, what, index);
        }
    }

    void notifyNewLeaf(TreeNode[] where, TestResult what, int index) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            this.treeObservers[i].nodeInserted(where, what, index);
        }
    }

    private void notifyChangeLeaf(TreeNode[] where, TestResult what, int index, TestResult old) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            this.treeObservers[i].nodeChanged(where, what, index, old);
        }
    }

    void notifyRemoveLeaf(TreeNode[] where, TestResult what, int index) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            this.treeObservers[i].nodeRemoved(where, what, index);
        }
    }

    void notifyRemoveLeaf(TreeNode[] where, TreeNode what, int index) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            this.treeObservers[i].nodeRemoved(where, what, index);
        }
    }

    void notifyStartRefresh(TreeNode origin) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            if (!(this.treeObservers[i] instanceof TreeEventObserver)) continue;
            ((TreeEventObserver)this.treeObservers[i]).startRefresh(origin);
        }
    }

    void notifyFinishRefresh(TreeNode origin) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            if (!(this.treeObservers[i] instanceof TreeEventObserver)) continue;
            ((TreeEventObserver)this.treeObservers[i]).finishRefresh(origin);
        }
    }

    private String[] preProcessInitFiles(File[] tests) throws Fault {
        if (tests == null || tests.length == 0) {
            if (debug > 1) {
                Debug.println("Initial files set empty.");
            }
            return null;
        }
        if (debug > 1) {
            Debug.println("Initial files: ");
            for (int i = 0; i < tests.length; ++i) {
                Debug.println("  + " + tests[i].getPath());
            }
        }
        String[] files = new String[tests.length];
        int filesLen = files.length;
        int distToDel = this.getWorkDir() == null ? 0 : this.finder.getRootDir().getAbsolutePath().length() + 1;
        for (int i = 0; i < tests.length; ++i) {
            if (debug > 1) {
                Debug.println(" *** init url resolve begin ***");
            }
            String relativeURL = null;
            if (this.finder.getRootDir().equals(tests[i])) {
                --filesLen;
                if (debug <= 1) continue;
                Debug.println("An initial URL equals testsuite root, ignoring it.");
                continue;
            }
            if (tests[i].isAbsolute()) {
                String thisInitPath;
                String rrp = TestResultTable.getRootRelativePath(this.getRoot());
                if (debug > 1) {
                    Debug.println("  -> Initial URL is absolute, stripping from " + tests[i].getPath());
                    Debug.println("  -> Stripping: " + this.finder.getRootDir());
                    Debug.println("  -> removing rrp: " + rrp);
                }
                if (!(thisInitPath = tests[i].getPath()).startsWith(this.finder.getRootDir().getPath())) {
                    throw new Fault(i18n, "trt.badInitFile", thisInitPath);
                }
                String platformPath = thisInitPath.substring(distToDel += rrp == null || rrp.length() == 0 ? 0 : rrp.length() + 1);
                relativeURL = platformPath.replace(File.separatorChar, '/');
            } else {
                relativeURL = tests[i].getPath().replace(File.separatorChar, '/');
            }
            files[i] = relativeURL;
        }
        if (filesLen != tests.length) {
            String[] newFiles = new String[filesLen];
            System.arraycopy(files, 0, newFiles, 0, filesLen);
            files = newFiles;
        }
        if (debug > 1) {
            Debug.println("*** finished preprocessing of init urls ***");
        }
        return files;
    }

    private static TestResult findTest(TreeNode where, String fullPath, String path) {
        ((TRT_TreeNode)where).scanIfNeeded();
        if (debug == 2 || debug == 99) {
            Debug.println("TRT looking for " + path + " IN " + where.getName());
        }
        String dir = TestResultTable.getDirName(path);
        TestResult tr = null;
        if (dir == path) {
            int location;
            if (debug == 2 || debug == 99) {
                Debug.println("    -> Looking for TR in this node.");
            }
            if ((location = ((TRT_TreeNode)where).getResultIndex(fullPath, false)) != -1) {
                tr = (TestResult)where.getChild(location);
                if (debug == 2 || debug == 99) {
                    Debug.println("    -> TRT.findTest() located " + tr);
                    Debug.println("");
                }
            } else if (debug == 2 || debug == 99) {
                Debug.println("    -> TRT.findTest(): unable to find node " + fullPath);
                Debug.println("");
            }
        } else {
            TRT_TreeNode tn;
            if (debug == 2 || debug == 99) {
                Debug.println("    -> Looking for branch name: " + dir);
            }
            if ((tn = ((TRT_TreeNode)where).getTreeNode(dir, false)) != null) {
                tr = TestResultTable.findTest(tn, fullPath, TestResultTable.behead(path));
            } else if (debug == 2 || debug == 99) {
                Debug.println("TRT.findTest(): unable to find node " + fullPath);
            }
        }
        return tr;
    }

    private static Object lookupNode(TreeNode where, String url) {
        TreeNode tn = TestResultTable.findNode(where, url);
        if (tn != null) {
            return tn;
        }
        String jtrPath = TestResult.getWorkRelativePath(url);
        TestResult tr = TestResultTable.findTest((TRT_TreeNode)where, jtrPath, jtrPath);
        return tr;
    }

    private static Object[] lookupInitURL(TreeNode where, String url) {
        TreeNode tn;
        Object simple;
        if (where == null || url == null) {
            throw new IllegalArgumentException("Starting node or URL may not be null!");
        }
        if (debug == 2 || debug == 99) {
            Debug.println("Starting iurl lookup on " + url + " in " + where.getName());
        }
        if ((simple = TestResultTable.lookupNode(where, url)) != null) {
            if (debug == 2 || debug == 99 && simple instanceof TreeNode) {
                Debug.println("  -> simple match found " + TestResultTable.getRootRelativePath((TreeNode)simple));
            }
            if (simple instanceof TestResult) {
                return new TestResult[]{(TestResult)simple};
            }
            return new TreeNode[]{(TreeNode)simple};
        }
        if (debug == 2 || debug == 99) {
            Debug.println("TRT looking for tests beginning with " + url + " IN " + where.getName());
            Debug.println("   -> retrieving possible TRs from " + TestResultTable.betail(url));
        }
        if ((tn = TestResultTable.findNode(where, TestResultTable.betail(url))) == null) {
            if (debug == 2 || debug == 99) {
                Debug.println("   -> No parent node found!");
            }
            return null;
        }
        Object[] trs = tn.getTestResults();
        if (trs == null || trs.length == 0) {
            return null;
        }
        Vector<Object> v = new Vector<Object>();
        try {
            for (int i = 0; i < trs.length; ++i) {
                if (!trs[i].getDescription().getRootRelativeURL().startsWith(url)) continue;
                v.addElement(trs[i]);
            }
        }
        catch (TestResult.Fault f) {
            throw new JavaTestError(i18n, "trt.trNoTd", f);
        }
        if (v.size() > 0) {
            trs = new TestResult[v.size()];
            v.copyInto(trs);
        } else {
            trs = null;
        }
        return trs;
    }

    private void initFinder() {
        this.suiteRoot = this.finder.getRoot();
    }

    void awakeCache() {
        if (this.trCache == null || !this.trCache.workerAlive()) {
            try {
                this.trCache = new TestResultCache(this.workDir, this.updater);
            }
            catch (IOException e) {
                this.updater.error(e);
            }
        }
    }

    private boolean needsCacheCompress() {
        return this.trCache.needsCompress();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        RootRegistry.getInstance().removeHandler(this.httpHandle);
        RootRegistry.unassociateObject(this, this.httpHandle);
        this.httpHandle = null;
    }

    private synchronized void setUpdateInProgress(boolean b) {
        this.updateInProgress = b;
        this.notifyAll();
    }

    public TestResult getCachedResult(TestDescription td) {
        if (this.cachedResults != null) {
            String url = TestResult.getWorkRelativePath(td.getRootRelativeURL());
            TestResult res = this.cachedResults.get(url);
            if (res != null) {
                res.setTestDescription(td);
            }
            return res;
        }
        this.rtc.addToUpdateFromCache(td);
        return null;
    }

    static String behead(String path) {
        int index = path.indexOf("/");
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    static String getDirName(String path) {
        int index = path.indexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    static String betail(String path) {
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    static boolean arrayContains(Object[] arr, Object o) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != o) continue;
            return true;
        }
        return false;
    }

    public ReentrantLock getLock() {
        return this.processLock;
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(TestResultTable.class);
        notYetRun = Status.notRun("test is awaiting execution");
        debug = Debug.getInt(TestResultTable.class);
    }

    public class PathRecord {
        private TreeNode[] nodes;
        private int[] inds;
        private TestResult tr;

        PathRecord() {
        }

        PathRecord(TestResult tr) {
            this.tr = tr;
        }

        PathRecord(TreeNode[] path, TestResult tr) {
            this.tr = tr;
            this.nodes = path;
        }

        PathRecord(TreeNode[] path, int[] inds) {
            this.nodes = path;
            this.inds = inds;
        }

        void setTestResult(TestResult tr) {
            this.tr = tr;
        }

        void addNode(TreeNode tn) {
            if (this.tr != null) {
                throw new JavaTestError(i18n, "trt.invalidPath");
            }
            this.nodes = (TreeNode[])DynamicArray.append(this.nodes, tn);
        }

        public int[] getIndicies() {
            if (this.inds == null) {
                this.inds = this.generateInds(this.tr);
            }
            return this.inds;
        }

        public TreeNode[] getNodes() {
            if (this.nodes == null) {
                this.nodes = this.generateNodes(this.tr);
            }
            return this.nodes;
        }

        public TreeNode[] generateNodes(TestResult tr) {
            if (tr == null) {
                return null;
            }
            TreeNode[] nodes = null;
            for (TreeNode node = tr.getParent(); node != null; node = node.getParent()) {
                nodes = (TreeNode[])DynamicArray.insert(nodes, node, 0);
            }
            return nodes;
        }

        private int[] generateInds(TestResult tr) {
            return null;
        }
    }

    class Updater
    implements TestResultCache.Observer {
        private int rebuildCount;

        Updater() {
        }

        public void update(Map tests) {
            TestResultTable.this.updateFromCache(tests);
        }

        public void waitingForLock(long timeSoFar) {
            int seconds = (int)(timeSoFar / 1000L);
            int minutes = seconds / 60;
            this.writeI18N("trt.waitingForLock", new Object[]{TestResultTable.this.workDir.getRoot(), new Integer(minutes), new Integer(seconds -= 60 * minutes)});
        }

        public void timeoutWaitingForLock() {
            this.writeI18N("trt.timeoutForLock", TestResultTable.this.workDir.getRoot());
        }

        public void acquiredLock() {
        }

        public void releasedLock() {
        }

        public void buildingCache(boolean reset) {
            this.rebuildCount = 0;
        }

        public void buildingCache(TestResult tr) {
            ++this.rebuildCount;
            if (this.rebuildCount == 100) {
                this.writeI18N("trt.rebuild");
            } else if (this.rebuildCount % 100 == 0) {
                System.err.println(".");
            }
        }

        public void builtCache() {
            if (this.rebuildCount > 0) {
                System.err.println();
            }
        }

        public void error(Throwable t) {
            this.writeI18N("trt.cacheError", t);
            t.printStackTrace();
        }

        private void writeI18N(String key) {
            System.err.println(i18n.getString(key));
        }

        private void writeI18N(String key, Object arg) {
            System.err.println(i18n.getString(key, arg));
        }

        private void writeI18N(String key, Object[] args) {
            System.err.println(i18n.getString(key, args));
        }
    }

    public static interface TreeIterator
    extends Enumeration,
    Iterator {
        public boolean hasMoreElements();

        public Object nextElement();

        public boolean hasNext();

        public Object next();

        public void remove();

        public int getRejectCount();

        public void setRecordRejects(boolean var1);

        public int[] getResultStats();

        public Hashtable getFilterStats();

        public TestFilter[] getFilters();

        public String[] getInitialURLs();

        public Object peek();

        public boolean isPending(TestResult var1);
    }

    private static class NullEnum
    extends TRT_Iterator {
        private static NullEnum instance;

        private NullEnum() {
        }

        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            return this.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from TestResultTable thhrough iterator.  Do not call this method.");
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException(i18n.getString("trt.noElements"));
        }

        public static NullEnum getInstance() {
            if (instance == null) {
                instance = new NullEnum();
            }
            return instance;
        }
    }

    public static interface TreeNode {
        public void addObserver(TreeNodeObserver var1);

        public void removeObserver(TreeNodeObserver var1);

        public int getSize();

        public TreeNode getParent();

        public boolean isRoot();

        public TestResultTable getEnclosingTable();

        public boolean isUpToDate();

        public int getChildCount();

        public Object getChild(int var1);

        public TestResult[] getTestResults();

        public TreeNode[] getTreeNodes();

        public String getName();

        public boolean isLeaf(int var1);

        public int[] getChildStatus();

        public int getIndex(Object var1);

        public TestResult matchTest(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestsToCache {
        private HashSet<TestDescription> needUpdateFromCache;

        private RequestsToCache() {
        }

        public synchronized void addToUpdateFromCache(TestDescription td) {
            if (this.needUpdateFromCache == null) {
                this.needUpdateFromCache = new HashSet();
            }
            this.needUpdateFromCache.add(td);
        }

        public HashSet<TestDescription> getRequests() {
            return this.needUpdateFromCache;
        }

        public synchronized void clear() {
            this.needUpdateFromCache = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortingComparator
    implements Comparator<DisassembledUrl> {
        Comparator<Object> c;

        public SortingComparator(Comparator c) {
            this.c = c;
        }

        @Override
        public int compare(DisassembledUrl o1, DisassembledUrl o2) {
            String[] s1 = o1.data;
            String[] s2 = o2.data;
            for (int i = 0; i < s1.length; ++i) {
                if (i >= s2.length) {
                    return 1;
                }
                int comp = this.c.compare(s1[i], s2[i]);
                if (comp == 0) continue;
                return comp;
            }
            if (s2.length > s1.length) {
                return -1;
            }
            return 0;
        }
    }

    private class DisassembledUrl {
        private String[] data;
        private String initStr;

        public DisassembledUrl(String str) {
            this.data = StringArray.splitList(str, "/");
            this.initStr = str;
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }
    }

    public static interface TreeNodeObserver {
        public void insertedBranch(TreeNode var1, TreeNode var2, int var3);

        public void insertedResult(TreeNode var1, TestResult var2, int var3);

        public void replacedResult(TreeNode var1, TestResult var2, TestResult var3, int var4);

        public void removedBranch(TreeNode var1, int var2);

        public void removedResult(TreeNode var1, TestResult var2, int var3);

        public void countersInvalidated(TreeNode var1);
    }

    public static interface TreeEventObserver
    extends TreeObserver {
        public void startRefresh(TreeNode var1);

        public void finishRefresh(TreeNode var1);
    }

    public static interface TreeObserver {
        public void nodeInserted(TreeNode[] var1, Object var2, int var3);

        public void nodeChanged(TreeNode[] var1, Object var2, int var3, Object var4);

        public void nodeRemoved(TreeNode[] var1, Object var2, int var3);
    }

    public static interface Observer {
        public void update(TestResult var1, TestResult var2);

        public void updated(TestResult var1);
    }
}

