/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.TestSuite;
import com.sun.javatest.services.LocalConnector;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceProperties;
import com.sun.javatest.services.ServiceReader;
import com.sun.javatest.services.TestPath;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyServiceReader
implements ServiceReader {
    private File propFile;
    private Properties props;
    private TestSuite ts;
    public static final String PROPERTY_PREFIX = "property";
    public static final String SERVICE_PREFIX = "service";
    public static final String TESTPATH_PREFIX = "testpath";
    public static final String SERVICES_PROPERTIES = File.separator + "lib" + File.separator + "services.properties";

    @Override
    public void init(TestSuite ts, String[] args) {
        this.ts = ts;
        File tsRoot = ts.getRootDir();
        if (args == null || args.length == 0) {
            this.propFile = new File(tsRoot, SERVICES_PROPERTIES);
        } else {
            String path = args[0].replace("/", File.separator);
            this.propFile = new File(tsRoot, path);
        }
        this.props = new Properties();
        try {
            this.props.load(new FileReader(this.propFile));
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    Set<String> findIDs(Set<String> keys, String prefix) {
        int len = prefix.length() + 1;
        HashSet<String> set = new HashSet<String>();
        for (String key : keys) {
            int i;
            if (!key.startsWith(prefix) || (i = key.indexOf(".", len)) <= 0) continue;
            set.add(key.substring(len, i));
        }
        return set;
    }

    Set<String> findProps(Set<String> keys, String prefix) {
        int len = prefix.length() + 1;
        HashSet<String> set = new HashSet<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            set.add(key.substring(len));
        }
        return set;
    }

    @Override
    public Map<String, Service> readServices() {
        TreeMap<String, Service> result = new TreeMap<String, Service>();
        if (this.props == null) {
            return result;
        }
        ServiceProperties common = new ServiceProperties(null);
        Set<String> allKeys = this.props.stringPropertyNames();
        Set<String> propertyNames = this.findProps(allKeys, PROPERTY_PREFIX);
        for (String propName : propertyNames) {
            String propValue = this.props.getProperty("property." + propName);
            common.addProperty(propName, propValue);
        }
        Set<String> serviceIDs = this.findIDs(allKeys, SERVICE_PREFIX);
        for (String serviceID : serviceIDs) {
            String serviceClass = this.props.getProperty("service." + serviceID + ".class");
            String serviceDescr = this.props.getProperty("service." + serviceID + ".description");
            if (serviceClass == null) {
                throw new Error("No service classname is provided for " + serviceID + " in " + this.propFile);
            }
            try {
                Service service = (Service)this.ts.loadClass(serviceClass).newInstance();
                service.setId(serviceID);
                service.setDescription(serviceDescr);
                LocalConnector conn = new LocalConnector(service.getDefaultServiceExecutor());
                service.setConnector(conn);
                ServiceProperties servProps = new ServiceProperties(common);
                String argPrefix = "service." + serviceID + ".arg";
                Set<String> serviceArgsNames = this.findProps(allKeys, argPrefix);
                for (String argName : serviceArgsNames) {
                    String argValue = this.props.getProperty(argPrefix + "." + argName);
                    servProps.addProperty(argName, argValue);
                }
                service.setProperties(servProps);
                result.put(service.getId(), service);
            }
            catch (Exception ex) {
                throw new Error("Failed to start services", ex);
            }
        }
        return result;
    }

    @Override
    public Set<TestPath> readTestServiceMap() {
        HashSet<TestPath> result = new HashSet<TestPath>();
        if (this.props == null) {
            return result;
        }
        Set<String> allKeys = this.props.stringPropertyNames();
        Set<String> testpathIDs = this.findIDs(allKeys, TESTPATH_PREFIX);
        for (String tpID : testpathIDs) {
            String[] refIDs;
            String path = this.props.getProperty("testpath." + tpID + ".path");
            String matcher = this.props.getProperty("testpath." + tpID + ".matcher");
            String ids = this.props.getProperty("testpath." + tpID + ".ids");
            TestPath tPath = new TestPath(this.ts, path, matcher);
            for (String refID : refIDs = ids.split(" ")) {
                tPath.addService(refID);
            }
            result.add(tPath);
        }
        return result;
    }

    @Override
    public String getServiceDescriptorFileName() {
        return SERVICES_PROPERTIES;
    }
}

