/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.Harness;
import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.batch.BatchManager;
import com.sun.javatest.report.ReportManager;
import com.sun.javatest.services.ServiceManager;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.CommandParser;
import com.sun.javatest.tool.ConfigManager;
import com.sun.javatest.tool.EnvironmentManager;
import com.sun.javatest.tool.HttpManager;
import com.sun.javatest.tool.LogManager;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.Vector;

public class Main {
    private CommandManager[] commandManagers;
    private MiniHelpManager helpManager;
    private static boolean initialized = false;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);
    private static final int RC_OK = 0;
    private static final int RC_BATCH_TESTS_FAILED = 1;
    private static final int RC_BATCH_TESTS_ERROR = 2;
    private static final int RC_USER_ERROR = 3;
    private static final int RC_INTERNAL_ERROR = 4;

    public final void run(String[] args, CommandContext ctx) throws Command.Fault, CommandContext.Fault, CommandParser.Fault {
        if (this.commandManagers == null) {
            this.helpManager = new MiniHelpManager();
            this.commandManagers = new CommandManager[]{new BatchManager(), new ReportManager(), new ConfigManager(), new EnvironmentManager(), new HttpManager(), new LogManager(), new ServiceManager.ServiceCommandManager(), this.helpManager};
            this.helpManager.setCommandManagers(this.commandManagers);
        }
        CommandParser p = new CommandParser(this.commandManagers);
        boolean urlEncoded = Boolean.getBoolean("javatest.command.urlEncoded");
        p.parse(args, urlEncoded, ctx);
        if (!initialized) {
            File classDir = ProductInfo.getJavaTestClassDir();
            Harness.setClassDir(classDir);
            JavaTestSecurityManager.install();
            initialized = true;
        }
        Command[] cmds = ctx.getCommands();
        boolean helpInfoRequired = this.helpManager.isInfoRequired();
        if (helpInfoRequired) {
            this.helpManager.showRequiredInfo(ctx.getLogWriter(), ctx);
            if (cmds.length == 0) {
                return;
            }
        }
        ctx.runCommands();
        ctx.dispose();
    }

    public static void main(String[] args) {
        Main.checkJavaVersion();
        Main.mainMini(args);
    }

    static void checkJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null) {
            String[] oldVersions = new String[]{"1.0", "1.1", "1.2", "1.3", "1.4", "1.5"};
            for (int i = 0; i < oldVersions.length; ++i) {
                if (!javaVersion.startsWith(oldVersions[i])) continue;
                System.err.println("Please use Java(TM) Standard Edition, Version 6.0 or better to run the JT Harness(TM) harness.");
                System.exit(1);
            }
        }
    }

    private static void mainMini(String[] args) {
        PrintWriter out = new PrintWriter(System.err){

            @Override
            public void close() {
                this.flush();
            }
        };
        try {
            ExitCount.inc();
            Main m = new Main();
            CommandContext ctx = new CommandContext(out);
            if (args.length == 0) {
                args = new String[]{"-version", "-help"};
            }
            m.run(args, ctx);
            out.flush();
            int[] stats = ctx.getTestStats();
            int rc = stats[2] > 0 ? 2 : (stats[1] > 0 ? 1 : 0);
            ExitCount.dec(true, rc);
            out.flush();
        }
        catch (Command.Fault e) {
            out.println("+ " + e.getCommand().toString());
            out.println(e.getMessage());
            out.flush();
            Main.exit(3);
        }
        catch (CommandContext.Fault e) {
            CommandContext ctx;
            boolean verboseCommands;
            Throwable t = e.getCause();
            if (t instanceof Command.Fault && !(verboseCommands = (ctx = e.getContext()).getVerboseOptionValue("commands"))) {
                Command.Fault ce = (Command.Fault)t;
                Command c = ce.getCommand();
                out.println("+ " + c.toString());
            }
            out.println(e.getMessage());
            out.flush();
            Main.exit(3);
        }
        catch (CommandParser.Fault e) {
            Throwable t = e.getCause();
            if (t instanceof Command.Fault) {
                Command.Fault ce = (Command.Fault)t;
                Command c = ce.getCommand();
                out.println("+ " + c.toString());
            }
            out.println(e.getMessage());
            out.flush();
            Main.exit(3);
        }
        catch (Error e) {
            e.printStackTrace(out);
            out.flush();
            Main.exit(4);
        }
        catch (RuntimeException e) {
            e.printStackTrace(out);
            out.flush();
            Main.exit(4);
        }
    }

    private static void exit(int exitCode) {
        SecurityManager sc = System.getSecurityManager();
        if (sc instanceof JavaTestSecurityManager) {
            ((JavaTestSecurityManager)sc).setAllowExit(true);
        }
        System.exit(exitCode);
    }

    public static class MiniHelpManager
    extends CommandManager {
        private CommandManager[] commandManagers;
        private boolean commandLineHelpFlag;
        private String[] commandLineHelpQuery;
        private boolean versionFlag;

        public MiniHelpManager() {
        }

        public MiniHelpManager(CommandManager[] commandManagers) {
            this.setCommandManagers(commandManagers);
        }

        @Override
        public HelpTree.Node getHelp() {
            String[] helpOptions = new String[]{"help", "usage", "version"};
            return new HelpTree.Node(i18n, "help.cmd.opts", helpOptions);
        }

        @Override
        public boolean parseCommand(String cmd, ListIterator argIter, CommandContext ctx) {
            if (cmd.equalsIgnoreCase("help") || cmd.equalsIgnoreCase("usage") || cmd.equalsIgnoreCase("?")) {
                Vector<String> v = new Vector<String>();
                while (argIter.hasNext()) {
                    v.add(((String)argIter.next()).toLowerCase());
                }
                this.commandLineHelpFlag = true;
                this.commandLineHelpQuery = v.toArray(new String[v.size()]);
                return true;
            }
            if (cmd.equalsIgnoreCase("version")) {
                this.versionFlag = true;
                return true;
            }
            return false;
        }

        public void setCommandManagers(CommandManager[] commandManagers) {
            this.commandManagers = commandManagers;
        }

        boolean isInfoRequired() {
            return this.versionFlag || this.commandLineHelpFlag;
        }

        void showRequiredInfo(PrintWriter out, CommandContext ctx) {
            if (this.versionFlag) {
                this.showVersion(out);
            }
            if (this.commandLineHelpFlag) {
                this.showCommandLineHelp(out);
            }
        }

        void showCommandLineHelp(PrintWriter out) {
            Integer descIndent;
            HelpTree commandHelpTree = new HelpTree();
            Integer nodeIndent = Integer.getInteger("javatest.help.nodeIndent");
            if (nodeIndent != null) {
                commandHelpTree.setNodeIndent(nodeIndent);
            }
            if ((descIndent = Integer.getInteger("javatest.help.descIndent")) != null) {
                commandHelpTree.setDescriptionIndent(descIndent);
            }
            TreeMap<String, HelpTree.Node> tm = new TreeMap<String, HelpTree.Node>();
            for (int i = 0; i < this.commandManagers.length; ++i) {
                HelpTree.Node n = this.commandManagers[i].getHelp();
                tm.put(n.getName(), n);
            }
            Iterator iter = tm.values().iterator();
            while (iter.hasNext()) {
                commandHelpTree.addNode((HelpTree.Node)iter.next());
            }
            String[] fileTypes = new String[]{"ts", "wd", "jti"};
            HelpTree.Node filesNode = new HelpTree.Node(i18n, "help.cmd.files", fileTypes);
            commandHelpTree.addNode(filesNode);
            String[] syntaxTypes = new String[]{"opts", "string", "atfile", "readfile", "encode"};
            HelpTree.Node syntaxNode = new HelpTree.Node(i18n, "help.cmd.syntax", syntaxTypes);
            commandHelpTree.addNode(syntaxNode);
            String progName = System.getProperty("program", "java " + Main.class.getName());
            try {
                WrapWriter ww = new WrapWriter(out);
                if (this.commandLineHelpQuery == null || this.commandLineHelpQuery.length == 0) {
                    ww.write(i18n.getString("help.cmd.proto", progName));
                    ww.write("\n\n");
                    ww.write(i18n.getString("help.cmd.introHead"));
                    ww.write('\n');
                    commandHelpTree.writeSummary(ww);
                } else if (Arrays.asList(this.commandLineHelpQuery).contains("all")) {
                    ww.write(i18n.getString("help.cmd.proto", progName));
                    ww.write("\n\n");
                    ww.write(i18n.getString("help.cmd.fullHead"));
                    ww.write('\n');
                    commandHelpTree.write(ww);
                } else {
                    HelpTree.Selection s = commandHelpTree.find(this.commandLineHelpQuery);
                    if (s != null) {
                        commandHelpTree.write((Writer)ww, s);
                    } else {
                        ww.write(i18n.getString("help.cmd.noEntriesFound"));
                        ww.write("\n\n");
                        ww.write(i18n.getString("help.cmd.summaryHead"));
                        ww.write('\n');
                        commandHelpTree.writeSummary(ww);
                    }
                }
                ww.write('\n');
                ww.write(i18n.getString("help.cmd.tail"));
                ww.write("\n\n");
                ww.write(i18n.getString("help.copyright.txt"));
                ww.write("\n\n");
                ww.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        void showVersion(PrintWriter out) {
            File classDir = Harness.getClassDir();
            String classDirPath = classDir == null ? i18n.getString("help.version.unknown") : classDir.getPath();
            DateFormat df = DateFormat.getDateInstance(1);
            Object[] versionArgs = new Object[]{ProductInfo.getName(), ProductInfo.getVersion(), ProductInfo.getMilestone(), ProductInfo.getBuildNumber(), this.getHarnessType(), classDirPath, System.getProperty("java.version"), System.getProperty("java.home"), ProductInfo.getBuildJavaVersion(), df.format(ProductInfo.getBuildDate())};
            out.println(i18n.getString("help.version.txt", versionArgs));
            out.println(i18n.getString("help.copyright.txt"));
        }

        String getHarnessType() {
            return i18n.getString("help.harnessType.lite.txt");
        }
    }
}

