/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.KnownFailuresList;
import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KflSorter {
    protected TreeSet<TestDiff> fail2pass;
    protected TreeSet<TestDiff> fail2error;
    protected TreeSet<TestDiff> fail2notrun;
    protected TreeSet<TestDiff> missing;
    protected TreeSet<TestDiff> newFailures;
    protected TreeSet<TestDiff> otherErrors;
    protected TreeSet<TestDiff> fail2fail;
    protected TreeSet<TestDiff> tc_missing;
    protected TreeSet<TestDiff> tc_fail2pass;
    protected TreeSet<TestDiff> tc_fail2error;
    protected TreeSet<TestDiff> tc_fail2notrun;
    protected TreeSet<TestDiff> tc_newFailures;
    protected KnownFailuresList kfl;
    protected TestResultTable trt;
    protected int errorCount;
    protected int tcErrorCount;
    private boolean enableTestCases;
    private boolean processF2f;
    private boolean processF2e;
    private boolean processMissing = true;
    protected static final Pattern testCasePattern = Pattern.compile("^(.*): (Passed\\.|Failed\\.|Error\\.|Not\\ run\\.)(.*)");

    KflSorter(KnownFailuresList kfl, TestResultTable trt, boolean testcases) {
        this.kfl = kfl;
        this.trt = trt;
        this.missing = new TreeSet();
        this.newFailures = new TreeSet();
        this.otherErrors = new TreeSet();
        this.fail2notrun = new TreeSet();
        this.fail2error = new TreeSet();
        this.fail2pass = new TreeSet();
        this.fail2fail = new TreeSet();
        this.tc_missing = new TreeSet();
        this.tc_fail2pass = new TreeSet();
        this.tc_fail2error = new TreeSet();
        this.tc_fail2notrun = new TreeSet();
        this.tc_newFailures = new TreeSet();
        this.enableTestCases = testcases;
    }

    KnownFailuresList getKfl() {
        return this.kfl;
    }

    synchronized void setF2eEnabled(boolean state) {
        this.processF2e = state;
    }

    synchronized void setF2fEnabled(boolean state) {
        this.processF2f = state;
    }

    synchronized void setMissingEnabled(boolean state) {
        this.processMissing = state;
    }

    synchronized int run(TestResultTable.TreeIterator iter) {
        TreeSet[] lists = new TreeSet[4];
        int totalFound = 0;
        while (iter.hasNext()) {
            TestResult tr = (TestResult)iter.next();
            Status s = tr.getStatus();
            TreeSet list = lists[s == null ? 3 : s.getType()];
            list.add(tr);
            ++totalFound;
        }
        return this.run(lists);
    }

    synchronized int run(TreeSet[] tests) {
        KnownFailuresList.Entry[] entries;
        TestDiff diff;
        TestResult tr;
        Iterator<KnownFailuresList.Entry> it = this.kfl.getIterator(false);
        int probs = 0;
        int tcprobs = 0;
        while (it.hasNext()) {
            KnownFailuresList.Entry entry = it.next();
            String url = entry.getRelativeURL();
            tr = this.trt.lookup(TestResult.getWorkRelativePath(url));
            if (tr == null) {
                if (!this.processMissing) continue;
                if (this.missing.add(new TestDiff(url, null, Transitions.FAIL2MISSING))) {
                    ++probs;
                }
                if (!this.enableTestCases) continue;
                tcprobs += this.addAllTestCases(entry, url, null, Transitions.TC_FAIL2MISSING, this.tc_missing);
                continue;
            }
            Map<String, Status> tcs = null;
            if (this.enableTestCases) {
                tcs = KflSorter.getTestCases(tr);
            }
            if (tr.getStatus().isPassed()) {
                diff = new TestDiff(url, tr, Transitions.FAIL2PASS);
                if (this.fail2pass.add(diff)) {
                    ++probs;
                }
                if (!this.enableTestCases) continue;
                tcprobs += this.addStatusTestCases(url, tr, 0, Transitions.TC_FAIL2PASS, tcs, this.tc_fail2pass);
                continue;
            }
            if (tr.getStatus().isError()) {
                if (!this.processF2e) continue;
                diff = new TestDiff(url, tr, Transitions.FAIL2ERROR);
                if (this.fail2error.add(diff)) {
                    ++probs;
                }
                if (!this.enableTestCases) continue;
                tcprobs += this.addStatusTestCases(url, tr, 2, Transitions.TC_FAIL2ERROR, tcs, this.tc_fail2error);
                continue;
            }
            if (tr.getStatus().isNotRun()) {
                diff = new TestDiff(url, tr, Transitions.FAIL2NOTRUN);
                if (this.fail2notrun.add(diff)) {
                    ++probs;
                }
                if (!this.enableTestCases) continue;
                tcprobs += this.addStatusTestCases(url, tr, 3, Transitions.TC_FAIL2NOTRUN, tcs, this.tc_fail2notrun);
                continue;
            }
            if (this.enableTestCases && !tr.getStatus().isFailed()) continue;
        }
        for (Object o : tests[1]) {
            Map<String, Status> tcs;
            tr = (TestResult)o;
            entries = this.kfl.find(tr.getTestName());
            if (entries == null || entries.length == 0) {
                diff = new TestDiff(tr.getTestName(), tr, Transitions.NEWFAILURES);
                if (this.newFailures.add(diff)) {
                    ++probs;
                }
            } else {
                if (!this.processF2f) continue;
                diff = new TestDiff(tr.getTestName(), tr, Transitions.FAIL2FAIL);
                this.fail2fail.add(diff);
            }
            if (!this.enableTestCases || (tcs = KflSorter.getTestCases(tr)) == null || tcs.isEmpty()) continue;
            KnownFailuresList.Entry[] full = this.kfl.find(tr.getTestName());
            boolean fullTestListed = full != null && !this.hasTestCases(full);
            block8: for (String name : tcs.keySet()) {
                KnownFailuresList.Entry e = this.kfl.find(tr.getTestName(), name);
                switch (tcs.get(name).getType()) {
                    case 1: {
                        if (fullTestListed || e != null) break;
                        TestDiff td = new TestDiff(tr.getTestName(), name, tr, Transitions.TC_NEWFAILURES);
                        if (!this.tc_newFailures.add(td)) continue block8;
                        ++tcprobs;
                        break;
                    }
                    case 0: {
                        if (!fullTestListed && e == null || !this.tc_fail2pass.add(new TestDiff(tr.getTestName(), name, tr, Transitions.TC_FAIL2PASS))) break;
                        ++tcprobs;
                        break;
                    }
                    case 2: {
                        if (!fullTestListed && e == null || !this.tc_fail2error.add(new TestDiff(tr.getTestName(), name, tr, Transitions.TC_FAIL2ERROR))) break;
                        ++tcprobs;
                        break;
                    }
                    case 3: {
                        if (!fullTestListed && e == null || !this.tc_fail2notrun.add(new TestDiff(tr.getTestName(), name, tr, Transitions.TC_FAIL2NOTRUN))) break;
                        ++tcprobs;
                        break;
                    }
                }
            }
        }
        for (Object o : tests[2]) {
            tr = (TestResult)o;
            entries = this.kfl.find(tr.getTestName());
            if (entries != null && entries.length != 0) continue;
            diff = new TestDiff(tr.getTestName(), tr, Transitions.OTHER_ERRORS);
            this.otherErrors.add(diff);
        }
        this.errorCount = probs;
        this.tcErrorCount = tcprobs;
        return probs;
    }

    private int findChangedCases(TestResult tr, Map<String, Status> tcs, KnownFailuresList.Entry entry) {
        int problems;
        block9: {
            String[] kfltcs;
            String kfltcl;
            block8: {
                kfltcl = entry.getTestCases();
                problems = 0;
                if (kfltcl != null) break block8;
                if (tcs == null || tcs.isEmpty()) break block9;
                for (String s : tcs.keySet()) {
                    Status stat = tcs.get(s);
                    if (stat.isError()) {
                        if (!this.tc_fail2error.add(new TestDiff(tr.getTestName(), s, tr, Transitions.TC_FAIL2ERROR))) continue;
                        ++problems;
                        continue;
                    }
                    if (stat.isPassed()) {
                        if (!this.tc_fail2pass.add(new TestDiff(tr.getTestName(), s, tr, Transitions.TC_FAIL2PASS))) continue;
                        ++problems;
                        continue;
                    }
                    if (!stat.isNotRun() || !this.tc_fail2notrun.add(new TestDiff(tr.getTestName(), s, tr, Transitions.TC_FAIL2NOTRUN))) continue;
                    ++problems;
                }
                break block9;
            }
            for (String s : kfltcs = StringArray.splitList(kfltcl, ",")) {
                if (tcs != null && !tcs.isEmpty()) {
                    return this.addAllTestCases(entry, entry.getRelativeURL(), tr, Transitions.TC_FAIL2MISSING, this.tc_missing);
                }
                Status stat = tcs.get(s);
                if (stat == null) {
                    if (!this.tc_missing.add(new TestDiff(tr.getTestName(), s, tr, Transitions.TC_FAIL2MISSING))) continue;
                    ++problems;
                    continue;
                }
                if (stat.isError()) {
                    if (!this.tc_fail2error.add(new TestDiff(tr.getTestName(), s, tr, Transitions.TC_FAIL2ERROR))) continue;
                    ++problems;
                    continue;
                }
                if (stat.isPassed()) {
                    if (!this.tc_fail2pass.add(new TestDiff(tr.getTestName(), s, tr, Transitions.TC_FAIL2PASS))) continue;
                    ++problems;
                    continue;
                }
                if (!stat.isNotRun() || !this.tc_fail2notrun.add(new TestDiff(tr.getTestName(), s, tr, Transitions.TC_FAIL2NOTRUN))) continue;
                ++problems;
            }
        }
        return problems;
    }

    private int addAllTestCases(KnownFailuresList.Entry entry, String url, TestResult tr, Transitions t, TreeSet set) {
        int problems = 0;
        String[] tcs = entry.getTestCaseList();
        if (tcs == null || tcs.length == 0) {
            return 0;
        }
        for (String s : tcs) {
            if (!set.add(new TestDiff(url, s, tr, t))) continue;
            ++problems;
        }
        return problems;
    }

    private int addListedTestCases(KnownFailuresList.Entry entry, String url, TestResult tr, Transitions t, TreeSet set) {
        int problems = 0;
        String[] tcs = entry.getTestCaseList();
        if (tcs == null || tcs.length == 0) {
            return 0;
        }
        for (String s : tcs) {
        }
        return problems;
    }

    private int addStatusTestCases(String url, TestResult tr, int status, Transitions t, Map<String, Status> trtcs, TreeSet set) {
        int problems = 0;
        if (trtcs == null || trtcs.isEmpty()) {
            return 0;
        }
        for (String key : trtcs.keySet()) {
            boolean fullTestListed;
            Status stat = trtcs.get(key);
            KnownFailuresList.Entry e = this.kfl.find(url, key);
            KnownFailuresList.Entry[] full = this.kfl.find(tr.getTestName());
            boolean bl = fullTestListed = full != null && !this.hasTestCases(full);
            if (!fullTestListed && e == null || stat.getType() != status) continue;
            TestDiff diff = new TestDiff(url, key, tr, t);
            if (fullTestListed && full != null && full.length > 0) {
                diff.setKflEntry(full[0]);
            }
            if (!set.add(diff)) continue;
            ++problems;
        }
        return problems;
    }

    private boolean hasTestCases(KnownFailuresList.Entry[] es) {
        if (es == null || es.length == 0) {
            return false;
        }
        for (KnownFailuresList.Entry e : es) {
            if (e.getTestCases() == null) continue;
            return true;
        }
        return false;
    }

    synchronized TreeSet<TestDiff> getSet(Transitions id) {
        switch (id) {
            case FAIL2PASS: {
                return this.fail2pass;
            }
            case FAIL2MISSING: {
                return this.missing;
            }
            case NEWFAILURES: {
                return this.newFailures;
            }
            case OTHER_ERRORS: {
                return this.otherErrors;
            }
            case FAIL2NOTRUN: {
                return this.fail2notrun;
            }
            case FAIL2ERROR: {
                return this.fail2error;
            }
            case FAIL2FAIL: {
                return this.fail2fail;
            }
            case TC_FAIL2PASS: {
                return this.tc_fail2pass;
            }
            case TC_FAIL2MISSING: {
                return this.tc_missing;
            }
            case TC_NEWFAILURES: {
                return this.tc_newFailures;
            }
            case TC_FAIL2NOTRUN: {
                return this.tc_fail2notrun;
            }
            case TC_FAIL2ERROR: {
                return this.tc_fail2error;
            }
        }
        return null;
    }

    synchronized int getErrorCount() {
        return this.errorCount;
    }

    synchronized int getTestCasesErrorCount() {
        return this.tcErrorCount;
    }

    private static Map<String, Status> getTestCases(TestResult tr) {
        int sCount;
        LinkedHashMap<String, Status> result = new LinkedHashMap<String, Status>();
        if (tr.isShrunk() && tr.isReloadable()) {
            tr.getSectionTitles();
        }
        if ((sCount = tr.getSectionCount()) != 0 || tr.getStatus().getType() != 3) {
            // empty if block
        }
        for (int i = 0; i < sCount; ++i) {
            try {
                String sectionOut = tr.getSection(i).getOutput("out1");
                if (sectionOut == null) continue;
                BufferedReader reader = new BufferedReader(new StringReader(sectionOut));
                String s = reader.readLine();
                while (s != null) {
                    Matcher m = testCasePattern.matcher(s);
                    if (m.matches()) {
                        String tcName = m.group(1);
                        if (tcName == null || tcName.contains(" ") || tcName.contains("\t")) {
                            s = reader.readLine();
                            continue;
                        }
                        Status stat = Status.parse(m.group(2));
                        result.put(tcName, stat);
                    }
                    s = reader.readLine();
                }
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (TestResult.ReloadFault e) {
                // empty catch block
            }
        }
        return result.isEmpty() ? null : result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Transitions {
        FAIL2PASS,
        FAIL2ERROR,
        FAIL2MISSING,
        FAIL2NOTRUN,
        FAIL2FAIL,
        NEWFAILURES,
        OTHER_ERRORS,
        TC_FAIL2MISSING,
        TC_FAIL2PASS,
        TC_PASS2ERROR,
        TC_FAIL2NOTRUN,
        TC_FAIL2ERROR,
        TC_NEWFAILURES;

    }

    public static class TestDiff
    implements Comparable {
        private TestResult tr;
        private String url;
        private String tc;
        private boolean resultMismatch = false;
        private boolean caseMismatch = false;
        private KnownFailuresList.Entry kflEntry;

        public TestDiff(String url, TestResult tr, Transitions type) {
            this.tr = tr;
            this.url = url;
        }

        public TestDiff(String url, String tc, TestResult tr, Transitions type) {
            this(url, tr, type);
            this.tc = tc;
        }

        public TestResult getTestResult() {
            return this.tr;
        }

        public boolean isTestMismatch() {
            return this.resultMismatch;
        }

        public String getName() {
            String u;
            String string = u = this.url != null ? this.url : this.tr.getTestName();
            if (this.tc == null) {
                return u;
            }
            return u + "[" + this.tc + "]";
        }

        public String getTestName() {
            return this.url;
        }

        public String getTestCase() {
            return this.tc;
        }

        public KnownFailuresList.Entry getKflEntry() {
            return this.kflEntry;
        }

        public void setKflEntry(KnownFailuresList.Entry e) {
            this.kflEntry = e;
        }

        public int compareTo(Object o) {
            TestDiff e = (TestDiff)o;
            int n = this.getName().compareTo(e.getName());
            return n;
        }
    }
}

