/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.InitialUrlFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.KnownFailuresList;
import com.sun.javatest.LastRunFilter;
import com.sun.javatest.ParameterFilter;
import com.sun.javatest.Status;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.KflSorter;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportSettings {
    private static final String PREFS_GEN_HTML = "rpt.type.html";
    private static final String PREFS_GEN_PLAIN = "rpt.type.plain";
    private static final String PREFS_GEN_XML = "rpt.type.xml";
    private static final String PREFS_GEN_COF = "rpt.type.cof";
    private static final String PREFS_COF_TC = "rpt.cof.tc";
    private static final String PREFS_HTML_CONFIG = "rpt.html.config";
    private static final String PREFS_HTML_QL = "rpt.html.ql";
    private static final String PREFS_HTML_ENV = "rpt.html.env";
    private static final String PREFS_HTML_STD = "rpt.html.std";
    private static final String PREFS_HTML_RES = "rpt.html.res";
    private static final String PREFS_HTML_KWS = "rpt.html.kws";
    private static final String PREFS_HTML_KFL = "rps.html.kfl";
    private static final String PREFS_HTML_REPORTF = "rpt.html.reportf";
    private static final String PREFS_HTML_INDEXF = "rpt.html.htmlf";
    private static final String PREFS_HTML_STATEF = "rpt.html.statef";
    private static final String PREFS_HTML_KFLF2E = "rps.html.kflf2e";
    private static final String PREFS_HTML_KFLF2F = "rpt.html.kflf2f";
    private static final String PREFS_HTML_KFLMISSING = "rpt.html.kflmissing";
    private static final String PREFS_HTML_KFLTC = "rpt.html.kfltc";
    private static final String PREFS_BACK = "rpt.bak.enable";
    private static final String PREFS_BACK_NUM = "rpt.bak.num";
    private TreeSet[] sortedResults;
    private KflSorter kflSorter;
    File xmlReportFile = null;
    File tmpXmlReportFile = null;
    private File[] mif = new File[0];
    private HashMap exchangeData;
    private InterviewParameters ip;
    private List<CustomReport> customReports = Collections.emptyList();
    TestFilter filter;
    boolean genHtml = true;
    boolean genPlain = true;
    boolean genCof = false;
    boolean genXml = false;
    private boolean genCofTestCases = true;
    boolean genConfig = true;
    boolean genQl = true;
    boolean genEnv = true;
    boolean genStd = true;
    boolean genResults = true;
    boolean genKfl = true;
    boolean genKws = true;
    boolean kflMissing = true;
    boolean kflF2e = true;
    boolean kflF2f = true;
    boolean kflTestCases = true;
    boolean reportHtml = true;
    boolean indexHtml = false;
    boolean[] stateFiles = new boolean[4];
    boolean doBackups = true;
    int backups = 1;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ReportSettings.class);

    public ReportSettings() {
        for (int i = 0; i < this.stateFiles.length; ++i) {
            this.stateFiles[i] = true;
        }
    }

    public ReportSettings(InterviewParameters p) {
        this();
        this.ip = p;
    }

    public ReportSettings(File xmlReportFile, File[] in) {
        this.xmlReportFile = xmlReportFile;
        this.mif = in;
    }

    public void write(Preferences prefs) {
        prefs.setPreference(PREFS_GEN_HTML, Boolean.toString(this.genHtml));
        prefs.setPreference(PREFS_GEN_PLAIN, Boolean.toString(this.genPlain));
        prefs.setPreference(PREFS_GEN_XML, Boolean.toString(this.genXml));
        prefs.setPreference(PREFS_GEN_COF, Boolean.toString(this.genCof));
        prefs.setPreference(PREFS_COF_TC, Boolean.toString(this.genCofTestCases));
        prefs.setPreference(PREFS_HTML_CONFIG, Boolean.toString(this.genConfig));
        prefs.setPreference(PREFS_HTML_QL, Boolean.toString(this.genQl));
        prefs.setPreference(PREFS_HTML_ENV, Boolean.toString(this.genEnv));
        prefs.setPreference(PREFS_HTML_STD, Boolean.toString(this.genStd));
        prefs.setPreference(PREFS_HTML_RES, Boolean.toString(this.genResults));
        prefs.setPreference(PREFS_HTML_KFL, Boolean.toString(this.genKfl));
        prefs.setPreference(PREFS_HTML_KWS, Boolean.toString(this.genKws));
        prefs.setPreference(PREFS_HTML_REPORTF, Boolean.toString(this.reportHtml));
        prefs.setPreference(PREFS_HTML_INDEXF, Boolean.toString(this.indexHtml));
        prefs.setPreference(PREFS_HTML_KFLF2E, Boolean.toString(this.kflF2e));
        prefs.setPreference(PREFS_HTML_KFLF2F, Boolean.toString(this.kflF2f));
        prefs.setPreference(PREFS_HTML_KFLMISSING, Boolean.toString(this.kflMissing));
        prefs.setPreference(PREFS_HTML_KFLTC, Boolean.toString(this.kflTestCases));
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.stateFiles.length; ++i) {
            sb.append(Boolean.toString(this.stateFiles[i]));
            if (i + 1 >= this.stateFiles.length) continue;
            sb.append(",");
        }
        prefs.setPreference(PREFS_HTML_STATEF, sb.toString());
        prefs.setPreference(PREFS_BACK, Boolean.toString(this.doBackups));
        prefs.setPreference(PREFS_BACK_NUM, Integer.toString(this.backups));
    }

    public static ReportSettings create(Preferences prefs) {
        ReportSettings result = new ReportSettings();
        String tst = prefs.getPreference(PREFS_GEN_HTML);
        if (tst == null) {
            return result;
        }
        result.genHtml = ReportSettings.parseBoolean(tst);
        result.genPlain = ReportSettings.parseBoolean(prefs.getPreference(PREFS_GEN_PLAIN));
        result.genXml = ReportSettings.parseBoolean(prefs.getPreference(PREFS_GEN_XML));
        result.genCof = ReportSettings.parseBoolean(prefs.getPreference(PREFS_GEN_COF));
        result.genCofTestCases = ReportSettings.parseBoolean(prefs.getPreference(PREFS_COF_TC));
        result.genConfig = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_CONFIG));
        result.genQl = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_QL));
        result.genEnv = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_ENV));
        result.genStd = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_STD));
        result.genResults = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_RES));
        result.genKfl = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_KFL));
        result.genKws = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_KWS));
        result.reportHtml = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_REPORTF));
        result.indexHtml = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_INDEXF));
        result.kflF2e = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_KFLF2E));
        result.kflF2f = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_KFLF2F));
        result.kflMissing = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_KFLMISSING));
        result.kflTestCases = ReportSettings.parseBoolean(prefs.getPreference(PREFS_HTML_KFLTC));
        String[] states = StringArray.splitList(prefs.getPreference(PREFS_HTML_STATEF), ",");
        if (states != null) {
            for (int i = 0; i < states.length; ++i) {
                result.stateFiles[i] = ReportSettings.parseBoolean(states[i]);
            }
        }
        result.doBackups = ReportSettings.parseBoolean(prefs.getPreference(PREFS_BACK));
        try {
            result.backups = Integer.parseInt(prefs.getPreference(PREFS_BACK_NUM));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    public void setInterview(InterviewParameters p) {
        this.ip = p;
    }

    public void setFilter(TestFilter f) {
        this.filter = f;
    }

    public void setEnableHtmlReport(boolean state) {
        this.genHtml = state;
    }

    public void setEnableXmlReport(boolean state) {
        this.genXml = state;
    }

    public void setEnablePlainReport(boolean state) {
        this.genPlain = state;
    }

    public void setEnableCOFReport(boolean state) {
        this.genCof = state;
    }

    public void setUseTestCases(boolean state) {
        this.genCofTestCases = state;
    }

    public void setShowConfigSection(boolean state) {
        this.genConfig = state;
    }

    public void setShowQuestionLog(boolean state) {
        this.genQl = state;
    }

    public void setShowEnvLog(boolean state) {
        this.genEnv = state;
    }

    public void setShowStdValues(boolean state) {
        this.genStd = state;
    }

    public void setShowResults(boolean state) {
        this.genResults = state;
    }

    public void setShowKflReport(boolean state) {
        this.genKfl = state;
    }

    public void setShowKeywordSummary(boolean state) {
        this.genKws = state;
    }

    public void setEnableHtmlStateFile(int status, boolean state) {
        if (status >= this.stateFiles.length) {
            return;
        }
        this.stateFiles[status] = state;
    }

    public void setHtmlMainReport(boolean reporthtml, boolean indexhtml) {
        this.reportHtml = reporthtml;
        this.indexHtml = indexhtml;
    }

    public void setEnableKflF2e(boolean state) {
        this.kflF2e = state;
    }

    public void setEnableKflF2f(boolean state) {
        this.kflF2f = state;
    }

    public void setEnableKflMissing(boolean state) {
        this.kflMissing = state;
    }

    public void setEnableKflTestCases(boolean state) {
        this.kflTestCases = state;
    }

    public void setEnableBackups(boolean state) {
        this.doBackups = state;
    }

    public void setBackupLevels(int n) {
        if (n > 0) {
            this.backups = n;
        }
    }

    public boolean isHtmlEnabled() {
        return this.genHtml;
    }

    public boolean isXmlEnabled() {
        return this.genXml;
    }

    public boolean isPlainEnabled() {
        return this.genPlain;
    }

    public boolean isCOFEnabled() {
        return this.genCof;
    }

    public boolean isCOFTestCasesEnabled() {
        return this.genCofTestCases;
    }

    public boolean isConfigSectionEnabled() {
        return this.genConfig;
    }

    public boolean isQuestionLogEnabled() {
        return this.genQl;
    }

    public boolean isEnvEnabled() {
        return this.genEnv;
    }

    public boolean isStdEnabled() {
        return this.genStd;
    }

    public boolean isResultsEnabled() {
        return this.genResults;
    }

    public boolean isKflEnabled() {
        return this.genKfl;
    }

    public boolean isKeywordSummaryEnabled() {
        return this.genKws;
    }

    public boolean isIndexHtmlEnabled() {
        return this.indexHtml;
    }

    public boolean isReportHtmlEnabled() {
        return this.reportHtml;
    }

    public boolean isStateFileEnabled(int status) {
        if (status >= this.stateFiles.length) {
            return false;
        }
        return this.stateFiles[status];
    }

    public boolean isKflTestCasesEnabled() {
        return this.kflTestCases;
    }

    public boolean isKflMissingEnabled() {
        return this.kflMissing;
    }

    public boolean isKflF2eEnabled() {
        return this.kflF2e;
    }

    public boolean isKflF2fEnabled() {
        return this.kflF2f;
    }

    public boolean isBackupsEnabled() {
        return this.doBackups;
    }

    public int getBackupLevel() {
        return this.backups;
    }

    public File[] getInitialFiles() {
        if (this.filter instanceof ParameterFilter) {
            File[] initFiles;
            InitialUrlFilter iuf = ((ParameterFilter)this.filter).getIUrlFilter();
            if (iuf == null) {
                initFiles = null;
            } else if (iuf.getInitFiles() != null) {
                initFiles = iuf.getInitFiles();
            } else if (iuf.getInitStrings() != null) {
                String[] s = iuf.getInitStrings();
                initFiles = new File[s.length];
                for (int i = 0; i < s.length; ++i) {
                    initFiles[i] = new File(s[i]);
                }
            } else {
                initFiles = null;
            }
            return initFiles;
        }
        if (this.filter instanceof LastRunFilter) {
            return ((LastRunFilter)this.filter).getTestURLs();
        }
        return null;
    }

    public TestFilter getTestFilter() {
        return this.filter;
    }

    public InterviewParameters getInterview() {
        return this.ip;
    }

    private static boolean parseBoolean(String s) {
        if (s == null) {
            return false;
        }
        return s.equalsIgnoreCase("true");
    }

    void cleanup() {
        if (this.tmpXmlReportFile != null) {
            this.tmpXmlReportFile.delete();
        }
        if (this.exchangeData != null) {
            this.exchangeData.clear();
        }
    }

    public void setXMLReportFile(File f) {
        this.xmlReportFile = f;
    }

    public void setMergingFiles(File[] files) {
        this.mif = files;
    }

    public File[] getMergingFiles() {
        return this.mif;
    }

    public Map getExchangeData() {
        if (this.exchangeData == null) {
            this.exchangeData = new HashMap();
        }
        return this.exchangeData;
    }

    void setupSortedResults() {
        TestResultTable.TreeIterator iter;
        if (this.sortedResults != null) {
            return;
        }
        TestResultTable resultTable = this.ip.getWorkDirectory().getTestResultTable();
        File[] initFiles = this.getInitialFiles();
        this.sortedResults = new TreeSet[4];
        for (int i = 0; i < this.sortedResults.length; ++i) {
            this.sortedResults[i] = new TreeSet(new TestResultsByNameComparator());
        }
        try {
            TestFilter[] fs = null;
            fs = this.filter == null ? new TestFilter[]{} : new TestFilter[]{this.filter};
            iter = initFiles == null ? resultTable.getIterator(fs) : resultTable.getIterator(initFiles, fs);
        }
        catch (TestResultTable.Fault f) {
            throw new JavaTestError(i18n.getString("result.testResult.err"));
        }
        while (iter.hasNext()) {
            TestResult tr = (TestResult)iter.next();
            Status s = tr.getStatus();
            TreeSet list = this.sortedResults[s == null ? 3 : s.getType()];
            list.add(tr);
        }
    }

    void setupKfl() {
        if (this.kflSorter != null) {
            return;
        }
        this.setupSortedResults();
        KnownFailuresList kfl = this.getInterview().getKnownFailuresList();
        TestResultTable resultTable = this.getInterview().getWorkDirectory().getTestResultTable();
        this.kflSorter = new KflSorter(kfl, resultTable, this.isKflTestCasesEnabled());
        this.kflSorter.setF2eEnabled(this.isKflF2eEnabled());
        this.kflSorter.setF2fEnabled(this.isKflF2fEnabled());
        this.kflSorter.setMissingEnabled(this.isKflMissingEnabled());
        this.kflSorter.run(this.sortedResults);
    }

    KflSorter getKflSorter() {
        return this.kflSorter;
    }

    TreeSet[] getSortedResults() {
        return this.sortedResults;
    }

    public void setCustomReports(List<CustomReport> customReportCollection) {
        this.customReports = customReportCollection;
    }

    public List<CustomReport> getCustomReports() {
        return this.customReports;
    }

    private static class TestResultsByNameComparator
    implements Comparator {
        private TestResultsByNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            TestResult tr1 = (TestResult)o1;
            TestResult tr2 = (TestResult)o2;
            return tr1.getTestName().compareTo(tr2.getTestName());
        }
    }
}

