/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import com.sun.media.imageioimpl.plugins.gif.GIFMetadata;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

class GIFWritableImageMetadata
extends GIFMetadata {
    static final String NATIVE_FORMAT_NAME = "javax_imageio_gif_image_1.0";
    static final String[] disposalMethodNames;
    public int imageLeftPosition;
    public int imageTopPosition;
    public int imageWidth;
    public int imageHeight;
    public boolean interlaceFlag = false;
    public boolean sortFlag = false;
    public byte[] localColorTable = null;
    public int disposalMethod = 0;
    public boolean userInputFlag = false;
    public boolean transparentColorFlag = false;
    public int delayTime = 0;
    public int transparentColorIndex = 0;
    public boolean hasPlainTextExtension = false;
    public int textGridLeft;
    public int textGridTop;
    public int textGridWidth;
    public int textGridHeight;
    public int characterCellWidth;
    public int characterCellHeight;
    public int textForegroundColor;
    public int textBackgroundColor;
    public byte[] text;
    public List applicationIDs = null;
    public List authenticationCodes = null;
    public List applicationData = null;
    public List comments = null;

    GIFWritableImageMetadata() {
        super(true, NATIVE_FORMAT_NAME, "com.sun.imageio.plugins.gif.GIFImageMetadataFormat", null, null);
    }

    public boolean isReadOnly() {
        return false;
    }

    public Node getAsTree(String formatName) {
        if (formatName.equals(this.nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private String toISO8859(byte[] data) {
        try {
            return new String(data, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private Node getNativeTree() {
        int numComments;
        int numAppExtensions;
        int i;
        IIOMetadataNode root = new IIOMetadataNode(this.nativeMetadataFormatName);
        IIOMetadataNode node = new IIOMetadataNode("ImageDescriptor");
        node.setAttribute("imageLeftPosition", Integer.toString(this.imageLeftPosition));
        node.setAttribute("imageTopPosition", Integer.toString(this.imageTopPosition));
        node.setAttribute("imageWidth", Integer.toString(this.imageWidth));
        node.setAttribute("imageHeight", Integer.toString(this.imageHeight));
        node.setAttribute("interlaceFlag", this.interlaceFlag ? "true" : "false");
        root.appendChild(node);
        if (this.localColorTable != null) {
            node = new IIOMetadataNode("LocalColorTable");
            int numEntries = this.localColorTable.length / 3;
            node.setAttribute("sizeOfLocalColorTable", Integer.toString(numEntries));
            node.setAttribute("sortFlag", this.sortFlag ? "TRUE" : "FALSE");
            i = 0;
            while (i < numEntries) {
                IIOMetadataNode entry = new IIOMetadataNode("ColorTableEntry");
                entry.setAttribute("index", Integer.toString(i));
                int r = this.localColorTable[3 * i] & 0xFF;
                int g = this.localColorTable[3 * i + 1] & 0xFF;
                int b = this.localColorTable[3 * i + 2] & 0xFF;
                entry.setAttribute("red", Integer.toString(r));
                entry.setAttribute("green", Integer.toString(g));
                entry.setAttribute("blue", Integer.toString(b));
                node.appendChild(entry);
                ++i;
            }
            root.appendChild(node);
        }
        node = new IIOMetadataNode("GraphicControlExtension");
        node.setAttribute("disposalMethod", disposalMethodNames[this.disposalMethod]);
        node.setAttribute("userInputFlag", this.userInputFlag ? "true" : "false");
        node.setAttribute("transparentColorFlag", this.transparentColorFlag ? "true" : "false");
        node.setAttribute("delayTime", Integer.toString(this.delayTime));
        node.setAttribute("transparentColorIndex", Integer.toString(this.transparentColorIndex));
        root.appendChild(node);
        if (this.hasPlainTextExtension) {
            node = new IIOMetadataNode("PlainTextExtension");
            node.setAttribute("textGridLeft", Integer.toString(this.textGridLeft));
            node.setAttribute("textGridTop", Integer.toString(this.textGridTop));
            node.setAttribute("textGridWidth", Integer.toString(this.textGridWidth));
            node.setAttribute("textGridHeight", Integer.toString(this.textGridHeight));
            node.setAttribute("characterCellWidth", Integer.toString(this.characterCellWidth));
            node.setAttribute("characterCellHeight", Integer.toString(this.characterCellHeight));
            node.setAttribute("textForegroundColor", Integer.toString(this.textForegroundColor));
            node.setAttribute("textBackgroundColor", Integer.toString(this.textBackgroundColor));
            node.setAttribute("text", this.toISO8859(this.text));
            root.appendChild(node);
        }
        int n = numAppExtensions = this.applicationIDs == null ? 0 : this.applicationIDs.size();
        if (numAppExtensions > 0) {
            node = new IIOMetadataNode("ApplicationExtensions");
            i = 0;
            while (i < numAppExtensions) {
                IIOMetadataNode appExtNode = new IIOMetadataNode("ApplicationExtension");
                byte[] applicationID = (byte[])this.applicationIDs.get(i);
                appExtNode.setAttribute("applicationID", this.toISO8859(applicationID));
                byte[] authenticationCode = (byte[])this.authenticationCodes.get(i);
                appExtNode.setAttribute("authenticationCode", this.toISO8859(authenticationCode));
                byte[] appData = (byte[])this.applicationData.get(i);
                appExtNode.setUserObject((byte[])appData.clone());
                node.appendChild(appExtNode);
                ++i;
            }
            root.appendChild(node);
        }
        int n2 = numComments = this.comments == null ? 0 : this.comments.size();
        if (numComments > 0) {
            node = new IIOMetadataNode("CommentExtensions");
            int i2 = 0;
            while (i2 < numComments) {
                IIOMetadataNode commentNode = new IIOMetadataNode("CommentExtension");
                byte[] comment = (byte[])this.comments.get(i2);
                commentNode.setAttribute("value", this.toISO8859(comment));
                node.appendChild(commentNode);
                ++i2;
            }
            root.appendChild(node);
        }
        return root;
    }

    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode chroma_node = new IIOMetadataNode("Chroma");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("ColorSpaceType");
        node.setAttribute("name", "RGB");
        chroma_node.appendChild(node);
        node = new IIOMetadataNode("NumChannels");
        node.setAttribute("value", this.transparentColorFlag ? "4" : "3");
        chroma_node.appendChild(node);
        node = new IIOMetadataNode("BlackIsZero");
        node.setAttribute("value", "TRUE");
        chroma_node.appendChild(node);
        if (this.localColorTable != null) {
            node = new IIOMetadataNode("Palette");
            int numEntries = this.localColorTable.length / 3;
            int i = 0;
            while (i < numEntries) {
                IIOMetadataNode entry = new IIOMetadataNode("PaletteEntry");
                entry.setAttribute("index", Integer.toString(i));
                entry.setAttribute("red", Integer.toString(this.localColorTable[3 * i] & 0xFF));
                entry.setAttribute("green", Integer.toString(this.localColorTable[3 * i + 1] & 0xFF));
                entry.setAttribute("blue", Integer.toString(this.localColorTable[3 * i + 2] & 0xFF));
                node.appendChild(entry);
                ++i;
            }
            chroma_node.appendChild(node);
        }
        return chroma_node;
    }

    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode compression_node = new IIOMetadataNode("Compression");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("CompressionTypeName");
        node.setAttribute("value", "lzw");
        compression_node.appendChild(node);
        node = new IIOMetadataNode("Lossless");
        node.setAttribute("value", "TRUE");
        compression_node.appendChild(node);
        node = new IIOMetadataNode("NumProgressiveScans");
        node.setAttribute("value", this.interlaceFlag ? "4" : "1");
        compression_node.appendChild(node);
        return compression_node;
    }

    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode data_node = new IIOMetadataNode("Data");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("SampleFormat");
        node.setAttribute("value", "Index");
        data_node.appendChild(node);
        return data_node;
    }

    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode dimension_node = new IIOMetadataNode("Dimension");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("ImageOrientation");
        node.setAttribute("value", "Normal");
        dimension_node.appendChild(node);
        node = new IIOMetadataNode("HorizontalPixelOffset");
        node.setAttribute("value", Integer.toString(this.imageLeftPosition));
        dimension_node.appendChild(node);
        node = new IIOMetadataNode("VerticalPixelOffset");
        node.setAttribute("value", Integer.toString(this.imageTopPosition));
        dimension_node.appendChild(node);
        return dimension_node;
    }

    public IIOMetadataNode getStandardTextNode() {
        if (this.comments == null) {
            return null;
        }
        Iterator commentIter = this.comments.iterator();
        if (!commentIter.hasNext()) {
            return null;
        }
        IIOMetadataNode text_node = new IIOMetadataNode("Text");
        IIOMetadataNode node = null;
        while (commentIter.hasNext()) {
            byte[] comment = (byte[])commentIter.next();
            String s = null;
            try {
                s = new String(comment, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding ISO-8859-1 unknown!");
            }
            node = new IIOMetadataNode("TextEntry");
            node.setAttribute("value", s);
            node.setAttribute("encoding", "ISO-8859-1");
            node.setAttribute("compression", "none");
            text_node.appendChild(node);
        }
        return text_node;
    }

    public IIOMetadataNode getStandardTransparencyNode() {
        if (!this.transparentColorFlag) {
            return null;
        }
        IIOMetadataNode transparency_node = new IIOMetadataNode("Transparency");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("TransparentIndex");
        node.setAttribute("value", Integer.toString(this.transparentColorIndex));
        transparency_node.appendChild(node);
        return transparency_node;
    }

    public void reset() {
        this.imageLeftPosition = 0;
        this.imageTopPosition = 0;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.interlaceFlag = false;
        this.sortFlag = false;
        this.localColorTable = null;
        this.disposalMethod = 0;
        this.userInputFlag = false;
        this.transparentColorFlag = false;
        this.delayTime = 0;
        this.transparentColorIndex = 0;
        this.hasPlainTextExtension = false;
        this.textGridLeft = 0;
        this.textGridTop = 0;
        this.textGridWidth = 0;
        this.textGridHeight = 0;
        this.characterCellWidth = 0;
        this.characterCellHeight = 0;
        this.textForegroundColor = 0;
        this.textBackgroundColor = 0;
        this.text = null;
        this.applicationIDs = null;
        this.authenticationCodes = null;
        this.applicationData = null;
        this.comments = null;
    }

    private byte[] fromISO8859(String data) {
        try {
            return data.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return new String("").getBytes();
        }
    }

    protected void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals(this.nativeMetadataFormatName)) {
            GIFMetadata.fatal(node, "Root must be " + this.nativeMetadataFormatName);
        }
        node = node.getFirstChild();
        while (node != null) {
            String name = node.getNodeName();
            if (name.equals("ImageDescriptor")) {
                this.imageLeftPosition = GIFMetadata.getIntAttribute(node, "imageLeftPosition", -1, true, true, 0, 65535);
                this.imageTopPosition = GIFMetadata.getIntAttribute(node, "imageTopPosition", -1, true, true, 0, 65535);
                this.imageWidth = GIFMetadata.getIntAttribute(node, "imageWidth", -1, true, true, 1, 65535);
                this.imageHeight = GIFMetadata.getIntAttribute(node, "imageHeight", -1, true, true, 1, 65535);
                this.interlaceFlag = GIFMetadata.getBooleanAttribute(node, "interlaceFlag", false, true);
            } else if (name.equals("LocalColorTable")) {
                int sizeOfLocalColorTable = GIFMetadata.getIntAttribute(node, "sizeOfLocalColorTable", true, 2, 256);
                if (sizeOfLocalColorTable != 2 && sizeOfLocalColorTable != 4 && sizeOfLocalColorTable != 8 && sizeOfLocalColorTable != 16 && sizeOfLocalColorTable != 32 && sizeOfLocalColorTable != 64 && sizeOfLocalColorTable != 128 && sizeOfLocalColorTable != 256) {
                    GIFMetadata.fatal(node, "Bad value for LocalColorTable attribute sizeOfLocalColorTable!");
                }
                this.sortFlag = GIFMetadata.getBooleanAttribute(node, "sortFlag", false, true);
                this.localColorTable = this.getColorTable(node, "ColorTableEntry", true, sizeOfLocalColorTable);
            } else if (name.equals("GraphicControlExtension")) {
                String disposalMethodName = GIFMetadata.getStringAttribute(node, "disposalMethod", null, true, disposalMethodNames);
                this.disposalMethod = 0;
                while (!disposalMethodName.equals(disposalMethodNames[this.disposalMethod])) {
                    ++this.disposalMethod;
                }
                this.userInputFlag = GIFMetadata.getBooleanAttribute(node, "userInputFlag", false, true);
                this.transparentColorFlag = GIFMetadata.getBooleanAttribute(node, "transparentColorFlag", false, true);
                this.delayTime = GIFMetadata.getIntAttribute(node, "delayTime", -1, true, true, 0, 65535);
                this.transparentColorIndex = GIFMetadata.getIntAttribute(node, "transparentColorIndex", -1, true, true, 0, 65535);
            } else if (name.equals("PlainTextExtension")) {
                this.hasPlainTextExtension = true;
                this.textGridLeft = GIFMetadata.getIntAttribute(node, "textGridLeft", -1, true, true, 0, 65535);
                this.textGridTop = GIFMetadata.getIntAttribute(node, "textGridTop", -1, true, true, 0, 65535);
                this.textGridWidth = GIFMetadata.getIntAttribute(node, "textGridWidth", -1, true, true, 1, 65535);
                this.textGridHeight = GIFMetadata.getIntAttribute(node, "textGridHeight", -1, true, true, 1, 65535);
                this.characterCellWidth = GIFMetadata.getIntAttribute(node, "characterCellWidth", -1, true, true, 1, 65535);
                this.characterCellHeight = GIFMetadata.getIntAttribute(node, "characterCellHeight", -1, true, true, 1, 65535);
                this.textForegroundColor = GIFMetadata.getIntAttribute(node, "textForegroundColor", -1, true, true, 0, 255);
                this.textBackgroundColor = GIFMetadata.getIntAttribute(node, "textBackgroundColor", -1, true, true, 0, 255);
                String textString = GIFMetadata.getStringAttribute(node, "text", "", false, null);
                this.text = this.fromISO8859(textString);
            } else if (name.equals("ApplicationExtensions")) {
                IIOMetadataNode applicationExtension = (IIOMetadataNode)node.getFirstChild();
                if (!applicationExtension.getNodeName().equals("ApplicationExtension")) {
                    GIFMetadata.fatal(node, "Only a ApplicationExtension may be a child of a ApplicationExtensions!");
                }
                String applicationIDString = GIFMetadata.getStringAttribute(applicationExtension, "applicationID", null, true, null);
                String authenticationCodeString = GIFMetadata.getStringAttribute(applicationExtension, "authenticationCode", null, true, null);
                Object applicationExtensionData = applicationExtension.getUserObject();
                if (applicationExtensionData == null || !(applicationExtensionData instanceof byte[])) {
                    GIFMetadata.fatal(applicationExtension, "Bad user object in ApplicationExtension!");
                }
                if (this.applicationIDs == null) {
                    this.applicationIDs = new ArrayList();
                    this.authenticationCodes = new ArrayList();
                    this.applicationData = new ArrayList();
                }
                this.applicationIDs.add(this.fromISO8859(applicationIDString));
                this.authenticationCodes.add(this.fromISO8859(authenticationCodeString));
                this.applicationData.add(applicationExtensionData);
            } else if (name.equals("CommentExtensions")) {
                Node commentExtension = node.getFirstChild();
                if (commentExtension != null) {
                    while (commentExtension != null) {
                        if (!commentExtension.getNodeName().equals("CommentExtension")) {
                            GIFMetadata.fatal(node, "Only a CommentExtension may be a child of a CommentExtensions!");
                        }
                        if (this.comments == null) {
                            this.comments = new ArrayList();
                        }
                        String comment = GIFMetadata.getStringAttribute(commentExtension, "value", null, true, null);
                        this.comments.add(this.fromISO8859(comment));
                        commentExtension = commentExtension.getNextSibling();
                    }
                }
            } else {
                GIFMetadata.fatal(node, "Unknown child of root node!");
            }
            node = node.getNextSibling();
        }
    }

    protected void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals("javax_imageio_1.0")) {
            GIFMetadata.fatal(node, "Root must be javax_imageio_1.0");
        }
        node = node.getFirstChild();
        while (node != null) {
            String childName;
            Node childNode;
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                childNode = node.getFirstChild();
                while (childNode != null) {
                    childName = childNode.getNodeName();
                    if (childName.equals("Palette")) {
                        this.localColorTable = this.getColorTable(childNode, "PaletteEntry", false, -1);
                        break;
                    }
                    childNode = childNode.getNextSibling();
                }
            } else if (name.equals("Compression")) {
                childNode = node.getFirstChild();
                while (childNode != null) {
                    childName = childNode.getNodeName();
                    if (childName.equals("NumProgressiveScans")) {
                        int numProgressiveScans = GIFMetadata.getIntAttribute(childNode, "value", 4, false, true, 1, Integer.MAX_VALUE);
                        if (numProgressiveScans <= 1) break;
                        this.interlaceFlag = true;
                        break;
                    }
                    childNode = childNode.getNextSibling();
                }
            } else if (name.equals("Dimension")) {
                childNode = node.getFirstChild();
                while (childNode != null) {
                    childName = childNode.getNodeName();
                    if (childName.equals("HorizontalPixelOffset")) {
                        this.imageLeftPosition = GIFMetadata.getIntAttribute(childNode, "value", -1, true, true, 0, 65535);
                    } else if (childName.equals("VerticalPixelOffset")) {
                        this.imageTopPosition = GIFMetadata.getIntAttribute(childNode, "value", -1, true, true, 0, 65535);
                    }
                    childNode = childNode.getNextSibling();
                }
            } else if (name.equals("Text")) {
                childNode = node.getFirstChild();
                while (childNode != null) {
                    childName = childNode.getNodeName();
                    if (childName.equals("TextEntry") && GIFMetadata.getAttribute(childNode, "compression", "none", false).equals("none") && Charset.isSupported(GIFMetadata.getAttribute(childNode, "encoding", "ISO-8859-1", false))) {
                        String value = GIFMetadata.getAttribute(childNode, "value");
                        byte[] comment = this.fromISO8859(value);
                        if (this.comments == null) {
                            this.comments = new ArrayList();
                        }
                        this.comments.add(comment);
                    }
                    childNode = childNode.getNextSibling();
                }
            } else if (name.equals("Transparency")) {
                childNode = node.getFirstChild();
                while (childNode != null) {
                    childName = childNode.getNodeName();
                    if (childName.equals("TransparentIndex")) {
                        this.transparentColorIndex = GIFMetadata.getIntAttribute(childNode, "value", -1, true, true, 0, 255);
                        this.transparentColorFlag = true;
                        break;
                    }
                    childNode = childNode.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
    }

    static {
        NATIVE_FORMAT_NAME = NATIVE_FORMAT_NAME;
        disposalMethodNames = new String[]{"none", "doNotDispose", "restoreToBackgroundColor", "restoreToPrevious", "undefinedDisposalMethod4", "undefinedDisposalMethod5", "undefinedDisposalMethod6", "undefinedDisposalMethod7"};
    }
}

