/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import java.io.IOException;

public class TIFFLSBDecompressor
extends TIFFDecompressor {
    private static byte[] flipTable = TIFFFaxDecompressor.flipTable;

    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        this.stream.seek(this.offset);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            int numBytes = bytesPerRow * this.srcHeight;
            this.stream.readFully(b, dstOffset, numBytes);
            int xMax = dstOffset + numBytes;
            int x = dstOffset;
            while (x < xMax) {
                b[x] = flipTable[b[x] & 0xFF];
                ++x;
            }
        } else {
            int y = 0;
            while (y < this.srcHeight) {
                this.stream.readFully(b, dstOffset, bytesPerRow);
                int xMax = dstOffset + bytesPerRow;
                int x = dstOffset;
                while (x < xMax) {
                    b[x] = flipTable[b[x] & 0xFF];
                    ++x;
                }
                dstOffset += scanlineStride;
                ++y;
            }
        }
    }
}

