/*
 * $RCSfile: TexCoord3f.java,v $
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * $Revision: 1.4 $
 * $Date: 2007/02/09 17:22:38 $
 * $State: Exp $
 */

package javax.vecmath;

import java.lang.Math;

/**
 * A 3 element texture coordinate that is represented by single precision 
 * floating point x,y,z coordinates.
 *
 */
public class TexCoord3f extends Tuple3f implements java.io.Serializable {

    // Combatible with 1.1
    static final long serialVersionUID = -3517736544731446513L;

    /**
     * Constructs and initializes a TexCoord3f from the specified xyz
     * coordinates.
     * @param x the x coordinate
     * @param y the y coordinate
     * @param z the z coordinate
     */
    public TexCoord3f(float x, float y, float z)
    {
        super(x,y,z);
    }


    /**
     * Constructs and initializes a TexCoord3f from the array of length 3.
     * @param v the array of length 3 containing xyz in order
     */
    public TexCoord3f(float[] v)
    {
       super(v);
    }


    /**
     * Constructs and initializes a TexCoord3f from the specified TexCoord3f.
     * @param v1 the TexCoord3f containing the initialization x y z data
     */
    public TexCoord3f(TexCoord3f v1)
    {
       super(v1);
    }


    /**
     * Constructs and initializes a TexCoord3f from the specified Tuple3f.
     * @param t1 the Tuple3f containing the initialization x y z data
     */ 
    public TexCoord3f(Tuple3f t1) 
    {
       super(t1);
    }


    /**
     * Constructs and initializes a TexCoord3f from the specified Tuple3d.
     * @param t1 the Tuple3d containing the initialization x y z data
     */ 
    public TexCoord3f(Tuple3d t1) 
    {
       super(t1);
    }


    /**
     * Constructs and initializes a TexCoord3f to (0,0,0).
     */
    public TexCoord3f()
    {
        super();
    }

}
