/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.alternate_appearance;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.AlternateAppearance;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.alternate_appearance.SphereGroup;

public class AlternateAppearanceScopeTest
extends JApplet
implements ActionListener {
    Material mat1;
    Material altMat;
    Appearance app;
    Appearance otherApp;
    JComboBox altAppMaterialColor;
    JComboBox appMaterialColor;
    JComboBox altAppScoping;
    JComboBox override;
    private Group content1 = null;
    private Group content2 = null;
    BoundingSphere worldBounds;
    AlternateAppearance altApp;
    Shape3D[] shapes1;
    Shape3D[] shapes2;
    boolean shape1Enabled = false;
    boolean shape2Enabled = false;
    Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
    Color3f red = new Color3f(1.0f, 0.0f, 0.0f);
    Color3f green = new Color3f(0.0f, 1.0f, 0.0f);
    Color3f blue = new Color3f(0.0f, 0.0f, 1.0f);
    Color3f[] colors = new Color3f[]{this.white, this.red, this.green, this.blue};
    private SimpleUniverse u;

    public void init() {
        Container contentPane = this.getContentPane();
        Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        contentPane.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(c, 112);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        this.u.addBranchGraph(scene);
        JPanel p = new JPanel();
        BoxLayout boxlayout = new BoxLayout(p, 1);
        p.add(this.createScopingPanel());
        p.add(this.createMaterialPanel());
        p.setLayout(boxlayout);
        contentPane.add("South", p);
    }

    public void destroy() {
        this.u.cleanup();
    }

    BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.worldBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
        Transform3D t = new Transform3D();
        t.set(new Vector3f(0.0f, 0.1f, 0.0f));
        t.setScale(0.8);
        TransformGroup trans = new TransformGroup(t);
        trans.setCapability(18);
        trans.setCapability(17);
        this.otherApp = new Appearance();
        this.altMat = new Material();
        this.altMat.setCapability(1);
        this.altMat.setDiffuseColor(new Color3f(0.0f, 1.0f, 0.0f));
        this.otherApp.setMaterial(this.altMat);
        this.altApp = new AlternateAppearance();
        this.altApp.setAppearance(this.otherApp);
        this.altApp.setCapability(17);
        this.altApp.setCapability(16);
        this.altApp.setInfluencingBounds((Bounds)this.worldBounds);
        objRoot.addChild((Node)this.altApp);
        Appearance app1 = new Appearance();
        this.mat1 = new Material();
        this.mat1.setCapability(1);
        this.mat1.setDiffuseColor(new Color3f(1.0f, 0.0f, 0.0f));
        app1.setMaterial(this.mat1);
        this.content1 = new SphereGroup(0.05f, 0.4f, 0.2f, 3, 5, app1, true);
        trans.addChild((Node)this.content1);
        this.shapes1 = ((SphereGroup)this.content1).getShapes();
        this.content2 = new SphereGroup(0.05f, 0.4f, 0.2f, 2, 5, app1, true);
        trans.addChild((Node)this.content2);
        this.shapes2 = ((SphereGroup)this.content2).getShapes();
        DirectionalLight light1 = null;
        light1 = new DirectionalLight();
        light1.setEnable(true);
        light1.setColor(new Color3f(0.2f, 0.2f, 0.2f));
        light1.setDirection(new Vector3f(1.0f, 0.0f, -1.0f));
        light1.setInfluencingBounds((Bounds)this.worldBounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight();
        light2.setEnable(true);
        light2.setColor(new Color3f(0.2f, 0.2f, 0.2f));
        light2.setDirection(new Vector3f(-1.0f, 0.0f, 1.0f));
        light2.setInfluencingBounds((Bounds)this.worldBounds);
        objRoot.addChild((Node)light2);
        AmbientLight ambient = new AmbientLight();
        ambient.setEnable(true);
        ambient.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        ambient.setInfluencingBounds((Bounds)this.worldBounds);
        objRoot.addChild((Node)ambient);
        objRoot.addChild((Node)trans);
        return objRoot;
    }

    JPanel createScopingPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Scopes"));
        String[] values = new String[]{"Scoped Set1", "Scoped Set2", "Universal Scope"};
        this.altAppScoping = new JComboBox<String>(values);
        this.altAppScoping.addActionListener(this);
        this.altAppScoping.setSelectedIndex(2);
        panel.add(new JLabel("Scoping"));
        panel.add(this.altAppScoping);
        String[] enables = new String[]{"Enabled Set1", "Enabled Set2", "Enabled set1&2", "Disabled set1&2"};
        this.override = new JComboBox<String>(enables);
        this.override.addActionListener(this);
        this.override.setSelectedIndex(3);
        panel.add(new JLabel("Alternate Appearance Override"));
        panel.add(this.override);
        return panel;
    }

    JPanel createMaterialPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Appearance Attributes"));
        String[] colorVals = new String[]{"WHITE", "RED", "GREEN", "BLUE"};
        this.altAppMaterialColor = new JComboBox<String>(colorVals);
        this.altAppMaterialColor.addActionListener(this);
        this.altAppMaterialColor.setSelectedIndex(2);
        panel.add(new JLabel("Alternate Appearance MaterialColor"));
        panel.add(this.altAppMaterialColor);
        this.appMaterialColor = new JComboBox<String>(colorVals);
        this.appMaterialColor.addActionListener(this);
        this.appMaterialColor.setSelectedIndex(1);
        panel.add(new JLabel("Normal Appearance MaterialColor"));
        panel.add(this.appMaterialColor);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.altAppMaterialColor) {
            this.altMat.setDiffuseColor(this.colors[this.altAppMaterialColor.getSelectedIndex()]);
        } else if (target == this.altAppScoping) {
            for (int i = 0; i < this.altApp.numScopes(); ++i) {
                this.altApp.removeScope(0);
            }
            if (this.altAppScoping.getSelectedIndex() == 0) {
                this.altApp.addScope(this.content1);
            } else if (this.altAppScoping.getSelectedIndex() == 1) {
                this.altApp.addScope(this.content2);
            }
        } else if (target == this.override) {
            if (this.override.getSelectedIndex() == 0) {
                int i;
                if (!this.shape1Enabled) {
                    for (i = 0; i < this.shapes1.length; ++i) {
                        this.shapes1[i].setAppearanceOverrideEnable(true);
                    }
                    this.shape1Enabled = true;
                }
                if (this.shape2Enabled) {
                    for (i = 0; i < this.shapes2.length; ++i) {
                        this.shapes2[i].setAppearanceOverrideEnable(false);
                    }
                    this.shape2Enabled = false;
                }
            } else if (this.override.getSelectedIndex() == 1) {
                int i;
                if (!this.shape2Enabled) {
                    for (i = 0; i < this.shapes2.length; ++i) {
                        this.shapes2[i].setAppearanceOverrideEnable(true);
                    }
                    this.shape2Enabled = true;
                }
                if (this.shape1Enabled) {
                    for (i = 0; i < this.shapes1.length; ++i) {
                        this.shapes1[i].setAppearanceOverrideEnable(false);
                    }
                    this.shape1Enabled = false;
                }
            } else if (this.override.getSelectedIndex() == 2) {
                int i;
                if (!this.shape1Enabled) {
                    for (i = 0; i < this.shapes1.length; ++i) {
                        this.shapes1[i].setAppearanceOverrideEnable(true);
                    }
                    this.shape1Enabled = true;
                }
                if (!this.shape2Enabled) {
                    for (i = 0; i < this.shapes2.length; ++i) {
                        this.shapes2[i].setAppearanceOverrideEnable(true);
                    }
                    this.shape2Enabled = true;
                }
            } else {
                int i;
                if (this.shape1Enabled) {
                    for (i = 0; i < this.shapes1.length; ++i) {
                        this.shapes1[i].setAppearanceOverrideEnable(false);
                    }
                    this.shape1Enabled = false;
                }
                if (this.shape2Enabled) {
                    for (i = 0; i < this.shapes2.length; ++i) {
                        this.shapes2[i].setAppearanceOverrideEnable(false);
                    }
                    this.shape2Enabled = false;
                }
            }
        } else if (target == this.appMaterialColor) {
            this.mat1.setDiffuseColor(this.colors[this.appMaterialColor.getSelectedIndex()]);
        }
    }

    public static void main(String[] args) {
        MainFrame frame = new MainFrame((Applet)new AlternateAppearanceScopeTest(), 800, 800);
    }
}

