/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.alternate_appearance;

import com.sun.j3d.utils.geometry.Sphere;
import javax.media.j3d.Appearance;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

public class SphereGroup
extends Group {
    Shape3D[] shapes;
    int numShapes = 0;

    public SphereGroup() {
        this(0.25f, 0.75f, 0.75f, 5, 5, null, false);
    }

    public SphereGroup(Appearance app) {
        this(0.25f, 0.75f, 0.75f, 5, 5, app, false);
    }

    public SphereGroup(float radius, float xSpacing, float ySpacing, int xCount, int yCount, boolean overrideflag) {
        this(radius, xSpacing, ySpacing, xCount, yCount, null, overrideflag);
    }

    public SphereGroup(float radius, float xSpacing, float ySpacing, int xCount, int yCount, Appearance app, boolean overrideflag) {
        if (app == null) {
            app = new Appearance();
            Material material = new Material();
            material.setDiffuseColor(new Color3f(0.8f, 0.8f, 0.8f));
            material.setSpecularColor(new Color3f(0.0f, 0.0f, 0.0f));
            material.setShininess(0.0f);
            app.setMaterial(material);
        }
        double xStart = (double)(-xSpacing) * (double)(xCount - 1) / 2.0;
        double yStart = (double)(-ySpacing) * (double)(yCount - 1) / 2.0;
        Sphere sphere = null;
        TransformGroup trans = null;
        Transform3D t3d = new Transform3D();
        Vector3d vec = new Vector3d();
        double y = yStart;
        double z = 0.0;
        this.shapes = new Shape3D[xCount * yCount];
        for (int i = 0; i < yCount; ++i) {
            double x = xStart;
            for (int j = 0; j < xCount; ++j) {
                vec.set(x, y, z);
                t3d.setTranslation(vec);
                trans = new TransformGroup(t3d);
                this.addChild((Node)trans);
                sphere = new Sphere(radius, 1, 16, app);
                trans.addChild((Node)sphere);
                x += (double)xSpacing;
                this.shapes[this.numShapes] = sphere.getShape();
                if (overrideflag) {
                    this.shapes[this.numShapes].setCapability(19);
                }
                ++this.numShapes;
            }
            y += (double)ySpacing;
        }
    }

    Shape3D[] getShapes() {
        return this.shapes;
    }
}

