/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.configured_universe;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.behaviors.sensor.Mouse6DPointerBehavior;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;

public class ConfigObjLoad {
    private boolean spin = false;
    private boolean noTriangulate = false;
    private boolean noStripify = false;
    private double creaseAngle = 60.0;
    private URL filename = null;
    private ConfiguredUniverse u;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.7);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objScale.addChild((Node)objTrans);
        int flags = 64;
        if (!this.noTriangulate) {
            flags |= 0x80;
        }
        if (!this.noStripify) {
            flags |= 0x200;
        }
        ObjectFile f = new ObjectFile(flags, (float)(this.creaseAngle * Math.PI / 180.0));
        Scene s = null;
        try {
            s = f.load(this.filename);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (ParsingErrorException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        catch (IncorrectFormatException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        objTrans.addChild((Node)s.getSceneGroup());
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        if (this.spin) {
            Transform3D yAxis = new Transform3D();
            Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
            RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
            rotator.setSchedulingBounds((Bounds)bounds);
            objTrans.addChild((Node)rotator);
        }
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bgNode);
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
        Color3f light2Color = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light2);
        return objRoot;
    }

    private void usage() {
        System.out.println("Usage: java ConfigObjLoad [-s] [-n] [-t] [-c degrees] <.obj file>");
        System.out.println("  -s Spin (no user interaction)");
        System.out.println("  -n No triangulation");
        System.out.println("  -t No stripification");
        System.out.println("  -c Set crease angle for normal generation (default is 60 without");
        System.out.println("     smoothing group info, otherwise 180 within smoothing groups)");
        System.exit(0);
    }

    public void init() {
        Sensor mouse6d;
        URL configURL;
        if (this.filename == null) {
            this.filename = Resources.getResource("resources/geometry/galleon.obj");
            if (this.filename == null) {
                System.err.println("resources/geometry/galleon.obj not found");
                System.exit(1);
            }
        }
        if ((configURL = ConfiguredUniverse.getConfigURL(null)) == null) {
            configURL = Resources.getResource("configured_universe/j3d1x1-window.cfg");
        }
        BranchGroup scene = this.createSceneGraph();
        this.u = new ConfiguredUniverse(configURL);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        if (!this.spin && viewingPlatform.getViewPlatformBehavior() == null) {
            OrbitBehavior orbit = new OrbitBehavior(this.u.getCanvas(), 112);
            BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
            orbit.setSchedulingBounds((Bounds)bounds);
            viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        }
        Map sensorMap = null;
        sensorMap = this.u.getNamedSensors();
        if (sensorMap != null && (mouse6d = (Sensor)sensorMap.get("mouse6d")) != null) {
            Mouse6DPointerBehavior behavior = new Mouse6DPointerBehavior(mouse6d, 1.0, true);
            BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
            behavior.setSchedulingBounds((Bounds)bounds);
            scene.addChild((Node)behavior);
            scene.addChild((Node)behavior.getEcho());
        }
        Canvas3D[] canvases = this.u.getViewer().getCanvas3Ds();
        class QuitListener
        extends KeyAdapter {
            QuitListener() {
            }

            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == 'q' || c == 'Q' || c == '\u001b') {
                    System.exit(0);
                }
            }
        }
        QuitListener quitListener = new QuitListener();
        for (int i = 0; i < canvases.length; ++i) {
            canvases[i].addKeyListener((KeyListener)quitListener);
        }
        this.u.addBranchGraph(scene);
    }

    public ConfigObjLoad(String[] args) {
        if (args.length != 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    if (args[i].equals("-s")) {
                        this.spin = true;
                        continue;
                    }
                    if (args[i].equals("-n")) {
                        this.noTriangulate = true;
                        continue;
                    }
                    if (args[i].equals("-t")) {
                        this.noStripify = true;
                        continue;
                    }
                    if (args[i].equals("-c")) {
                        if (i < args.length - 1) {
                            this.creaseAngle = new Double(args[++i]);
                            continue;
                        }
                        this.usage();
                        continue;
                    }
                    this.usage();
                    continue;
                }
                try {
                    if (args[i].indexOf("file:") == 0 || args[i].indexOf("http") == 0) {
                        this.filename = new URL(args[i]);
                        continue;
                    }
                    if (args[i].charAt(0) != '/') {
                        this.filename = new URL("file:./" + args[i]);
                        continue;
                    }
                    this.filename = new URL("file:" + args[i]);
                    continue;
                }
                catch (MalformedURLException e) {
                    System.err.println(e);
                    System.exit(1);
                }
            }
        }
        this.init();
    }

    public static void main(String[] args) {
        new ConfigObjLoad(args);
    }
}

