/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.depth_func;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jdesktop.j3d.examples.depth_func.RenderFrame;

public class DepthFuncTest
extends JFrame {
    RenderFrame rf;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JComboBox normalComboBox;
    private JComboBox rotatingComboBox;
    private JCheckBox shadedCheckBox;
    private JComboBox shadedComboBox;
    private JCheckBox wfCheckBox;

    public DepthFuncTest() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.normalComboBox = new JComboBox();
        this.wfCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.shadedComboBox = new JComboBox();
        this.shadedCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.rotatingComboBox = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBorder(new TitledBorder("WireFrame Object"));
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setText("Depth function");
        this.jLabel1.setToolTipText("Mode for normal object");
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.getAccessibleContext().setAccessibleParent(this.shadedComboBox);
        this.normalComboBox.setFont(new Font("Dialog", 0, 12));
        this.normalComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"ALWAYS", "NEVER", "EQUAL", "NOT_EQUAL", "LESS", "LESS_OR_EQUAL", "GREATER", "GREATER_OR_EQUAL"}));
        this.normalComboBox.setSelectedIndex(6);
        this.normalComboBox.setPreferredSize(new Dimension(150, 22));
        this.normalComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DepthFuncTest.this.normalComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.normalComboBox);
        this.wfCheckBox.setFont(new Font("Dialog", 0, 12));
        this.wfCheckBox.setText("Write Depth Buffer");
        this.wfCheckBox.setToolTipText("Depth will be written for the object, if selected");
        this.wfCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DepthFuncTest.this.wfCheckBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.wfCheckBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(new TitledBorder("Shaded Object"));
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        this.jLabel3.setText("Depth Function");
        this.jLabel3.setToolTipText("Mode of shaded object");
        this.jPanel2.add(this.jLabel3);
        this.shadedComboBox.setFont(new Font("Dialog", 0, 12));
        this.shadedComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"ALWAYS", "NEVER", "EQUAL", "NOT_EQUAL", "LESS", "LESS_OR_EQUAL", "GREATER", "GREATER_OR_EQUAL"}));
        this.shadedComboBox.setSelectedIndex(4);
        this.shadedComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DepthFuncTest.this.shadedComboBoxActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.shadedComboBox);
        this.shadedCheckBox.setFont(new Font("Dialog", 0, 12));
        this.shadedCheckBox.setSelected(true);
        this.shadedCheckBox.setText("Write Depth Buffer");
        this.shadedCheckBox.setToolTipText("Depth will be written for the object, if selected");
        this.shadedCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DepthFuncTest.this.shadedCheckBoxActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.shadedCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setBorder(new TitledBorder("Rotating Cube"));
        this.jLabel4.setFont(new Font("Dialog", 0, 12));
        this.jLabel4.setText("Raster Operator");
        this.jLabel4.setToolTipText("Raster mode of rotating object (try NOOP)");
        this.jPanel3.add(this.jLabel4);
        this.rotatingComboBox.setFont(new Font("Dialog", 0, 12));
        this.rotatingComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"CLEAR", "AND", "AND_REVERSE", "COPY", "AND_INVERTED", "NOOP", "XOR", "OR", "NOR", "EQUIV", "INVERT", "OR_REVERSE", "COPY_INVERTED", "OR_INVERTED", "NAND", "SET"}));
        this.rotatingComboBox.setSelectedIndex(3);
        this.rotatingComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DepthFuncTest.this.rotatingComboBoxActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.rotatingComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.setBounds(0, 0, 403, 240);
    }

    private void rotatingComboBoxActionPerformed(ActionEvent evt) {
        String selectedItem = this.rotatingComboBox.getSelectedItem().toString();
        int mode = 3;
        if ("CLEAR".equals(selectedItem)) {
            mode = 0;
        } else if ("AND".equals(selectedItem)) {
            mode = 1;
        } else if ("AND_REVERSE".equals(selectedItem)) {
            mode = 2;
        } else if ("COPY".equals(selectedItem)) {
            mode = 3;
        } else if ("AND_INVERTED".equals(selectedItem)) {
            mode = 4;
        } else if ("NOOP".equals(selectedItem)) {
            mode = 5;
        } else if ("XOR".equals(selectedItem)) {
            mode = 6;
        } else if ("OR".equals(selectedItem)) {
            mode = 7;
        } else if ("NOR".equals(selectedItem)) {
            mode = 8;
        } else if ("EQUIV".equals(selectedItem)) {
            mode = 9;
        } else if ("INVERT".equals(selectedItem)) {
            mode = 10;
        } else if ("OR_REVERSE".equals(selectedItem)) {
            mode = 11;
        } else if ("COPY_INVERTED".equals(selectedItem)) {
            mode = 12;
        } else if ("OR_INVERTED".equals(selectedItem)) {
            mode = 13;
        } else if ("NAND".equals(selectedItem)) {
            mode = 14;
        } else if ("SET".equals(selectedItem)) {
            mode = 15;
        } else {
            System.out.println("oops. wrong mode in ROP combo: " + selectedItem);
        }
        this.rf.setRotatingObjectROPMode(mode);
    }

    private void shadedCheckBoxActionPerformed(ActionEvent evt) {
        this.rf.setStaticObjectDBWriteStatus(this.shadedCheckBox.isSelected());
    }

    private void wfCheckBoxActionPerformed(ActionEvent evt) {
        this.rf.setStaticWFObjectDBWriteStatus(this.wfCheckBox.isSelected());
    }

    private void shadedComboBoxActionPerformed(ActionEvent evt) {
        int func = 5;
        String selectedItem = this.shadedComboBox.getSelectedItem().toString();
        this.rf.setStaticObjectTestFunc(this.getID(selectedItem));
    }

    private void normalComboBoxActionPerformed(ActionEvent evt) {
        int func = 5;
        String selectedItem = this.normalComboBox.getSelectedItem().toString();
        this.rf.setStaticWFObjectTestFunc(this.getID(selectedItem));
    }

    int getID(String selectedItem) {
        int func = 5;
        if ("LESS_OR_EQUAL".equals(selectedItem)) {
            func = 5;
        } else if ("NEVER".equals(selectedItem)) {
            func = 1;
        } else if ("ALWAYS".equals(selectedItem)) {
            func = 0;
        } else if ("GREATER".equals(selectedItem)) {
            func = 6;
        } else if ("GREATER_OR_EQUAL".equals(selectedItem)) {
            func = 7;
        } else if ("LESS".equals(selectedItem)) {
            func = 4;
        } else if ("EQUAL".equals(selectedItem)) {
            func = 2;
        } else if ("NOT_EQUAL".equals(selectedItem)) {
            func = 3;
        }
        return func;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DepthFuncTest dpt = new DepthFuncTest();
                dpt.rf = new RenderFrame(dpt);
                dpt.setVisible(true);
                dpt.rf.setVisible(true);
            }
        });
    }
}

