/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.distort_glyph;

import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class DistortBehavior
extends Behavior {
    protected WakeupCondition m_InitialWakeupCondition = null;
    protected WakeupCondition m_FrameWakeupCondition = null;
    protected Shape3D m_Shape3D = null;
    protected GeometryArray m_GeometryArray = null;
    protected float[] m_CoordinateArray = null;
    protected float[] m_OriginalCoordinateArray = null;
    protected Appearance m_Appearance = null;
    protected int m_nElapsedTime = 0;
    protected int m_nNumFrames = 0;
    protected int m_nFrameNumber = 0;
    private int frame = 0;
    protected Vector3f m_Vector = new Vector3f();

    public DistortBehavior(Shape3D shape3D, int nElapsedTime, int nNumFrames) {
        this.m_FrameWakeupCondition = new WakeupOnElapsedFrames(0);
        this.restart(shape3D, nElapsedTime, nNumFrames);
    }

    public WakeupCondition restart(Shape3D shape3D, int nElapsedTime, int nNumFrames) {
        this.m_Shape3D = shape3D;
        this.m_nElapsedTime = nElapsedTime;
        this.m_nNumFrames = nNumFrames;
        this.m_nFrameNumber = 0;
        this.m_InitialWakeupCondition = new WakeupOnElapsedTime((long)this.m_nElapsedTime);
        this.m_GeometryArray = (GeometryArray)this.m_Shape3D.getGeometry();
        if (!this.m_Shape3D.isLive() && !this.m_Shape3D.isCompiled()) {
            this.m_Shape3D.setCapability(14);
            this.m_Shape3D.setCapability(15);
            this.m_Shape3D.getAppearance().setCapability(19);
            this.m_Shape3D.getAppearance().setCapability(15);
            this.m_Shape3D.getAppearance().setCapability(11);
            this.m_Shape3D.getAppearance().setCapability(3);
            this.m_GeometryArray.setCapability(0);
            this.m_GeometryArray.setCapability(1);
            this.m_GeometryArray.setCapability(8);
        }
        this.m_Appearance = new Appearance();
        this.m_Appearance = (Appearance)this.m_Shape3D.getAppearance().cloneNodeComponent(true);
        this.m_CoordinateArray = new float[3 * this.m_GeometryArray.getVertexCount()];
        this.m_OriginalCoordinateArray = new float[3 * this.m_GeometryArray.getVertexCount()];
        this.m_GeometryArray.getCoordinates(0, this.m_OriginalCoordinateArray);
        this.setEnable(true);
        return this.m_InitialWakeupCondition;
    }

    public void initialize() {
        this.wakeupOn(this.m_InitialWakeupCondition);
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeUp = (WakeupCriterion)criteria.nextElement();
            if (wakeUp instanceof WakeupOnElapsedTime) continue;
            ++this.m_nFrameNumber;
            ++this.frame;
            this.m_GeometryArray.getCoordinates(0, this.m_CoordinateArray);
            Transform3D t3 = new Transform3D();
            for (int n = 0; n < this.m_CoordinateArray.length; n += 3) {
                this.m_Vector.x = this.m_OriginalCoordinateArray[n];
                this.m_Vector.y = this.m_OriginalCoordinateArray[n + 1];
                this.m_Vector.z = this.m_OriginalCoordinateArray[n + 2];
                float spx = (float)Math.sin((float)this.frame * 3.0f / 500.0f);
                float spy = (float)Math.cos((float)this.frame * 5.0f / 500.0f);
                Vector3f v = new Vector3f(spx, spy, 0.0f);
                float px = this.m_Vector.x - v.x;
                float py = this.m_Vector.y - v.y;
                float pz = this.m_Vector.z - v.z;
                float d = (float)Math.sqrt(px * px + py * py + pz * pz);
                this.m_Vector.add((Tuple3f)new Vector3f(-0.25f, -0.25f, -0.25f));
                t3.rotZ((double)d);
                t3.rotX((double)(d * 2.0f));
                t3.rotY((double)d);
                t3.transform(this.m_Vector);
                this.m_CoordinateArray[n] = this.m_Vector.x;
                this.m_CoordinateArray[n + 1] = this.m_Vector.y;
                this.m_CoordinateArray[n + 2] = this.m_Vector.z;
            }
            this.m_GeometryArray.setCoordinates(0, this.m_CoordinateArray);
        }
        if (this.m_nFrameNumber < this.m_nNumFrames) {
            this.wakeupOn(this.m_FrameWakeupCondition);
        } else {
            this.m_nFrameNumber = 0;
            this.wakeupOn(this.m_FrameWakeupCondition);
        }
    }
}

