/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.distort_glyph;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.distort_glyph.DistortBehavior;

public class DistortGlyphTest
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private JPanel drawingPanel;

    private static GraphicsConfiguration getGraphicsConfig() {
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        template.setSceneAntialiasing(2);
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
        return gcfg;
    }

    private void setupLights(BranchGroup root) {
        BoundingSphere bounds = new BoundingSphere(new Point3d(), 100.0);
        AmbientLight lightAmbient = new AmbientLight(new Color3f(0.37f, 0.37f, 0.37f));
        lightAmbient.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)lightAmbient);
        Vector3f lightDirection1 = new Vector3f(0.0f, 0.0f, -1.0f);
        DirectionalLight lightDirectional1 = new DirectionalLight(new Color3f(1.0f, 0.1f, 0.0f), lightDirection1);
        lightDirectional1.setInfluencingBounds((Bounds)bounds);
        lightDirectional1.setCapability(13);
        root.addChild((Node)lightDirectional1);
        Point3f lightPos1 = new Point3f(-4.0f, 8.0f, 16.0f);
        Point3f lightAttenuation1 = new Point3f(1.0f, 0.0f, 0.0f);
        PointLight pointLight1 = new PointLight(new Color3f(0.37f, 1.0f, 0.37f), lightPos1, lightAttenuation1);
        pointLight1.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)pointLight1);
        Point3f lightPos2 = new Point3f(-16.0f, 8.0f, 4.0f);
        Point3f lightAttenuation2 = new Point3f(1.0f, 0.0f, 0.0f);
        PointLight pointLight2 = new PointLight(new Color3f(0.37f, 0.37f, 1.0f), lightPos2, lightAttenuation2);
        pointLight2.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)pointLight2);
    }

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.setupLights(objRoot);
        TransformGroup objTransform = new TransformGroup();
        objTransform.setCapability(18);
        objTransform.setCapability(17);
        objRoot.addChild((Node)objTransform);
        Appearance app = new Appearance();
        Color3f objColor = new Color3f(1.0f, 0.7f, 0.8f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        app.setMaterial(new Material(objColor, black, objColor, black, 80.0f));
        Texture txtr = new TextureLoader(Resources.getResource("resources/images/gold.jpg"), (Component)this).getTexture();
        app.setTexture(txtr);
        TexCoordGeneration tcg = new TexCoordGeneration(2, 0);
        app.setTexCoordGeneration(tcg);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(0.01f, 0.01f);
        gp.lineTo(0.2f, 0.01f);
        gp.lineTo(0.21f, 0.0f);
        FontExtrusion fontEx = new FontExtrusion((Shape)gp);
        Font fnt = new Font("dialog", 1, 1);
        Font3D f3d = new Font3D(fnt, 0.001, fontEx);
        GeometryArray geom = f3d.getGlyphGeometry('A');
        Shape3D shape = new Shape3D((Geometry)geom, app);
        objTransform.addChild((Node)shape);
        DistortBehavior eb = new DistortBehavior(shape, 1000, 1000);
        eb.setSchedulingBounds((Bounds)new BoundingSphere());
        objTransform.addChild((Node)eb);
        MouseRotate myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(objTransform);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)myMouseRotate);
        MouseTranslate myMouseTranslate = new MouseTranslate();
        myMouseTranslate.setTransformGroup(objTransform);
        myMouseTranslate.setSchedulingBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)myMouseTranslate);
        MouseZoom myMouseZoom = new MouseZoom();
        myMouseZoom.setTransformGroup(objTransform);
        myMouseZoom.setSchedulingBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)myMouseZoom);
        objRoot.compile();
        return objRoot;
    }

    private Canvas3D createUniverse() {
        Canvas3D c = new Canvas3D(DistortGlyphTest.getGraphicsConfig());
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public DistortGlyphTest() {
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("DistortGlyphTest");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new DistortGlyphTest().setVisible(true);
            }
        });
    }
}

