/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.dot3;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URL;
import java.util.Enumeration;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.dot3.TextureControlPanel;

public class Dot3Demo
extends JFrame {
    private TextureControlPanel ctrlPanel = null;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    TextureUnitState tuLightMap;
    TextureUnitState tuDOT3NormalMap;
    TextureUnitState tuColor;
    TextureUnitState[] tusArr;
    Appearance appearance;
    PolygonAttributes polygonAttributes;
    Texture textureColor;
    Texture textureDOT3NormalMap;
    Texture2D textureLightMap;
    ImageComponent2D imageLightMap;
    String textureColorName = "resources/images/wood.jpg";
    String textureDOT3NormalMapName = "resources/images/Java3Ddot3.jpg";
    private BufferedImage tempImage;
    private boolean lockTempImage = false;

    public Dot3Demo() {
        super("Java3D DOT3 demo");
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setSize(new Dimension(400, 400));
        this.setDefaultCloseOperation(3);
        JPanel mainPanel = new JPanel();
        this.getContentPane().add((Component)mainPanel, null);
        mainPanel.setLayout(new BorderLayout());
        GraphicsConfiguration conf = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(conf);
        SimpleUniverse su = new SimpleUniverse(canvas);
        BranchGroup sceneGraph = this.createSceneGraph();
        su.addBranchGraph(sceneGraph);
        su.getViewingPlatform().setNominalViewingTransform();
        su.getViewer().getView().setMinimumFrameCycleTime(5L);
        ViewingPlatform viewingPlatform = su.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(canvas, 368);
        orbit.setSchedulingBounds((Bounds)this.bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        mainPanel.add((Component)canvas, "Center");
        this.setVisible(true);
        this.ctrlPanel = new TextureControlPanel(this);
        this.ctrlPanel.setVisible(true);
        this.ctrlPanel.setLocation(410, 10);
    }

    private void loadTextures() {
        try {
            URL urlColor = Resources.getResource(this.textureColorName);
            URL urlDot3 = Resources.getResource(this.textureDOT3NormalMapName);
            this.textureColor = new TextureLoader(urlColor, (Component)this).getTexture();
            this.textureDOT3NormalMap = new TextureLoader(urlDot3, (Component)this).getTexture();
            BufferedImage image = new BufferedImage(256, 256, 1);
            Graphics2D graphics = image.createGraphics();
            graphics.setPaint(new Color(130, 130, 250));
            graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
            graphics.dispose();
            this.imageLightMap = new ImageComponent2D(1, image, false, false);
            this.imageLightMap.setCapability(3);
            this.imageLightMap.setCapability(2);
            this.textureLightMap = new Texture2D(1, 5, 256, 256);
            this.textureLightMap.setImage(0, (ImageComponent)this.imageLightMap);
            this.textureLightMap.setMagFilter(1);
            this.textureLightMap.setMinFilter(1);
            this.textureLightMap.setCapability(1);
            this.textureLightMap.setCapability(0);
            this.textureLightMap.setCapability(7);
            this.textureLightMap.setCapability(4);
        }
        catch (Exception e) {
            System.err.println("Failed to load textures");
            e.printStackTrace();
        }
    }

    private TextureUnitState[] setupTextureUnitState() {
        TextureAttributes textAttDot3 = new TextureAttributes();
        TextureAttributes textAttLightMap = new TextureAttributes();
        TextureAttributes texAttColor = new TextureAttributes();
        texAttColor.setTextureMode(6);
        texAttColor.setCombineRgbMode(1);
        texAttColor.setCombineRgbScale(2);
        textAttDot3.setTextureMode(6);
        textAttDot3.setCombineRgbMode(6);
        textAttDot3.setCombineAlphaMode(6);
        textAttDot3.setTextureBlendColor(1.0f, 1.0f, 1.0f, 0.0f);
        textAttDot3.setCombineRgbScale(2);
        textAttDot3.setCombineRgbFunction(0, 0);
        textAttDot3.setCombineRgbFunction(1, 0);
        textAttDot3.setCombineRgbFunction(2, 0);
        textAttDot3.setCombineRgbSource(0, 3);
        textAttDot3.setCombineRgbSource(1, 1);
        textAttDot3.setCombineRgbSource(2, 0);
        TexCoordGeneration tcg1 = null;
        this.tuLightMap = new TextureUnitState((Texture)this.textureLightMap, textAttLightMap, tcg1);
        this.tuDOT3NormalMap = new TextureUnitState(this.textureDOT3NormalMap, textAttDot3, null);
        this.tuColor = new TextureUnitState(this.textureColor, texAttColor, null);
        TextureUnitState[] tus = new TextureUnitState[]{this.tuLightMap, this.tuDOT3NormalMap, this.tuColor};
        for (int i = 0; i < tus.length; ++i) {
            tus[i].setCapability(1);
            tus[i].setCapability(0);
        }
        return tus;
    }

    private GeometryArray createGeometry(float scale) {
        float[] verts = new float[]{2.0f, -1.0f, 0.0f, 2.0f, 1.0f, 0.0f, -2.0f, 1.0f, 0.0f, -2.0f, -1.0f, 0.0f};
        float[] texCoords = new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        int[] texCoordSetMap = new int[]{0, 0, 0, 0};
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f[] normals = new Vector3f[]{normal, normal, normal, normal};
        int i = 0;
        while (i < verts.length) {
            int n = i++;
            verts[n] = verts[n] * scale;
        }
        GeometryInfo gi = new GeometryInfo(2);
        gi.setCoordinates(verts);
        gi.setNormals(normals);
        gi.setTextureCoordinateParams(4, 2);
        gi.setTexCoordSetMap(texCoordSetMap);
        gi.setTextureCoordinates(0, texCoords);
        gi.setTextureCoordinates(1, texCoords);
        gi.setTextureCoordinates(2, texCoords);
        gi.setTextureCoordinates(3, texCoords);
        return gi.getGeometryArray();
    }

    private BranchGroup createSceneGraph() {
        BranchGroup bgRoot = new BranchGroup();
        CheckNewLightMapBehavior checkNewLightMapBehavior = new CheckNewLightMapBehavior();
        bgRoot.addChild((Node)checkNewLightMapBehavior);
        Background background = new Background(0.4f, 0.4f, 0.8f);
        background.setApplicationBounds((Bounds)this.bounds);
        bgRoot.addChild((Node)background);
        AmbientLight alit = new AmbientLight(true, new Color3f(0.4f, 0.4f, 0.4f));
        bgRoot.addChild((Node)alit);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
        Color3f light2Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)this.bounds);
        bgRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)this.bounds);
        bgRoot.addChild((Node)light2);
        this.loadTextures();
        GeometryArray geo = this.createGeometry(0.4f);
        this.appearance = new Appearance();
        this.appearance.setCapability(14);
        this.appearance.setCapability(15);
        this.appearance.setCapability(20);
        this.appearance.setCapability(21);
        this.appearance.setMaterial(new Material());
        this.polygonAttributes = new PolygonAttributes();
        this.polygonAttributes.setCapability(3);
        this.polygonAttributes.setCullFace(0);
        this.appearance.setPolygonAttributes(this.polygonAttributes);
        this.tusArr = this.setupTextureUnitState();
        this.appearance.setTextureUnitState(this.tusArr);
        Shape3D shape3D = new Shape3D((Geometry)geo, this.appearance);
        shape3D.setCapability(14);
        shape3D.setCapability(15);
        bgRoot.addChild((Node)shape3D);
        bgRoot.compile();
        return bgRoot;
    }

    public void setWireframeMode(boolean mode) {
        if (mode) {
            this.polygonAttributes.setPolygonMode(1);
        } else {
            this.polygonAttributes.setPolygonMode(2);
        }
    }

    public void showTextures(boolean showLightMap, boolean showDot3, boolean showColor) {
        int bitSet = 0;
        bitSet |= showLightMap ? 4 : 0;
        bitSet |= showDot3 ? 2 : 0;
        int n = showColor ? 1 : 0;
        this.tusArr[0] = null;
        this.tusArr[1] = null;
        this.tusArr[2] = null;
        switch (bitSet |= n) {
            case 7: {
                this.tusArr[0] = this.tuLightMap;
                this.tusArr[1] = this.tuDOT3NormalMap;
                this.tusArr[2] = this.tuColor;
                break;
            }
            case 6: {
                this.tusArr[0] = this.tuLightMap;
                this.tusArr[1] = this.tuDOT3NormalMap;
                break;
            }
            case 5: {
                this.tusArr[0] = this.tuLightMap;
                this.tusArr[1] = this.tuColor;
                break;
            }
            case 4: {
                this.tusArr[0] = this.tuLightMap;
                break;
            }
            case 3: {
                this.tusArr[0] = this.tuDOT3NormalMap;
                this.tusArr[1] = this.tuColor;
                break;
            }
            case 2: {
                this.tusArr[0] = this.tuDOT3NormalMap;
                break;
            }
            case 1: {
                this.tusArr[0] = this.tuColor;
                break;
            }
        }
        this.appearance.setTextureUnitState(this.tusArr);
    }

    public void updateLighMap(BufferedImage image) {
        this.imageLightMap.setSubImage((RenderedImage)image, image.getWidth(), image.getHeight(), 0, 0, 0, 0);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new Dot3Demo();
            }
        });
    }

    class CheckNewLightMapBehavior
    extends Behavior {
        WakeupOnElapsedFrames wakeup = new WakeupOnElapsedFrames(0);

        public CheckNewLightMapBehavior() {
            this.setEnable(true);
            this.setSchedulingBounds((Bounds)Dot3Demo.this.bounds);
        }

        public void initialize() {
            this.wakeupOn((WakeupCondition)this.wakeup);
        }

        public void processStimulus(Enumeration e) {
            if (Dot3Demo.this.ctrlPanel.hasTextureImageReady()) {
                Dot3Demo.this.updateLighMap(Dot3Demo.this.ctrlPanel.getTextureImage());
            }
            this.wakeupOn((WakeupCondition)this.wakeup);
        }
    }
}

