/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.dot3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class MyCanvas
extends JPanel
implements MouseInputListener {
    BufferedImage lightMask = null;
    BufferedImage textureImage = null;
    Graphics2D gr = null;
    Point location = new Point();
    Color bgColor = new Color(147, 147, 147);
    int x = 0;
    int y = 0;
    int z = 142;
    private static final int textureSize = 256;
    boolean mouseOut = true;
    boolean imageReady = false;
    boolean dragMask = false;
    boolean updateLightDir = false;
    boolean updateMaskPosition = false;

    public MyCanvas(BufferedImage mask) {
        this.lightMask = mask;
        this.setTextureImage(new BufferedImage(256, 256, 1));
        this.gr = this.getTextureImage().createGraphics();
        Dimension dimSize = new Dimension(256, 256);
        this.setSize(dimSize);
        this.setMaximumSize(dimSize);
        this.setMinimumSize(dimSize);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent ev) {
        this.x = ev.getX();
        this.y = this.getHeight() - ev.getY();
        this.updateLightDir = true;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent ev) {
        block4: {
            block6: {
                block5: {
                    if (this.mouseOut) break block4;
                    this.x = ev.getX();
                    this.y = this.getHeight() - ev.getY();
                    if ((ev.getModifiers() & 0x10) == 16) {
                        this.updateLightDir = true;
                        this.updateMaskPosition = false;
                    }
                    if ((ev.getModifiers() & 8) == 8) break block5;
                    if ((ev.getModifiers() & 4) != 4) break block6;
                }
                this.updateLightDir = false;
                this.updateMaskPosition = true;
            }
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent ev) {
        this.updateLightDir = false;
        this.updateMaskPosition = false;
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseOut = false;
    }

    public void mouseExited(MouseEvent e) {
        this.mouseOut = true;
    }

    public void paintComponent(Graphics g) {
        this.imageReady = false;
        Graphics2D g2d = (Graphics2D)g;
        if (this.updateLightDir) {
            int blue = this.bgColor.getBlue();
            this.y = this.y > 255 ? 255 : this.y;
            this.x = this.x > 255 ? 255 : this.x;
            this.bgColor = new Color(this.y, this.x, blue);
        }
        this.gr.setColor(this.bgColor);
        this.gr.fillRect(0, 0, 256, 256);
        if (this.dragMask || this.updateMaskPosition) {
            int maskWH = this.lightMask.getWidth() / 2;
            int mx = this.x - maskWH;
            int my = 256 - this.y - maskWH;
            mx = mx > 256 ? 256 : mx;
            my = my > 256 ? 256 : my;
            this.gr.drawImage((Image)this.lightMask, mx, my, this);
        }
        g2d.drawImage((Image)this.getTextureImage(), 0, 0, this);
        this.imageReady = true;
    }

    public boolean hasTextureImageReady() {
        return this.imageReady;
    }

    public BufferedImage getTextureImage() {
        this.imageReady = false;
        return this.textureImage;
    }

    public Image getMask() {
        return this.lightMask;
    }

    public void setLightMask(BufferedImage mask) {
        this.lightMask = mask;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setTextureImage(BufferedImage textureImage) {
        this.textureImage = textureImage;
    }
}

