/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.dot3;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.dot3.Dot3Demo;
import org.jdesktop.j3d.examples.dot3.MyCanvas;

public class TextureControlPanel
extends JDialog
implements ChangeListener,
ActionListener {
    private MyCanvas canvas = null;
    private String maskFileName = "resources/images/mask.png";
    private JSlider sliderZ = new JSlider(0, 1, 255, 142);
    private Dot3Demo dot3DemoFrame;
    private JCheckBox cbWireframe = new JCheckBox("Show as Wireframe", false);
    private JCheckBox cbDot3 = new JCheckBox("Show Dot3 texture", true);
    private JCheckBox cbShowLightMap = new JCheckBox("Show LightMap texture", true);
    private JCheckBox cbShowColor = new JCheckBox("Show Color texture", true);
    private JCheckBox cbDragLightMask = new JCheckBox("Drag light mask");
    private JLabel lbSliderZ = new JLabel();
    private JLabel lbMessage = new JLabel();

    public TextureControlPanel(Dot3Demo owner) {
        super(owner);
        this.dot3DemoFrame = owner;
        try {
            URL url = Resources.getResource(this.maskFileName);
            BufferedImage mask = ImageIO.read(url);
            this.canvas = new MyCanvas(mask);
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TextureControlPanel() {
        this((Dot3Demo)null);
    }

    private void init() throws Exception {
        Dimension dim = new Dimension(540, 350);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setTitle("DOT3Demo Texture Control Panel");
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        this.canvas.setSize(new Dimension(256, 256));
        this.canvas.setBounds(new Rectangle(40, 40, 256, 256));
        this.sliderZ.setBounds(new Rectangle(310, 190, 205, 45));
        this.sliderZ.setPaintTicks(true);
        this.sliderZ.setMajorTickSpacing(63);
        this.cbWireframe.setBounds(new Rectangle(310, 50, 200, 20));
        this.cbWireframe.setToolTipText("Toggles Wireframe");
        this.cbDot3.setBounds(new Rectangle(310, 70, 150, 20));
        this.cbShowLightMap.setBounds(new Rectangle(310, 90, 200, 20));
        this.cbShowLightMap.setToolTipText("Toggles DOT3 texture");
        this.cbShowColor.setBounds(new Rectangle(310, 110, 200, 20));
        this.cbShowColor.setToolTipText("Toggles Color texture");
        panel.setLayout(null);
        this.cbDragLightMask.setBounds(new Rectangle(310, 135, 200, 20));
        this.lbMessage.setText("<html>Left-click and drag to change Light Direction. Right-click and drag to move spotlight.</html>");
        this.lbMessage.setBounds(new Rectangle(305, 245, 210, 60));
        this.lbSliderZ.setText("Blue Light (Dot3 Z axis)");
        this.lbSliderZ.setBounds(new Rectangle(310, 170, 210, 15));
        this.lbSliderZ.setToolTipText("changes light intensity from Z axis");
        panel.add((Component)this.cbDragLightMask, null);
        panel.add((Component)this.lbMessage, null);
        panel.add((Component)this.lbSliderZ, null);
        panel.add((Component)this.sliderZ, null);
        panel.add((Component)this.canvas, null);
        panel.add((Component)this.cbShowColor, null);
        panel.add((Component)this.cbShowLightMap, null);
        panel.add((Component)this.cbWireframe, null);
        panel.add((Component)this.cbDot3, null);
        this.sliderZ.addChangeListener(this);
        this.cbDot3.addActionListener(this);
        this.cbShowColor.addActionListener(this);
        this.cbShowLightMap.addActionListener(this);
        this.cbWireframe.addActionListener(this);
        this.cbDragLightMask.addActionListener(this);
    }

    public void stateChanged(ChangeEvent ev) {
        JComponent source = (JComponent)ev.getSource();
        if (this.sliderZ.equals(source)) {
            int xVal = this.canvas.getBgColor().getRed();
            int yVal = this.canvas.getBgColor().getGreen();
            int zVal = this.sliderZ.getValue();
            Color ligtDir = new Color(xVal, yVal, zVal);
            this.updateLightMap(ligtDir);
        }
    }

    private void updateLightMap(Color ligtDir) {
        this.canvas.setBgColor(ligtDir);
        this.canvas.repaint();
        this.dot3DemoFrame.updateLighMap(this.canvas.getTextureImage());
    }

    public void actionPerformed(ActionEvent ev) {
        JComponent source = (JComponent)ev.getSource();
        if (this.cbWireframe.equals(source)) {
            this.dot3DemoFrame.setWireframeMode(this.cbWireframe.isSelected());
        } else if (this.cbDot3.equals(source) || this.cbShowColor.equals(source) || this.cbShowLightMap.equals(source)) {
            this.dot3DemoFrame.showTextures(this.cbShowLightMap.isSelected(), this.cbDot3.isSelected(), this.cbShowColor.isSelected());
        } else if (this.cbDragLightMask.equals(source)) {
            this.canvas.dragMask = this.cbDragLightMask.isSelected();
        }
    }

    public boolean hasTextureImageReady() {
        return this.canvas.hasTextureImageReady();
    }

    public BufferedImage getTextureImage() {
        return this.canvas.getTextureImage();
    }

    public void setLightMask(BufferedImage mask) {
        this.canvas.setLightMask(mask);
    }
}

