/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.four_by_four;

import com.sun.j3d.utils.geometry.Sphere;
import java.util.BitSet;
import javax.media.j3d.Appearance;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.four_by_four.BigCube;
import org.jdesktop.j3d.examples.four_by_four.Board;
import org.jdesktop.j3d.examples.four_by_four.ID;

public class Positions {
    static final int UNOCCUPIED = 0;
    static final int HUMAN = 1;
    static final int MACHINE = 2;
    static final int END = 3;
    private Vector3f[] point;
    private Switch posSwitch;
    private Switch humanSwitch;
    private Switch machineSwitch;
    private BitSet posMask;
    private BitSet humanMask;
    private BitSet machineMask;
    private Group group;
    private Material redMat;
    private Material blueMat;
    private Material yellowMat;
    private Material whiteMat;
    private Appearance redApp;
    private Appearance blueApp;
    private Appearance yellowApp;
    private Appearance whiteApp;
    private Board board;
    private Sphere[] posSphere;
    private BigCube[] cube;
    private TransformGroup tgroup;
    private boolean winnerFlag = false;

    public Positions() {
        int i;
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f red = new Color3f(0.9f, 0.1f, 0.2f);
        Color3f blue = new Color3f(0.3f, 0.3f, 0.8f);
        Color3f yellow = new Color3f(1.0f, 1.0f, 0.0f);
        Color3f ambRed = new Color3f(0.3f, 0.03f, 0.03f);
        Color3f ambBlue = new Color3f(0.03f, 0.03f, 0.3f);
        Color3f ambYellow = new Color3f(0.3f, 0.3f, 0.03f);
        Color3f ambWhite = new Color3f(0.3f, 0.3f, 0.3f);
        Color3f specular = new Color3f(1.0f, 1.0f, 1.0f);
        this.redMat = new Material(ambRed, black, red, specular, 100.0f);
        this.redMat.setLightingEnable(true);
        this.redApp = new Appearance();
        this.redApp.setMaterial(this.redMat);
        this.blueMat = new Material(ambBlue, black, blue, specular, 100.0f);
        this.blueMat.setLightingEnable(true);
        this.blueApp = new Appearance();
        this.blueApp.setMaterial(this.blueMat);
        this.yellowMat = new Material(ambYellow, black, yellow, specular, 100.0f);
        this.yellowMat.setLightingEnable(true);
        this.yellowApp = new Appearance();
        this.yellowApp.setMaterial(this.yellowMat);
        this.whiteMat = new Material(ambWhite, black, white, specular, 100.0f);
        this.whiteMat.setLightingEnable(true);
        this.whiteApp = new Appearance();
        this.whiteApp.setMaterial(this.whiteMat);
        this.point = new Vector3f[64];
        int count = 0;
        for (i = -30; i < 40; i += 20) {
            for (int j = -30; j < 40; j += 20) {
                for (int k = -30; k < 40; k += 20) {
                    this.point[count] = new Vector3f((float)k, (float)j, (float)i);
                    ++count;
                }
            }
        }
        this.posSwitch = new Switch(-3);
        this.humanSwitch = new Switch(-3);
        this.machineSwitch = new Switch(-3);
        this.posSwitch.setCapability(17);
        this.posSwitch.setCapability(18);
        this.humanSwitch.setCapability(17);
        this.humanSwitch.setCapability(18);
        this.machineSwitch.setCapability(17);
        this.machineSwitch.setCapability(18);
        this.posMask = new BitSet();
        this.humanMask = new BitSet();
        this.machineMask = new BitSet();
        this.posSphere = new Sphere[64];
        for (i = 0; i < 64; ++i) {
            Transform3D transform3D = new Transform3D();
            transform3D.set(this.point[i]);
            TransformGroup transformGroup = new TransformGroup(transform3D);
            this.posSphere[i] = new Sphere(2.0f, 65, 12, this.whiteApp);
            Shape3D shape = this.posSphere[i].getShape();
            ID id = new ID(i);
            shape.setUserData((Object)id);
            transformGroup.addChild((Node)this.posSphere[i]);
            this.posSwitch.addChild((Node)transformGroup);
            this.posMask.set(i);
        }
        for (i = 0; i < 64; ++i) {
            Transform3D transform3D = new Transform3D();
            transform3D.set(this.point[i]);
            TransformGroup transformGroup = new TransformGroup(transform3D);
            transformGroup.addChild((Node)new Sphere(7.0f, this.redApp));
            this.humanSwitch.addChild((Node)transformGroup);
            this.humanMask.clear(i);
        }
        for (i = 0; i < 64; ++i) {
            Transform3D transform3D = new Transform3D();
            transform3D.set(this.point[i]);
            TransformGroup transformGroup = new TransformGroup(transform3D);
            BigCube cube = new BigCube(this.blueApp);
            transformGroup.addChild((Node)cube.getChild());
            this.machineSwitch.addChild((Node)transformGroup);
            this.machineMask.clear(i);
        }
        this.posSwitch.setChildMask(this.posMask);
        this.humanSwitch.setChildMask(this.humanMask);
        this.machineSwitch.setChildMask(this.machineMask);
        this.group = new Group();
        this.group.addChild((Node)this.posSwitch);
        this.group.addChild((Node)this.humanSwitch);
        this.group.addChild((Node)this.machineSwitch);
    }

    public void setTransformGroup(TransformGroup transformGroup) {
        this.tgroup = transformGroup;
    }

    public Group getChild() {
        return this.group;
    }

    public void setBoard(Board board) {
        this.board = board;
    }

    public void winner() {
        this.winnerFlag = true;
    }

    public void noWinner() {
        this.winnerFlag = false;
    }

    public void setHighlight(int pos) {
        this.posSphere[pos].setAppearance(this.yellowApp);
    }

    public void clearHighlight(int pos) {
        this.posSphere[pos].setAppearance(this.whiteApp);
    }

    public void newGame() {
        for (int i = 0; i < 64; ++i) {
            this.posMask.set(i);
            this.humanMask.clear(i);
            this.machineMask.clear(i);
        }
        this.posSwitch.setChildMask(this.posMask);
        this.humanSwitch.setChildMask(this.humanMask);
        this.machineSwitch.setChildMask(this.machineMask);
        Transform3D t = new Transform3D();
        this.tgroup.getTransform(t);
        this.tgroup.setTransform(t);
        this.winnerFlag = false;
    }

    public void set(int pos, int player) {
        if (this.winnerFlag) {
            return;
        }
        if (player == 1 && !this.board.unoccupied(pos)) {
            return;
        }
        this.posMask.clear(pos);
        this.posSwitch.setChildMask(this.posMask);
        if (player == 1) {
            this.humanMask.set(pos);
            this.humanSwitch.setChildMask(this.humanMask);
            this.board.selection(pos, 1);
        } else {
            this.machineMask.set(pos);
            this.machineSwitch.setChildMask(this.machineMask);
        }
        Transform3D t = new Transform3D();
        this.tgroup.getTransform(t);
        this.tgroup.setTransform(t);
    }

    public void clear(int pos) {
        this.posMask.set(pos);
        this.posSwitch.setChildMask(this.posMask);
        this.humanMask.clear(pos);
        this.humanSwitch.setChildMask(this.humanMask);
        this.machineMask.clear(pos);
        this.machineSwitch.setChildMask(this.machineMask);
        Transform3D t = new Transform3D();
        this.tgroup.getTransform(t);
        this.tgroup.setTransform(t);
    }
}

