/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.fps_counter;

import java.text.NumberFormat;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;

public class FPSCounter
extends Behavior {
    WakeupOnElapsedFrames FPSwakeup = new WakeupOnElapsedFrames(0);
    private static final long testduration = 1000L;
    private static final long sampleduration = 10000L;
    private boolean doCalibration = true;
    private boolean startup = true;
    private boolean warmup = true;
    private long warmupTime = 20000L;
    private int numframes = 0;
    private int maxframes = 1;
    private long startuptime = 0L;
    private long currtime = 0L;
    private long lasttime = 0L;
    private long deltatime;
    private boolean finiteLoop = false;
    private long maxLoops;
    private long numLoops = 0L;
    private int sumFrames = 0;
    private long sumTimes = 0L;
    private int loop = 0;
    private int loopCount = 5;
    private double sumFps = 0.0;
    private String[] symbol = new String[]{"\\", "|", "|", "/", "-", "|", "-"};
    int index = 0;
    private NumberFormat nf = null;

    public FPSCounter() {
        this.setEnable(true);
        this.nf = NumberFormat.getNumberInstance();
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.FPSwakeup);
    }

    public void processStimulus(Enumeration critera) {
        if (this.doCalibration) {
            if (this.startup) {
                this.startuptime = System.currentTimeMillis();
                this.startup = false;
            } else if (this.warmup) {
                System.out.print("\rFPSCounter warming up..." + this.symbol[this.index++ % this.symbol.length]);
                this.currtime = System.currentTimeMillis();
                this.deltatime = this.currtime - this.startuptime;
                if (this.deltatime > this.warmupTime) {
                    this.warmup = false;
                    this.lasttime = System.currentTimeMillis();
                    System.out.println("\rFPSCounter warming up...Done");
                }
            } else {
                ++this.numframes;
                if (this.numframes >= this.maxframes) {
                    this.currtime = System.currentTimeMillis();
                    this.deltatime = this.currtime - this.lasttime;
                    if (this.deltatime > 1000L) {
                        this.maxframes = (int)Math.ceil((double)this.numframes * (10000.0 / (double)this.deltatime));
                        this.doCalibration = false;
                        this.numframes = 0;
                        this.lasttime = System.currentTimeMillis();
                    } else {
                        this.maxframes *= 2;
                    }
                }
            }
        } else {
            ++this.numframes;
            if (this.numframes >= this.maxframes) {
                this.currtime = System.currentTimeMillis();
                this.deltatime = this.currtime - this.lasttime;
                double fps = (double)this.numframes / ((double)this.deltatime / 1000.0);
                System.out.println("Frame Rate : \n\tNo. of frames : " + this.numframes + "\n\tTime : " + (double)this.deltatime / 1000.0 + " sec." + "\n\tFrames/sec : " + this.nf.format(fps));
                this.sumFrames += this.numframes;
                this.sumTimes += this.deltatime;
                this.sumFps += fps;
                ++this.loop;
                if (this.loop >= this.loopCount) {
                    double avgFps = (double)this.sumFrames * 1000.0 / (double)this.sumTimes;
                    double ravgFps = this.sumFps / (double)this.loopCount;
                    System.out.println("Aggregate frame rate " + this.nf.format(avgFps) + " frames/sec");
                    System.out.println("Average frame rate " + this.nf.format(ravgFps) + " frames/sec");
                    ++this.numLoops;
                    if (this.finiteLoop && this.numLoops >= this.maxLoops) {
                        System.out.println("************** The End **************\n");
                        this.setEnable(false);
                    }
                    this.loop = 0;
                    this.sumFps = 0.0;
                }
                this.numframes = 0;
                this.lasttime = System.currentTimeMillis();
            }
        }
        this.wakeupOn((WakeupCondition)this.FPSwakeup);
    }

    public void setWarmupTime(long wt) {
        this.warmupTime = wt;
    }

    public void setLoopCount(int lc) {
        this.loopCount = lc;
    }

    public void setMaxLoops(int ml) {
        this.maxLoops = ml;
        this.finiteLoop = true;
    }
}

