/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.fps_counter;

import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import org.jdesktop.j3d.examples.fps_counter.FPSCounter;

public class FPSCounterDemo
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private FPSCounter fpsCounter = new FPSCounter();
    private JPanel drawingPanel;

    BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        objTrans.addChild((Node)new ColorCube(0.4));
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 4000L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)rotator);
        this.fpsCounter.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)this.fpsCounter);
        return objRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        return c;
    }

    public FPSCounterDemo() {
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
        JOptionPane.showMessageDialog(this, "This program measures the number of frames rendered per second.\nNote that the frame rate is limited by the refresh rate of the monitor.\nTo get the true frame rate you need to disable vertical retrace.\n\nOn Windows(tm) you do this through the Control Panel.\n\nOn Solaris set the environment variable OGL_NO_VBLANK", "Frame Counter", 1);
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            if (args[i].startsWith("w", 1)) {
                System.out.println("Warmup time : " + args[++i]);
                int w = new Integer(args[i]);
                this.fpsCounter.setWarmupTime(w);
                continue;
            }
            if (args[i].startsWith("l", 1)) {
                System.out.println("Loop count : " + args[++i]);
                int l = new Integer(args[i]);
                this.fpsCounter.setLoopCount(l);
                continue;
            }
            if (args[i].startsWith("m", 1)) {
                System.out.println("Max Loop Count : " + args[++i]);
                int m = new Integer(args[i]);
                this.fpsCounter.setMaxLoops(m);
                continue;
            }
            if (!args[i].startsWith("h", 1)) continue;
            System.out.println("Usage : FPSCounterDemo [-name value]\nAll arguments are of the form: -name value. All -name arguments can be\nshortened to one character. All the value arguments take a number. The\narguments accepted are:\n\n    -warmupTime : Specifies amount of time the FPSCounter should wait\n        for the HotSpot(tm) VM to perform initial\n        optimizations. Specified in milliseconds\n\n    -loopCount : Specifies the number of sampling intervals over which\n        the FPSCounter should calculate the aggregate and average\n        frame rate. Specified as a count\n\n    -maxLoops : Specifies that the FPSCounter should run for only these\n        many sampling intervals. Specified as number. If this argument\n        is not specified, the FPSCounter runs indefinitely.\n\n    -help : Prints this message.");
        }
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("FPSCounterDemo");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(250, 250));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FPSCounterDemo fp = new FPSCounterDemo();
                fp.parseArgs(args);
                fp.setVisible(true);
            }
        });
    }
}

