/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.gears;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.gears.SpurGearThinBody;

public class GearTest
extends JFrame {
    private int toothCount = 24;
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private JPanel drawingPanel;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        objScale.addChild((Node)bgNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(4.0f, -7.0f, -12.0f);
        Color3f light2Color = new Color3f(0.3f, 0.3f, 0.4f);
        Vector3f light2Direction = new Vector3f(-6.0f, -2.0f, -1.0f);
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)ambientLightNode);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)light2);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objScale.addChild((Node)objTrans);
        Appearance look = new Appearance();
        Color3f objColor = new Color3f(0.5f, 0.5f, 0.6f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        look.setMaterial(new Material(objColor, black, objColor, white, 100.0f));
        SpurGearThinBody gear = new SpurGearThinBody(this.toothCount, 1.0f, 0.2f, 0.05f, 0.05f, 0.3f, 0.28f, look);
        objTrans.addChild((Node)gear);
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 8000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        objRoot.compile();
        return objRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public GearTest(String[] args) {
        if (args.length > 1) {
            System.out.println("Usage: java GearTest [#teeth]");
            System.exit(0);
        } else if (args.length == 1) {
            int value;
            try {
                value = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                System.out.println("Illegal integer specified");
                System.out.println("Usage: java GearTest [#teeth]");
                value = 0;
                System.exit(0);
            }
            if (value <= 0) {
                System.out.println("Integer must be positive (> 0)");
                System.out.println("Usage: java GearBox [#teeth]");
                System.exit(0);
            }
            this.toothCount = value;
        }
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("GearTest");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                GearTest gt = new GearTest(args);
                gt.setVisible(true);
            }
        });
    }
}

