/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.gears;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Shaft
extends TransformGroup {
    public Shaft(float radius, float length, int segmentCount, Appearance look) {
        int shaftVertexCount;
        double tempAngle;
        int shaftFaceVertexCount;
        float frontZ = -0.5f * length;
        float rearZ = 0.5f * length;
        int[] shaftFaceStripCount = new int[1];
        int[] shaftStripCount = new int[1];
        Vector3f frontNormal = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f rearNormal = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f outNormal = new Vector3f(1.0f, 0.0f, 0.0f);
        Point3f coordinate = new Point3f(0.0f, 0.0f, 0.0f);
        double segmentAngle = Math.PI * 2 / (double)segmentCount;
        this.setCapability(18);
        shaftFaceStripCount[0] = shaftFaceVertexCount = segmentCount + 2;
        TriangleFanArray frontShaftFace = new TriangleFanArray(shaftFaceVertexCount, 3, shaftFaceStripCount);
        TriangleFanArray rearShaftFace = new TriangleFanArray(shaftFaceVertexCount, 3, shaftFaceStripCount);
        coordinate.set(0.0f, 0.0f, frontZ);
        frontShaftFace.setCoordinate(0, coordinate);
        frontShaftFace.setNormal(0, frontNormal);
        coordinate.set(0.0f, 0.0f, rearZ);
        rearShaftFace.setCoordinate(0, coordinate);
        rearShaftFace.setNormal(0, rearNormal);
        for (int index = 1; index < segmentCount + 2; ++index) {
            tempAngle = segmentAngle * -((double)index);
            coordinate.set(radius * (float)Math.cos(tempAngle), radius * (float)Math.sin(tempAngle), frontZ);
            frontShaftFace.setCoordinate(index, coordinate);
            frontShaftFace.setNormal(index, frontNormal);
            tempAngle = -tempAngle;
            coordinate.set(radius * (float)Math.cos(tempAngle), radius * (float)Math.sin(tempAngle), rearZ);
            rearShaftFace.setCoordinate(index, coordinate);
            rearShaftFace.setNormal(index, rearNormal);
        }
        Shape3D newShape = new Shape3D((Geometry)frontShaftFace, look);
        this.addChild((Node)newShape);
        newShape = new Shape3D((Geometry)rearShaftFace, look);
        this.addChild((Node)newShape);
        shaftStripCount[0] = shaftVertexCount = 2 * segmentCount + 2;
        TriangleStripArray shaft = new TriangleStripArray(shaftVertexCount, 3, shaftStripCount);
        outNormal.set(1.0f, 0.0f, 0.0f);
        coordinate.set(radius, 0.0f, rearZ);
        shaft.setCoordinate(0, coordinate);
        shaft.setNormal(0, outNormal);
        coordinate.set(radius, 0.0f, frontZ);
        shaft.setCoordinate(1, coordinate);
        shaft.setNormal(1, outNormal);
        for (int count = 0; count < segmentCount; ++count) {
            int index = 2 + count * 2;
            tempAngle = segmentAngle * (double)(count + 1);
            float xDirection = (float)Math.cos(tempAngle);
            float yDirection = (float)Math.sin(tempAngle);
            float xShaft = radius * xDirection;
            float yShaft = radius * yDirection;
            outNormal.set(xDirection, yDirection, 0.0f);
            coordinate.set(xShaft, yShaft, rearZ);
            shaft.setCoordinate(index, coordinate);
            shaft.setNormal(index, outNormal);
            coordinate.set(xShaft, yShaft, frontZ);
            shaft.setCoordinate(index + 1, coordinate);
            shaft.setNormal(index + 1, outNormal);
        }
        newShape = new Shape3D((Geometry)shaft, look);
        this.addChild((Node)newShape);
    }
}

