/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.gears;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.gears.Gear;

public class SpurGear
extends Gear {
    float toothTopAngleIncrement;
    float toothDeclineAngleIncrement;
    float rootRadius;
    float outsideRadius;
    float circularToothEdgeAngle;
    float circularToothFlatAngle;

    SpurGear(int toothCount, float pitchCircleRadius, float addendum, float dedendum, float toothToValleyAngleRatio) {
        super(toothCount);
        this.circularPitchAngle = (float)(Math.PI * 2 / (double)toothCount);
        this.circularToothFlatAngle = this.circularPitchAngle * toothToValleyAngleRatio;
        this.toothTopAngleIncrement = this.circularToothEdgeAngle = this.circularPitchAngle / 2.0f - this.circularToothFlatAngle;
        this.toothDeclineAngleIncrement = this.toothTopAngleIncrement + this.circularToothFlatAngle;
        this.toothValleyAngleIncrement = this.toothDeclineAngleIncrement + this.circularToothEdgeAngle;
        this.toothTopCenterAngle = this.toothTopAngleIncrement + this.circularToothFlatAngle / 2.0f;
        this.valleyCenterAngle = this.toothValleyAngleIncrement + this.circularToothFlatAngle / 2.0f;
        this.gearStartAngle = -1.0 * (double)this.toothTopCenterAngle;
        this.rootRadius = pitchCircleRadius - dedendum;
        this.outsideRadius = pitchCircleRadius + addendum;
        this.setCapability(18);
    }

    public SpurGear(int toothCount, float pitchCircleRadius, float shaftRadius, float addendum, float dedendum, float gearThickness) {
        this(toothCount, pitchCircleRadius, shaftRadius, addendum, dedendum, gearThickness, gearThickness, 0.25f, null);
    }

    public SpurGear(int toothCount, float pitchCircleRadius, float shaftRadius, float addendum, float dedendum, float gearThickness, Appearance look) {
        this(toothCount, pitchCircleRadius, shaftRadius, addendum, dedendum, gearThickness, gearThickness, 0.25f, look);
    }

    public SpurGear(int toothCount, float pitchCircleRadius, float shaftRadius, float addendum, float dedendum, float gearThickness, float toothTipThickness, Appearance look) {
        this(toothCount, pitchCircleRadius, shaftRadius, addendum, dedendum, gearThickness, toothTipThickness, 0.25f, look);
    }

    public SpurGear(int toothCount, float pitchCircleRadius, float shaftRadius, float addendum, float dedendum, float gearThickness, float toothTipThickness, float toothToValleyAngleRatio, Appearance look) {
        this(toothCount, pitchCircleRadius, addendum, dedendum, toothToValleyAngleRatio);
        this.addBodyDisks(shaftRadius, this.rootRadius, gearThickness, look);
        this.addCylinderSkins(shaftRadius, gearThickness, -1, look);
        this.addTeeth(pitchCircleRadius, this.rootRadius, this.outsideRadius, gearThickness, toothTipThickness, toothToValleyAngleRatio, look);
    }

    void addTeeth(float pitchCircleRadius, float rootRadius, float outsideRadius, float gearThickness, float toothTipThickness, float toothToValleyAngleRatio, Appearance look) {
        int topVertexCount;
        float yRoot3;
        float xRoot3;
        float yOuter2;
        float xOuter2;
        float yOuter1;
        float xOuter1;
        float yRoot0;
        float xRoot0;
        double toothValleyStartAngle;
        double toothDeclineStartAngle;
        double toothTopStartAngle;
        double toothStartAngle;
        int index;
        float frontZ = -0.5f * gearThickness;
        float rearZ = 0.5f * gearThickness;
        float toothTipFrontZ = -0.5f * toothTipThickness;
        float toothTipRearZ = 0.5f * toothTipThickness;
        int[] toothFaceStripCount = new int[this.toothCount];
        int[] topStripCount = new int[1];
        Vector3f frontToothNormal = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f rearToothNormal = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f leftNormal = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f rightNormal = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f outNormal = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f inNormal = new Vector3f(-1.0f, 0.0f, 0.0f);
        Point3f coordinate = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f tempCoordinate1 = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f tempCoordinate2 = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f tempCoordinate3 = new Point3f(0.0f, 0.0f, 0.0f);
        Vector3f tempVector1 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f tempVector2 = new Vector3f(0.0f, 0.0f, 0.0f);
        int toothFacetVertexCount = 4;
        int toothFaceTotalVertexCount = toothFacetVertexCount * this.toothCount;
        for (int i = 0; i < this.toothCount; ++i) {
            toothFaceStripCount[i] = toothFacetVertexCount;
        }
        TriangleStripArray frontGearTeeth = new TriangleStripArray(toothFaceTotalVertexCount, 3, toothFaceStripCount);
        for (int count = 0; count < this.toothCount; ++count) {
            index = count * toothFacetVertexCount;
            toothStartAngle = this.gearStartAngle + (double)this.circularPitchAngle * (double)count;
            toothTopStartAngle = toothStartAngle + (double)this.toothTopAngleIncrement;
            toothDeclineStartAngle = toothStartAngle + (double)this.toothDeclineAngleIncrement;
            toothValleyStartAngle = toothStartAngle + (double)this.toothValleyAngleIncrement;
            xRoot0 = rootRadius * (float)Math.cos(toothStartAngle);
            yRoot0 = rootRadius * (float)Math.sin(toothStartAngle);
            xOuter1 = outsideRadius * (float)Math.cos(toothTopStartAngle);
            yOuter1 = outsideRadius * (float)Math.sin(toothTopStartAngle);
            xOuter2 = outsideRadius * (float)Math.cos(toothDeclineStartAngle);
            yOuter2 = outsideRadius * (float)Math.sin(toothDeclineStartAngle);
            xRoot3 = rootRadius * (float)Math.cos(toothValleyStartAngle);
            yRoot3 = rootRadius * (float)Math.sin(toothValleyStartAngle);
            tempCoordinate1.set(xRoot0, yRoot0, frontZ);
            tempCoordinate2.set(xRoot3, yRoot3, frontZ);
            tempVector1.sub((Tuple3f)tempCoordinate2, (Tuple3f)tempCoordinate1);
            tempCoordinate2.set(xOuter1, yOuter1, toothTipFrontZ);
            tempVector2.sub((Tuple3f)tempCoordinate2, (Tuple3f)tempCoordinate1);
            frontToothNormal.cross(tempVector1, tempVector2);
            frontToothNormal.normalize();
            coordinate.set(xOuter1, yOuter1, toothTipFrontZ);
            frontGearTeeth.setCoordinate(index, coordinate);
            frontGearTeeth.setNormal(index, frontToothNormal);
            coordinate.set(xRoot0, yRoot0, frontZ);
            frontGearTeeth.setCoordinate(index + 1, coordinate);
            frontGearTeeth.setNormal(index + 1, frontToothNormal);
            coordinate.set(xOuter2, yOuter2, toothTipFrontZ);
            frontGearTeeth.setCoordinate(index + 2, coordinate);
            frontGearTeeth.setNormal(index + 2, frontToothNormal);
            coordinate.set(xRoot3, yRoot3, frontZ);
            frontGearTeeth.setCoordinate(index + 3, coordinate);
            frontGearTeeth.setNormal(index + 3, frontToothNormal);
        }
        Shape3D newShape = new Shape3D((Geometry)frontGearTeeth, look);
        this.addChild((Node)newShape);
        toothFacetVertexCount = 4;
        toothFaceTotalVertexCount = toothFacetVertexCount * this.toothCount;
        QuadArray rearGearTeeth = new QuadArray(this.toothCount * toothFacetVertexCount, 3);
        for (int count = 0; count < this.toothCount; ++count) {
            index = count * toothFacetVertexCount;
            toothStartAngle = this.gearStartAngle + (double)this.circularPitchAngle * (double)count;
            toothTopStartAngle = toothStartAngle + (double)this.toothTopAngleIncrement;
            toothDeclineStartAngle = toothStartAngle + (double)this.toothDeclineAngleIncrement;
            toothValleyStartAngle = toothStartAngle + (double)this.toothValleyAngleIncrement;
            xRoot0 = rootRadius * (float)Math.cos(toothStartAngle);
            yRoot0 = rootRadius * (float)Math.sin(toothStartAngle);
            xOuter1 = outsideRadius * (float)Math.cos(toothTopStartAngle);
            yOuter1 = outsideRadius * (float)Math.sin(toothTopStartAngle);
            xOuter2 = outsideRadius * (float)Math.cos(toothDeclineStartAngle);
            yOuter2 = outsideRadius * (float)Math.sin(toothDeclineStartAngle);
            xRoot3 = rootRadius * (float)Math.cos(toothValleyStartAngle);
            yRoot3 = rootRadius * (float)Math.sin(toothValleyStartAngle);
            tempCoordinate1.set(xRoot0, yRoot0, rearZ);
            tempCoordinate2.set(xRoot3, yRoot3, rearZ);
            tempVector1.sub((Tuple3f)tempCoordinate2, (Tuple3f)tempCoordinate1);
            tempCoordinate2.set(xOuter1, yOuter1, toothTipRearZ);
            tempVector2.sub((Tuple3f)tempCoordinate2, (Tuple3f)tempCoordinate1);
            rearToothNormal.cross(tempVector2, tempVector1);
            rearToothNormal.normalize();
            coordinate.set(xRoot0, yRoot0, rearZ);
            rearGearTeeth.setCoordinate(index, coordinate);
            rearGearTeeth.setNormal(index, rearToothNormal);
            coordinate.set(xOuter1, yOuter1, toothTipRearZ);
            rearGearTeeth.setCoordinate(index + 1, coordinate);
            rearGearTeeth.setNormal(index + 1, rearToothNormal);
            coordinate.set(xOuter2, yOuter2, toothTipRearZ);
            rearGearTeeth.setCoordinate(index + 2, coordinate);
            rearGearTeeth.setNormal(index + 2, rearToothNormal);
            coordinate.set(xRoot3, yRoot3, rearZ);
            rearGearTeeth.setCoordinate(index + 3, coordinate);
            rearGearTeeth.setNormal(index + 3, rearToothNormal);
        }
        newShape = new Shape3D((Geometry)rearGearTeeth, look);
        this.addChild((Node)newShape);
        topStripCount[0] = topVertexCount = 8 * this.toothCount + 2;
        toothFacetVertexCount = 4;
        int toothFacetCount = 4;
        QuadArray topGearTeeth = new QuadArray(this.toothCount * toothFacetVertexCount * toothFacetCount, 3);
        for (int count = 0; count < this.toothCount; ++count) {
            index = count * toothFacetCount * toothFacetVertexCount;
            toothStartAngle = this.gearStartAngle + (double)this.circularPitchAngle * (double)count;
            toothTopStartAngle = toothStartAngle + (double)this.toothTopAngleIncrement;
            toothDeclineStartAngle = toothStartAngle + (double)this.toothDeclineAngleIncrement;
            toothValleyStartAngle = toothStartAngle + (double)this.toothValleyAngleIncrement;
            double nextToothStartAngle = toothStartAngle + (double)this.circularPitchAngle;
            xRoot0 = rootRadius * (float)Math.cos(toothStartAngle);
            yRoot0 = rootRadius * (float)Math.sin(toothStartAngle);
            xOuter1 = outsideRadius * (float)Math.cos(toothTopStartAngle);
            yOuter1 = outsideRadius * (float)Math.sin(toothTopStartAngle);
            xOuter2 = outsideRadius * (float)Math.cos(toothDeclineStartAngle);
            yOuter2 = outsideRadius * (float)Math.sin(toothDeclineStartAngle);
            xRoot3 = rootRadius * (float)Math.cos(toothValleyStartAngle);
            yRoot3 = rootRadius * (float)Math.sin(toothValleyStartAngle);
            float xRoot4 = rootRadius * (float)Math.cos(nextToothStartAngle);
            float yRoot4 = rootRadius * (float)Math.sin(nextToothStartAngle);
            tempCoordinate1.set(xRoot0, yRoot0, frontZ);
            tempCoordinate2.set(xOuter1, yOuter1, toothTipFrontZ);
            tempVector1.sub((Tuple3f)tempCoordinate2, (Tuple3f)tempCoordinate1);
            leftNormal.cross(this.frontNormal, tempVector1);
            leftNormal.normalize();
            coordinate.set(xRoot0, yRoot0, rearZ);
            topGearTeeth.setCoordinate(index, coordinate);
            topGearTeeth.setNormal(index, leftNormal);
            coordinate.set((Tuple3f)tempCoordinate1);
            topGearTeeth.setCoordinate(index + 1, coordinate);
            topGearTeeth.setNormal(index + 1, leftNormal);
            topGearTeeth.setCoordinate(index + 2, tempCoordinate2);
            topGearTeeth.setNormal(index + 2, leftNormal);
            topGearTeeth.setCoordinate(index + 5, tempCoordinate2);
            coordinate.set(xOuter1, yOuter1, toothTipRearZ);
            topGearTeeth.setCoordinate(index + 3, coordinate);
            topGearTeeth.setNormal(index + 3, leftNormal);
            topGearTeeth.setCoordinate(index + 4, coordinate);
            tempCoordinate1.set(xOuter1, yOuter1, toothTipFrontZ);
            tempCoordinate2.set(xOuter2, yOuter2, toothTipFrontZ);
            tempVector1.sub((Tuple3f)tempCoordinate2, (Tuple3f)tempCoordinate1);
            outNormal.cross(this.frontNormal, tempVector1);
            outNormal.normalize();
            topGearTeeth.setNormal(index + 4, outNormal);
            topGearTeeth.setNormal(index + 5, outNormal);
            topGearTeeth.setCoordinate(index + 6, tempCoordinate2);
            topGearTeeth.setNormal(index + 6, outNormal);
            topGearTeeth.setCoordinate(index + 9, tempCoordinate2);
            coordinate.set(xOuter2, yOuter2, toothTipRearZ);
            topGearTeeth.setCoordinate(index + 7, coordinate);
            topGearTeeth.setNormal(index + 7, outNormal);
            topGearTeeth.setCoordinate(index + 8, coordinate);
            tempCoordinate1.set(xOuter2, yOuter2, toothTipFrontZ);
            tempCoordinate2.set(xRoot3, yRoot3, frontZ);
            tempVector1.sub((Tuple3f)tempCoordinate2, (Tuple3f)tempCoordinate1);
            rightNormal.cross(this.frontNormal, tempVector1);
            rightNormal.normalize();
            topGearTeeth.setNormal(index + 8, rightNormal);
            topGearTeeth.setNormal(index + 9, rightNormal);
            topGearTeeth.setCoordinate(index + 10, tempCoordinate2);
            topGearTeeth.setNormal(index + 10, rightNormal);
            topGearTeeth.setCoordinate(index + 13, tempCoordinate2);
            coordinate.set(xRoot3, yRoot3, rearZ);
            topGearTeeth.setCoordinate(index + 11, coordinate);
            topGearTeeth.setNormal(index + 11, rightNormal);
            topGearTeeth.setCoordinate(index + 12, coordinate);
            tempCoordinate1.set(xRoot3, yRoot3, frontZ);
            tempCoordinate2.set(xRoot4, yRoot4, frontZ);
            tempVector1.sub((Tuple3f)tempCoordinate2, (Tuple3f)tempCoordinate1);
            outNormal.cross(this.frontNormal, tempVector1);
            outNormal.normalize();
            topGearTeeth.setNormal(index + 12, outNormal);
            topGearTeeth.setNormal(index + 13, outNormal);
            topGearTeeth.setCoordinate(index + 14, tempCoordinate2);
            topGearTeeth.setNormal(index + 14, outNormal);
            coordinate.set(xRoot4, yRoot4, rearZ);
            topGearTeeth.setCoordinate(index + 15, coordinate);
            topGearTeeth.setNormal(index + 15, outNormal);
            toothTopStartAngle = nextToothStartAngle + (double)this.toothTopAngleIncrement;
            xOuter1 = outsideRadius * (float)Math.cos(toothTopStartAngle);
            yOuter1 = outsideRadius * (float)Math.sin(toothTopStartAngle);
            tempCoordinate1.set(xRoot4, yRoot4, toothTipFrontZ);
            tempCoordinate2.set(xOuter1, yOuter1, toothTipFrontZ);
            tempVector1.sub((Tuple3f)tempCoordinate2, (Tuple3f)tempCoordinate1);
            leftNormal.cross(this.frontNormal, tempVector1);
            leftNormal.normalize();
        }
        newShape = new Shape3D((Geometry)topGearTeeth, look);
        this.addChild((Node)newShape);
    }
}

