/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.geometry_by_ref;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleStripArray;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class GeometryByReferenceNIOBuffer
extends JApplet
implements ActionListener,
GeometryUpdater {
    RenderingAttributes ra;
    ColoringAttributes ca;
    Material mat;
    Appearance app;
    JComboBox geomType;
    JComboBox vertexType;
    JComboBox colorType;
    JCheckBox transparency;
    JComboBox updates;
    Shape3D shape;
    TransparencyAttributes transp;
    int updateIndex = 0;
    int colorCount = 0;
    int vertexCount = 0;
    int vertexIndex = 0;
    int colorIndex = 0;
    GeometryArray tetraRegular;
    GeometryArray tetraStrip;
    GeometryArray tetraIndexed;
    GeometryArray tetraIndexedStrip;
    GeometryArray[] geoArrays = new GeometryArray[4];
    private static final float sqrt3 = (float)Math.sqrt(3.0);
    private static final float sqrt3_3 = sqrt3 / 3.0f;
    private static final float sqrt24_3 = (float)Math.sqrt(24.0) / 3.0f;
    private static final float ycenter = 0.5f * sqrt24_3;
    private static final float zcenter = -sqrt3_3;
    private static final Point3f p1 = new Point3f(-1.0f, -ycenter, -zcenter);
    private static final Point3f p2 = new Point3f(1.0f, -ycenter, -zcenter);
    private static final Point3f p3 = new Point3f(0.0f, -ycenter, -sqrt3 - zcenter);
    private static final Point3f p4 = new Point3f(0.0f, sqrt24_3 - ycenter, 0.0f);
    private static final float[] floatVerts = new float[]{GeometryByReferenceNIOBuffer.p1.x, GeometryByReferenceNIOBuffer.p1.y, GeometryByReferenceNIOBuffer.p1.z, GeometryByReferenceNIOBuffer.p2.x, GeometryByReferenceNIOBuffer.p2.y, GeometryByReferenceNIOBuffer.p2.z, GeometryByReferenceNIOBuffer.p4.x, GeometryByReferenceNIOBuffer.p4.y, GeometryByReferenceNIOBuffer.p4.z, GeometryByReferenceNIOBuffer.p1.x, GeometryByReferenceNIOBuffer.p1.y, GeometryByReferenceNIOBuffer.p1.z, GeometryByReferenceNIOBuffer.p4.x, GeometryByReferenceNIOBuffer.p4.y, GeometryByReferenceNIOBuffer.p4.z, GeometryByReferenceNIOBuffer.p3.x, GeometryByReferenceNIOBuffer.p3.y, GeometryByReferenceNIOBuffer.p3.z, GeometryByReferenceNIOBuffer.p2.x, GeometryByReferenceNIOBuffer.p2.y, GeometryByReferenceNIOBuffer.p2.z, GeometryByReferenceNIOBuffer.p3.x, GeometryByReferenceNIOBuffer.p3.y, GeometryByReferenceNIOBuffer.p3.z, GeometryByReferenceNIOBuffer.p4.x, GeometryByReferenceNIOBuffer.p4.y, GeometryByReferenceNIOBuffer.p4.z, GeometryByReferenceNIOBuffer.p1.x, GeometryByReferenceNIOBuffer.p1.y, GeometryByReferenceNIOBuffer.p1.z, GeometryByReferenceNIOBuffer.p3.x, GeometryByReferenceNIOBuffer.p3.y, GeometryByReferenceNIOBuffer.p3.z, GeometryByReferenceNIOBuffer.p2.x, GeometryByReferenceNIOBuffer.p2.y, GeometryByReferenceNIOBuffer.p2.z};
    private static final Color3f c1 = new Color3f(0.6f, 0.0f, 0.0f);
    private static final Color3f c2 = new Color3f(0.0f, 0.6f, 0.0f);
    private static final Color3f c3 = new Color3f(0.0f, 0.6f, 0.6f);
    private static final Color3f c4 = new Color3f(0.6f, 0.6f, 0.0f);
    private static final float[] floatClrs = new float[]{GeometryByReferenceNIOBuffer.c1.x, GeometryByReferenceNIOBuffer.c1.y, GeometryByReferenceNIOBuffer.c1.z, GeometryByReferenceNIOBuffer.c2.x, GeometryByReferenceNIOBuffer.c2.y, GeometryByReferenceNIOBuffer.c2.z, GeometryByReferenceNIOBuffer.c4.x, GeometryByReferenceNIOBuffer.c4.y, GeometryByReferenceNIOBuffer.c4.z, GeometryByReferenceNIOBuffer.c1.x, GeometryByReferenceNIOBuffer.c1.y, GeometryByReferenceNIOBuffer.c1.z, GeometryByReferenceNIOBuffer.c4.x, GeometryByReferenceNIOBuffer.c4.y, GeometryByReferenceNIOBuffer.c4.z, GeometryByReferenceNIOBuffer.c3.x, GeometryByReferenceNIOBuffer.c3.y, GeometryByReferenceNIOBuffer.c3.z, GeometryByReferenceNIOBuffer.c2.x, GeometryByReferenceNIOBuffer.c2.y, GeometryByReferenceNIOBuffer.c2.z, GeometryByReferenceNIOBuffer.c3.x, GeometryByReferenceNIOBuffer.c3.y, GeometryByReferenceNIOBuffer.c3.z, GeometryByReferenceNIOBuffer.c4.x, GeometryByReferenceNIOBuffer.c4.y, GeometryByReferenceNIOBuffer.c4.z, GeometryByReferenceNIOBuffer.c1.x, GeometryByReferenceNIOBuffer.c1.y, GeometryByReferenceNIOBuffer.c1.z, GeometryByReferenceNIOBuffer.c3.x, GeometryByReferenceNIOBuffer.c3.y, GeometryByReferenceNIOBuffer.c3.z, GeometryByReferenceNIOBuffer.c2.x, GeometryByReferenceNIOBuffer.c2.y, GeometryByReferenceNIOBuffer.c2.z};
    private static final float[] indexedFloatVerts = new float[]{GeometryByReferenceNIOBuffer.p1.x, GeometryByReferenceNIOBuffer.p1.y, GeometryByReferenceNIOBuffer.p1.z, GeometryByReferenceNIOBuffer.p2.x, GeometryByReferenceNIOBuffer.p2.y, GeometryByReferenceNIOBuffer.p2.z, GeometryByReferenceNIOBuffer.p3.x, GeometryByReferenceNIOBuffer.p3.y, GeometryByReferenceNIOBuffer.p3.z, GeometryByReferenceNIOBuffer.p4.x, GeometryByReferenceNIOBuffer.p4.y, GeometryByReferenceNIOBuffer.p4.z};
    private static final float[] indexedFloatClrs = new float[]{GeometryByReferenceNIOBuffer.c1.x, GeometryByReferenceNIOBuffer.c1.y, GeometryByReferenceNIOBuffer.c1.z, GeometryByReferenceNIOBuffer.c2.x, GeometryByReferenceNIOBuffer.c2.y, GeometryByReferenceNIOBuffer.c2.z, GeometryByReferenceNIOBuffer.c3.x, GeometryByReferenceNIOBuffer.c3.y, GeometryByReferenceNIOBuffer.c3.z, GeometryByReferenceNIOBuffer.c4.x, GeometryByReferenceNIOBuffer.c4.y, GeometryByReferenceNIOBuffer.c4.z};
    private static final int[] indices = new int[]{0, 1, 3, 0, 3, 2, 1, 2, 3, 0, 2, 1};
    private int[] stripVertexCounts = new int[]{3, 3, 3, 3};
    private SimpleUniverse u;
    private J3DBuffer floatBufferCoord;
    private J3DBuffer floatBufferColor;
    private J3DBuffer indexedFloatBufferCoord;
    private J3DBuffer indexedFloatBufferColor;

    void createJ3DBuffers() {
        ByteOrder order = ByteOrder.nativeOrder();
        FloatBuffer coord = ByteBuffer.allocateDirect(144).order(order).asFloatBuffer();
        coord.put(floatVerts, 0, 36);
        this.floatBufferCoord = new J3DBuffer((Buffer)coord);
        FloatBuffer color = ByteBuffer.allocateDirect(144).order(order).asFloatBuffer();
        color.put(floatClrs, 0, 36);
        this.floatBufferColor = new J3DBuffer((Buffer)color);
        FloatBuffer indexedCoord = ByteBuffer.allocateDirect(48).order(order).asFloatBuffer();
        indexedCoord.put(indexedFloatVerts, 0, 12);
        this.indexedFloatBufferCoord = new J3DBuffer((Buffer)indexedCoord);
        FloatBuffer indexedColor = ByteBuffer.allocateDirect(48).order(order).asFloatBuffer();
        indexedColor.put(indexedFloatClrs, 0, 12);
        this.indexedFloatBufferColor = new J3DBuffer((Buffer)indexedColor);
    }

    BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.app = new Appearance();
        this.transp = new TransparencyAttributes();
        this.transp.setTransparency(0.5f);
        this.transp.setCapability(1);
        this.transp.setTransparencyMode(4);
        this.app.setTransparencyAttributes(this.transp);
        this.createJ3DBuffers();
        this.tetraRegular = this.createGeometry(1);
        this.tetraStrip = this.createGeometry(2);
        this.tetraIndexed = this.createGeometry(3);
        this.tetraIndexedStrip = this.createGeometry(4);
        this.geoArrays[0] = this.tetraRegular;
        this.geoArrays[1] = this.tetraStrip;
        this.geoArrays[2] = this.tetraIndexed;
        this.geoArrays[3] = this.tetraIndexedStrip;
        this.shape = new Shape3D((Geometry)this.tetraRegular, this.app);
        this.shape.setCapability(13);
        this.shape.setCapability(12);
        Transform3D t = new Transform3D();
        t.set(new Vector3f(0.0f, 0.3f, 0.0f));
        Transform3D temp = new Transform3D();
        temp.rotX(0.7853981633974483);
        t.mul(temp);
        temp.rotY(0.7853981633974483);
        t.mul(temp);
        t.setScale(0.6);
        TransformGroup trans = new TransformGroup(t);
        trans.setCapability(18);
        trans.setCapability(17);
        objRoot.addChild((Node)trans);
        trans.addChild((Node)this.shape);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        Vector3f lDir1 = new Vector3f(-1.0f, -1.0f, -1.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        AmbientLight aLgt = new AmbientLight(alColor);
        aLgt.setInfluencingBounds((Bounds)bounds);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)aLgt);
        objRoot.addChild((Node)lgt1);
        objRoot.compile();
        return objRoot;
    }

    JPanel createGeometryByReferencePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Geometry Type"));
        String[] values = new String[]{"Array", "Strip", "Indexed", "IndexedStrip"};
        this.geomType = new JComboBox<String>(values);
        this.geomType.setLightWeightPopupEnabled(false);
        this.geomType.addActionListener(this);
        this.geomType.setSelectedIndex(0);
        panel.add(new JLabel("Geometry Type"));
        panel.add(this.geomType);
        return panel;
    }

    JPanel createUpdatePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Other Attributes"));
        String[] updateComp = new String[]{"None", "Geometry", "Color"};
        this.transparency = new JCheckBox("EnableTransparency", false);
        this.transparency.addActionListener(this);
        panel.add(this.transparency);
        this.updates = new JComboBox<String>(updateComp);
        this.updates.setLightWeightPopupEnabled(false);
        this.updates.addActionListener(this);
        this.updates.setSelectedIndex(0);
        panel.add(new JLabel("UpdateData"));
        panel.add(this.updates);
        return panel;
    }

    public void init() {
        Container contentPane = this.getContentPane();
        Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        contentPane.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        this.u.addBranchGraph(scene);
        OrbitBehavior orbit = new OrbitBehavior(c, 112);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        JPanel p = new JPanel();
        BoxLayout boxlayout = new BoxLayout(p, 1);
        p.add(this.createGeometryByReferencePanel());
        p.add(this.createUpdatePanel());
        p.setLayout(boxlayout);
        contentPane.add("South", p);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public void actionPerformed(ActionEvent e) {
        GeometryArray geo;
        Object target = e.getSource();
        boolean setColor = false;
        boolean setVertex = false;
        if (target == this.geomType) {
            geo = this.geoArrays[this.geomType.getSelectedIndex()];
            geo.setColorRefBuffer(null);
            geo.setCoordRefBuffer(null);
            this.shape.setGeometry((Geometry)this.geoArrays[this.geomType.getSelectedIndex()]);
            setColor = true;
            setVertex = true;
        } else if (target == this.transparency) {
            if (this.transparency.isSelected()) {
                this.transp.setTransparencyMode(2);
            } else {
                this.transp.setTransparencyMode(4);
            }
        } else if (target == this.updates) {
            this.updateIndex = this.updates.getSelectedIndex();
            if (this.updateIndex == 1) {
                System.out.println("Doing coordinate update");
                ((GeometryArray)this.shape.getGeometry()).updateData((GeometryUpdater)this);
            } else if (this.updateIndex == 2) {
                System.out.println("Doing color update");
                ((GeometryArray)this.shape.getGeometry()).updateData((GeometryUpdater)this);
            }
        }
        if (setVertex) {
            geo = (GeometryArray)this.shape.getGeometry();
            if (geo instanceof IndexedGeometryArray) {
                geo.setCoordRefBuffer(this.indexedFloatBufferCoord);
            } else {
                geo.setCoordRefBuffer(this.floatBufferCoord);
            }
        }
        if (setColor) {
            geo = (GeometryArray)this.shape.getGeometry();
            if (geo instanceof IndexedGeometryArray) {
                geo.setColorRefBuffer(this.indexedFloatBufferColor);
            } else {
                geo.setColorRefBuffer(this.floatBufferColor);
            }
        }
    }

    public static void main(String[] args) {
        MainFrame frame = new MainFrame((Applet)new GeometryByReferenceNIOBuffer(), 800, 800);
    }

    public GeometryArray createGeometry(int type) {
        TriangleArray tetra = null;
        if (type == 1) {
            tetra = new TriangleArray(12, 2181);
            tetra.setCoordRefBuffer(this.floatBufferCoord);
            tetra.setColorRefBuffer(this.floatBufferColor);
        } else if (type == 2) {
            tetra = new TriangleStripArray(12, 2181, this.stripVertexCounts);
            tetra.setCoordRefBuffer(this.floatBufferCoord);
            tetra.setColorRefBuffer(this.floatBufferColor);
        } else if (type == 3) {
            tetra = new IndexedTriangleArray(4, 2181, 12);
            tetra.setCoordRefBuffer(this.indexedFloatBufferCoord);
            tetra.setColorRefBuffer(this.indexedFloatBufferColor);
            ((IndexedTriangleArray)tetra).setCoordinateIndices(0, indices);
            ((IndexedTriangleArray)tetra).setColorIndices(0, indices);
        } else if (type == 4) {
            tetra = new IndexedTriangleStripArray(4, 2693, 12, this.stripVertexCounts);
            tetra.setCoordRefBuffer(this.indexedFloatBufferCoord);
            tetra.setColorRefBuffer(this.indexedFloatBufferColor);
            ((IndexedTriangleStripArray)tetra).setCoordinateIndices(0, indices);
        }
        if (tetra != null) {
            tetra.setCapability(19);
        }
        return tetra;
    }

    public void updateData(Geometry geometry) {
        block7: {
            block6: {
                float val1;
                int i;
                if (this.updateIndex != 1) break block6;
                ++this.vertexCount;
                float val = (this.vertexCount & 1) == 1 ? 0.2f : -0.2f;
                FloatBuffer indexedCoord = (FloatBuffer)this.indexedFloatBufferCoord.getBuffer();
                indexedCoord.rewind();
                FloatBuffer coord = (FloatBuffer)this.floatBufferCoord.getBuffer();
                coord.rewind();
                if (this.vertexIndex != 0) break block7;
                for (i = 0; i < indexedCoord.limit(); i += 3) {
                    val1 = indexedCoord.get(i);
                    indexedCoord.put(i, val1 + val);
                }
                for (i = 0; i < coord.limit(); i += 3) {
                    val1 = coord.get(i);
                    coord.put(i, val1 + val);
                }
                break block7;
            }
            if (this.updateIndex == 2) {
                ++this.colorCount;
                float val = (this.colorCount & 1) == 1 ? 0.4f : -0.4f;
                FloatBuffer indexedColors = (FloatBuffer)this.indexedFloatBufferColor.getBuffer();
                indexedColors.rewind();
                FloatBuffer colors = (FloatBuffer)this.floatBufferColor.getBuffer();
                colors.rewind();
                if (this.colorIndex == 0) {
                    int i;
                    for (i = 0; i < indexedColors.limit(); i += 3) {
                        indexedColors.put(i, indexedColors.get(i) + val);
                    }
                    for (i = 0; i < colors.limit(); i += 3) {
                        colors.put(i, colors.get(i) + val);
                    }
                }
            }
        }
    }
}

