/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.geometry_by_ref;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleStripArray;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class GeometryByReferenceTest
extends JApplet
implements ActionListener,
GeometryUpdater {
    RenderingAttributes ra;
    ColoringAttributes ca;
    Material mat;
    Appearance app;
    JComboBox geomType;
    JComboBox vertexType;
    JComboBox colorType;
    JCheckBox transparency;
    JComboBox updates;
    Shape3D shape;
    TransparencyAttributes transp;
    int updateIndex = 0;
    int colorCount = 0;
    int vertexCount = 0;
    int vertexIndex = 0;
    int colorIndex = 0;
    GeometryArray tetraRegular;
    GeometryArray tetraStrip;
    GeometryArray tetraIndexed;
    GeometryArray tetraIndexedStrip;
    GeometryArray[] geoArrays = new GeometryArray[4];
    private static final float sqrt3 = (float)Math.sqrt(3.0);
    private static final float sqrt3_3 = sqrt3 / 3.0f;
    private static final float sqrt24_3 = (float)Math.sqrt(24.0) / 3.0f;
    private static final float ycenter = 0.5f * sqrt24_3;
    private static final float zcenter = -sqrt3_3;
    private static final Point3f p1 = new Point3f(-1.0f, -ycenter, -zcenter);
    private static final Point3f p2 = new Point3f(1.0f, -ycenter, -zcenter);
    private static final Point3f p3 = new Point3f(0.0f, -ycenter, -sqrt3 - zcenter);
    private static final Point3f p4 = new Point3f(0.0f, sqrt24_3 - ycenter, 0.0f);
    private static final float[] floatVerts = new float[]{GeometryByReferenceTest.p1.x, GeometryByReferenceTest.p1.y, GeometryByReferenceTest.p1.z, GeometryByReferenceTest.p2.x, GeometryByReferenceTest.p2.y, GeometryByReferenceTest.p2.z, GeometryByReferenceTest.p4.x, GeometryByReferenceTest.p4.y, GeometryByReferenceTest.p4.z, GeometryByReferenceTest.p1.x, GeometryByReferenceTest.p1.y, GeometryByReferenceTest.p1.z, GeometryByReferenceTest.p4.x, GeometryByReferenceTest.p4.y, GeometryByReferenceTest.p4.z, GeometryByReferenceTest.p3.x, GeometryByReferenceTest.p3.y, GeometryByReferenceTest.p3.z, GeometryByReferenceTest.p2.x, GeometryByReferenceTest.p2.y, GeometryByReferenceTest.p2.z, GeometryByReferenceTest.p3.x, GeometryByReferenceTest.p3.y, GeometryByReferenceTest.p3.z, GeometryByReferenceTest.p4.x, GeometryByReferenceTest.p4.y, GeometryByReferenceTest.p4.z, GeometryByReferenceTest.p1.x, GeometryByReferenceTest.p1.y, GeometryByReferenceTest.p1.z, GeometryByReferenceTest.p3.x, GeometryByReferenceTest.p3.y, GeometryByReferenceTest.p3.z, GeometryByReferenceTest.p2.x, GeometryByReferenceTest.p2.y, GeometryByReferenceTest.p2.z};
    private static final Color3f c1 = new Color3f(0.6f, 0.0f, 0.0f);
    private static final Color3f c2 = new Color3f(0.0f, 0.6f, 0.0f);
    private static final Color3f c3 = new Color3f(0.0f, 0.6f, 0.6f);
    private static final Color3f c4 = new Color3f(0.6f, 0.6f, 0.0f);
    private static final float[] floatClrs = new float[]{GeometryByReferenceTest.c1.x, GeometryByReferenceTest.c1.y, GeometryByReferenceTest.c1.z, GeometryByReferenceTest.c2.x, GeometryByReferenceTest.c2.y, GeometryByReferenceTest.c2.z, GeometryByReferenceTest.c4.x, GeometryByReferenceTest.c4.y, GeometryByReferenceTest.c4.z, GeometryByReferenceTest.c1.x, GeometryByReferenceTest.c1.y, GeometryByReferenceTest.c1.z, GeometryByReferenceTest.c4.x, GeometryByReferenceTest.c4.y, GeometryByReferenceTest.c4.z, GeometryByReferenceTest.c3.x, GeometryByReferenceTest.c3.y, GeometryByReferenceTest.c3.z, GeometryByReferenceTest.c2.x, GeometryByReferenceTest.c2.y, GeometryByReferenceTest.c2.z, GeometryByReferenceTest.c3.x, GeometryByReferenceTest.c3.y, GeometryByReferenceTest.c3.z, GeometryByReferenceTest.c4.x, GeometryByReferenceTest.c4.y, GeometryByReferenceTest.c4.z, GeometryByReferenceTest.c1.x, GeometryByReferenceTest.c1.y, GeometryByReferenceTest.c1.z, GeometryByReferenceTest.c3.x, GeometryByReferenceTest.c3.y, GeometryByReferenceTest.c3.z, GeometryByReferenceTest.c2.x, GeometryByReferenceTest.c2.y, GeometryByReferenceTest.c2.z};
    private static final float[] indexedFloatVerts = new float[]{GeometryByReferenceTest.p1.x, GeometryByReferenceTest.p1.y, GeometryByReferenceTest.p1.z, GeometryByReferenceTest.p2.x, GeometryByReferenceTest.p2.y, GeometryByReferenceTest.p2.z, GeometryByReferenceTest.p3.x, GeometryByReferenceTest.p3.y, GeometryByReferenceTest.p3.z, GeometryByReferenceTest.p4.x, GeometryByReferenceTest.p4.y, GeometryByReferenceTest.p4.z};
    private static final float[] indexedFloatClrs = new float[]{GeometryByReferenceTest.c1.x, GeometryByReferenceTest.c1.y, GeometryByReferenceTest.c1.z, GeometryByReferenceTest.c2.x, GeometryByReferenceTest.c2.y, GeometryByReferenceTest.c2.z, GeometryByReferenceTest.c3.x, GeometryByReferenceTest.c3.y, GeometryByReferenceTest.c3.z, GeometryByReferenceTest.c4.x, GeometryByReferenceTest.c4.y, GeometryByReferenceTest.c4.z};
    private static final Point3f[] p3fVerts = new Point3f[]{p1, p2, p4, p1, p4, p3, p2, p3, p4, p1, p3, p2};
    private static final Point3f[] indexedP3fVerts = new Point3f[]{p1, p2, p3, p4};
    private static final Color3f[] c3fClrs = new Color3f[]{c1, c2, c4, c1, c4, c3, c2, c3, c4, c1, c3, c2};
    private static final Color3f[] indexedC3fClrs = new Color3f[]{c1, c2, c3, c4};
    private static final int[] indices = new int[]{0, 1, 3, 0, 3, 2, 1, 2, 3, 0, 2, 1};
    private int[] stripVertexCounts = new int[]{3, 3, 3, 3};
    private SimpleUniverse u;

    BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.app = new Appearance();
        this.transp = new TransparencyAttributes();
        this.transp.setTransparency(0.5f);
        this.transp.setCapability(1);
        this.transp.setTransparencyMode(4);
        this.app.setTransparencyAttributes(this.transp);
        this.tetraRegular = this.createGeometry(1);
        this.tetraStrip = this.createGeometry(2);
        this.tetraIndexed = this.createGeometry(3);
        this.tetraIndexedStrip = this.createGeometry(4);
        this.geoArrays[0] = this.tetraRegular;
        this.geoArrays[1] = this.tetraStrip;
        this.geoArrays[2] = this.tetraIndexed;
        this.geoArrays[3] = this.tetraIndexedStrip;
        this.shape = new Shape3D((Geometry)this.tetraRegular, this.app);
        this.shape.setCapability(13);
        this.shape.setCapability(12);
        Transform3D t = new Transform3D();
        t.set(new Vector3f(0.0f, 0.3f, 0.0f));
        Transform3D temp = new Transform3D();
        temp.rotX(0.7853981633974483);
        t.mul(temp);
        temp.rotY(0.7853981633974483);
        t.mul(temp);
        t.setScale(0.6);
        TransformGroup trans = new TransformGroup(t);
        trans.setCapability(18);
        trans.setCapability(17);
        objRoot.addChild((Node)trans);
        trans.addChild((Node)this.shape);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        Vector3f lDir1 = new Vector3f(-1.0f, -1.0f, -1.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        AmbientLight aLgt = new AmbientLight(alColor);
        aLgt.setInfluencingBounds((Bounds)bounds);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)aLgt);
        objRoot.addChild((Node)lgt1);
        objRoot.compile();
        return objRoot;
    }

    JPanel createGeometryByReferencePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Geometry Type"));
        String[] values = new String[]{"Array", "Strip", "Indexed", "IndexedStrip"};
        this.geomType = new JComboBox<String>(values);
        this.geomType.setLightWeightPopupEnabled(false);
        this.geomType.addActionListener(this);
        this.geomType.setSelectedIndex(0);
        panel.add(new JLabel("Geometry Type"));
        panel.add(this.geomType);
        String[] vertex_types = new String[]{"Float", "P3F"};
        this.vertexType = new JComboBox<String>(vertex_types);
        this.vertexType.setLightWeightPopupEnabled(false);
        this.vertexType.addActionListener(this);
        this.vertexType.setSelectedIndex(0);
        panel.add(new JLabel("VertexType"));
        panel.add(this.vertexType);
        String[] color_types = new String[]{"Float", "C3F"};
        this.colorType = new JComboBox<String>(color_types);
        this.colorType.setLightWeightPopupEnabled(false);
        this.colorType.addActionListener(this);
        this.colorType.setSelectedIndex(0);
        panel.add(new JLabel("ColorType"));
        panel.add(this.colorType);
        return panel;
    }

    JPanel createUpdatePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Other Attributes"));
        String[] updateComp = new String[]{"None", "Geometry", "Color"};
        this.transparency = new JCheckBox("EnableTransparency", false);
        this.transparency.addActionListener(this);
        panel.add(this.transparency);
        this.updates = new JComboBox<String>(updateComp);
        this.updates.setLightWeightPopupEnabled(false);
        this.updates.addActionListener(this);
        this.updates.setSelectedIndex(0);
        panel.add(new JLabel("UpdateData"));
        panel.add(this.updates);
        return panel;
    }

    public void init() {
        Container contentPane = this.getContentPane();
        Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        contentPane.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        this.u.addBranchGraph(scene);
        OrbitBehavior orbit = new OrbitBehavior(c, 112);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        JPanel p = new JPanel();
        BoxLayout boxlayout = new BoxLayout(p, 1);
        p.add(this.createGeometryByReferencePanel());
        p.add(this.createUpdatePanel());
        p.setLayout(boxlayout);
        contentPane.add("South", p);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public void actionPerformed(ActionEvent e) {
        GeometryArray geo;
        Object target = e.getSource();
        boolean setColor = false;
        boolean setVertex = false;
        if (target == this.geomType) {
            geo = this.geoArrays[this.geomType.getSelectedIndex()];
            geo.setColorRefFloat(null);
            geo.setColorRef3f(null);
            geo.setCoordRefFloat(null);
            geo.setCoordRef3f(null);
            this.shape.setGeometry((Geometry)this.geoArrays[this.geomType.getSelectedIndex()]);
            setColor = true;
            setVertex = true;
        } else if (target == this.transparency) {
            if (this.transparency.isSelected()) {
                this.transp.setTransparencyMode(2);
            } else {
                this.transp.setTransparencyMode(4);
            }
        } else if (target == this.updates) {
            this.updateIndex = this.updates.getSelectedIndex();
            if (this.updateIndex == 1) {
                System.out.println("Doing coordinate update");
                ((GeometryArray)this.shape.getGeometry()).updateData((GeometryUpdater)this);
            } else if (this.updateIndex == 2) {
                System.out.println("Doing color update");
                ((GeometryArray)this.shape.getGeometry()).updateData((GeometryUpdater)this);
            }
        } else if (target == this.vertexType) {
            geo = (GeometryArray)this.shape.getGeometry();
            if (this.vertexIndex == 0) {
                geo.setCoordRefFloat(null);
            } else if (this.vertexIndex == 1) {
                geo.setCoordRef3f(null);
            }
            this.vertexIndex = this.vertexType.getSelectedIndex();
            setVertex = true;
        } else if (target == this.colorType) {
            geo = (GeometryArray)this.shape.getGeometry();
            if (this.colorIndex == 0) {
                geo.setColorRefFloat(null);
            } else if (this.colorIndex == 1) {
                geo.setColorRef3f(null);
            }
            this.colorIndex = this.colorType.getSelectedIndex();
            setColor = true;
        }
        if (setVertex) {
            geo = (GeometryArray)this.shape.getGeometry();
            if (this.vertexIndex == 0) {
                if (geo instanceof IndexedGeometryArray) {
                    geo.setCoordRefFloat(indexedFloatVerts);
                } else {
                    geo.setCoordRefFloat(floatVerts);
                }
            } else if (this.vertexIndex == 1) {
                if (geo instanceof IndexedGeometryArray) {
                    geo.setCoordRef3f(indexedP3fVerts);
                } else {
                    geo.setCoordRef3f(p3fVerts);
                }
            }
        }
        if (setColor) {
            geo = (GeometryArray)this.shape.getGeometry();
            if (this.colorIndex == 0) {
                if (geo instanceof IndexedGeometryArray) {
                    geo.setColorRefFloat(indexedFloatClrs);
                } else {
                    geo.setColorRefFloat(floatClrs);
                }
            } else if (this.colorIndex == 1) {
                if (geo instanceof IndexedGeometryArray) {
                    geo.setColorRef3f(indexedC3fClrs);
                } else {
                    geo.setColorRef3f(c3fClrs);
                }
            }
        }
    }

    public static void main(String[] args) {
        MainFrame frame = new MainFrame((Applet)new GeometryByReferenceTest(), 800, 800);
    }

    public GeometryArray createGeometry(int type) {
        TriangleArray tetra = null;
        if (type == 1) {
            tetra = new TriangleArray(12, 133);
            tetra.setCoordRefFloat(floatVerts);
            tetra.setColorRefFloat(floatClrs);
        } else if (type == 2) {
            tetra = new TriangleStripArray(12, 133, this.stripVertexCounts);
            tetra.setCoordRefFloat(floatVerts);
            tetra.setColorRefFloat(floatClrs);
        } else if (type == 3) {
            tetra = new IndexedTriangleArray(4, 133, 12);
            tetra.setCoordRefFloat(indexedFloatVerts);
            tetra.setColorRefFloat(indexedFloatClrs);
            ((IndexedTriangleArray)tetra).setCoordinateIndices(0, indices);
            ((IndexedTriangleArray)tetra).setColorIndices(0, indices);
        } else if (type == 4) {
            tetra = new IndexedTriangleStripArray(4, 133, 12, this.stripVertexCounts);
            tetra.setCoordRefFloat(indexedFloatVerts);
            tetra.setColorRefFloat(indexedFloatClrs);
            ((IndexedTriangleStripArray)tetra).setCoordinateIndices(0, indices);
            ((IndexedTriangleStripArray)tetra).setColorIndices(0, indices);
        }
        if (tetra != null) {
            tetra.setCapability(19);
        }
        return tetra;
    }

    public void updateData(Geometry geometry) {
        block11: {
            block10: {
                if (this.updateIndex != 1) break block10;
                ++this.vertexCount;
                float val = (this.vertexCount & 1) == 1 ? 0.2f : -0.2f;
                if (this.vertexIndex == 0) {
                    int i;
                    for (i = 0; i < indexedFloatVerts.length; i += 3) {
                        int n = i;
                        indexedFloatVerts[n] = indexedFloatVerts[n] + val;
                    }
                    for (i = 0; i < floatVerts.length; i += 3) {
                        int n = i;
                        floatVerts[n] = floatVerts[n] + val;
                    }
                } else {
                    for (int i = 0; i < indexedP3fVerts.length; ++i) {
                        GeometryByReferenceTest.indexedP3fVerts[i].x += val;
                    }
                }
                break block11;
            }
            if (this.updateIndex != 2) break block11;
            ++this.colorCount;
            float val = (this.colorCount & 1) == 1 ? 0.4f : -0.4f;
            if (this.colorIndex == 0) {
                int i;
                for (i = 0; i < indexedFloatClrs.length; i += 3) {
                    int n = i;
                    indexedFloatClrs[n] = indexedFloatClrs[n] + val;
                }
                for (i = 0; i < floatClrs.length; i += 3) {
                    int n = i;
                    floatClrs[n] = floatClrs[n] + val;
                }
            } else {
                for (int i = 0; i < indexedC3fClrs.length; ++i) {
                    GeometryByReferenceTest.indexedC3fClrs[i].x += val;
                }
            }
        }
    }
}

