/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.geometry_by_ref;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.Raster;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.geometry_by_ref.TiledImage;

public class ImageComponentByReferenceTest
extends JApplet
implements ActionListener {
    Shape3D s1;
    Shape3D s2;
    TextureLoader t0;
    TextureLoader t1;
    TextureLoader t2;
    int count = 0;
    Appearance app = new Appearance();
    BranchGroup objRoot = new BranchGroup();
    TransformGroup objTrans = new TransformGroup();
    BufferedImage bImage1;
    TiledImage checkBoard;
    boolean yUp = false;
    boolean byRef = true;
    JComboBox rasterType;
    JComboBox texType;
    ImageComponent2D[] image = new ImageComponent2D[8];
    Appearance dummyApp = new Appearance();
    Texture2D texOne;
    Texture2D texCheckBoard;
    Raster raster;
    Box textureCube;
    Shape3D boxShape;
    int w1 = 64;
    int h1 = 32;
    int checkw = 16;
    int checkh = 16;
    private URL texImage = null;
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        this.objRoot = new BranchGroup();
        this.objTrans.setCapability(18);
        this.objTrans.setCapability(13);
        this.objRoot.addChild((Node)this.objTrans);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.app.setCapability(3);
        this.textureCube = new Box(0.4f, 0.4f, 0.4f, 3, this.app);
        this.boxShape = this.textureCube.getShape(0);
        this.boxShape.setCapability(15);
        this.objTrans.addChild((Node)this.textureCube);
        this.checkBoard = new TiledImage();
        TextureLoader texLoader = new TextureLoader(this.texImage, (Component)this);
        ImageComponent2D oneImage = texLoader.getImage();
        this.bImage1 = oneImage.getImage();
        int index = 0;
        this.image[index++] = new ImageComponent2D(oneImage.getFormat(), (RenderedImage)this.bImage1, false, true);
        this.image[index++] = new ImageComponent2D(oneImage.getFormat(), (RenderedImage)this.bImage1, true, true);
        this.image[index++] = new ImageComponent2D(oneImage.getFormat(), (RenderedImage)this.bImage1, false, false);
        this.image[index++] = new ImageComponent2D(oneImage.getFormat(), (RenderedImage)this.bImage1, true, false);
        this.createRaster(this.objRoot);
        this.image[index++] = new ImageComponent2D(2, (RenderedImage)this.checkBoard, false, true);
        this.image[index++] = new ImageComponent2D(2, (RenderedImage)this.checkBoard, true, true);
        this.image[index++] = new ImageComponent2D(2, (RenderedImage)this.checkBoard, false, false);
        this.image[index++] = new ImageComponent2D(2, (RenderedImage)this.checkBoard, true, false);
        this.texOne = new Texture2D(1, 6, this.image[2].getWidth(), this.image[2].getHeight());
        this.texOne.setCapability(7);
        this.texOne.setImage(0, (ImageComponent)this.image[2]);
        this.app.setTexture((Texture)this.texOne);
        this.texCheckBoard = new Texture2D(1, 6, this.image[4].getWidth(), this.image[4].getHeight());
        this.texCheckBoard.setCapability(7);
        this.objRoot.compile();
        return this.objRoot;
    }

    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.rasterType) {
            if (this.rasterType.getSelectedIndex() < 4) {
                this.raster.setSize(this.w1, this.h1);
            } else {
                this.raster.setSize(this.checkw, this.checkh);
            }
            this.raster.setImage(this.image[this.rasterType.getSelectedIndex()]);
        } else if (target == this.texType) {
            this.boxShape.setAppearance(this.dummyApp);
            if (this.texType.getSelectedIndex() < 4) {
                this.texOne.setImage(0, (ImageComponent)this.image[this.texType.getSelectedIndex()]);
                this.app.setTexture((Texture)this.texOne);
            } else {
                this.texCheckBoard.setImage(0, (ImageComponent)this.image[this.texType.getSelectedIndex()]);
                this.app.setTexture((Texture)this.texCheckBoard);
            }
            this.boxShape.setAppearance(this.app);
        }
    }

    JPanel createImagePanel() {
        JPanel panel = new JPanel();
        String[] texVals = new String[]{"One_Yup_ByCopy", "One_Yup_ByReference", "One_Ydown_ByCopy", "One_Ydown_ByReference", "Checkered_Yup_ByCopy", "Checkered_Yup_ByReference", "Checkered_Ydown_ByCopy", "Checkered_Ydown_ByReference"};
        this.rasterType = new JComboBox<String>(texVals);
        this.rasterType.setLightWeightPopupEnabled(false);
        this.rasterType.addActionListener(this);
        this.rasterType.setSelectedIndex(2);
        panel.add(new JLabel("Raster Image"));
        panel.add(this.rasterType);
        this.texType = new JComboBox<String>(texVals);
        this.texType.setLightWeightPopupEnabled(false);
        this.texType.addActionListener(this);
        this.texType.setSelectedIndex(2);
        panel.add(new JLabel("Texture Image"));
        panel.add(this.texType);
        return panel;
    }

    public ImageComponentByReferenceTest() {
    }

    public ImageComponentByReferenceTest(URL url) {
        this.texImage = url;
    }

    public void init() {
        this.texImage = Resources.getResource("resources/images/one.jpg");
        if (this.texImage == null) {
            System.err.println("resources/images/one.jpg not found");
            System.exit(1);
        }
        Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
        Container contentPane = this.getContentPane();
        JPanel p = new JPanel();
        BoxLayout boxlayout = new BoxLayout(p, 1);
        p.setLayout(boxlayout);
        contentPane.add("Center", (Component)c);
        contentPane.add("South", p);
        p.add(this.createImagePanel());
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        URL url = null;
        url = Resources.getResource("resources/images/one.jpg");
        if (url == null) {
            System.err.println("resources/images/one.jpg not found");
            System.exit(1);
        }
        new MainFrame((Applet)new ImageComponentByReferenceTest(url), 800, 700);
    }

    void createRaster(BranchGroup scene) {
        Vector3f trans = new Vector3f();
        Transform3D tr = new Transform3D();
        this.raster = new Raster();
        this.raster.setCapability(5);
        this.raster.setCapability(9);
        this.raster.setPosition(new Point3f(-0.9f, 0.75f, 0.0f));
        this.raster.setType(1);
        this.raster.setOffset(0, 0);
        this.raster.setSize(this.image[2].getWidth(), this.image[2].getHeight());
        this.raster.setImage(this.image[2]);
        Shape3D sh = new Shape3D((Geometry)this.raster, new Appearance());
        scene.addChild((Node)sh);
    }
}

