/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.geometry_by_ref;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleStripArray;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;

public class InterleavedNIOBuffer
extends JApplet
implements ActionListener {
    RenderingAttributes ra;
    ColoringAttributes ca;
    Material mat;
    Appearance app;
    JComboBox geomType;
    JCheckBox transparency;
    JCheckBox textureBox;
    Shape3D shape;
    TransparencyAttributes transp;
    GeometryArray tetraRegular;
    GeometryArray tetraStrip;
    GeometryArray tetraIndexed;
    GeometryArray tetraIndexedStrip;
    GeometryArray[] geoArrays = new GeometryArray[4];
    Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
    Color3f red = new Color3f(1.0f, 0.0f, 0.0f);
    Color3f green = new Color3f(0.0f, 1.0f, 0.0f);
    Color3f blue = new Color3f(0.0f, 0.0f, 1.0f);
    Color3f[] colors = new Color3f[]{this.white, this.red, this.green, this.blue};
    private static final float sqrt3 = (float)Math.sqrt(3.0);
    private static final float sqrt3_3 = sqrt3 / 3.0f;
    private static final float sqrt24_3 = (float)Math.sqrt(24.0) / 3.0f;
    private static final float ycenter = 0.5f * sqrt24_3;
    private static final float zcenter = -sqrt3_3;
    private static final Point3f p1 = new Point3f(-1.0f, -ycenter, -zcenter);
    private static final Point3f p2 = new Point3f(1.0f, -ycenter, -zcenter);
    private static final Point3f p3 = new Point3f(0.0f, -ycenter, -sqrt3 - zcenter);
    private static final Point3f p4 = new Point3f(0.0f, sqrt24_3 - ycenter, 0.0f);
    private static final Point2f t1 = new Point2f(0.0f, 0.0f);
    private static final Point2f t2 = new Point2f(0.5f, 1.0f);
    private static final Point2f t3 = new Point2f(1.0f, 0.0f);
    private static final Point2f t4 = new Point2f(1.0f, 1.0f);
    private static final Color3f c1 = new Color3f(1.0f, 0.0f, 0.0f);
    private static final Color3f c2 = new Color3f(0.0f, 1.0f, 0.0f);
    private static final Color3f c3 = new Color3f(0.0f, 1.0f, 1.0f);
    private static final Color3f c4 = new Color3f(1.0f, 1.0f, 0.0f);
    private static final float[] interleaved = new float[]{InterleavedNIOBuffer.t1.x, InterleavedNIOBuffer.t1.y, InterleavedNIOBuffer.t1.x, InterleavedNIOBuffer.t1.y, InterleavedNIOBuffer.c1.x, InterleavedNIOBuffer.c1.y, InterleavedNIOBuffer.c1.z, InterleavedNIOBuffer.p1.x, InterleavedNIOBuffer.p1.y, InterleavedNIOBuffer.p1.z, InterleavedNIOBuffer.t2.x, InterleavedNIOBuffer.t2.y, InterleavedNIOBuffer.t2.x, InterleavedNIOBuffer.t2.y, InterleavedNIOBuffer.c2.x, InterleavedNIOBuffer.c2.y, InterleavedNIOBuffer.c2.z, InterleavedNIOBuffer.p2.x, InterleavedNIOBuffer.p2.y, InterleavedNIOBuffer.p2.z, InterleavedNIOBuffer.t4.x, InterleavedNIOBuffer.t4.y, InterleavedNIOBuffer.t4.x, InterleavedNIOBuffer.t4.y, InterleavedNIOBuffer.c4.x, InterleavedNIOBuffer.c4.y, InterleavedNIOBuffer.c4.z, InterleavedNIOBuffer.p4.x, InterleavedNIOBuffer.p4.y, InterleavedNIOBuffer.p4.z, InterleavedNIOBuffer.t1.x, InterleavedNIOBuffer.t1.y, InterleavedNIOBuffer.t1.x, InterleavedNIOBuffer.t1.y, InterleavedNIOBuffer.c1.x, InterleavedNIOBuffer.c1.y, InterleavedNIOBuffer.c1.z, InterleavedNIOBuffer.p1.x, InterleavedNIOBuffer.p1.y, InterleavedNIOBuffer.p1.z, InterleavedNIOBuffer.t4.x, InterleavedNIOBuffer.t4.y, InterleavedNIOBuffer.t4.x, InterleavedNIOBuffer.t4.y, InterleavedNIOBuffer.c4.x, InterleavedNIOBuffer.c4.y, InterleavedNIOBuffer.c4.z, InterleavedNIOBuffer.p4.x, InterleavedNIOBuffer.p4.y, InterleavedNIOBuffer.p4.z, InterleavedNIOBuffer.t3.x, InterleavedNIOBuffer.t3.y, InterleavedNIOBuffer.t3.x, InterleavedNIOBuffer.t3.y, InterleavedNIOBuffer.c3.x, InterleavedNIOBuffer.c3.y, InterleavedNIOBuffer.c3.z, InterleavedNIOBuffer.p3.x, InterleavedNIOBuffer.p3.y, InterleavedNIOBuffer.p3.z, InterleavedNIOBuffer.t2.x, InterleavedNIOBuffer.t2.y, InterleavedNIOBuffer.t2.x, InterleavedNIOBuffer.t2.y, InterleavedNIOBuffer.c2.x, InterleavedNIOBuffer.c2.y, InterleavedNIOBuffer.c2.z, InterleavedNIOBuffer.p2.x, InterleavedNIOBuffer.p2.y, InterleavedNIOBuffer.p2.z, InterleavedNIOBuffer.t3.x, InterleavedNIOBuffer.t3.y, InterleavedNIOBuffer.t3.x, InterleavedNIOBuffer.t3.y, InterleavedNIOBuffer.c3.x, InterleavedNIOBuffer.c3.y, InterleavedNIOBuffer.c3.z, InterleavedNIOBuffer.p3.x, InterleavedNIOBuffer.p3.y, InterleavedNIOBuffer.p3.z, InterleavedNIOBuffer.t4.x, InterleavedNIOBuffer.t4.y, InterleavedNIOBuffer.t4.x, InterleavedNIOBuffer.t4.y, InterleavedNIOBuffer.c4.x, InterleavedNIOBuffer.c4.y, InterleavedNIOBuffer.c4.z, InterleavedNIOBuffer.p4.x, InterleavedNIOBuffer.p4.y, InterleavedNIOBuffer.p4.z, InterleavedNIOBuffer.t1.x, InterleavedNIOBuffer.t1.y, InterleavedNIOBuffer.t1.x, InterleavedNIOBuffer.t1.y, InterleavedNIOBuffer.c1.x, InterleavedNIOBuffer.c1.y, InterleavedNIOBuffer.c1.z, InterleavedNIOBuffer.p1.x, InterleavedNIOBuffer.p1.y, InterleavedNIOBuffer.p1.z, InterleavedNIOBuffer.t3.x, InterleavedNIOBuffer.t3.y, InterleavedNIOBuffer.t3.x, InterleavedNIOBuffer.t3.y, InterleavedNIOBuffer.c3.x, InterleavedNIOBuffer.c3.y, InterleavedNIOBuffer.c3.z, InterleavedNIOBuffer.p3.x, InterleavedNIOBuffer.p3.y, InterleavedNIOBuffer.p3.z, InterleavedNIOBuffer.t2.x, InterleavedNIOBuffer.t2.y, InterleavedNIOBuffer.t2.x, InterleavedNIOBuffer.t2.y, InterleavedNIOBuffer.c2.x, InterleavedNIOBuffer.c2.y, InterleavedNIOBuffer.c2.z, InterleavedNIOBuffer.p2.x, InterleavedNIOBuffer.p2.y, InterleavedNIOBuffer.p2.z};
    private static final float[] indexedInterleaved = new float[]{InterleavedNIOBuffer.t1.x, InterleavedNIOBuffer.t1.y, InterleavedNIOBuffer.t1.x, InterleavedNIOBuffer.t1.y, InterleavedNIOBuffer.c1.x, InterleavedNIOBuffer.c1.y, InterleavedNIOBuffer.c1.z, InterleavedNIOBuffer.p1.x, InterleavedNIOBuffer.p1.y, InterleavedNIOBuffer.p1.z, InterleavedNIOBuffer.t2.x, InterleavedNIOBuffer.t2.y, InterleavedNIOBuffer.t2.x, InterleavedNIOBuffer.t2.y, InterleavedNIOBuffer.c2.x, InterleavedNIOBuffer.c2.y, InterleavedNIOBuffer.c2.z, InterleavedNIOBuffer.p2.x, InterleavedNIOBuffer.p2.y, InterleavedNIOBuffer.p2.z, InterleavedNIOBuffer.t3.x, InterleavedNIOBuffer.t3.y, InterleavedNIOBuffer.t3.x, InterleavedNIOBuffer.t3.y, InterleavedNIOBuffer.c3.x, InterleavedNIOBuffer.c3.y, InterleavedNIOBuffer.c3.z, InterleavedNIOBuffer.p3.x, InterleavedNIOBuffer.p3.y, InterleavedNIOBuffer.p3.z, InterleavedNIOBuffer.t4.x, InterleavedNIOBuffer.t4.y, InterleavedNIOBuffer.t4.x, InterleavedNIOBuffer.t4.y, InterleavedNIOBuffer.c4.x, InterleavedNIOBuffer.c4.y, InterleavedNIOBuffer.c4.z, InterleavedNIOBuffer.p4.x, InterleavedNIOBuffer.p4.y, InterleavedNIOBuffer.p4.z};
    private static final int[] indices = new int[]{0, 1, 3, 0, 3, 2, 1, 2, 3, 0, 2, 1};
    private int[] stripVertexCounts = new int[]{3, 3, 3, 3};
    TextureUnitState[] textureUnitState = new TextureUnitState[2];
    Texture tex1;
    Texture tex2;
    private URL texImage1 = null;
    private URL texImage2 = null;
    private SimpleUniverse u;
    private J3DBuffer interleavedBuffer;
    private J3DBuffer indexedInterleavedBuffer;

    void createInterleavedBuffers() {
        ByteOrder order = ByteOrder.nativeOrder();
        int size = 120;
        FloatBuffer vertex = ByteBuffer.allocateDirect(size * 4).order(order).asFloatBuffer();
        vertex.put(interleaved, 0, size);
        this.interleavedBuffer = new J3DBuffer((Buffer)vertex);
        size = 40;
        FloatBuffer indexedVertex = ByteBuffer.allocateDirect(size * 4).order(order).asFloatBuffer();
        indexedVertex.put(indexedInterleaved, 0, size);
        this.indexedInterleavedBuffer = new J3DBuffer((Buffer)indexedVertex);
    }

    BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.app = new Appearance();
        this.app.setCapability(21);
        this.transp = new TransparencyAttributes();
        this.transp.setTransparency(0.5f);
        this.transp.setCapability(1);
        this.transp.setTransparencyMode(4);
        this.app.setTransparencyAttributes(this.transp);
        TextureAttributes texAttr1 = new TextureAttributes();
        texAttr1.setTextureMode(3);
        TextureAttributes texAttr2 = new TextureAttributes();
        texAttr2.setTextureMode(2);
        TextureLoader tex = new TextureLoader(this.texImage1, new String("RGB"), (Component)this);
        if (tex == null) {
            return null;
        }
        this.tex1 = tex.getTexture();
        tex = new TextureLoader(this.texImage2, new String("RGB"), (Component)this);
        if (tex == null) {
            return null;
        }
        this.tex2 = tex.getTexture();
        this.textureUnitState[0] = new TextureUnitState(this.tex1, texAttr1, null);
        this.textureUnitState[1] = new TextureUnitState(this.tex2, texAttr2, null);
        this.createInterleavedBuffers();
        this.tetraRegular = this.createGeometry(1);
        this.tetraStrip = this.createGeometry(2);
        this.tetraIndexed = this.createGeometry(3);
        this.tetraIndexedStrip = this.createGeometry(4);
        this.geoArrays[0] = this.tetraRegular;
        this.geoArrays[1] = this.tetraStrip;
        this.geoArrays[2] = this.tetraIndexed;
        this.geoArrays[3] = this.tetraIndexedStrip;
        this.shape = new Shape3D((Geometry)this.tetraRegular, this.app);
        this.shape.setCapability(13);
        Transform3D t = new Transform3D();
        t.set(new Vector3f(0.0f, 0.3f, 0.0f));
        Transform3D temp = new Transform3D();
        temp.rotX(0.7853981633974483);
        t.mul(temp);
        temp.rotY(0.7853981633974483);
        t.mul(temp);
        t.setScale(0.6);
        TransformGroup trans = new TransformGroup(t);
        trans.setCapability(18);
        trans.setCapability(17);
        objRoot.addChild((Node)trans);
        trans.addChild((Node)this.shape);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        Vector3f lDir1 = new Vector3f(-1.0f, -1.0f, -1.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        AmbientLight aLgt = new AmbientLight(alColor);
        aLgt.setInfluencingBounds((Bounds)bounds);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)aLgt);
        objRoot.addChild((Node)lgt1);
        objRoot.compile();
        return objRoot;
    }

    JPanel createGeometryByReferencePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Geometry Type"));
        String[] values = new String[]{"Array", "Strip", "Indexed", "IndexedStrip"};
        this.geomType = new JComboBox<String>(values);
        this.geomType.setLightWeightPopupEnabled(false);
        this.geomType.addActionListener(this);
        this.geomType.setSelectedIndex(0);
        panel.add(new JLabel("Geometry Type"));
        panel.add(this.geomType);
        this.transparency = new JCheckBox("EnableTransparency", false);
        this.transparency.addActionListener(this);
        panel.add(this.transparency);
        this.textureBox = new JCheckBox("EnableTexture", false);
        this.textureBox.addActionListener(this);
        panel.add(this.textureBox);
        return panel;
    }

    public InterleavedNIOBuffer() {
    }

    public InterleavedNIOBuffer(URL texURL1, URL texURL2) {
        this.texImage1 = texURL1;
        this.texImage2 = texURL2;
    }

    public void init() {
        this.texImage1 = Resources.getResource("resources/images/bg.jpg");
        if (this.texImage1 == null) {
            System.err.println("resources/images/bg.jpg not found");
            System.exit(1);
        }
        this.texImage2 = Resources.getResource("resources/images/one.jpg");
        if (this.texImage2 == null) {
            System.err.println("resources/images/one.jpg not found");
            System.exit(1);
        }
        Container contentPane = this.getContentPane();
        Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        contentPane.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(c, 112);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        this.u.addBranchGraph(scene);
        JPanel p = new JPanel();
        BoxLayout boxlayout = new BoxLayout(p, 1);
        p.add(this.createGeometryByReferencePanel());
        p.setLayout(boxlayout);
        contentPane.add("South", p);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.geomType) {
            this.shape.setGeometry((Geometry)this.geoArrays[this.geomType.getSelectedIndex()]);
        } else if (target == this.transparency) {
            if (this.transparency.isSelected()) {
                this.transp.setTransparencyMode(2);
            } else {
                this.transp.setTransparencyMode(4);
            }
        } else if (target == this.textureBox) {
            if (this.textureBox.isSelected()) {
                this.app.setTextureUnitState(this.textureUnitState);
            } else {
                this.app.setTextureUnitState(null);
            }
        }
    }

    public static void main(String[] args) {
        URL texURL1 = null;
        URL texURL2 = null;
        texURL1 = Resources.getResource("resources/images/bg.jpg");
        if (texURL1 == null) {
            System.err.println("resources/images/bg.jpg not found");
            System.exit(1);
        }
        if ((texURL2 = Resources.getResource("resources/images/one.jpg")) == null) {
            System.err.println("resources/images/one.jpg not found");
            System.exit(1);
        }
        MainFrame frame = new MainFrame((Applet)new InterleavedNIOBuffer(texURL1, texURL2), 800, 800);
    }

    public GeometryArray createGeometry(int type) {
        TriangleArray tetra = null;
        int[] texCoordSetMap = new int[]{0, 0};
        if (type == 1) {
            tetra = new TriangleArray(12, 2469, 2, texCoordSetMap);
            tetra.setInterleavedVertexBuffer(this.interleavedBuffer);
        } else if (type == 2) {
            tetra = new TriangleStripArray(12, 2469, 2, texCoordSetMap, this.stripVertexCounts);
            tetra.setInterleavedVertexBuffer(this.interleavedBuffer);
        } else if (type == 3) {
            tetra = new IndexedTriangleArray(4, 2981, 2, texCoordSetMap, 12);
            tetra.setInterleavedVertexBuffer(this.indexedInterleavedBuffer);
            ((IndexedTriangleArray)tetra).setCoordinateIndices(0, indices);
        } else if (type == 4) {
            tetra = new IndexedTriangleStripArray(4, 2469, 2, texCoordSetMap, 12, this.stripVertexCounts);
            tetra.setInterleavedVertexBuffer(this.indexedInterleavedBuffer);
            ((IndexedTriangleStripArray)tetra).setCoordinateIndices(0, indices);
            ((IndexedTriangleStripArray)tetra).setColorIndices(0, indices);
            ((IndexedTriangleStripArray)tetra).setTextureCoordinateIndices(0, 0, indices);
            ((IndexedTriangleStripArray)tetra).setTextureCoordinateIndices(1, 0, indices);
        } else if (type == 5) {
            // empty if block
        }
        return tetra;
    }
}

