/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.glsl_shader;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.shader.StringIO;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GLSLShaderProgram;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shader;
import javax.media.j3d.ShaderAppearance;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderErrorListener;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.SourceCodeShader;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;

public class PhongShadingGLSL
extends JFrame {
    private static final int DIRECTIONAL_LIGHT = 0;
    private static final int POINT_LIGHT = 1;
    private static final int SPOT_LIGHT = 2;
    private static int lightType = 0;
    private SimpleUniverse univ = null;
    private ShaderAppearance sApp = null;
    private ShaderProgram gouraudSP = null;
    private ShaderProgram phongSP = null;
    private JPanel drawingPanel;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JRadioButton gouraudButton;
    private JPanel guiPanel;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JRadioButton phongButton;
    private ButtonGroup shaderButtonGroup;

    public BranchGroup createSceneGraph() {
        Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f sColor = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f objColor = new Color3f(0.6f, 0.6f, 0.6f);
        Color3f lColor1 = new Color3f(1.0f, 1.0f, 0.5f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.5);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bg);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objScale.addChild((Node)objTrans);
        this.sApp = new ShaderAppearance();
        this.sApp.setCapability(23);
        Material m = new Material(objColor, eColor, objColor, sColor, 100.0f);
        this.sApp.setMaterial(m);
        String vertexProgram = null;
        String fragmentProgram = null;
        Shader[] shaders = new Shader[2];
        String[] attrNames = new String[]{"numLights"};
        try {
            vertexProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/gouraud.vert"));
            fragmentProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/gouraud.frag"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        shaders[0] = new SourceCodeShader(1, 1, vertexProgram);
        shaders[1] = new SourceCodeShader(1, 2, fragmentProgram);
        this.gouraudSP = new GLSLShaderProgram();
        this.gouraudSP.setShaders(shaders);
        try {
            vertexProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/phong.vert"));
            fragmentProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/phong.frag"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        shaders[0] = new SourceCodeShader(1, 1, vertexProgram);
        shaders[1] = new SourceCodeShader(1, 2, fragmentProgram);
        this.phongSP = new GLSLShaderProgram();
        this.phongSP.setShaders(shaders);
        if (this.gouraudButton.isSelected()) {
            this.sApp.setShaderProgram(this.gouraudSP);
        } else if (this.phongButton.isSelected()) {
            this.sApp.setShaderProgram(this.phongSP);
        }
        Sphere sph = new Sphere(1.0f, 1, 30, (Appearance)this.sApp);
        objTrans.addChild((Node)sph);
        Transform3D yAxis = new Transform3D();
        yAxis.rotZ(Math.PI);
        Alpha rotationAlpha = new Alpha(-1, 10000L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        rotator.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)rotator);
        TransformGroup l1RotTrans = new TransformGroup();
        l1RotTrans.setCapability(18);
        objScale.addChild((Node)l1RotTrans);
        TransformGroup l2RotTrans = new TransformGroup();
        l2RotTrans.setCapability(18);
        objScale.addChild((Node)l2RotTrans);
        Transform3D t = new Transform3D();
        Vector3d lPos1 = new Vector3d(0.0, 0.0, 2.0);
        t.set(lPos1);
        TransformGroup l1Trans = new TransformGroup(t);
        l1RotTrans.addChild((Node)l1Trans);
        ColoringAttributes caL1 = new ColoringAttributes();
        caL1.setColor(lColor1);
        Appearance appL1 = new Appearance();
        appL1.setColoringAttributes(caL1);
        l1Trans.addChild((Node)new Sphere(0.05f, appL1));
        AmbientLight aLgt = new AmbientLight(alColor);
        DirectionalLight lgt1 = null;
        Point3f lPoint = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f atten = new Point3f(1.0f, 0.0f, 0.0f);
        Vector3f lDirect1 = new Vector3f(lPos1);
        lDirect1.negate();
        switch (lightType) {
            case 0: {
                lgt1 = new DirectionalLight(lColor1, lDirect1);
                break;
            }
            case 1: {
                assert (false) : "can't get here";
                lgt1 = new PointLight(lColor1, lPoint, atten);
                break;
            }
            case 2: {
                assert (false) : "can't get here";
                lgt1 = new SpotLight(lColor1, lPoint, atten, lDirect1, 0.43633232f, 10.0f);
            }
        }
        aLgt.setInfluencingBounds((Bounds)bounds);
        lgt1.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)aLgt);
        l1Trans.addChild((Node)lgt1);
        yAxis = new Transform3D();
        Alpha rotor1Alpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator1 = new RotationInterpolator(rotor1Alpha, l1RotTrans, yAxis, 0.0f, (float)Math.PI * 2);
        rotator1.setSchedulingBounds((Bounds)bounds);
        l1RotTrans.addChild((Node)rotator1);
        Alpha rotor2Alpha = new Alpha(-1, 1, 0L, 0L, 1000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator2 = new RotationInterpolator(rotor2Alpha, l2RotTrans, yAxis, 0.0f, 0.0f);
        bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator2.setSchedulingBounds((Bounds)bounds);
        l2RotTrans.addChild((Node)rotator2);
        return objRoot;
    }

    private Canvas3D initScene() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.addShaderErrorListener(new ShaderErrorListener(){

            public void errorOccurred(ShaderError error) {
                error.printVerbose();
                JOptionPane.showMessageDialog(PhongShadingGLSL.this, error.toString(), "ShaderError", 0);
            }
        });
        this.univ.getViewingPlatform().setNominalViewingTransform();
        BranchGroup scene = this.createSceneGraph();
        this.univ.addBranchGraph(scene);
        return c;
    }

    public PhongShadingGLSL() {
        this.initComponents();
        Canvas3D c = this.initScene();
        this.drawingPanel.add((Component)c, "Center");
    }

    private void initComponents() {
        this.shaderButtonGroup = new ButtonGroup();
        this.guiPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.gouraudButton = new JRadioButton();
        this.phongButton = new JRadioButton();
        this.drawingPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Phong Shading Test");
        this.guiPanel.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Shader"));
        this.shaderButtonGroup.add(this.gouraudButton);
        this.gouraudButton.setSelected(true);
        this.gouraudButton.setText("Per-Vertex Lighting (Gouraud)");
        this.gouraudButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.gouraudButton.setMargin(new Insets(0, 0, 0, 0));
        this.gouraudButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PhongShadingGLSL.this.gouraudButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.gouraudButton, gridBagConstraints);
        this.shaderButtonGroup.add(this.phongButton);
        this.phongButton.setText("Per-Pixel Lighting (Phong)");
        this.phongButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.phongButton.setMargin(new Insets(0, 0, 0, 0));
        this.phongButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PhongShadingGLSL.this.phongButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.phongButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.guiPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.guiPanel, "North");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.fileMenu.setText("File");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PhongShadingGLSL.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void phongButtonActionPerformed(ActionEvent evt) {
        this.sApp.setShaderProgram(this.phongSP);
    }

    private void gouraudButtonActionPerformed(ActionEvent evt) {
        this.sApp.setShaderProgram(this.gouraudSP);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PhongShadingGLSL().setVisible(true);
            }
        });
    }
}

