/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.jcanvas3d;

import com.sun.j3d.exp.swing.JCanvas3D;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JInternalFrame;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class JInternalWorld
extends JInternalFrame {
    private Component comp;

    public JInternalWorld(boolean isInteractive, boolean isDelayed, boolean isRandom) {
        this.setSize(256, 256);
        this.setClosable(true);
        JCanvas3D canvas = new JCanvas3D(new GraphicsConfigTemplate3D());
        if (isDelayed) {
            canvas.setResizeMode(1);
        }
        this.comp = canvas;
        Dimension dim = new Dimension(256, 256);
        this.comp.setPreferredSize(dim);
        this.comp.setSize(dim);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.comp, "Center");
        this.pack();
        BranchGroup scene = this.createSceneGraph(isInteractive, isRandom);
        SimpleUniverse universe = new SimpleUniverse(canvas.getOffscreenCanvas3D());
        universe.getViewingPlatform().setNominalViewingTransform();
        universe.getViewer().getView().setMinimumFrameCycleTime(30L);
        universe.addBranchGraph(scene);
    }

    private BranchGroup createSceneGraph(boolean isInteractive, boolean isRandom) {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTrans = new TransformGroup();
        Transform3D t3dTrans = new Transform3D();
        t3dTrans.setTranslation(new Vector3d(0.0, 0.0, -1.0));
        objTrans.setTransform(t3dTrans);
        TransformGroup objRot = new TransformGroup();
        objRot.setCapability(18);
        objRoot.addChild((Node)objTrans);
        objTrans.addChild((Node)objRot);
        Font3D f3d = new Font3D(new Font("dialog", 0, 1), new FontExtrusion());
        Text3D text = new Text3D(f3d, "JCanvas3D", new Point3f(-2.3f, -0.5f, 0.0f));
        Shape3D sh = new Shape3D();
        Appearance app = new Appearance();
        Material mm = new Material();
        mm.setLightingEnable(true);
        app.setMaterial(mm);
        sh.setGeometry((Geometry)text);
        sh.setAppearance(app);
        objRot.addChild((Node)sh);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f ambientColor = new Color3f(0.3f, 0.3f, 0.3f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
        Color3f light2Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light2);
        if (isInteractive) {
            MouseRotate mr = new MouseRotate(this.comp, objRot);
            mr.setSchedulingBounds((Bounds)bounds);
            mr.setSchedulingInterval(1);
            objRoot.addChild((Node)mr);
        } else {
            Transform3D yAxis = new Transform3D();
            Alpha rotationAlpha = null;
            if (isRandom) {
                int duration = Math.max(2000, (int)(Math.random() * 8000.0));
                rotationAlpha = new Alpha(-1, (long)((int)((double)duration * Math.random())), 0L, (long)duration, 0L, 0L);
            } else {
                rotationAlpha = new Alpha(-1, 4000L);
            }
            RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objRot, yAxis, 0.0f, (float)Math.PI * 2);
            rotator.setSchedulingBounds((Bounds)bounds);
            objRoot.addChild((Node)rotator);
        }
        return objRoot;
    }
}

