/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.model_clip;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.ModelClip;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;

public class ModelClipTest
extends Applet {
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objScale.addChild((Node)objTrans);
        ModelClip mc = new ModelClip();
        boolean[] enables = new boolean[]{false, false, false, false, false, false};
        Vector4d eqn1 = new Vector4d(0.0, 1.0, 0.0, 0.0);
        Vector4d eqn2 = new Vector4d(1.0, 1.0, 0.0, 0.0);
        mc.setEnables(enables);
        mc.setPlane(1, eqn1);
        mc.setPlane(2, eqn2);
        mc.setEnable(1, true);
        mc.setEnable(2, true);
        mc.setInfluencingBounds((Bounds)bounds);
        objTrans.addChild((Node)mc);
        PolygonAttributes attr = new PolygonAttributes();
        attr.setCullFace(0);
        Appearance ap = new Appearance();
        Material mat = new Material();
        mat.setLightingEnable(true);
        ap.setMaterial(mat);
        ap.setPolygonAttributes(attr);
        Cylinder CylinderObj = new Cylinder(1.0f, 2.0f, ap);
        objTrans.addChild((Node)CylinderObj);
        MouseRotate behavior = new MouseRotate(objTrans);
        objTrans.addChild((Node)behavior);
        behavior.setSchedulingBounds((Bounds)bounds);
        MouseZoom behavior2 = new MouseZoom(objTrans);
        objTrans.addChild((Node)behavior2);
        behavior2.setSchedulingBounds((Bounds)bounds);
        Color3f lColor1 = new Color3f(0.5f, 0.0f, 0.5f);
        Color3f lColor2 = new Color3f(0.7f, 0.7f, 0.0f);
        Vector3f lDir1 = new Vector3f(-1.0f, -1.0f, 1.0f);
        Vector3f lDir2 = new Vector3f(0.0f, 0.0f, -1.0f);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        DirectionalLight lgt2 = new DirectionalLight(lColor2, lDir2);
        lgt1.setInfluencingBounds((Bounds)bounds);
        lgt2.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)lgt1);
        objScale.addChild((Node)lgt2);
        objRoot.compile();
        return objRoot;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] argv) {
        new MainFrame((Applet)new ModelClipTest(), 500, 500);
    }
}

