/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.offscreen_canvas3d;

import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.Raster;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import org.jdesktop.j3d.examples.offscreen_canvas3d.OffScreenCanvas3D;
import org.jdesktop.j3d.examples.offscreen_canvas3d.OnScreenCanvas3D;

public class OffScreenTest
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private Raster drawRaster = null;
    private JPanel drawingPanel;

    private BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        Transform3D trans = new Transform3D();
        Transform3D rot = new Transform3D();
        trans.rotX(0.7853981633974483);
        rot.rotY(0.6283185307179586);
        trans.mul(rot);
        trans.setScale(0.7);
        trans.setTranslation(new Vector3d(-0.4, 0.3, 0.0));
        TransformGroup objTrans = new TransformGroup(trans);
        objRoot.addChild((Node)objTrans);
        objTrans.addChild((Node)new ColorCube(0.4));
        BufferedImage bImage = new BufferedImage(200, 200, 2);
        ImageComponent2D buffer = new ImageComponent2D(2, bImage, true, true);
        buffer.setCapability(2);
        this.drawRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, 200, 200, buffer, null);
        this.drawRaster.setCapability(5);
        Shape3D shape = new Shape3D((Geometry)this.drawRaster);
        objRoot.addChild((Node)shape);
        objRoot.compile();
        return objRoot;
    }

    private OnScreenCanvas3D createOnScreenCanvasAndUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        OnScreenCanvas3D onScrCanvas = new OnScreenCanvas3D(config, false);
        this.univ = new SimpleUniverse((Canvas3D)onScrCanvas);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return onScrCanvas;
    }

    private OffScreenCanvas3D createOffScreenCanvas() {
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        template.setDoubleBuffer(3);
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
        OffScreenCanvas3D offScrCanvas = new OffScreenCanvas3D(gc, true, this.drawRaster);
        return offScrCanvas;
    }

    public OffScreenTest() {
        this.initComponents();
        this.scene = this.createSceneGraph();
        OnScreenCanvas3D onScreenCanvas = this.createOnScreenCanvasAndUniverse();
        this.drawingPanel.add((Component)((Object)onScreenCanvas), "Center");
        OffScreenCanvas3D offScreenCanvas = this.createOffScreenCanvas();
        Screen3D sOn = onScreenCanvas.getScreen3D();
        Screen3D sOff = offScreenCanvas.getScreen3D();
        sOff.setSize(sOn.getSize());
        sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth());
        sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight());
        View view = this.univ.getViewer().getView();
        view.addCanvas3D((Canvas3D)offScreenCanvas);
        onScreenCanvas.setOffScreenCanvas(offScreenCanvas);
        this.univ.addBranchGraph(this.scene);
        view.stopView();
        onScreenCanvas.setImageReady();
        view.startView();
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Window Title");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new OffScreenTest().setVisible(true);
            }
        });
    }
}

