/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.oriented_shape3d;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.net.URL;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.oriented_shape3d.MouseRotateY;

public class OrientedTest
extends Applet {
    private String fontName = "TestFont";
    private String textString = "OrientedShape3D";
    float sl = this.textString.length();
    private URL earthImage = null;
    private URL stoneImage = null;
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D textMat = new Transform3D();
        textMat.setScale(1.2 / (double)this.sl);
        objScale.setTransform(textMat);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objRoot.addChild((Node)objTrans);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Appearance apText = new Appearance();
        Material m = new Material();
        m.setLightingEnable(true);
        apText.setMaterial(m);
        Appearance apEarth = new Appearance();
        Material mm = new Material();
        mm.setLightingEnable(true);
        apEarth.setMaterial(mm);
        Appearance apStone = new Appearance();
        apStone.setMaterial(mm);
        Font3D f3d = new Font3D(new Font(this.fontName, 0, 2), new FontExtrusion());
        Text3D txt = new Text3D(f3d, this.textString, new Point3f(-this.sl / 2.0f, 3.0f, 0.0f));
        OrientedShape3D textShape = new OrientedShape3D();
        textShape.setGeometry((Geometry)txt);
        textShape.setAppearance(apText);
        textShape.setAlignmentAxis(0.0f, 1.0f, 0.0f);
        objScale.addChild((Node)textShape);
        Transform3D cubeMat = new Transform3D();
        TransformGroup cubeTrans = new TransformGroup(cubeMat);
        cubeMat.set(new Vector3d(0.9, 0.0, -1.0));
        cubeTrans.setTransform(cubeMat);
        cubeTrans.addChild((Node)new ColorCube(0.3));
        objTrans.addChild((Node)cubeTrans);
        TextureLoader stoneTex = new TextureLoader(this.stoneImage, new String("RGB"), (Component)this);
        if (stoneTex != null) {
            apStone.setTexture(stoneTex.getTexture());
        }
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        apStone.setTextureAttributes(texAttr);
        Transform3D coneMat = new Transform3D();
        TransformGroup coneTrans = new TransformGroup(coneMat);
        coneMat.set(new Vector3d(0.0, 0.0, 0.0));
        coneTrans.setTransform(coneMat);
        coneTrans.addChild((Node)new Cone(0.2f, 0.8f, 3, apStone));
        objTrans.addChild((Node)coneTrans);
        TextureLoader earthTex = new TextureLoader(this.earthImage, new String("RGB"), (Component)this);
        if (earthTex != null) {
            apEarth.setTexture(earthTex.getTexture());
        }
        apEarth.setTextureAttributes(texAttr);
        Transform3D cylinderMat = new Transform3D();
        TransformGroup cylinderTrans = new TransformGroup(cylinderMat);
        cylinderMat.set(new Vector3d(-0.9, 0.5, -1.0));
        cylinderTrans.setTransform(cylinderMat);
        cylinderTrans.addChild((Node)new Cylinder(0.35f, 2.0f, 3, apEarth));
        objTrans.addChild((Node)cylinderTrans);
        objTrans.addChild((Node)objScale);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bgNode);
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
        Color3f light2Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light2);
        apText.setMaterial(mm);
        objRoot.compile();
        return objRoot;
    }

    public OrientedTest() {
    }

    public OrientedTest(URL earthURL, URL stoneURL) {
        this.earthImage = earthURL;
        this.stoneImage = stoneURL;
    }

    public void init() {
        this.earthImage = Resources.getResource("resources/images/earth.jpg");
        if (this.earthImage == null) {
            System.err.println("resources/images/earth.jpg not found");
            System.exit(1);
        }
        this.stoneImage = Resources.getResource("resources/images/stone.jpg");
        if (this.stoneImage == null) {
            System.err.println("resources/images/stone.jpg not found");
            System.exit(1);
        }
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c, 4);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        MouseRotateY rotate = new MouseRotateY(2);
        rotate.setTransformGroup(viewingPlatform.getMultiTransformGroup().getTransformGroup(0));
        BranchGroup rotateBG = new BranchGroup();
        rotateBG.addChild((Node)rotate);
        viewingPlatform.addChild((Node)rotateBG);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotate.setSchedulingBounds((Bounds)bounds);
        MouseZoom zoom = new MouseZoom((Component)c, 2);
        zoom.setTransformGroup(viewingPlatform.getMultiTransformGroup().getTransformGroup(1));
        zoom.setSchedulingBounds((Bounds)bounds);
        BranchGroup zoomBG = new BranchGroup();
        zoomBG.addChild((Node)zoom);
        viewingPlatform.addChild((Node)zoomBG);
        MouseTranslate translate = new MouseTranslate((Component)c, 2);
        translate.setTransformGroup(viewingPlatform.getMultiTransformGroup().getTransformGroup(2));
        translate.setSchedulingBounds((Bounds)bounds);
        BranchGroup translateBG = new BranchGroup();
        translateBG.addChild((Node)translate);
        viewingPlatform.addChild((Node)translateBG);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        URL earthURL = null;
        URL stoneURL = null;
        earthURL = Resources.getResource("resources/images/earth.jpg");
        if (earthURL == null) {
            System.err.println("resources/images/earth.jpg not found");
            System.exit(1);
        }
        if ((stoneURL = Resources.getResource("resources/images/stone.jpg")) == null) {
            System.err.println("resources/images/stone.jpg not found");
            System.exit(1);
        }
        new MainFrame((Applet)new OrientedTest(earthURL, stoneURL), 400, 400);
    }
}

